/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BasePizzaModifierPrice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class PizzaModifierPrice
extends BasePizzaModifierPrice
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private Map<String, ModifierMultiplierPrice> priceMap = new HashMap<String, ModifierMultiplierPrice>();
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public PizzaModifierPrice() {
    }

    public PizzaModifierPrice(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public double getPrice() {
        return 0.0;
    }

    public double getExtraPrice() {
        return 0.0;
    }

    public void setPrice(double d) {
    }

    public void setExtraPrice(double d) {
    }

    public void initializeSizeAndPriceList(List<Multiplier> list) {
        this.priceMap.clear();
        List<ModifierMultiplierPrice> list2 = this.getMultiplierPriceList();
        if (list2 == null) {
            list2 = new ArrayList<ModifierMultiplierPrice>();
            this.setMultiplierPriceList(list2);
        }
        for (ModifierMultiplierPrice comparable : list2) {
            this.priceMap.put(comparable.getMultiplier().getId(), comparable);
        }
        for (Multiplier multiplier : list) {
            ModifierMultiplierPrice modifierMultiplierPrice = this.priceMap.get(multiplier.getId());
            if (modifierMultiplierPrice != null) continue;
            modifierMultiplierPrice = new ModifierMultiplierPrice();
            modifierMultiplierPrice.setMultiplier(multiplier);
            list2.add(modifierMultiplierPrice);
            this.priceMap.put(multiplier.getId(), modifierMultiplierPrice);
        }
    }

    public ModifierMultiplierPrice getMultiplier(String string) {
        return this.priceMap.get(string);
    }

    public void populateMultiplierPriceListRowValue(MenuModifier menuModifier) {
        Iterator<ModifierMultiplierPrice> iterator = this.getMultiplierPriceList().iterator();
        while (iterator.hasNext()) {
            ModifierMultiplierPrice modifierMultiplierPrice = iterator.next();
            if (modifierMultiplierPrice.getPrice() == null) {
                iterator.remove();
                continue;
            }
            modifierMultiplierPrice.setModifierId(menuModifier.getId());
            modifierMultiplierPrice.setPizzaModifierPriceId(this.getId());
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

