/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketSource;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.ServiceChargeType;
import com.floreantpos.model.util.pricecalc.TicketCalcFactory;
import com.floreantpos.model.util.pricecalc.TicketItemCalcFactory;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.orocube.common.util.TicketStatus;
import java.beans.Transient;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

@JsonIgnoreProperties(ignoreUnknown=true, value={"properties", "customer", "tables", "terminal", "createDateFormatted", "title", "outlet", "customerName", "customerEmail", "customerMobileNo", "bartabName", "gratuityAmount", "serviceChargePaidAmount", "serviceChargeDueAmount", "owner", "cashier", "shift", "customer", "department", "salesArea", "assignedDriver", "voidedBy", "terminal", "beverageCount", "beverageItemCount", "ticketStatus"})
@XmlSeeAlso(value={PosTransaction.class, TicketItem.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ticket")
public class Ticket
extends BaseTicket
implements PropertyContainer,
TimedModel {
    public static final String CUSTOMER_TAX_EXEMPT = "customer.taxExempt";
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROP_TICKET_DISC_AMOUNT = "ticketDiscAmount";
    public static final String JSON_PROP_ITEM_DISC_AMOUNT = "itemDiscAmount";
    public static final String PROP_TRANSACTIONS = "transactions";
    public static final String PROP_TICKET_ITEMS = "ticketItems";
    public static final String PROPERTY_ONLINE_ID = "onlineOrderId";
    public static final String PROPERTY_CARD_TRANSACTION_ID = "card_transaction_id";
    public static final String PROPERTY_CARD_TRACKS = "card_tracks";
    public static final String PROPERTY_CARD_NAME = "card_name";
    public static final String PROPERTY_PAYMENT_METHOD = "payment_method";
    public static final String PROPERTY_CARD_READER = "card_reader";
    public static final String PROPERTY_CARD_NUMBER = "card_number";
    public static final String PROPERTY_CARD_EXP_YEAR = "card_exp_year";
    public static final String PROPERTY_CARD_EXP_MONTH = "card_exp_month";
    public static final String PROPERTY_ADVANCE_PAYMENT = "advance_payment";
    public static final String PROPERTY_CARD_AUTH_CODE = "card_auth_code";
    public static final String PROPERTY_SUB_ORDER_TYPE = "ticket.sub_order_type";
    public static final String PROPERTY_LOYALTY_ADDED = "loyalty";
    public static final String PROPERTY_EXTRA_SEATS = "extra_seats";
    public static final String PROPERTY_OUTLET_SC_RATE = "storeScRate";
    private static final String PROPERTY_OUTLET_GRATUITY_RATE = "storeGratuityRate";
    public static final String CUSTOMER_PHONE = "CUSTOMER_MOBILE";
    public static final String CUSTOMER_NAME = "CUSTOMER_NAME";
    public static final String CUSTOMER_EMAIL = "CUSTOMER_EMAIL";
    public static final String JSON_PROP_BARTAB_NAME = "BARTAB_NAME";
    public static final String CUSTOMER_LAST_NAME = "CUSTOMER_LAST_NAME";
    public static final String CUSTOMER_ID = "CUSTOMER_ID";
    public static final String CUSTOMER_ZIP_CODE = "CUSTOMER_ZIP_CODE";
    public static final String MANAGER_INSTRUCTION = "MANAGER_INSTRUCTION";
    public static final String PHONE_EXTENSION = "PHONE_EXTENSION";
    public static final String CUSTOMER_TOTAL_LOYALTY_POINT = "CUSTOMER_LOYALTY_POINT";
    public static final String DRIVER_OUT_TIME = "OUT_AT";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    public static final int ORDER_PENDING = 0;
    public static final int ORDER_VERIFIED = 1;
    public static final int ORDER_FULLY_INVOICED = 2;
    public static final int ORDER_PARTIALLY_INVOICED = 3;
    public static final int ORDER_FULLY_SHIPMENT = 4;
    public static final int ORDER_PARTIALLY_SHIPMENT = 5;
    public static final int ORDER_PARTIALLY_SHIPMENT_AND_INVOICED = 6;
    public static final int ORDER_CLOSED = 7;
    public static final int ORDER_CANCELLED = 8;
    private transient boolean showNewOrderNotification = false;
    private transient Map<String, ActionHistory> events = new LinkedHashMap<String, ActionHistory>();
    public static final String[] ORDER_STATUS = new String[]{"Pending", "Verified", "Fully Invoiced", "Partially Invoiced", "Fully Shipped", "Partially Shipped", "Partially Shipped and Invoiced", "Closed", "Cancelled"};
    public static final String ORDER_VERIFIED_BY = "Verified_By";
    public static final String ORDER_SENT_BY = "Sent_By";
    public static final String ORDER_SHIPMENT_BY = "Shipping_By";
    public static final String ORDER_INVOICED_BY = "Invoiced_By";
    public static final String ORDER_CLOSED_BY = "Closed_By";
    public static final String DEBIT = "DEBIT";
    public static final String CREDIT = "CREDIT";
    public static final String SPLIT = "split";
    public static final String SPLIT_TICKET_ID = "split_ticket_id";
    public static final String SPLIT_SEAT_NUMBER = "split_seat_number";
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;
    private List deletedItems;
    private String sortOrder;
    private transient Customer customer;
    private transient Outlet outlet;
    private transient Department department;
    private transient SalesArea salesArea;
    private List<TicketDiscount> discounts;
    private List<Integer> tableNumbers;
    private List<ShopTable> tables;
    private boolean shouldUpdateTableStatus;
    private transient boolean shouldUpdateStock;
    private transient OrderType orderType;
    private transient com.google.gson.JsonObject propertiesContainer;
    private boolean shouldPublishMqtt = true;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private static final String jSON_PROP_TABLE_NAMES = "tableNames";

    public Ticket() {
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public Ticket(String string) {
        super(string);
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public Ticket(boolean bl) {
        this(bl, true);
    }

    public Ticket(boolean bl, boolean bl2) {
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
        if (bl) {
            this.populateDefaultProperties(bl2);
        }
    }

    public TicketType getTicketType() {
        return TicketType.getByTypeNo(super.getType());
    }

    public void setTicketType(TicketType ticketType) {
        if (ticketType != null) {
            super.setType(ticketType.getTypeNo());
        }
    }

    public void addTable(int n) {
        List<Integer> list = this.getTableNumbers();
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        list.add(n);
        this.setTableNumbers(list);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    public double getGratuityAmount() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity != null) {
            return gratuity.getAmount();
        }
        return 0.0;
    }

    public void updateGratuityInfo() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity == null || gratuity.getAmount() == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        User user = this.getCashier();
        User user2 = this.getAssignedDriver();
        if (user2 != null) {
            TipsReceivedBy tipsReceivedBy = store.getTipsReceivedByForDeliveryOrder();
            if (tipsReceivedBy == TipsReceivedBy.Driver) {
                gratuity.setOwnerId(user2 != null ? user2.getId() : this.getOwner().getId());
            } else if (tipsReceivedBy == TipsReceivedBy.Cashier) {
                gratuity.setOwnerId(user != null ? user.getId() : this.getOwner().getId());
            } else {
                gratuity.setOwnerId(this.getOwnerId());
            }
        } else {
            TipsReceivedBy tipsReceivedBy = store.getTipsReceivedByForNonDeliveryOrder();
            if (tipsReceivedBy == TipsReceivedBy.Cashier) {
                gratuity.setOwnerId(user != null ? user.getId() : this.getOwner().getId());
            } else {
                gratuity.setOwnerId(this.getOwnerId());
            }
        }
        gratuity.setTicketId(this.getId());
    }

    public void setGratuityAmount(double d) {
        if (d == 0.0 && this.getGratuity() == null) {
            return;
        }
        Gratuity gratuity = this.createGratuity();
        gratuity.setAutoCalculated(false);
        gratuity.setAmount(NumberUtil.round(d));
        this.setGratuity(gratuity);
    }

    public Gratuity createGratuity() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity == null) {
            gratuity = new Gratuity();
            gratuity.setTicketId(this.getId());
            Terminal terminal = Application.getInstance().getTerminal();
            if (terminal != null) {
                gratuity.setTerminalId(terminal.getId());
            }
            gratuity.setOutletId(DataProvider.get().getCurrentOutletId());
            gratuity.setPaid(false);
        }
        return gratuity;
    }

    public boolean hasGratuity() {
        Gratuity gratuity = this.getGratuity();
        return gratuity != null && gratuity.getAmount() > 0.0;
    }

    @Override
    public void setCreateDate(Date date) {
        super.setCreateDate(date);
        super.setActiveDate(date);
    }

    @Override
    public List<TicketItem> getTicketItems() {
        List<TicketItem> list = super.getTicketItems();
        if (list == null) {
            list = new ArrayList<TicketItem>();
            super.setTicketItems(list);
        }
        return list;
    }

    @Override
    @XmlElement(name="transactionList")
    public Set<PosTransaction> getTransactions() {
        Set<PosTransaction> set = super.getTransactions();
        if (set == null) {
            set = new HashSet<PosTransaction>();
            super.setTransactions(set);
        }
        return set;
    }

    @Override
    public Integer getNumberOfGuests() {
        Integer n = super.getNumberOfGuests();
        if (n == null || n == 0) {
            return 1;
        }
        return n;
    }

    public String getCreateDateFormatted() {
        return DateUtil.formatDateWithTime(this.getCreateDate());
    }

    public String getTitle() {
        String string = "";
        if (this.getId() != null) {
            string = string + "#" + this.getId();
        }
        string = string + ": " + this.getOwner();
        string = string + ":" + this.getCreateDateFormatted();
        string = string + ": " + NumberUtil.formatNumber(this.getTotalAmountWithTips());
        return string;
    }

    @XmlTransient
    @JsonIgnore
    public int getBeverageCount() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isBeverage().booleanValue()) continue;
            n = (int)((double)n + ticketItem.getQuantity());
        }
        return n;
    }

    public void calculatePrice() {
        TicketCalcFactory.getCalc(this).calculatePrice(this);
    }

    public double getRepricableAmount() {
        double d = this.getTotalAmount() - this.getDeliveryCharge() - this.getFeeAmount();
        if (!this.isDiscountOnSerivceCharge()) {
            d -= this.getServiceCharge().doubleValue();
        }
        return d;
    }

    public double getToleranceAmount() {
        if (this.hasProperty("toleranceAmount")) {
            return POSUtil.parseDouble(this.getProperty("toleranceAmount"));
        }
        return 0.0;
    }

    public void setToleranceAmount(double d) {
        this.addProperty("toleranceAmount", String.valueOf(d));
    }

    public double getToleranceFactor() {
        if (this.hasProperty("toleranceFactor")) {
            return POSUtil.parseDouble(this.getProperty("toleranceFactor"));
        }
        Currency currency = DataProvider.get().getMainCurrency();
        if (currency != null) {
            return currency.getTolerance();
        }
        return 0.0;
    }

    public void setToleranceFactor(double d) {
        this.addProperty("toleranceFactor", String.valueOf(d));
    }

    public double getSubtotalAmountWithVoidItems() {
        return this.getSubtotalAmount() + this.getVoidSubtotal();
    }

    public static TicketDiscount convertToTicketDiscount(Discount discount, Ticket ticket) {
        return TicketCalcFactory.getCalc(ticket).convertToTicketDiscount(discount, ticket);
    }

    public static TicketDiscount buildLoyaltyDiscount(Ticket ticket) {
        return TicketCalcFactory.getCalc(ticket).buildLoyaltyDiscount(ticket);
    }

    public double calculateDiscountFromType(TicketDiscount ticketDiscount, double d) {
        return TicketCalcFactory.getCalc(this).calculateDiscountFromType(this, ticketDiscount, d);
    }

    public void addDeletedItems(Object object) {
        if (this.deletedItems == null) {
            this.deletedItems = new ArrayList();
        }
        this.deletedItems.add(object);
    }

    public List getDeletedItems() {
        return this.deletedItems;
    }

    public void clearDeletedItems() {
        if (this.deletedItems != null) {
            this.deletedItems.clear();
        }
        this.deletedItems = null;
    }

    public int countItem(TicketItem ticketItem) {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItem ticketItem2 : list) {
            if (!ticketItem.getMenuItemId().equals(ticketItem2.getMenuItemId())) continue;
            ++n;
        }
        return n;
    }

    public boolean needsKitchenPrint() {
        if (this.getDeletedItems() != null && this.getDeletedItems().size() > 0) {
            return true;
        }
        List<TicketItem> list = this.getTicketItems();
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isShouldPrintToKitchen().booleanValue() || ticketItem.isPrintedToKitchen().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoreAmountPaid() {
        return !(this.getPaidAmount() < this.getTotalAmount());
    }

    public double getRemainingGratuity() {
        if (!this.hasGratuity()) {
            return 0.0;
        }
        Set<PosTransaction> set = this.getTransactions();
        double d = 0.0;
        for (PosTransaction posTransaction : set) {
            d += posTransaction.getTipsAmount().doubleValue();
        }
        Gratuity gratuity = this.getGratuity();
        return gratuity.getAmount() - d;
    }

    @Override
    public void addProperty(String string, String string2) {
        if (StringUtils.isEmpty((String)string2)) {
            return;
        }
        this.initPropertiesContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setExtraProperties(this.propertiesContainer.toString());
    }

    @Override
    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    @Override
    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    private void initPropertiesContainer() {
        if (this.propertiesContainer == null) {
            String string = super.getExtraProperties();
            this.propertiesContainer = StringUtils.isBlank((String)string) ? new com.google.gson.JsonObject() : (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
        }
    }

    @Override
    public String getProperty(String string, String string2) {
        JsonElement jsonElement;
        this.initPropertiesContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return string2;
    }

    @Override
    public void removeProperty(String string) {
        this.initPropertiesContainer();
        this.propertiesContainer.remove(string);
        super.setExtraProperties(this.propertiesContainer.toString());
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public String toURLForm() {
        String string = "ticket_id=" + this.getId();
        List<TicketItem> list = this.getTicketItems();
        if (list == null || list.size() == 0) {
            return string;
        }
        for (int i = 0; i < list.size(); ++i) {
            TicketItem ticketItem = list.get(i);
            string = string + "&items[" + i + "][id]=" + ticketItem.getId();
            string = string + "&items[" + i + "][name]=" + POSUtil.encodeURLString(ticketItem.getName());
            string = string + "&items[" + i + "][price]=" + ticketItem.getSubtotalAmount();
        }
        string = string + "&tax=" + this.getTaxAmount();
        string = string + "&subtotal=" + this.getSubtotalAmount();
        string = string + "&grandtotal=" + this.getTotalAmountWithTips();
        return string;
    }

    public void updateCustomer(Customer customer) {
        this.customer = customer;
    }

    public void setCustomer(Customer customer) {
        String string = this.getCustomerId();
        this.customer = customer;
        if (customer == null) {
            this.removeCustomer();
            return;
        }
        this.setCustomerId(customer.getId());
        this.addProperty(CUSTOMER_ID, String.valueOf(customer.getId()));
        this.addProperty(CUSTOMER_NAME, customer.getFirstName());
        this.addProperty(CUSTOMER_LAST_NAME, customer.getLastName());
        this.addProperty(CUSTOMER_PHONE, customer.getMobileNo());
        this.addProperty(CUSTOMER_ZIP_CODE, customer.getZipCode());
        this.addProperty(CUSTOMER_TAX_EXEMPT, customer.isTaxExempt().toString());
        this.addProperty(CUSTOMER_EMAIL, customer.getEmail());
        this.setTaxExempt(customer.isTaxExempt());
        String string2 = "Customer removed";
        String string3 = null;
        String string4 = "";
        if (customer != null) {
            string2 = "Customer set";
            string3 = customer.getId();
        }
        if (StringUtils.isBlank((String)string)) {
            string4 = String.format("Customer id: %s", string3);
        } else {
            string2 = "Customer updated";
            string4 = String.format("Old customer id: %s, New customer id: %s", string, string3);
        }
        if (customer.getId() != null) {
            this.addEvent(string2, string4);
        }
    }

    public void updateCustomerRef(Customer customer) {
        this.customer = customer;
    }

    @XmlTransient
    public Customer getCustomer() {
        if (this.customer != null) {
            return this.customer;
        }
        String string = this.getCustomerId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.customer = DataProvider.get().getCustomer(string);
        return this.customer;
    }

    public void removeCustomer() {
        this.setCustomerId(null);
        this.removeProperty(CUSTOMER_ID);
        this.removeProperty(CUSTOMER_NAME);
        this.removeProperty(CUSTOMER_LAST_NAME);
        this.removeProperty(CUSTOMER_PHONE);
        this.removeProperty(CUSTOMER_ZIP_CODE);
        this.removeProperty(CUSTOMER_TAX_EXEMPT);
    }

    public String getSortOrder() {
        if (this.sortOrder == null) {
            return "";
        }
        return this.sortOrder;
    }

    public void setSortOrder(String string) {
        this.sortOrder = string;
    }

    public void setTicketStatus(TicketStatus ticketStatus) {
        super.setStatus(ticketStatus.name());
        String string = "delivery." + ticketStatus.name() + ".time";
        if (this.hasProperty(string)) {
            return;
        }
        this.addProperty(string, DateUtil.formatDateWithUTCDefaultTimeAndSec(new Date()));
    }

    @XmlTransient
    public TicketStatus getTicketStatus() {
        try {
            String string = super.getStatus();
            if (StringUtils.isBlank((String)string)) {
                return TicketStatus.Unknown;
            }
            return TicketStatus.valueOf((String)string);
        }
        catch (Exception exception) {
            return TicketStatus.Unknown;
        }
    }

    public String getOrderStatusDisplay() {
        return ORDER_STATUS[this.getOrderStatus()];
    }

    public void setOrderStatusDisplay(String string) {
    }

    public void consolidateTicketItems() {
        Object object;
        if (this.hasSeat()) {
            return;
        }
        List<TicketItem> list = this.getTicketItems();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (TicketItem object22 : list) {
            object = object22.getMenuItemId() == null ? object22.getName() : object22.getMenuItemId();
            if (StringUtils.isEmpty((String)object)) continue;
            List list2 = (List)linkedHashMap.get(object);
            if (list2 == null) {
                ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
                arrayList.add(object22);
                linkedHashMap.put(((String)object).toString(), arrayList);
                continue;
            }
            boolean bl = false;
            for (TicketItem ticketItem : list2) {
                if (!ticketItem.isMergable(object22, false)) continue;
                ticketItem.merge(object22);
                bl = true;
                break;
            }
            if (bl) continue;
            list2.add(object22);
        }
        this.getTicketItems().clear();
        Collection collection = linkedHashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            if (object == null) continue;
            this.getTicketItems().addAll((Collection<TicketItem>)object);
        }
        List<TicketItem> list3 = this.getTicketItems();
        if (this.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    if (ticketItem.getId() == null || ticketItem2.getId() == null) {
                        return 0;
                    }
                    return ticketItem.getId().compareTo(ticketItem2.getId());
                }
            });
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    return ticketItem.getSeatNumber() - ticketItem2.getSeatNumber();
                }
            });
        }
        this.calculatePrice();
    }

    public void consolidateKitchenTicketItems() {
        boolean bl = true;
        this.consolidateKitchenTicketItems(bl);
    }

    public void consolidateKitchenTicketItems(boolean bl) {
        this.consolidateKitchenTicketItems(bl, null);
    }

    public void consolidateKitchenTicketItems(boolean bl, List<TicketItem> list) {
        Object object;
        if (this.hasSeat() || this.isSourceOnline()) {
            return;
        }
        if (list == null) {
            list = this.getTicketItems();
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (TicketItem object22 : list) {
            List list2;
            if (!object22.isShouldPrintToKitchen().booleanValue() && !object22.isPrintKitchenSticker().booleanValue() || bl && object22.isPrintedToKitchen().booleanValue()) continue;
            object = object22.getMenuItemId();
            if (StringUtils.isEmpty((String)object)) {
                object = object22.getName();
            }
            if ((list2 = (List)linkedHashMap.get(object)) == null) {
                ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
                arrayList.add(object22);
                linkedHashMap.put(((String)object).toString(), arrayList);
                continue;
            }
            list2.add(object22);
        }
        list.clear();
        Collection collection = linkedHashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            if (object == null) continue;
            list.addAll((Collection<TicketItem>)object);
        }
        List<TicketItem> list3 = list;
        if (this.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    if (ticketItem.getId() == null || ticketItem2.getId() == null) {
                        return 0;
                    }
                    return ticketItem.getId().compareTo(ticketItem2.getId());
                }
            });
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    return ticketItem.getSeatNumber() - ticketItem2.getSeatNumber();
                }
            });
        }
        this.calculatePrice();
    }

    public void markPrintedToKitchen() {
        List<TicketItem> list = this.getTicketItems();
        this.markPrintedToKitchen(list);
    }

    public void markPrintedToKitchen(List<TicketItem> list) {
        for (TicketItem ticketItem : list) {
            Object object;
            Object object2;
            List<Printer> list2;
            if (ticketItem.isPrintedToKitchen().booleanValue() || !ticketItem.isShouldPrintToKitchen().booleanValue() || (list2 = ticketItem.getPrinters(this.getOrderType())) == null) continue;
            ticketItem.setPrintedToKitchen(true);
            ticketItem.setKitchenStatusValue(KitchenStatus.WAITING);
            List<TicketItemModifier> list3 = ticketItem.getTicketItemModifiers();
            if (list3 != null) {
                object2 = list3.iterator();
                while (object2.hasNext()) {
                    object = (TicketItemModifier)object2.next();
                    ((BaseTicketItemModifier)object).setPrintedToKitchen(true);
                }
            }
            if ((object2 = ticketItem.getCookingInstructions()) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                TicketItemCookingInstruction ticketItemCookingInstruction = (TicketItemCookingInstruction)object.next();
                ticketItemCookingInstruction.setPrintedToKitchen(true);
            }
            ticketItem.buildCoookingInstructions();
        }
    }

    public TicketSource getTicketSource() {
        return TicketSource.fromName(super.getSource());
    }

    public void setTicketSource(TicketSource ticketSource) {
        super.setSource(ticketSource.name());
    }

    public boolean isSourceOnline() {
        return this.getTicketSource() == TicketSource.Online;
    }

    public boolean isReservation() {
        TicketType ticketType;
        return this.getTicketType() != null && (ticketType = this.getTicketType()).equals((Object)TicketType.RESERVATION);
    }

    public static Ticket clone(Ticket ticket) {
        return (Ticket)SerializationUtils.clone((Serializable)ticket);
    }

    public String getNumberToDisplay() {
        return Messages.getString("Ticket.11") + this.getTokenNo();
    }

    @XmlTransient
    @JsonIgnore
    public Outlet getOutlet() {
        if (this.outlet != null) {
            return this.outlet;
        }
        String string = this.getOutletId();
        if (string == null) {
            return null;
        }
        this.outlet = (Outlet)DataProvider.get().getObjectOf(Outlet.class, (Serializable)((Object)string));
        return this.outlet;
    }

    @Transient
    public void setOutlet(Outlet outlet) {
        this.outlet = outlet;
        if (outlet == null) {
            this.setOutletId(null);
        } else {
            this.setOutletId(outlet.getId());
        }
    }

    @XmlTransient
    public Department getDepartment() {
        String string = this.getDepartmentId();
        if (string == null) {
            return null;
        }
        if (this.department == null) {
            this.department = (Department)DataProvider.get().getObjectOf(Department.class, (Serializable)((Object)string));
        }
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
        if (department == null) {
            this.setDepartmentId(null);
        } else {
            this.setDepartmentId(department.getId());
        }
    }

    @XmlTransient
    public SalesArea getSalesArea() {
        if (this.salesArea != null) {
            return this.salesArea;
        }
        String string = this.getSalesAreaId();
        if (string == null) {
            return null;
        }
        this.salesArea = DataProvider.get().getSalesArea(string);
        return this.salesArea;
    }

    public void setSalesArea(SalesArea salesArea) {
        this.salesArea = salesArea;
        if (salesArea == null) {
            this.setSalesAreaId(null);
        } else {
            this.setSalesAreaId(salesArea.getId());
        }
    }

    public boolean isSplited() {
        return Boolean.valueOf(this.getProperty(SPLIT));
    }

    public void updateTicketItemPriceBySubOrderType() {
        List<TicketItem> list = this.getTicketItems();
        OrderType orderType = this.getOrderType();
        SubOrderType subOrderType = this.getSubOrderType();
        TaxGroup taxGroup = null;
        if (subOrderType == null || list == null) {
            return;
        }
        if (subOrderType == SubOrderType.FOR_HERE) {
            taxGroup = orderType.getForHereTaxGroup();
        } else if (subOrderType == SubOrderType.TO_GO) {
            taxGroup = orderType.getToGoTaxGroup();
        }
        if (taxGroup != null) {
            for (TicketItem ticketItem : list) {
                MenuItem.setItemTaxes(ticketItem, taxGroup, this.getOrderType());
            }
        }
        this.calculatePrice();
    }

    public String getSplitId() {
        return this.getProperty(SPLIT_TICKET_ID);
    }

    public void setSplitOrder(int n) {
        this.addProperty("SPLIT_ORDER", String.valueOf(n));
    }

    @JsonIgnore
    public String getDiffWithCrntTime() {
        if (this.getCreateDate() == null) {
            return null;
        }
        return DateUtil.getElapsedTime(this.getCreateDate(), new Date());
    }

    public void setDiffWithCrntTime(String string) {
    }

    public String getTableNames() {
        return this.getProperty(jSON_PROP_TABLE_NAMES);
    }

    @XmlTransient
    public String getBartabName() {
        if (this.getOrderType() != null && this.getOrderType().isBarTab().booleanValue()) {
            String string = this.getProperty(JSON_PROP_BARTAB_NAME);
            if (StringUtils.isBlank((String)string)) {
                string = this.getProperty(CUSTOMER_NAME);
            }
            if (StringUtils.isNotBlank((String)string)) {
                return string;
            }
        }
        return null;
    }

    public String getTableNameDisplay() {
        String string = this.getTableNames();
        if (StringUtils.isBlank((String)string)) {
            return POSUtil.toFormattedString(this.getTableNumbers());
        }
        return string;
    }

    public String getTableNameOrNumberDisplay() {
        Store store = DataProvider.get().getStore();
        if (store.isShowTableNameOnTable()) {
            return this.getTableNameDisplay();
        }
        return this.getTableNumbersDisplay();
    }

    public Double getTotalAmountWithTips() {
        return super.getTotalAmount() + this.getGratuityAmount();
    }

    public String getTableNumbersDisplay() {
        List<Integer> list = this.getTableNumbers();
        if (list == null || list.size() <= 0) {
            return "";
        }
        String string = list.toString().replaceAll("[\\[\\]]", "");
        return string;
    }

    public boolean isPrintedToKitchenOrInventoryAdjusted() {
        for (TicketItem ticketItem : this.getTicketItems()) {
            if (ticketItem.isPrintedToKitchen().booleanValue() || ticketItem.isInventoryAdjusted() || !ticketItem.isReturned() && ticketItem.isVoided().booleanValue()) {
                return true;
            }
            if (!ticketItem.isHasModifiers().booleanValue()) continue;
            for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRepriceDiscount() {
        List<TicketDiscount> list = this.getDiscounts();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (TicketDiscount ticketDiscount : list) {
            if (ticketDiscount.getOriginalType() != 2) continue;
            return true;
        }
        return false;
    }

    public double getVoidSubtotal() {
        if (this.hasProperty("voidSubtotal")) {
            return POSUtil.parseDouble("voidSubtotal");
        }
        return 0.0;
    }

    public void setVoidSubtotal(double d) {
        this.addProperty("voidSubtotal", String.valueOf(d));
    }

    public double getVoidTotal() {
        if (this.hasProperty("voidTotal")) {
            return POSUtil.parseDouble("voidTotal");
        }
        return 0.0;
    }

    public void setVoidTotal(double d) {
        this.addProperty("voidTotal", String.valueOf(d));
    }

    @Override
    public void setTotalAmount(Double d) {
        super.setTotalAmount(d + 0.0);
    }

    @Override
    public void setDueAmount(Double d) {
        super.setDueAmount(d + 0.0);
    }

    @Override
    public void setDiscountAmount(Double d) {
        super.setDiscountAmount(d + 0.0);
    }

    @Override
    public void setTaxAmount(Double d) {
        super.setTaxAmount(d + 0.0);
    }

    @XmlTransient
    public OrderType getOrderType() {
        if (this.orderType == null) {
            this.orderType = DataProvider.get().getOrderTypeById(this.getOrderTypeId());
        }
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
        if (orderType != null) {
            this.setServiceChargeApplicable(orderType.isServiceChargeApplicable());
            this.setServiceChargeType(orderType.getServiceChargeType());
            this.setOutletServiceChargeRate(orderType.getServiceChargeRate());
            super.setOrderTypeId(orderType.getId());
        }
    }

    @XmlTransient
    public Shift getShift() {
        return DataProvider.get().getShiftById(this.getShiftId());
    }

    public void setShift(Shift shift) {
        String string = null;
        if (shift != null) {
            string = shift.getId();
        }
        super.setShiftId(string);
    }

    @XmlTransient
    public User getOwner() {
        return DataProvider.get().getUserById(this.getOwnerId());
    }

    public void setOwner(User user) {
        String string = null;
        String string2 = null;
        if (user != null) {
            string = user.getId();
            string2 = user.getUserTypeId();
            if (this.getCreatedByUserId() == null) {
                this.setCreatedByUserId(string);
            }
            this.addProperty("owner.firstname", user.getFirstName());
            this.addProperty("owner.lastname", user.getLastName());
        }
        super.setOwnerId(string);
        super.setOwnerTypeId(string2);
    }

    @XmlTransient
    public User getCashier() {
        return DataProvider.get().getUserById(this.getCashierId());
    }

    public void setCashier(User user) {
        String string = null;
        if (user != null) {
            string = user.getId();
        }
        super.setCashierId(string);
    }

    @XmlTransient
    public User getAssignedDriver() {
        return DataProvider.get().getUserById(this.getAssignedDriverId());
    }

    public void setAssignedDriver(User user) {
        String string = null;
        if (user != null) {
            string = user.getId();
            this.addProperty("driver.firstname", user.getFirstName());
            this.addProperty("driver.lastname", user.getLastName());
        } else {
            this.removeProperty("driver.firstname");
            this.removeProperty("driver.lastname");
        }
        super.setAssignedDriverId(string);
    }

    @XmlTransient
    public String getDriverNameFromProperty() {
        String string = this.getProperty("driver.firstname", "");
        String string2 = this.getProperty("driver.lastname", "");
        return string + " " + string2;
    }

    @XmlTransient
    public User getVoidedBy() {
        return DataProvider.get().getUserById(this.getVoidedById());
    }

    public void setVoidedBy(User user) {
        String string = null;
        if (user != null) {
            string = user.getId();
        }
        super.setVoidedById(string);
    }

    @XmlTransient
    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    public void setTerminal(Terminal terminal) {
        Integer n = null;
        if (terminal != null) {
            n = terminal.getId();
        }
        super.setTerminalId(n);
    }

    public void setDiscounts(List<TicketDiscount> list) {
        this.discounts = list;
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketDiscount>();
        }
    }

    public List<TicketDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketDiscount>();
            this.convertDiscountPropertyToList();
        }
        return this.discounts;
    }

    public void convertDiscountPropertyToList() {
        String string = super.getDiscountsProperty();
        if (StringUtils.isNotEmpty((String)string)) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
            JsonArray jsonArray = jsonReader.readArray();
            jsonReader.close();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                TicketDiscount ticketDiscount = new TicketDiscount();
                ticketDiscount.setTicket(this);
                ticketDiscount.setId(JsonUtil.getString(jsonObject, TicketDiscount.PROP_ID));
                ticketDiscount.setLoyaltyPoint(JsonUtil.getInt(jsonObject, TicketDiscount.PROP_LOYALTY_POINT));
                ticketDiscount.setLoyaltyCharged(JsonUtil.getBoolean(jsonObject, TicketDiscount.PROP_LOYALTY_CHARGED));
                ticketDiscount.setDiscountId(JsonUtil.getString(jsonObject, TicketDiscount.PROP_DISCOUNT_ID));
                ticketDiscount.setName(JsonUtil.getString(jsonObject, TicketDiscount.PROP_NAME));
                ticketDiscount.setType(JsonUtil.getInt(jsonObject, TicketDiscount.PROP_TYPE));
                ticketDiscount.setAutoApply(JsonUtil.getBoolean(jsonObject, TicketDiscount.PROP_AUTO_APPLY));
                ticketDiscount.setCouponQuantity(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_COUPON_QUANTITY));
                ticketDiscount.setMinimumAmount(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_MINIMUM_AMOUNT));
                ticketDiscount.setValue(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_VALUE));
                ticketDiscount.setTotalDiscountAmount(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_TOTAL_DISCOUNT_AMOUNT));
                ticketDiscount.setCouponBarcode(JsonUtil.getString(jsonObject, "couponBarcode"));
                Integer n = JsonUtil.getInt(jsonObject, TicketDiscount.PROP_ORIGINAL_TYPE);
                if (n == null) {
                    n = ticketDiscount.getType();
                }
                ticketDiscount.setOriginalType(n);
                Double d = JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_ORIGINAL_VALUE);
                if (d == null) {
                    d = ticketDiscount.getValue();
                }
                ticketDiscount.setOriginalValue(d);
                this.discounts.add(ticketDiscount);
            }
        }
    }

    public void addTodiscounts(TicketDiscount ticketDiscount) {
        this.discounts = this.getDiscounts();
        this.discounts.add(ticketDiscount);
        this.buildDiscounts();
        ActionHistoryDAO.addDiscountAddedActionHistory(this, ticketDiscount);
    }

    public void buildDiscounts() {
        JSONArray jSONArray = new JSONArray();
        for (TicketDiscount ticketDiscount : this.discounts) {
            jSONArray.put((Object)ticketDiscount.toJson());
        }
        this.setDiscountsProperty(jSONArray.toString());
    }

    @Override
    @XmlTransient
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        if (map == null) {
            map = new HashMap<String, String>();
            super.setProperties(map);
        }
        return map;
    }

    @Override
    public String getTicketTableNumbers() {
        String string = "";
        List<Integer> list = this.getTableNumbers();
        if (list != null && list.size() > 0) {
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                Integer n = iterator.next();
                string = string + n;
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
        }
        return string;
    }

    @Override
    public void setTicketTableNumbers(String string) {
        this.tableNumbers = new ArrayList<Integer>();
        if (StringUtils.isNotEmpty((String)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                int n = POSUtil.parseInteger(string2);
                if (n <= 0) continue;
                this.tableNumbers.add(n);
            }
        }
        super.setTicketTableNumbers(string);
    }

    public List<Integer> getTableNumbers() {
        return this.tableNumbers;
    }

    public void setTableNumbers(List<Integer> list) {
        this.tableNumbers = list;
        if (list == null || list.size() <= 0) {
            this.removeProperty(jSON_PROP_TABLE_NAMES);
            return;
        }
        List<String> list2 = ShopTableDAO.getInstance().getTableNames(list);
        if (list2 != null && !list2.isEmpty()) {
            this.addProperty(jSON_PROP_TABLE_NAMES, POSUtil.toFormattedString(list2));
        } else {
            this.addProperty(jSON_PROP_TABLE_NAMES, POSUtil.toFormattedString(list));
        }
    }

    public List<ShopTable> getTables() {
        List<Integer> list = this.getTableNumbers();
        if (list == null || list.size() == 0) {
            return new ArrayList<ShopTable>(1);
        }
        if (this.tables == null) {
            this.tables = new ArrayList<ShopTable>(1);
        }
        for (Integer n : list) {
            ShopTable shopTable2 = new ShopTable(n);
            if (this.tables.contains(shopTable2) || (shopTable2 = ShopTableDAO.getInstance().loadWithSeats(n)) == null) continue;
            this.tables.add(shopTable2);
        }
        this.tables = this.tables.stream().filter(shopTable -> list.contains(shopTable.getId())).collect(Collectors.toList());
        return this.tables;
    }

    public void voidItem(TicketItem ticketItem, String string, boolean bl) {
        this.voidItem(ticketItem, string, bl, ticketItem.getQuantity());
    }

    public void voidItem(TicketItem ticketItem, String string, boolean bl, double d) {
        TicketCalcFactory.getCalc(this).voidItem(this, ticketItem, string, bl, d);
    }

    public void voidReturnedItem(TicketItem ticketItem, String string, boolean bl) {
        TicketCalcFactory.getCalc(this).voidReturnedItem(ticketItem, string, bl);
    }

    public TicketItem undoVoidItem(TicketItem ticketItem) {
        return TicketCalcFactory.getCalc(this).undoVoidItem(this, ticketItem);
    }

    public TicketItem getTicketItem(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        for (TicketItem ticketItem : this.getTicketItems()) {
            if (ticketItem.getId() == null || !ticketItem.getId().equals(string)) continue;
            return ticketItem;
        }
        return null;
    }

    private void populateDefaultProperties() {
        this.populateDefaultProperties(true);
    }

    private void populateDefaultProperties(boolean bl) {
        Outlet outlet;
        Department department;
        Application application = Application.getInstance();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        this.setTaxIncluded(application.isPriceIncludesTax());
        this.setTerminal(terminal);
        this.setCreateDate(StoreDAO.getServerTimestamp());
        this.setStoreSessionId(DataProvider.get().getStoreSessionId());
        if (terminal != null) {
            this.setSalesAreaId(terminal.getSalesAreaId());
        }
        if ((department = terminal.getDepartment()) != null) {
            this.setDepartmentId(department.getId());
        }
        if ((outlet = DataProvider.get().getOutlet()) != null) {
            this.setOutletId(outlet.getId());
            this.setOutletServiceChargeRate(outlet.getServiceChargePercentage());
            this.setOutletGratuityRate(outlet.getDefaultGratuityPercentage());
        }
        this.setOwner(Application.getCurrentUser());
        this.setShift(ShiftUtil.getCurrentShift());
        this.setShouldIncludeInSales(true);
        Currency currency = DataProvider.get().getMainCurrency();
        this.setToleranceFactor(currency.getTolerance());
        Store store = DataProvider.get().getStore();
        this.setApplyFloridaTaxRule(store.isEnableFloridaTaxRule());
        if (bl) {
            String string = "New ticket";
            ActionHistory actionHistory = ActionHistory.create(this, string, "");
            this.addToEvents(string, actionHistory);
        }
        this.setDataVersion(2);
    }

    public boolean isShouldUpdateTableStatus() {
        return this.shouldUpdateTableStatus;
    }

    public void setShouldUpdateTableStatus(boolean bl) {
        this.shouldUpdateTableStatus = bl;
    }

    public PosTransaction getBartabTransaction() {
        String string = this.getProperty("bartab.transaction.id");
        if (StringUtils.isNotEmpty((String)string)) {
            for (PosTransaction posTransaction : this.getTransactions()) {
                if (posTransaction.isVoided().booleanValue() || !string.equals(String.valueOf(posTransaction.getId()))) continue;
                return posTransaction;
            }
        }
        return null;
    }

    @Override
    public String getExtraProperties() {
        this.initPropertiesContainer();
        return this.propertiesContainer.toString();
    }

    @Override
    public void setExtraProperties(String string) {
        super.setExtraProperties(string);
        this.propertiesContainer = null;
        this.initPropertiesContainer();
    }

    public void addExtraProperty(String string, String string2) {
        this.initPropertiesContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setExtraProperties(this.propertiesContainer.toString());
    }

    public String getExtraProperty(String string) {
        JsonElement jsonElement;
        this.initPropertiesContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    public String toString() {
        return "Ticket [ticketDiscountAmount=, itemDiscountAmount=" + this.getItemDiscountAmount() + ", deletedItems=" + this.deletedItems + ", sortOrder=" + this.sortOrder + ", customer=" + this.customer + ", outlet=" + this.outlet + ", department=" + this.department + ", salesArea=" + this.salesArea + ", discounts=" + this.discounts + ", tableNumbers=" + this.tableNumbers + ", tables=" + this.tables + ", shouldUpdateTableStatus=" + this.shouldUpdateTableStatus + ", roundedAmount=" + this.getRoundedAmount() + ", toleranceAmount=" + this.getToleranceAmount() + ", getTicketItems()=" + this.getTicketItems() + "]";
    }

    public boolean isShouldPublishMqtt() {
        return this.shouldPublishMqtt;
    }

    public void setShouldPublishMqtt(boolean bl) {
        this.shouldPublishMqtt = bl;
    }

    public String getOwnerName() {
        if (this.getOwner() != null) {
            return this.getOwner().getFullName();
        }
        return "";
    }

    @XmlTransient
    public String getOwnerNameFromProperty() {
        String string = this.getProperty("owner.firstname");
        String string2 = this.getProperty("owner.lastname", "");
        if (StringUtils.isBlank((String)string2)) {
            return string;
        }
        return string + " " + string2;
    }

    public void setOwnerName(String string) {
    }

    @XmlTransient
    public String getCustomerName() {
        if (this.getCustomer() != null) {
            return this.getCustomer().getName();
        }
        return this.getCustomerNameByProperty();
    }

    public void setCustomerName(String string) {
        this.addProperty(CUSTOMER_NAME, string);
    }

    @XmlTransient
    public String getCustomerEmail() {
        if (this.getCustomer() != null) {
            return this.getCustomer().getEmail();
        }
        return this.getProperty("customer_email");
    }

    public void setCustomerEmail(String string) {
        this.addProperty("customer_email", string);
    }

    @XmlTransient
    public String getCustomerMobileNo() {
        if (this.getCustomer() != null) {
            return this.getCustomer().getMobileNo();
        }
        return this.getProperty(CUSTOMER_PHONE);
    }

    public void setCustomerMobileNo(String string) {
        this.addProperty(CUSTOMER_PHONE, string);
    }

    public void makeXmlTransient() {
        this.setProperties(null);
        this.setDiscounts(null);
        for (TicketItem comparable : this.getTicketItems()) {
            comparable.setTicket(null);
        }
        if (this.getTransactions() != null) {
            for (PosTransaction posTransaction : this.getTransactions()) {
                posTransaction.setTicket(null);
                posTransaction.setProperties(null);
            }
        }
    }

    public void mergeTicket(Ticket ticket) {
        TicketCalcFactory.getCalc(this).mergeTicket(this, ticket);
    }

    public boolean isPriceApplicable(TicketItem ticketItem) {
        return ticketItem.isVoided() == false || ticketItem.isItemReturned() != false;
    }

    public boolean hasGiftCard() {
        List<TicketItem> list = this.getTicketItems();
        if (list != null && !list.isEmpty()) {
            for (TicketItem ticketItem : list) {
                if (!ticketItem.isGiftCard()) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public void setSubOrderType(SubOrderType subOrderType) {
        if (subOrderType != null) {
            this.addProperty(PROPERTY_SUB_ORDER_TYPE, subOrderType.getName());
        }
    }

    @JsonIgnore
    public SubOrderType getSubOrderType() {
        return SubOrderType.fromName((String)this.getExtraProperty(PROPERTY_SUB_ORDER_TYPE));
    }

    public boolean hasSeat() {
        for (TicketItem ticketItem : this.getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public boolean isKitchenPrintable() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return false;
        }
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isKitchenPrintable()) continue;
            return true;
        }
        return false;
    }

    public boolean isDiscountable() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null || list.isEmpty()) {
            return Boolean.FALSE;
        }
        for (TicketItem ticketItem : list) {
            if (ticketItem.isTreatAsSeat().booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void checkVoidable() throws PosException {
        List<TicketItem> list = this.getTicketItems();
        if (list == null || list.isEmpty()) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        if (this.hasReturnedItem()) {
            throw new PosException(Messages.getString("POSConstants.27"));
        }
        if (this.getBooleanProperty(SPLIT, false).booleanValue()) {
            throw new PosException(Messages.getString("Ticket.4"));
        }
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isGiftCard() || !(ticketItem.getGiftCardPaidAmount() > 0.0)) continue;
            throw new PosException(Messages.getString("Ticket.3"));
        }
    }

    public List<ShopSeat> getExtraSeats() {
        List<ShopSeat> list = null;
        String string = this.getProperty(PROPERTY_EXTRA_SEATS, null);
        if (StringUtils.isEmpty((String)string)) {
            list = new ArrayList<ShopSeat>();
        } else {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                list = (List)objectMapper.readValue(string, (TypeReference)new TypeReference<List<ShopSeat>>(){});
            }
            catch (IOException iOException) {
                PosLog.error(this.getClass(), iOException);
            }
        }
        return list;
    }

    public void addExtraSeats(List<ShopSeat> list) {
        String string = null;
        if (list != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                string = objectMapper.writeValueAsString(list);
            }
            catch (JsonProcessingException jsonProcessingException) {
                PosLog.error(this.getClass(), (Exception)((Object)jsonProcessingException));
            }
        }
        this.addProperty(PROPERTY_EXTRA_SEATS, string);
    }

    public Map<String, ActionHistory> getEvents() {
        if (this.events == null) {
            this.events = new LinkedHashMap<String, ActionHistory>();
        }
        return this.events;
    }

    public void addToEvents(String string, ActionHistory actionHistory) {
        if (this.events == null) {
            this.events = new LinkedHashMap<String, ActionHistory>();
        }
        this.events.put(string, actionHistory);
    }

    public void removeEvents(String string) {
        if (this.events.containsKey(string)) {
            this.events.remove(string);
        }
    }

    public void addEvent(String string, String string2) {
        ActionHistory actionHistory = ActionHistory.create(this, string, string2);
        this.addToEvents(actionHistory.getActionName(), actionHistory);
    }

    public void addRandomEvent(String string, String string2) {
        ActionHistory actionHistory = ActionHistory.create(this, string, string2);
        this.getEvents().put(actionHistory.getActionName() + Math.random(), actionHistory);
    }

    public boolean hasLoyaltyDiscount() {
        List<TicketDiscount> list = this.getDiscounts();
        if (list == null) {
            return false;
        }
        for (TicketDiscount ticketDiscount : list) {
            String string = ticketDiscount.getDiscountId();
            if (!StringUtils.isNotBlank((String)string) || !string.equals("loyalty_discount")) continue;
            return true;
        }
        return false;
    }

    @XmlTransient
    public int getBeverageItemCount() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItem ticketItem : list) {
            if (ticketItem.isTreatAsSeat().booleanValue() || !ticketItem.isBeverage().booleanValue()) continue;
            n = (int)((double)n + Math.abs(ticketItem.getQuantity()));
        }
        return n;
    }

    public void validateTicketBeforeSave() {
        if (this.getTicketItems() == null || this.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        if (this.orderType.isBeverageMandatory()) {
            Integer n = this.getNumberOfGuests();
            int n2 = this.getBeverageItemCount();
            if (n2 < n) {
                throw new PosException(String.format(Messages.getString("Ticket.2"), n));
            }
        }
    }

    public double getTaxAmountFromProperty() {
        return POSUtil.parseDouble(this.getProperty("tax.exempt.amount"));
    }

    public String getCustomerNameByProperty() {
        String string = this.getProperty(CUSTOMER_NAME, "");
        String string2 = this.getProperty(CUSTOMER_LAST_NAME, "");
        if (StringUtils.isBlank((String)string) && StringUtils.isBlank((String)string2)) {
            return "";
        }
        return string + " " + string2;
    }

    public Double getOutletServiceChargeRate() {
        String string = this.getProperty(PROPERTY_OUTLET_SC_RATE);
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        try {
            return NumberUtil.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    public void setOutletServiceChargeRate(Double d) {
        this.addProperty(PROPERTY_OUTLET_SC_RATE, String.valueOf(d));
    }

    public Double getOutletGratuityRate() {
        String string = this.getProperty(PROPERTY_OUTLET_GRATUITY_RATE);
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        try {
            return NumberUtil.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            PosLog.error(this.getClass(), parseException);
            return 0.0;
        }
    }

    public void setOutletGratuityRate(Double d) {
        this.addProperty(PROPERTY_OUTLET_GRATUITY_RATE, String.valueOf(d));
    }

    public Double getSubtotalWithoutIncludedTax() {
        if (this.isTaxIncluded().booleanValue()) {
            return this.getSubtotalAmount() - this.getTaxAmount();
        }
        return this.getSubtotalAmount();
    }

    public void closeIfApplicable() {
        OrderType orderType;
        if (NumberUtil.isZero(this.getDueAmount()) && (orderType = this.getOrderType()) != null && (orderType.isCloseOnPaid().booleanValue() || orderType.isBarTab().booleanValue())) {
            this.setClosed(true);
            this.setClosingDate(StoreDAO.getServerTimestamp());
        }
    }

    public boolean isShouldUpdateStock() {
        return this.shouldUpdateStock;
    }

    public void setShouldUpdateStock(boolean bl) {
        this.shouldUpdateStock = bl;
    }

    @JsonIgnore
    public double getServiceChargePaidAmount() {
        Set<PosTransaction> set = this.getTransactions();
        if (set == null || set.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (PosTransaction posTransaction : set) {
            if (posTransaction.isVoided().booleanValue() || posTransaction instanceof RefundTransaction) continue;
            d += posTransaction.getServiceChargeAmount().doubleValue();
        }
        return d;
    }

    @JsonIgnore
    public double getServiceChargeDueAmount() {
        return this.getServiceCharge() - this.getServiceChargePaidAmount();
    }

    public void setItemDiscountAmount(double d) {
        this.addProperty(JSON_PROP_ITEM_DISC_AMOUNT, String.valueOf(d));
    }

    public double getItemDiscountAmount() {
        return this.getDoubleProperty(JSON_PROP_ITEM_DISC_AMOUNT);
    }

    public double getTicketDiscountAmount() {
        return this.getDoubleProperty(JSON_PROP_TICKET_DISC_AMOUNT);
    }

    public void setTicketDiscountAmount(double d) {
        this.addProperty(JSON_PROP_TICKET_DISC_AMOUNT, String.valueOf(d));
    }

    public double getOldDataTolerance() {
        return this.getDoubleProperty("oldDataTolerance");
    }

    public void setOldDataTolerance(double d) {
        this.addProperty("oldDataTolerance", String.valueOf(d));
    }

    @Override
    public com.google.gson.JsonObject getPropertyStore() {
        return this.propertiesContainer;
    }

    public void setDiscountOnSerivceCharge(boolean bl) {
        this.addProperty("discOnSc", String.valueOf(bl));
    }

    public boolean isDiscountOnSerivceCharge() {
        return POSUtil.getBoolean(this.getProperty("discOnSc"));
    }

    public void setServiceChargeApplicable(boolean bl) {
        this.addProperty("scApplicable", String.valueOf(bl));
    }

    public boolean isServiceChargeApplicable() {
        return POSUtil.getBoolean(this.getProperty("scApplicable"));
    }

    public void setApplyFloridaTaxRule(boolean bl) {
        this.addProperty("applyFlTaxRule", String.valueOf(bl));
    }

    public boolean isApplyFloridaTaxRule() {
        return POSUtil.getBoolean(this.getProperty("applyFlTaxRule"));
    }

    public boolean isItemReturnable(TicketItem ticketItem, double d) {
        double d2 = ticketItem.getQuantity();
        double d3 = 0.0;
        List<TicketItem> list = this.getTicketItems();
        for (TicketItem ticketItem2 : list) {
            String string;
            if (ticketItem2.isTreatAsSeat().booleanValue() || !StringUtils.isNotBlank((String)(string = ticketItem2.getVoidedItemId())) || !string.equals(ticketItem.getId()) || !ticketItem2.isItemReturned().booleanValue()) continue;
            d3 += ticketItem2.getQuantity().doubleValue();
        }
        return Math.abs(d3) + d <= d2;
    }

    public boolean isItemReturned(TicketItem ticketItem) {
        String string = ticketItem.getId();
        List<TicketItem> list = this.getTicketItems();
        for (TicketItem ticketItem2 : list) {
            String string2;
            if (ticketItem2.isTreatAsSeat().booleanValue() || !ticketItem2.isItemReturned().booleanValue() || !StringUtils.isNotBlank((String)(string2 = ticketItem2.getVoidedItemId())) || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReturnedItem() {
        List<TicketItem> list = this.getTicketItems();
        if (list != null) {
            for (TicketItem ticketItem : list) {
                if (!ticketItem.isItemReturned().booleanValue()) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public String getDeliveryFlatNo() {
        return this.getProperty("flatNo", "");
    }

    public void setDeliveryFlatNo(String string) {
        this.addProperty("flatNo", string);
    }

    public String getDeliveryZipCode() {
        return this.getProperty("deliAddressZipCode");
    }

    public void setDeliveryAddressZipCode(String string) {
        this.addProperty("deliAddressZipCode", string);
    }

    public String getFullDeliveryAddress() {
        String string = super.getDeliveryAddress();
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String string2 = this.getDeliveryFlatNo();
        String string3 = this.getDeliveryZipCode();
        if (StringUtils.isNotBlank((String)string2)) {
            string = string + ", Flat/Suite: " + string2;
        }
        if (StringUtils.isNotBlank((String)string3)) {
            string = string + ", Zip/Postal: " + string3;
        }
        return string;
    }

    public String getEstimatedDeliveryTime() {
        return this.getProperty("estimated_delivery_time");
    }

    public void setEstimatedDeliveryTime(String string) {
        this.addProperty("estimated_delivery_time", string);
    }

    @XmlTransient
    public boolean isShowNewOrderNotification() {
        return this.showNewOrderNotification;
    }

    public void setShowNewOrderNotification(boolean bl) {
        this.showNewOrderNotification = bl;
    }

    public boolean isDeliveryASAP() {
        return this.getBooleanProperty("delivery_asap", Boolean.TRUE);
    }

    public void setDeliveryASAP(boolean bl) {
        this.addProperty("delivery_asap", String.valueOf(bl));
    }

    public String getCustomerTotalLoyaltyPoint() {
        return this.getProperty(CUSTOMER_TOTAL_LOYALTY_POINT);
    }

    public void setCustomerTotalLoyaltyPoint(int n) {
        this.addProperty(CUSTOMER_TOTAL_LOYALTY_POINT, String.valueOf(n));
    }

    @JsonIgnore
    @XmlTransient
    public double getLoyaltyDiscountAmount() {
        double d = 0.0;
        List<TicketDiscount> list = this.getDiscounts();
        if (list != null) {
            for (TicketDiscount ticketDiscount : list) {
                if (ticketDiscount.getType() != 3) continue;
                d += ticketDiscount.getTotalDiscountAmount().doubleValue();
            }
        }
        return d;
    }

    @JsonIgnore
    @XmlTransient
    public boolean isLoyaltyAdded() {
        return this.getBooleanProperty(PROPERTY_LOYALTY_ADDED, false);
    }

    public void setLoyaltyAdded(boolean bl) {
        this.addProperty(PROPERTY_LOYALTY_ADDED, String.valueOf(bl));
    }

    @JsonIgnore
    @XmlTransient
    public int getLoyaltyEarnedForVisit() {
        return POSUtil.parseInteger(this.getProperty("loyalty.pointForVisit"));
    }

    public void setLoyaltyEarnedForVisit(int n) {
        this.addProperty("loyalty.pointForVisit", String.valueOf(n));
    }

    @JsonIgnore
    @XmlTransient
    public int getTotalLoyaltyEarned() {
        int n = 0;
        Set<PosTransaction> set = this.getTransactions();
        if (set == null) {
            return 0;
        }
        for (PosTransaction posTransaction : set) {
            if (posTransaction.isVoided().booleanValue()) continue;
            n += posTransaction.getLoyaltyEarnedForPurchase();
        }
        return n + this.getLoyaltyEarnedForVisit();
    }

    @JsonIgnore
    @XmlTransient
    public int getTotalLoyaltyChargedAmount() {
        int n = 0;
        Set<PosTransaction> set = this.getTransactions();
        if (set == null) {
            return 0;
        }
        for (PosTransaction posTransaction : set) {
            if (posTransaction.isVoided().booleanValue()) continue;
            n += posTransaction.getLoyaltyChargedAmount();
        }
        return n;
    }

    public boolean hasServiceItem(MenuItem menuItem) {
        List<TicketItem> list = this.getTicketItems();
        if (list.size() == 0) {
            return false;
        }
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isService().booleanValue() || ticketItem.getServiceType() == null || menuItem.getServiceType() == null || !ticketItem.getServiceType().equals(menuItem.getServiceType())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    @XmlTransient
    public TicketItem getItemWithRequiredCustomer() {
        List<TicketItem> list = this.getTicketItems();
        if (list.size() == 0) {
            return null;
        }
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isService().booleanValue() || !ticketItem.isCustomerRequired()) continue;
            return ticketItem;
        }
        return null;
    }

    public void setServiceChargeType(ServiceChargeType serviceChargeType) {
        this.addProperty("serviceChargeType", serviceChargeType.name());
    }

    @JsonIgnore
    public ServiceChargeType getServiceChargeType() {
        String string = this.getProperty("serviceChargeType");
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return ServiceChargeType.valueOf(string);
            }
            catch (Exception exception) {
                return ServiceChargeType.EMPTY;
            }
        }
        return ServiceChargeType.EMPTY;
    }

    public boolean hasDiscountWithoutPercentage() {
        List<TicketDiscount> list = this.getDiscounts();
        if (list != null && list.size() > 0) {
            for (TicketDiscount ticketDiscount : list) {
                if (ticketDiscount.getOriginalType() == 1) continue;
                return true;
            }
        }
        return false;
    }

    public void setCustomer(Customer customer, boolean bl) {
        this.setCustomer(customer);
        if (bl) {
            this.updateTicketItemsPrice();
        }
    }

    public void updateTicketItemsPrice() {
        if (this.getTicketItems().isEmpty()) {
            return;
        }
        for (TicketItem ticketItem : this.getTicketItems()) {
            MenuItem menuItem = ticketItem.getMenuItem();
            if (menuItem == null) continue;
            if (ticketItem.isComboItem().booleanValue()) {
                TicketItemCalcFactory.getCalc(ticketItem).doCalculateComboItemPrice(ticketItem, true);
                continue;
            }
            String string = ticketItem.getUnitName();
            IUnit iUnit = StringUtils.isBlank((String)string) ? null : DataProvider.get().getUnitByCode(string);
            menuItem.setTicketItemUnitPriceAndCost(ticketItem, menuItem, iUnit, this);
        }
    }
}

