/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.dao.BasePriceShiftDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ShiftDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class PriceShiftDAO
extends BasePriceShiftDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.validateData((PriceShift)object, session);
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.validateData((PriceShift)object, session);
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.validateData((PriceShift)object, session);
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    private void validateData(PriceShift priceShift, Session session) {
        GenericDAO.getInstance().checkIdOrNameExists(priceShift.getId(), priceShift.getName(), PriceShift.class, session);
        if (this.priceShiftExists(priceShift.getId(), priceShift.getStartHour(), priceShift.getStartMin(), priceShift.getEndHour(), priceShift.getEndMin(), priceShift.getDaysOfWeek(), session)) {
            throw new DuplicateDataException(Messages.getString("PriceShiftDAO.0"));
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        ShiftDAO.getInstance().delete(object, session);
    }

    @Override
    public List<PriceShift> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public boolean exists(String string) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)PriceShift.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            throw new PosException("An error occured while trying to check price shift duplicacy", exception);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean priceShiftExists(String string, Integer n, Integer n2, Integer n3, Integer n4, String string2, Session session) throws PosException {
        SimpleExpression simpleExpression;
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        if (StringUtils.isNotEmpty((String)string)) {
            simpleExpression = Restrictions.ne((String)"id", (Object)string);
            criteria.add((Criterion)simpleExpression);
        }
        this.addDeletedFilter(criteria);
        simpleExpression = Restrictions.eq((String)PriceShift.PROP_START_HOUR, (Object)n);
        SimpleExpression simpleExpression2 = Restrictions.eq((String)PriceShift.PROP_START_MIN, (Object)n2);
        SimpleExpression simpleExpression3 = Restrictions.eq((String)PriceShift.PROP_END_HOUR, (Object)n3);
        SimpleExpression simpleExpression4 = Restrictions.eq((String)PriceShift.PROP_END_MIN, (Object)n4);
        SimpleExpression simpleExpression5 = Restrictions.eq((String)PriceShift.PROP_DAYS_OF_WEEK, (Object)string2);
        Conjunction conjunction = Restrictions.and((Criterion[])new Criterion[]{simpleExpression, simpleExpression2, simpleExpression3, simpleExpression4, simpleExpression5});
        criteria.add((Criterion)conjunction);
        List list = criteria.list();
        return list != null && list.size() > 0;
    }

    public List<PriceShift> findAllActive() {
        try (Session session = null;){
            session = this.createNewSession();
            List<PriceShift> list = this.findAllActive(session);
            return list;
        }
    }

    public List<PriceShift> findAllActive(Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)PriceShift.PROP_ENABLE, (Object)Boolean.TRUE));
        criteria.addOrder(Order.asc((String)PriceShift.PROP_PRIORITY));
        return criteria.list();
    }
}

