/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.PosLog;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.JsonUtil;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.lang.StringUtils;

public class DiscountData
implements Serializable {
    private String a;
    private String b;
    private Date c;
    private double d;
    private double e;
    private String f;
    private boolean g = Boolean.FALSE;

    public String getItemName() {
        return this.a;
    }

    public void setItemName(String string) {
        this.a = string;
    }

    public String getTicketId() {
        return this.b;
    }

    public void setTicketId(String string) {
        this.b = string;
    }

    public String getFormattedDate() {
        if (this.c == null) {
            return null;
        }
        return DateUtil.formatDateAsString(this.c);
    }

    public Date getDate() {
        return this.c;
    }

    public void setDate(Date date) {
        this.c = date;
    }

    public double getDiscount() {
        if (this.g) {
            return this.getTicketDiscount();
        }
        return this.getTotalItemDiscount();
    }

    public double getTotalWithDiscount() {
        return this.d;
    }

    public void setTotalWithDiscount(double d) {
        this.d = d;
    }

    public String getProperties() {
        return this.f;
    }

    public void setProperties(String string) {
        this.f = string;
    }

    public double getTicketDiscount() {
        if (StringUtils.isBlank((String)this.f) || this.f.equals("[]")) {
            return 0.0;
        }
        double d = 0.0;
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(this.f));){
            JsonArray jsonArray = jsonReader.readArray();
            for (JsonObject jsonObject : jsonArray) {
                d += JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_TOTAL_DISCOUNT_AMOUNT).doubleValue();
            }
        }
        catch (Exception exception) {
            PosLog.error(DiscountData.class, exception);
        }
        return d;
    }

    public String getDiscountName() {
        if (StringUtils.isBlank((String)this.f) || this.f.equals("[]")) {
            return null;
        }
        String string = "";
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(this.f));){
            JsonArray jsonArray = jsonReader.readArray();
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JsonObject jsonObject = (JsonObject)iterator.next();
                string = string + JsonUtil.getString(jsonObject, TicketDiscount.PROP_NAME);
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
        }
        catch (Exception exception) {
            PosLog.error(DiscountData.class, exception);
        }
        return string;
    }

    public boolean isTicketDiscount() {
        return this.g;
    }

    public void setTicketDiscount(boolean bl) {
        this.g = bl;
    }

    public double getTotalItemDiscount() {
        return this.e;
    }

    public void setTotalItemDiscount(double d) {
        this.e = d;
    }
}

