/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MenuUsageReport {
    private Date a;
    private Date b;
    private Date c;
    private List<MenuUsageReportData> d = new ArrayList<MenuUsageReportData>();
    private MenuUsageReportTableModel e;

    public MenuUsageReportTableModel getTableModel() {
        if (this.e == null) {
            this.e = new MenuUsageReportTableModel(this.d);
        }
        return this.e;
    }

    public Date getFromDate() {
        return this.a;
    }

    public void setFromDate(Date date) {
        this.a = date;
    }

    public Date getReportTime() {
        return this.c;
    }

    public void setReportTime(Date date) {
        this.c = date;
    }

    public Date getToDate() {
        return this.b;
    }

    public void setToDate(Date date) {
        this.b = date;
    }

    public void addReportData(MenuUsageReportData menuUsageReportData) {
        this.d.add(menuUsageReportData);
    }

    public void addAllReportData(List<MenuUsageReportData> list) {
        for (MenuUsageReportData menuUsageReportData : list) {
            menuUsageReportData.calculate();
            this.d.add(menuUsageReportData);
        }
    }

    public static class MenuUsageReportTableModel
    extends ListTableModel {
        public MenuUsageReportTableModel(List<MenuUsageReportData> list) {
            super(new String[]{"category", "count", "grossSale", "discount", "returnAmount", "netSale", "serviceCharge", "total", "profit", "profitPercentage", "taxAmount"}, list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MenuUsageReportData menuUsageReportData = (MenuUsageReportData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return menuUsageReportData.getCategoryName();
                }
                case 1: {
                    return NumberUtil.formatNumber(menuUsageReportData.getCount());
                }
                case 2: {
                    return NumberUtil.formatNumber(menuUsageReportData.getGrossSales());
                }
                case 3: {
                    return NumberUtil.formatNumber(menuUsageReportData.getDiscount());
                }
                case 4: {
                    return NumberUtil.formatNumber(menuUsageReportData.getReturnAmount());
                }
                case 5: {
                    return NumberUtil.formatNumber(menuUsageReportData.getNetSales());
                }
                case 6: {
                    return NumberUtil.formatNumber(menuUsageReportData.getServiceCharge());
                }
                case 7: {
                    return NumberUtil.formatNumber(menuUsageReportData.getTotal());
                }
                case 8: {
                    return NumberUtil.formatNumber(menuUsageReportData.getProfit());
                }
                case 9: {
                    return menuUsageReportData.getPercentage();
                }
                case 10: {
                    return NumberUtil.formatNumber(menuUsageReportData.getTaxAmount());
                }
            }
            return null;
        }
    }

    public static class MenuUsageReportData {
        private double a;
        private String b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        private double m;
        private double n;
        private double o;

        public double getAvgSales() {
            return this.f;
        }

        public void setAvgSales(double d) {
            this.f = d;
        }

        public String getCategoryName() {
            return this.b;
        }

        public void setCategoryName(String string) {
            this.b = string;
        }

        public double getCostPercentage() {
            return this.h;
        }

        public void setCostPercentage(double d) {
            this.h = d;
        }

        public double getCount() {
            return this.a;
        }

        public void setCount(double d) {
            this.a = d;
        }

        public double getDiscount() {
            return this.d;
        }

        public void setDiscount(double d) {
            this.d = d;
        }

        public double getGrossSales() {
            return this.c;
        }

        public void setGrossSales(double d) {
            this.c = d;
        }

        public double getNetSales() {
            return this.e;
        }

        public void setNetSales(double d) {
            this.e = d;
        }

        public double getPercentage() {
            return this.i;
        }

        public void setPercentage(double d) {
            this.i = d;
        }

        public double getProfit() {
            return this.g;
        }

        public void setProfit(double d) {
            this.g = d;
        }

        public void calculate() {
            this.e = this.c + this.d + this.m;
            this.k = this.e + this.j + this.o;
            this.g = this.k - this.l;
            this.i = NumberUtil.isZero(this.k) ? 0.0 : this.g / Math.abs(this.k) * 100.0;
        }

        public double getServiceCharge() {
            return this.j;
        }

        public void setServiceCharge(double d) {
            this.j = d;
        }

        public double getTotal() {
            return this.k;
        }

        public void setTotal(double d) {
            this.k = d;
        }

        public double getTotalCost() {
            return this.l;
        }

        public void setTotalCost(double d) {
            this.l = d;
        }

        public double getReturnAmount() {
            return this.m;
        }

        public void setReturnAmount(double d) {
            this.m = d;
        }

        public double getIncludedTaxAmount() {
            return this.n;
        }

        public void setIncludedTaxAmount(double d) {
            this.n = d;
        }

        public double getTaxAmount() {
            return this.o;
        }

        public void setTaxAmount(double d) {
            this.o = d;
        }
    }
}

