/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.swing.ListTableModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SalesDetailedReport {
    private Date j;
    private Date k;
    private Date l;
    int a;
    double b;
    int c;
    double d;
    int e;
    double f;
    double g;
    double h;
    double i;
    private Map<String, CreditCardData> m = new HashMap<String, CreditCardData>();
    private Map<String, OtherPaymentData> n = new HashMap<String, OtherPaymentData>();
    private Map<String, RefundPaymentData> o = new HashMap<String, RefundPaymentData>();

    public void addCreditCardData(CreditCardTransaction creditCardTransaction) {
        CreditCardData creditCardData = this.m.get(creditCardTransaction.getCardType());
        if (creditCardData == null) {
            creditCardData = new CreditCardData();
            creditCardData.setCardName(creditCardTransaction.getCardType());
            this.m.put(creditCardTransaction.getCardType(), creditCardData);
        }
        creditCardData.setSalesCount(creditCardData.getSalesCount() + 1);
        creditCardData.setSalesAmount(creditCardData.getSalesAmount() + creditCardTransaction.getAmount());
        creditCardData.setNetSalesAmount(creditCardData.getNetSalesAmount() + creditCardTransaction.getAmount());
    }

    public void addCreditCardData(DebitCardTransaction debitCardTransaction) {
        CreditCardData creditCardData = this.m.get(debitCardTransaction.getCardType());
        if (creditCardData == null) {
            creditCardData = new CreditCardData();
            creditCardData.setCardName(debitCardTransaction.getCardType());
            this.m.put(debitCardTransaction.getCardType(), creditCardData);
        }
        creditCardData.setSalesCount(creditCardData.getSalesCount() + 1);
        creditCardData.setSalesAmount(creditCardData.getSalesAmount() + debitCardTransaction.getAmount());
        creditCardData.setNetSalesAmount(creditCardData.getNetSalesAmount() + debitCardTransaction.getAmount());
    }

    public void addPaymentData(PosTransaction posTransaction) {
        PaymentType paymentType = posTransaction.getPaymentType();
        String string = posTransaction.getCardType();
        if (posTransaction instanceof RefundTransaction) {
            if (paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) {
                RefundPaymentData refundPaymentData = this.o.get(string);
                if (refundPaymentData == null) {
                    refundPaymentData = new RefundPaymentData();
                    refundPaymentData.setPaymentName(string.replaceAll("_", " "));
                    this.o.put(string, refundPaymentData);
                }
                refundPaymentData.setRefundCount(refundPaymentData.getRefundCount() + 1);
                refundPaymentData.setRefundAmount(refundPaymentData.getRefundAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            } else if (paymentType == PaymentType.CUSTOM_PAYMENT) {
                RefundPaymentData refundPaymentData = this.o.get(posTransaction.getCustomPaymentName());
                if (refundPaymentData == null) {
                    refundPaymentData = new RefundPaymentData();
                    refundPaymentData.setPaymentName(posTransaction.getCustomPaymentName());
                    this.o.put(posTransaction.getCustomPaymentName(), refundPaymentData);
                }
                refundPaymentData.setRefundCount(refundPaymentData.getRefundCount() + 1);
                refundPaymentData.setRefundAmount(refundPaymentData.getRefundAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            } else {
                RefundPaymentData refundPaymentData = this.o.get(posTransaction.getPaymentTypeString());
                if (refundPaymentData == null) {
                    refundPaymentData = new RefundPaymentData();
                    refundPaymentData.setPaymentName(posTransaction.getPaymentType().getDisplayString());
                    this.o.put(posTransaction.getPaymentTypeString(), refundPaymentData);
                }
                refundPaymentData.setRefundCount(refundPaymentData.getRefundCount() + 1);
                refundPaymentData.setRefundAmount(refundPaymentData.getRefundAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            }
            this.i -= posTransaction.getAmount() - posTransaction.getTipsAmount();
        } else if (paymentType == PaymentType.CUSTOM_PAYMENT) {
            if (posTransaction.isVoided().booleanValue()) {
                return;
            }
            OtherPaymentData otherPaymentData = this.n.get(posTransaction.getCustomPaymentName());
            if (otherPaymentData == null) {
                otherPaymentData = new OtherPaymentData();
                otherPaymentData.setPaymentName(posTransaction.getCustomPaymentName());
                this.n.put(posTransaction.getCustomPaymentName(), otherPaymentData);
            }
            otherPaymentData.setSalesCount(otherPaymentData.getSalesCount() + 1);
            otherPaymentData.setSalesAmount(otherPaymentData.getSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetSalesAmount(otherPaymentData.getNetSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetTipsAmount(otherPaymentData.getNetTipsAmount() + posTransaction.getTipsAmount());
            this.i += posTransaction.getAmount() - posTransaction.getTipsAmount();
        } else if (paymentType == PaymentType.CASH || paymentType == PaymentType.GIFT_CERTIFICATE || paymentType == PaymentType.MEMBER_ACCOUNT) {
            if (posTransaction.isVoided().booleanValue()) {
                return;
            }
            OtherPaymentData otherPaymentData = this.n.get(posTransaction.getPaymentTypeString());
            if (otherPaymentData == null) {
                otherPaymentData = new OtherPaymentData();
                otherPaymentData.setPaymentName(posTransaction.getPaymentType().getDisplayString());
                this.n.put(posTransaction.getPaymentTypeString(), otherPaymentData);
            }
            otherPaymentData.setSalesCount(otherPaymentData.getSalesCount() + 1);
            otherPaymentData.setSalesAmount(otherPaymentData.getSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetSalesAmount(otherPaymentData.getNetSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            otherPaymentData.setNetTipsAmount(otherPaymentData.getNetTipsAmount() + posTransaction.getTipsAmount());
            this.i += posTransaction.getAmount() - posTransaction.getTipsAmount();
        } else if (paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) {
            if (posTransaction.isVoided().booleanValue() && !posTransaction.hasProperty("REFUNDED_AMOUNT")) {
                return;
            }
            CreditCardData creditCardData = this.m.get(string);
            if (creditCardData == null) {
                creditCardData = new CreditCardData();
                creditCardData.setCardName(string != null ? string.replaceAll("_", " ") : Messages.getString("SalesDetailedReport.0"));
                this.m.put(string, creditCardData);
            }
            creditCardData.setSalesCount(creditCardData.getSalesCount() + 1);
            creditCardData.setSalesAmount(creditCardData.getSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            creditCardData.setNetSalesAmount(creditCardData.getNetSalesAmount() + (posTransaction.getAmount() - posTransaction.getTipsAmount()));
            creditCardData.setNetTipsAmount(creditCardData.getNetTipsAmount() + posTransaction.getTipsAmount());
            this.i += posTransaction.getAmount() - posTransaction.getTipsAmount();
        }
    }

    public Date getFromDate() {
        return this.j;
    }

    public void setFromDate(Date date) {
        this.j = date;
    }

    public Date getReportTime() {
        return this.l;
    }

    public void setReportTime(Date date) {
        this.l = date;
    }

    public Date getToDate() {
        return this.k;
    }

    public void setToDate(Date date) {
        this.k = date;
    }

    public CreditCardDataTableModel getCreditCardDataTableModel() {
        CreditCardDataTableModel creditCardDataTableModel = new CreditCardDataTableModel();
        ArrayList<CreditCardData> arrayList = new ArrayList<CreditCardData>(this.m.values());
        creditCardDataTableModel.setRows(arrayList);
        for (CreditCardData creditCardData : arrayList) {
            double d = creditCardData.getNetSalesAmount() + creditCardData.getNetTipsAmount();
            creditCardData.setTotalAmount(d);
        }
        return creditCardDataTableModel;
    }

    public OtherPaymentDataTableModel getOtherPaymentDataTableModel() {
        OtherPaymentDataTableModel otherPaymentDataTableModel = new OtherPaymentDataTableModel();
        ArrayList<OtherPaymentData> arrayList = new ArrayList<OtherPaymentData>(this.n.values());
        ArrayList<OtherPaymentData> arrayList2 = new ArrayList<OtherPaymentData>();
        for (OtherPaymentData otherPaymentData : arrayList) {
            double d = otherPaymentData.getNetSalesAmount() + otherPaymentData.getNetTipsAmount();
            otherPaymentData.setTotalAmount(d);
            if (otherPaymentData.getPaymentName() != null && otherPaymentData.getPaymentName().equals(PaymentType.CASH.getDisplayString())) {
                arrayList2.add(0, otherPaymentData);
                continue;
            }
            arrayList2.add(otherPaymentData);
        }
        otherPaymentDataTableModel.setRows(arrayList2);
        return otherPaymentDataTableModel;
    }

    public RefundPaymentDataTableModel getRefundPaymentDataTableModel() {
        RefundPaymentDataTableModel refundPaymentDataTableModel = new RefundPaymentDataTableModel();
        ArrayList<RefundPaymentData> arrayList = new ArrayList<RefundPaymentData>(this.o.values());
        ArrayList<RefundPaymentData> arrayList2 = new ArrayList<RefundPaymentData>();
        for (RefundPaymentData refundPaymentData : arrayList) {
            if (refundPaymentData.getPaymentName() != null && refundPaymentData.getPaymentName().equals(PaymentType.CASH.getDisplayString())) {
                arrayList2.add(0, refundPaymentData);
                continue;
            }
            arrayList2.add(refundPaymentData);
        }
        refundPaymentDataTableModel.setRows(arrayList2);
        return refundPaymentDataTableModel;
    }

    public double getChargedTips() {
        return this.f;
    }

    public void setChargedTips(double d) {
        this.f = d;
    }

    public double getGiftCertChangeAmount() {
        return this.d;
    }

    public void setGiftCertChangeAmount(double d) {
        this.d = d;
    }

    public int getGiftCertChangeCount() {
        return this.c;
    }

    public void setGiftCertChangeCount(int n) {
        this.c = n;
    }

    public double getGiftCertReturnAmount() {
        return this.b;
    }

    public void setGiftCertReturnAmount(double d) {
        this.b = d;
    }

    public int getGiftCertReturnCount() {
        return this.a;
    }

    public void setGiftCertReturnCount(int n) {
        this.a = n;
    }

    public double getTipsDifferential() {
        return this.h;
    }

    public void setTipsDifferential(double d) {
        this.h = d;
    }

    public double getTipsPaid() {
        return this.g;
    }

    public void setTipsPaid(double d) {
        this.g = d;
    }

    public int getTipsCount() {
        return this.e;
    }

    public void setTipsCount(int n) {
        this.e = n;
    }

    public class RefundPaymentDataTableModel
    extends ListTableModel<RefundPaymentData> {
        public RefundPaymentDataTableModel() {
            this.setColumnNames(new String[]{"paymentName", "returnCount", "returnAmount"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            RefundPaymentData refundPaymentData = (RefundPaymentData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return refundPaymentData.a;
                }
                case 1: {
                    return refundPaymentData.b;
                }
                case 2: {
                    return refundPaymentData.c;
                }
            }
            return null;
        }
    }

    public class OtherPaymentDataTableModel
    extends ListTableModel<OtherPaymentData> {
        public OtherPaymentDataTableModel() {
            this.setColumnNames(new String[]{"paymentName", "salesCount", "salesAmount", "returnCount", "returnAmount", "netAmount", "netTipsAmount", "percentage"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            OtherPaymentData otherPaymentData = (OtherPaymentData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return otherPaymentData.a;
                }
                case 1: {
                    return otherPaymentData.b;
                }
                case 2: {
                    return otherPaymentData.c;
                }
                case 3: {
                    return otherPaymentData.d;
                }
                case 4: {
                    return otherPaymentData.e;
                }
                case 5: {
                    return otherPaymentData.f;
                }
                case 6: {
                    return otherPaymentData.g;
                }
                case 7: {
                    return otherPaymentData.h;
                }
            }
            return null;
        }
    }

    public class CreditCardDataTableModel
    extends ListTableModel<CreditCardData> {
        public CreditCardDataTableModel() {
            this.setColumnNames(new String[]{"creditCard", "salesCount", "salesAmount", "returnCount", "returnAmount", "netAmount", "netTipsAmount", "percentage"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CreditCardData creditCardData = (CreditCardData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return creditCardData.a;
                }
                case 1: {
                    return creditCardData.b;
                }
                case 2: {
                    return creditCardData.c;
                }
                case 3: {
                    return creditCardData.d;
                }
                case 4: {
                    return creditCardData.e;
                }
                case 5: {
                    return creditCardData.f;
                }
                case 6: {
                    return creditCardData.g;
                }
                case 7: {
                    return creditCardData.h;
                }
            }
            return null;
        }
    }

    public static class RefundPaymentData {
        String a;
        int b;
        double c;

        public String getPaymentName() {
            return this.a;
        }

        public void setPaymentName(String string) {
            this.a = string;
        }

        public double getRefundAmount() {
            return this.c;
        }

        public void setRefundAmount(double d) {
            this.c = d;
        }

        public int getRefundCount() {
            return this.b;
        }

        public void setRefundCount(int n) {
            this.b = n;
        }
    }

    public static class OtherPaymentData {
        String a;
        int b;
        double c;
        int d;
        double e;
        double f;
        double g;
        double h;

        public String getPaymentName() {
            return this.a;
        }

        public void setPaymentName(String string) {
            this.a = string;
        }

        public double getNetSalesAmount() {
            return this.f;
        }

        public void setNetSalesAmount(double d) {
            this.f = d;
        }

        public double getNetTipsAmount() {
            return this.g;
        }

        public void setNetTipsAmount(double d) {
            this.g = d;
        }

        public double getTotalAmount() {
            return this.h;
        }

        public void setTotalAmount(double d) {
            this.h = d;
        }

        public double getReturnAmount() {
            return this.e;
        }

        public void setReturnAmount(double d) {
            this.e = d;
        }

        public int getReturnCount() {
            return this.d;
        }

        public void setReturnCount(int n) {
            this.d = n;
        }

        public double getSalesAmount() {
            return this.c;
        }

        public void setSalesAmount(double d) {
            this.c = d;
        }

        public int getSalesCount() {
            return this.b;
        }

        public void setSalesCount(int n) {
            this.b = n;
        }
    }

    public static class CreditCardData {
        String a;
        int b;
        double c;
        int d;
        double e;
        double f;
        double g;
        double h;

        public String getCardName() {
            return this.a;
        }

        public void setCardName(String string) {
            this.a = string;
        }

        public double getNetSalesAmount() {
            return this.f;
        }

        public void setNetSalesAmount(double d) {
            this.f = d;
        }

        public double getNetTipsAmount() {
            return this.g;
        }

        public void setNetTipsAmount(double d) {
            this.g = d;
        }

        public double getTotalAmount() {
            return this.h;
        }

        public void setTotalAmount(double d) {
            this.h = d;
        }

        public double getRefundAmount() {
            return this.e;
        }

        public void setRefundAmount(double d) {
            this.e = d;
        }

        public int getRefundCount() {
            return this.d;
        }

        public void setRefundCount(int n) {
            this.d = n;
        }

        public double getSalesAmount() {
            return this.c;
        }

        public void setSalesAmount(double d) {
            this.c = d;
        }

        public int getSalesCount() {
            return this.b;
        }

        public void setSalesCount(int n) {
            this.b = n;
        }
    }
}

