/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Customer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeliverySummaryReportData;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DeliverySummaryReportModel
extends ListTableModel {
    Map<String, Customer> a = new HashMap<String, Customer>();
    Map<String, User> b = new HashMap<String, User>();

    public DeliverySummaryReportModel() {
        super(new String[]{"empName", "ticketHeaderDetails", "itemName", "itemSubtotalAmount", "discount", "tax", "total", "ticketId"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DeliverySummaryReportData deliverySummaryReportData = (DeliverySummaryReportData)this.rows.get(n);
        switch (n2) {
            case 0: {
                if (StringUtils.isBlank((String)deliverySummaryReportData.getEmployeeId())) {
                    return Messages.getString("DeliverySummaryReportModel.2");
                }
                return Messages.getString("DeliverySummaryReportModel.1") + deliverySummaryReportData.getEmployeeId() + " / " + deliverySummaryReportData.getEmployeeName();
            }
            case 1: {
                String string = "";
                string = string + ReportUtil.reportLabelWithBoldTag(POSConstants.TICKET_ID + ": ") + deliverySummaryReportData.getTicketId();
                string = string + ", " + ReportUtil.reportLabelWithBoldTag(Messages.getString("CUSTOMER") + ": ") + this.a(deliverySummaryReportData);
                if (deliverySummaryReportData.getAssignedDriverId() != null) {
                    string = string + ", " + this.a(deliverySummaryReportData.getAssignedDriverId());
                }
                string = string + ", " + ReportUtil.reportLabelWithBoldTag(Messages.getString("DeliveryDate") + ": ") + DateUtil.tweentyFourHoursDateFormat(deliverySummaryReportData.getDeliveryDate());
                string = string + ", " + ReportUtil.reportLabelWithBoldTag(Messages.getString("DeliverySummaryReportView.0") + ": ") + NumberUtil.getCurrencyFormatWithoutCurrencySymbol(deliverySummaryReportData.getDeliveryCharge());
                return string;
            }
            case 2: {
                String string = deliverySummaryReportData.getTicketItemName();
                double d = deliverySummaryReportData.getTicketItemQuantity();
                if (d != 1.0) {
                    string = NumberUtil.trimDecilamIfNotNeeded(d, true) + "x " + deliverySummaryReportData.getTicketItemName();
                }
                return string;
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getSubTotalAmount());
            }
            case 4: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getDiscount());
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getAdjustedTaxAmount());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(deliverySummaryReportData.getSubTotalAmount() - deliverySummaryReportData.getDiscount() + deliverySummaryReportData.getAdjustedTaxAmount());
            }
            case 7: {
                return deliverySummaryReportData.getTicketId();
            }
        }
        return null;
    }

    private String a(String string) {
        if (StringUtils.isBlank((String)string)) {
            return Messages.getString("DeliverySummaryReportModel.0");
        }
        User user = this.b.get(string);
        if (user == null) {
            user = UserDAO.getInstance().get(string);
            this.b.put(string, user);
        }
        return ReportUtil.reportLabelWithBoldTag("Driver: ") + user.getFullName();
    }

    private String a(DeliverySummaryReportData deliverySummaryReportData) {
        String string = deliverySummaryReportData.getCustomerId();
        if (StringUtils.isBlank((String)string)) {
            return Messages.getString("GUEST");
        }
        Customer customer = this.a.get(string);
        if (customer == null) {
            customer = CustomerDAO.getInstance().get(string);
            if (customer == null) {
                return this.b(deliverySummaryReportData.getProperties());
            }
            this.a.put(string, customer);
        }
        return customer == null ? "" : customer.getName();
    }

    private String b(String string) {
        JsonElement jsonElement;
        String string2;
        JsonObject jsonObject;
        String string3 = "";
        if (StringUtils.isNotEmpty((String)string) && (jsonObject = StringUtils.isBlank((String)string) ? new JsonObject() : (JsonObject)new Gson().fromJson(string, JsonObject.class)).has(string2 = "CUSTOMER_NAME") && !(jsonElement = jsonObject.get(string2)).isJsonNull()) {
            string3 = jsonElement.getAsString();
        }
        return string3;
    }
}

