/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.hibernate.Session;

public class SalesTaxReportService {
    private Date a;
    private Date b;
    private SalesReportModel c;

    public SalesTaxReportService(Date date, Date date2) {
        this.a = date;
        this.b = date2;
    }

    public JasperPrint createSalesTaxReportJasperPrint() throws JRException {
        this.a();
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_tax_sub_report"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, null, this.a, this.b, null, true);
        this.a(hashMap);
        hashMap.put("dailySalesDataSource", new JRTableModelDataSource((TableModel)this.c));
        hashMap.put("dailySalesReport", jasperReport);
        JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_tax_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, hashMap, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    private void a(HashMap<String, Object> hashMap) {
        String string = POSConstants.SALES_TAX_REPORT;
        String string2 = POSConstants.DATE;
        hashMap.put("reportTitle", string);
        hashMap.put("colName", ReportUtil.reportLabelWithBoldTag(string2));
        hashMap.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("colId", ReportUtil.reportLabelWithBoldTag(POSConstants.ID));
        hashMap.put("colQty", ReportUtil.reportLabelWithBoldTag(POSConstants.QTY));
        hashMap.put("colUnit", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT));
        hashMap.put("colSales", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT_PRICE));
        hashMap.put("colDiscount", ReportUtil.reportLabelWithBoldTag(POSConstants.DISCOUNT));
        hashMap.put("colCost", ReportUtil.reportLabelWithBoldTag(POSConstants.COST));
        hashMap.put("colCostPer", ReportUtil.reportLabelWithBoldTag(POSConstants.COST_PERCENTAGE));
        hashMap.put("colNetTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.NET_SALES));
        hashMap.put("colTax", ReportUtil.reportLabelWithBoldTag(POSConstants.TAX));
        hashMap.put("colSC", ReportUtil.reportLabelWithBoldTag(POSConstants.S_C));
        hashMap.put("colGrossT", ReportUtil.reportLabelWithBoldTag(POSConstants.TOTAL));
        hashMap.put("groupTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GROUP_TOTAL));
        hashMap.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        hashMap.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.MODIFIER_TOTAL + ": "));
        hashMap.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        hashMap.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_SALES));
        hashMap.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag(Messages.getString("SalesReportService.0")));
        hashMap.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag(POSConstants.RETURN));
        hashMap.put("lblProfit", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_PROFIT));
        hashMap.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag(POSConstants.PROFIT + " %"));
        hashMap.put("itemSection", POSConstants.ITEMS);
    }

    private void a() {
        List<Date> list = POSUtil.getMonthBetweenDates(this.a, this.b);
        ArrayList<ReportItem> arrayList = new ArrayList<ReportItem>();
        GenericDAO genericDAO = new GenericDAO();
        try (Session session = genericDAO.createNewSession();){
            session.setDefaultReadOnly(true);
            for (Date date : list) {
                ReportItem reportItem = new ReportItem();
                Date date2 = DateUtil.startOfMonth(date);
                Date date3 = DateUtil.endOfMonth(date);
                reportItem.setName(DateUtil.format("MMM yyyy", date2));
                SalesReportUtil salesReportUtil = new SalesReportUtil(date2, date3);
                double d = salesReportUtil.calculateGrossSalesWithOutIncludedTax(session);
                double d2 = salesReportUtil.calculateDiscountAmount(session);
                double d3 = salesReportUtil.calculateReturnAmountWithOutIncludedTax(session);
                d2 = NumberUtil.isZero(d2) ? 0.0 : -1.0 * d2;
                d3 = NumberUtil.isZero(d3) ? 0.0 : -1.0 * d3;
                double d4 = d + d2 + d3;
                double d5 = salesReportUtil.calculateTotalServiceChargeAmount(session);
                double d6 = salesReportUtil.calculateSalesTaxAmount(session);
                reportItem.setGrossSale(d);
                reportItem.setDiscount(d2);
                reportItem.setReturnAmount(d3);
                reportItem.setNetTotal(d4);
                reportItem.setServiceCharge(d5);
                reportItem.setTaxTotal(d6);
                reportItem.setTotal(d4 + d5 + d6);
                reportItem.calculate();
                arrayList.add(reportItem);
            }
        }
        this.c = new SalesReportModel();
        this.c.setItems(arrayList);
    }
}

