/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashInTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CategoryBreakOut;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StoreSessionSummaryReportService {
    private StoreSession a;
    private Session b;
    private CashDrawer c = new CashDrawer();

    public StoreSessionSummaryReportService(StoreSession storeSession) {
        this.a = storeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer populateStoreSessionSummaryReport() {
        GenericDAO genericDAO = new GenericDAO();
        try {
            this.b = genericDAO.createNewSession();
            SalesReportUtil salesReportUtil = new SalesReportUtil(this.a);
            this.c.setGrossSales(salesReportUtil.calculateGrossSalesWithOutIncludedTax(this.b));
            this.c.setTotalDiscountAmount(salesReportUtil.calculateDiscountAmount(this.b));
            this.c.setReturnAmount(salesReportUtil.calculateReturnAmountWithOutIncludedTax(this.b));
            this.c.setNetSales(this.c.getGrossSales() - this.c.getTotalDiscountAmount() - this.c.getReturnAmount());
            this.c.setSalesTax(salesReportUtil.calculateSalesTaxAmount(this.b));
            this.c.setServiceCharge(salesReportUtil.calculateTotalServiceChargeAmount(this.b));
            this.c.setFeeAmount(salesReportUtil.calculateFeeAmount(this.b));
            this.c.setTotalRevenue(POSUtil.getDoubleAmount(this.c.getNetSales() + this.c.getSalesTax() + this.c.getServiceCharge() + this.c.getFeeAmount()));
            this.c.setCashTips(salesReportUtil.calculateGratuity(this.b));
            this.c.setGrossReceipts(POSUtil.getDoubleAmount(this.c.getTotalRevenue() + this.c.getCashTips()));
            this.c.setRefundAmount(salesReportUtil.calculateRefundAmount(this.b));
            this.c.setCashReceiptAmount(salesReportUtil.calculateCashReceipt(this.b));
            this.c.setCreditCardReceiptAmount(salesReportUtil.calculateCreditReceipt(this.b));
            this.c.setDebitCardReceiptAmount(salesReportUtil.calculateDebitReceipt(this.b));
            this.c.setCustomerPaymentAmount(salesReportUtil.calculateMemberPayment(this.b));
            this.c.setCustomPaymentAmount(salesReportUtil.calculateCustomPaymentWithoutPromotion(this.b));
            this.c.setPromotionAmount(salesReportUtil.calculatePromotionPayment(this.b));
            this.c.setGiftCertChangeAmount(salesReportUtil.calculateGiftCertReceipts(this.b));
            this.c.setRoundedAmount(salesReportUtil.calculateRoundingAmount(this.b));
            this.a();
            this.d();
            this.e();
            this.g();
            this.f();
            this.k();
            Store store = DataProvider.get().getStore();
            if (POSUtil.getBoolean(store.getProperty("show_category_breakout.in_server_Summary"))) {
                List<CategoryBreakOut> list = salesReportUtil.calculateCategoryBreakout(this.b);
                this.c.setCategoryBreakOut(list);
            }
            double d = this.c.getCashReceiptAmount() + this.c.getCreditCardReceiptAmount() + this.c.getDebitCardReceiptAmount() + this.c.getCustomerPaymentAmount() + this.c.getCustomPaymentAmount() + this.c.getPromotionAmount() + this.c.getGiftCertChangeAmount() - this.c.getRefundAmount() - this.c.getToleranceAmount();
            this.c.setReceiptDifferential(NumberUtil.round(this.c.getGrossReceipts() - d));
            this.c.setAssignedUser(this.a.getOpenedBy());
            this.c.setStartTime(this.a.getOpenTime());
            this.c.setAssignedBy(this.a.getOpenedBy());
            this.c.setReportTime(this.a.getCloseTime());
            this.c.setClosedBy(this.a.getClosedBy());
            this.c.setStoreOperationData(this.a);
            this.i();
            this.j();
            this.b();
            this.c();
            this.h();
            CashDrawer cashDrawer = this.c;
            return cashDrawer;
        }
        finally {
            if (this.b != null) {
                this.b.close();
            }
        }
    }

    private Criteria a(Class clazz) {
        Criteria criteria = this.b.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else if (clazz.equals(PayOutTransaction.class) || clazz.equals(CashDropTransaction.class)) {
            LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()), (Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.OUT.name()));
            criteria.add((Criterion)logicalExpression);
        } else if (clazz.equals(CashInTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.IN.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private void a() {
        Criteria criteria = this.b.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.c.setCardVoidAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void b() {
        Criteria criteria = this.b.createCriteria(CashDrawer.class);
        criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
        this.c.setBeginCash(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void c() {
        Criteria criteria = this.a(CashInTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashInTransaction.PROP_AMOUNT));
        this.c.setCashInAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void d() {
        Criteria criteria = this.b.createCriteria(GratuityPaymentHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
        this.c.setTipsPaid(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void e() {
        Criteria criteria = this.a(PayOutTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.c.setPayOutAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void f() {
        Criteria criteria = this.a(CashDropTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashDropTransaction.PROP_AMOUNT));
        this.c.setDrawerBleedAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void g() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.c.setCashBack(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void h() {
        double d = this.c.getCashReceiptAmount() - this.c.getTipsPaid() - this.c.getPayOutAmount() - this.c.getCashBack() + this.c.getBeginCash() + this.c.getCashInAmount() - this.c.getDrawerBleedAmount();
        this.c.setDrawerAccountable(d);
    }

    private void i() {
        double d = this.c.getCashTips() + this.c.getChargedTips() - this.c.getTipsPaid();
        this.c.setTipsDifferential(POSUtil.getDoubleAmount(d));
    }

    private void j() {
        Criteria criteria = this.b.createCriteria(DeclaredTips.class);
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)CashDropTransaction.PROP_AMOUNT));
        this.c.setDeclaredTips(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void k() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        this.c.setToleranceAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    public static CashDrawer createSessionSummaryReport(StoreSession storeSession) throws Exception {
        StoreSessionSummaryReportService storeSessionSummaryReportService = new StoreSessionSummaryReportService(storeSession);
        CashDrawer cashDrawer = storeSessionSummaryReportService.populateStoreSessionSummaryReport();
        return cashDrawer;
    }
}

