/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.POSFileChooser;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.JpegReader;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.ImageUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class ImageUploaderDialog
extends POSDialog {
    public static String LAST_USED_FOLDER = "";
    private ImageResource.IMAGE_CATEGORY a = ImageResource.IMAGE_CATEGORY.PRODUCTS;
    private JLabel b;
    private JLabel c;
    private ImageResource d;
    private POSTextField e;
    private POSToggleButton f;
    private POSToggleButton g;
    private POSToggleButton h;
    private POSToggleButton i;
    private JPanel j;
    private ArrayList<byte[]> k;
    private boolean l;
    private JProgressBar m;
    private JLabel n;
    private PosButton o;
    private PosButton p;
    private List<ImagePreviewWithDescription> q;
    private POSFileChooser r = null;
    private boolean s;
    private ArrayList<ImageResource> t;
    private StringBuffer u = new StringBuffer();

    public ImageUploaderDialog(ImageResource imageResource, ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.a = iMAGE_CATEGORY;
        this.d = imageResource;
        this.a();
        this.d();
    }

    public ImageUploaderDialog(ImageResource imageResource) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.d = imageResource;
        this.a();
        this.d();
    }

    public ImageUploaderDialog(ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.a = iMAGE_CATEGORY;
        this.a();
        this.d();
        this.l = true;
    }

    public ImageUploaderDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.a();
        this.d();
        this.l = true;
    }

    private void a() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ImageUploaderDialog.1"));
        this.t = new ArrayList();
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.f = new POSToggleButton(Messages.getString("ImageUploaderDialog.2"));
        this.g = new POSToggleButton(Messages.getString("ImageUploaderDialog.3"));
        this.h = new POSToggleButton(Messages.getString("ImageUploaderDialog.4"));
        this.i = new POSToggleButton(Messages.getString("ImageUploaderDialog.5"));
        buttonGroup.add(this.f);
        buttonGroup.add(this.g);
        buttonGroup.add(this.h);
        buttonGroup.add(this.i);
        jPanel.add(this.f);
        jPanel.add(this.g);
        jPanel.add(this.h);
        jPanel.add(this.i);
        this.h.setEnabled(true);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setBorder(new EmptyBorder(20, 5, 20, 5));
        this.b = new JLabel();
        this.c = new JLabel(Messages.getString("ImageUploaderDialog.6"));
        this.e = new POSTextField(50);
        this.j = new JPanel(new WrapLayout(1, PosUIManager.getSize(20), PosUIManager.getSize(20)));
        this.j.setBorder(BorderFactory.createLineBorder(Color.gray));
        JScrollPane jScrollPane = new JScrollPane(this.j, 20, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.setPreferredSize(new Dimension(350, 220));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jScrollPane.setVisible(true);
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jPanel3.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)this.c, "West");
        jPanel3.add((Component)this.e, "Center");
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[grow][grow][grow]", ""));
        this.m = new JProgressBar();
        this.m.setBounds(40, 40, 160, 30);
        this.m.setValue(0);
        this.m.setMinimum(0);
        this.m.setStringPainted(true);
        this.m.setVisible(false);
        this.u = new StringBuffer();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.o = new PosButton(Messages.getString("ImageUploaderDialog.11"));
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!ImageUploaderDialog.this.l) {
                        ImageUploaderDialog.this.selectImage();
                    } else {
                        ImageUploaderDialog.this.selectBulkImage();
                    }
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(exception.getMessage(), exception);
                }
            }
        });
        this.p = new PosButton(Messages.getString("ImageUploaderDialog.15"));
        this.p.setPreferredSize(PosUIManager.getSize(100, 0));
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.doOk();
                ImageUploaderDialog.this.setCanceled(false);
            }
        });
        PosButton posButton = new PosButton(Messages.getString("ImageUploaderDialog.16"));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.setCanceled(true);
                ImageUploaderDialog.this.dispose();
            }
        });
        this.n = new JLabel(Messages.getString("ImageUploaderDialog.17"));
        this.n.setVisible(false);
        jPanel4.add((Component)this.o, "");
        jPanel4.add((Component)this.n, "left,split 2");
        jPanel4.add((Component)this.m, "");
        jPanel4.add((Component)this.p, "growy,right,skip 2, split 2");
        jPanel4.add((Component)posButton, "");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel4, "South");
    }

    public void doOk() {
        if (!this.l) {
            this.b();
            ImageResourceDAO.getInstance().saveOrUpdate(this.d);
            this.t.add(this.d);
            OroMqttClient.getInstance().notifyDataUpdated(ImageResource.class);
        } else {
            this.doSaveMultipleImage();
        }
        this.dispose();
    }

    private void b() {
        try {
            byte[] byArray;
            if (this.d == null) {
                this.d = new ImageResource();
                this.d.addProperty("imageFormat", ImageUtil.IMAGE_FORMAT_PNG);
            }
            if ((byArray = (byte[])this.b.getClientProperty("image")) != null) {
                this.d.setImageBytes(byArray);
            }
            this.d.setDescription(this.e.getText());
            this.d.putImageFileName((String)this.b.getClientProperty("fileName"));
            if (this.f.isSelected()) {
                this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                this.a = ImageResource.IMAGE_CATEGORY.UNLISTED;
            } else if (this.g.isSelected()) {
                this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.a = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            } else if (this.i.isSelected()) {
                this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                this.a = ImageResource.IMAGE_CATEGORY.PEOPLE;
            } else if (this.h.isSelected()) {
                this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.a = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            } else {
                this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.a = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            }
        }
        catch (Exception exception) {
            PosLog.error(ImageUploaderDialog.class, exception.getMessage(), exception);
        }
    }

    public void doSaveMultipleImage() {
        try {
            for (ImagePreviewWithDescription imagePreviewWithDescription : this.q) {
                String string = imagePreviewWithDescription.getImageDescription().getText();
                String string2 = (String)imagePreviewWithDescription.getClientProperty("fileName");
                byte[] byArray = (byte[])imagePreviewWithDescription.getClientProperty("image");
                this.d = new ImageResource();
                this.d.addProperty("imageFormat", ImageUtil.IMAGE_FORMAT_PNG);
                if (byArray != null) {
                    this.d.setImageBytes(byArray);
                }
                this.d.setDescription(string);
                this.d.putImageFileName(string2);
                if (this.f.isSelected()) {
                    this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                    this.a = ImageResource.IMAGE_CATEGORY.UNLISTED;
                } else if (this.g.isSelected()) {
                    this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                    this.a = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
                } else if (this.i.isSelected()) {
                    this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                    this.a = ImageResource.IMAGE_CATEGORY.PEOPLE;
                } else if (this.h.isSelected()) {
                    this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.a = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                } else {
                    this.d.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.a = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                }
                this.t.add(this.d);
            }
            ImageResourceDAO.getInstance().saveOrUpdate(this.t);
            OroMqttClient.getInstance().notifyDataUpdated(ImageResource.class);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void selectBulkImage() throws Exception {
        if (!this.l) {
            this.m.setVisible(false);
            return;
        }
        this.m.setVisible(true);
        this.o.setVisible(false);
        this.p.setEnabled(false);
        this.q = new ArrayList<ImagePreviewWithDescription>();
        Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
        this.r = LAST_USED_FOLDER != null ? new POSFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
        this.r.setMultiSelectionEnabled(true);
        this.r.setFileSelectionMode(2);
        this.r.setAcceptAllFileFilterUsed(false);
        int n = this.r.showOpenDialog(POSUtil.getFocusedWindow());
        this.k = new ArrayList();
        if (n == 0) {
            File[] fileArray = this.r.getSelectedFiles();
            AsyncAction.execute(() -> {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    for (File file : fileArray) {
                        if (this.s) {
                            return;
                        }
                        if (file.isDirectory()) {
                            List<String> list = this.c();
                            File[] fileArray2 = file.listFiles(this.a(list));
                            if (fileArray2.length == 0) {
                                POSMessageDialog.showMessage(Messages.getString("ImageUploaderDialog.8"));
                                this.setCanceled(true);
                                this.dispose();
                            }
                            ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(fileArray2));
                            this.m.setMaximum(arrayList.size());
                            this.n.setVisible(true);
                            for (File file2 : arrayList) {
                                if (this.s) {
                                    return;
                                }
                                if (file2.isDirectory()) {
                                    this.m.setValue(this.m.getValue() + 1);
                                    continue;
                                }
                                this.a(file2);
                                this.m.setValue(this.m.getValue() + 1);
                            }
                        } else {
                            this.m.setMaximum(fileArray.length);
                            this.n.setVisible(true);
                            this.a(file);
                        }
                        this.m.setValue(this.m.getValue() + 1);
                    }
                    String string = this.u.toString();
                    if (StringUtils.isNotEmpty((String)string)) {
                        POSMessageDialog.showError(string);
                    }
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                    this.p.setEnabled(true);
                    this.m.setValue(this.m.getValue() + 1);
                }
            });
        } else {
            this.setCanceled(true);
            this.dispose();
        }
    }

    private FileFilter a(List<String> list) {
        return file -> {
            String string = this.a(file.getName());
            return list.contains(string);
        };
    }

    private void a(String string, byte[] byArray) {
        String string2 = FilenameUtils.removeExtension((String)string);
        ImagePreviewWithDescription imagePreviewWithDescription = new ImagePreviewWithDescription();
        imagePreviewWithDescription.putClientProperty("fileName", string);
        imagePreviewWithDescription.putClientProperty("image", byArray);
        this.q.add(imagePreviewWithDescription);
        imagePreviewWithDescription.setOpaque(true);
        ImageIcon imageIcon = new ImageIcon(byArray);
        ImageIcon imageIcon2 = ImageResource.getScaledImageIcon(imageIcon, 140);
        imagePreviewWithDescription.setImagePreview(imageIcon2);
        imagePreviewWithDescription.setImageDescription(string2);
        imagePreviewWithDescription.setBackground(Color.WHITE);
        imagePreviewWithDescription.getImagePreview().setHorizontalAlignment(0);
        this.j.add(imagePreviewWithDescription);
        this.j.revalidate();
        this.j.repaint();
    }

    private void a(File file) {
        try {
            PosLog.debug(this.getClass(), "Loading image " + file.getName());
            String string = this.a(file.toString());
            if (this.c().contains(string.trim().toLowerCase())) {
                int n;
                BufferedImage bufferedImage = JpegReader.readImage(file);
                if (bufferedImage == null) {
                    this.u.append("Failed to load image " + file.getName() + "\n");
                    return;
                }
                byte[] byArray = ImageUtil.convertImageToByteArray(bufferedImage);
                if (byArray != null && (n = byArray.length / 1024) > 1000) {
                    bufferedImage = ImageUtil.reduceImageFileSize(bufferedImage, bufferedImage.getWidth() > bufferedImage.getHeight() ? bufferedImage.getWidth() : bufferedImage.getHeight());
                    byArray = ImageUtil.convertImageToByteArray(bufferedImage);
                }
                this.k.add(byArray);
                this.a(file.getName(), byArray);
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Failed to upload image " + file.getName(), exception);
        }
    }

    private String a(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        int n2 = string2.indexOf(46, n = string2.lastIndexOf(92) + 1);
        return n2 == -1 ? "" : string2.substring(n2 + 1);
    }

    private List<String> c() {
        return Arrays.asList("jpg", "jpeg", "png", "gif");
    }

    public boolean selectImage() throws Exception {
        Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
        this.r = LAST_USED_FOLDER != null ? new POSFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
        this.r.setMultiSelectionEnabled(false);
        this.r.setFileSelectionMode(0);
        int n = this.r.showOpenDialog(POSUtil.getFocusedWindow());
        if (n == 0) {
            File file = this.r.getSelectedFile();
            preferences.put(LAST_USED_FOLDER, file.getPath());
            if (!file.exists()) {
                POSMessageDialog.showError(Messages.getString("ImageUploaderDialog.7"));
                return false;
            }
            BufferedImage bufferedImage = JpegReader.readImage(file);
            if (bufferedImage == null) {
                POSMessageDialog.showError(POSConstants.ERROR_MESSAGE);
                return false;
            }
            bufferedImage = ImageUtil.reduceImageFileSize(bufferedImage, bufferedImage.getWidth() > bufferedImage.getHeight() ? bufferedImage.getWidth() : bufferedImage.getHeight());
            this.b.setIcon(new ImageIcon(bufferedImage));
            this.e.setText(FilenameUtils.removeExtension((String)file.getName()));
            byte[] byArray = ImageUtil.convertImageToByteArray(bufferedImage);
            this.b.putClientProperty("fileName", file.getName());
            this.b.putClientProperty("image", byArray);
            this.b.setText("");
            this.j.add(this.b);
            this.setCanceled(false);
            return true;
        }
        this.setCanceled(true);
        return false;
    }

    private void d() {
        if (this.d != null && this.d.getImageCategory() != null) {
            this.a = this.d.getImageCategory();
        }
        if (this.a == ImageResource.IMAGE_CATEGORY.UNLISTED) {
            this.f.setSelected(true);
        } else if (this.a == ImageResource.IMAGE_CATEGORY.FLOORPLAN) {
            this.g.setSelected(true);
        } else if (this.a == ImageResource.IMAGE_CATEGORY.PRODUCTS) {
            this.h.setSelected(true);
        } else if (this.a == ImageResource.IMAGE_CATEGORY.PEOPLE) {
            this.i.setSelected(true);
        } else {
            this.h.setSelected(true);
        }
        if (this.d == null) {
            return;
        }
        ImageIcon imageIcon = this.d.getImageIcon();
        if (imageIcon == null) {
            return;
        }
        this.b.setText("");
        this.b.setIcon(imageIcon);
        if (this.b.getParent() == null) {
            this.j.add(this.b);
        }
        if (this.d.getDescription() != null) {
            this.e.setText(this.d.getDescription());
        }
    }

    public ImageResource getSelectedImageResourse() {
        return this.d;
    }

    @Override
    public void open() {
        super.open();
    }

    public void setDescriptionVisible(boolean bl) {
        this.c.setVisible(bl);
        this.e.setVisible(bl);
    }

    public List<ImageResource> getUploadedBulkImage() {
        if (this.t == null) {
            this.t = new ArrayList();
        }
        return this.t;
    }

    @Override
    public void dispose() {
        this.s = true;
        super.dispose();
    }

    private class ImagePreviewWithDescription
    extends JPanel {
        private JLabel b;
        private JLabel c;
        private JTextField d;

        public ImagePreviewWithDescription(Icon icon, String string) {
            this();
            this.b.setIcon(icon);
            this.d.setText(string);
        }

        public ImagePreviewWithDescription() {
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.b = new JLabel();
            this.c = new JLabel(Messages.getString("IMAGE_TITLE"));
            this.d = new JTextField();
            this.setLayout(new BorderLayout(5, 5));
            this.add(this.b);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            jPanel.add((Component)this.c, "West");
            jPanel.add(this.d);
            this.add((Component)jPanel, "South");
            this.setPreferredSize(PosUIManager.getSize(160, 160));
        }

        public JLabel getImagePreview() {
            return this.b;
        }

        public void setImagePreview(Icon icon) {
            this.b.setIcon(icon);
        }

        public JTextField getImageDescription() {
            return this.d;
        }

        public void setImageDescription(String string) {
            this.d.setText(string);
        }
    }
}

