/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.jidesoft.swing.TitledSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class ReorderDialog
extends POSDialog {
    private Ticket a;
    private List<TicketItem> b;
    private TicketViewerTable c;

    public ReorderDialog(Ticket ticket) {
        this.a = ticket;
        this.a();
    }

    private void a() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ReorderDialog.0"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill", "[grow][][grow][]", ""));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("ReorderDialog.4"));
        jLabel.setForeground(Color.BLUE);
        TitledSeparator titledSeparator = new TitledSeparator((JComponent)jLabel, 0);
        JLabel jLabel2 = new JLabel(Messages.getString("ReorderDialog.5"));
        jLabel2.setForeground(Color.BLUE);
        TitledSeparator titledSeparator2 = new TitledSeparator((JComponent)jLabel2, 0);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton posButton = new PosButton();
        posButton.setToolTipText(Messages.getString("ReorderDialog.7"));
        posButton.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        PosButton posButton2 = new PosButton();
        posButton2.setToolTipText(Messages.getString("ReorderDialog.10"));
        posButton2.setIcon(IconFactory.getIcon("/ui_icons/", "triple_arrow.png"));
        PosButton posButton3 = new PosButton();
        posButton3.setToolTipText(Messages.getString("ReorderDialog.13"));
        posButton3.setIcon(IconFactory.getIcon("/ui_icons/", "double_arrow.png"));
        jPanel3.add((Component)posButton, "center, wrap");
        jPanel3.add((Component)posButton3, "center, wrap");
        jPanel3.add((Component)posButton2, "center, wrap");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout());
        PosButton posButton4 = new PosButton();
        PosButton posButton5 = new PosButton();
        PosButton posButton6 = new PosButton();
        PosButton posButton7 = new PosButton();
        posButton4.setToolTipText(Messages.getString("ReorderDialog.19"));
        posButton5.setToolTipText(Messages.getString("ReorderDialog.20"));
        posButton6.setToolTipText(Messages.getString("ReorderDialog.21"));
        posButton7.setToolTipText(Messages.getString("ReorderDialog.22"));
        posButton4.setIcon(IconFactory.getIcon("/ui_icons/", "add.png"));
        posButton5.setIcon(IconFactory.getIcon("/ui_icons/", "remove.png"));
        posButton6.setIcon(IconFactory.getIcon("/ui_icons/", "clear.png"));
        posButton7.setIcon(IconFactory.getIcon("/ui_icons/", "remove_all.png"));
        int n = 50;
        posButton4.setPreferredSize(PosUIManager.getSize(0, n));
        posButton5.setPreferredSize(PosUIManager.getSize(0, n));
        posButton6.setPreferredSize(PosUIManager.getSize(0, n));
        jPanel5.add((Component)posButton4, "growx, wrap");
        jPanel5.add((Component)posButton5, "growx, wrap");
        jPanel5.add((Component)posButton6, "growx, wrap");
        jPanel5.add((Component)posButton7, "growx, wrap");
        final TicketViewerTable ticketViewerTable = new TicketViewerTable(this.a);
        ticketViewerTable.setRowHeight(PosUIManager.getSize(45));
        this.resizeColumnWidth(ticketViewerTable);
        ticketViewerTable.setSelectionMode(0);
        PosGuiUtil.setTicketViewerTableVoidedAndSeatRowFilter(ticketViewerTable);
        PosScrollPane posScrollPane = new PosScrollPane(ticketViewerTable, 20, 31);
        Ticket ticket = new Ticket(true);
        ticket.setOrderType(this.a.getOrderType());
        this.c = new TicketViewerTable(ticket);
        this.c.setRowHeight(PosUIManager.getSize(45));
        this.resizeColumnWidth(this.c);
        this.c.setSelectionMode(0);
        PosScrollPane posScrollPane2 = new PosScrollPane(this.c, 20, 31);
        jPanel2.add((Component)titledSeparator, "North");
        jPanel2.add((Component)posScrollPane, "Center");
        jPanel4.add((Component)titledSeparator2, "North");
        jPanel4.add((Component)posScrollPane2, "Center");
        jPanel.add((Component)jPanel2, "grow");
        jPanel.add((Component)jPanel3, "");
        jPanel.add((Component)jPanel4, "grow");
        jPanel.add((Component)jPanel5, "");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.b(ticketViewerTable);
                ticketViewerTable.clearSelection();
            }
        });
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.c(ticketViewerTable);
                ticketViewerTable.clearSelection();
            }
        });
        posButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.a(ticketViewerTable);
            }
        });
        posButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.c();
            }
        });
        posButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.d();
            }
        });
        posButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.e();
            }
        });
        posButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.f();
            }
        });
        JPanel jPanel6 = new JPanel((LayoutManager)new MigLayout("al center, insets 10 10 10 80", "sg, fill", ""));
        PosButton posButton8 = new PosButton(Messages.getString("DONE"));
        jPanel6.add((Component)posButton8, "grow");
        posButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReorderDialog.this.doReorder();
            }
        });
        jPanel6.add(new PosButton(new CloseDialogAction(this, Messages.getString("CANCEL"))));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel6, "South");
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.b().get(i));
        }
    }

    private List b() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(PosUIManager.getSize(250));
        arrayList.add(PosUIManager.getSize(30));
        arrayList.add(PosUIManager.getSize(30));
        return arrayList;
    }

    public void doReorder() {
        List<TicketItem> list = this.c.getTicketItems();
        if (list == null) {
            return;
        }
        this.setTicketItems(list);
        this.setCanceled(false);
        this.dispose();
    }

    private void a(TicketViewerTable ticketViewerTable) {
        KitchenTicket kitchenTicket = KitchenTicketDAO.getInstance().findByLastOrderParentId(this.a.getId());
        if (kitchenTicket == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ReorderDialog.1"));
            return;
        }
        List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
        boolean bl = false;
        for (KitchenTicketItem kitchenTicketItem : list) {
            if (kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isVoided().booleanValue()) continue;
            List<TicketItem> list2 = ticketViewerTable.getTicketItems();
            for (TicketItem ticketItem : list2) {
                if (!ticketItem.getId().equals(kitchenTicketItem.getTicketItemId()) || ticketItem.isItemReturned().booleanValue()) continue;
                TicketItem ticketItem2 = ticketItem.cloneAsNew();
                ticketItem2.calculatePrice();
                this.c.addTicketItem(ticketItem2);
                bl = true;
            }
        }
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ReorderDialog.1"));
            return;
        }
        this.c.repaint();
    }

    private void b(TicketViewerTable ticketViewerTable) {
        try {
            PropertyContainer propertyContainer;
            int n = ticketViewerTable.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ReorderDialog.2"));
                return;
            }
            n = ticketViewerTable.convertRowIndexToModel(n);
            TicketViewerTableModel ticketViewerTableModel = ticketViewerTable.getModel();
            Object object = ticketViewerTableModel.get(n);
            TicketItem ticketItem = null;
            if (object instanceof TicketItem) {
                ticketItem = (TicketItem)object;
            } else if (object instanceof TicketItemModifier) {
                propertyContainer = (TicketItemModifier)object;
                ticketItem = ((BaseTicketItemModifier)((Object)propertyContainer)).getTicketItem();
            }
            if (ticketItem != null) {
                propertyContainer = ticketItem.cloneAsNew();
                ((TicketItem)propertyContainer).calculatePrice();
                this.c.addTicketItem((TicketItem)propertyContainer);
                this.c.repaint();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage());
        }
    }

    private void c(TicketViewerTable ticketViewerTable) {
        try {
            List<TicketItem> list = ticketViewerTable.getTicketItems();
            for (TicketItem ticketItem : list) {
                if (ticketItem.isVoided().booleanValue() || ticketItem.isItemReturned().booleanValue() || ticketItem.isTreatAsSeat().booleanValue()) continue;
                TicketItem ticketItem2 = ticketItem.cloneAsNew();
                ticketItem2.calculatePrice();
                this.c.addTicketItem(ticketItem2);
            }
            this.c.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List<TicketItem> getTicketItems() {
        return this.b;
    }

    public void setTicketItems(List<TicketItem> list) {
        this.b = list;
    }

    private void c() {
        int n = this.c.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ReorderDialog.2"));
            return;
        }
        n = this.c.convertRowIndexToModel(n);
        TicketViewerTableModel ticketViewerTableModel = this.c.getModel();
        Object object = ticketViewerTableModel.get(n);
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            ticketItem.setQuantity(ticketItem.getQuantity() + 1.0);
            ticketItem.calculatePrice();
            ticketViewerTableModel.update();
            this.c.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    private void d() {
        int n = this.c.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ReorderDialog.2"));
            return;
        }
        n = this.c.convertRowIndexToModel(n);
        TicketViewerTableModel ticketViewerTableModel = this.c.getModel();
        Object object = ticketViewerTableModel.get(n);
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            if (ticketItem.getQuantity() <= 1.0) {
                ticketViewerTableModel.delete(n);
            } else {
                ticketItem.setQuantity(ticketItem.getQuantity() - 1.0);
                ticketItem.calculatePrice();
                ticketViewerTableModel.update();
                this.c.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    private void e() {
        int n = this.c.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ReorderDialog.2"));
            return;
        }
        n = this.c.convertRowIndexToModel(n);
        TicketViewerTableModel ticketViewerTableModel = this.c.getModel();
        Object object = ticketViewerTableModel.get(n);
        if (object instanceof TicketItem) {
            ticketViewerTableModel.delete(n);
        }
    }

    private void f() {
        TicketViewerTableModel ticketViewerTableModel = this.c.getModel();
        int n = ticketViewerTableModel.getItemCount();
        if (n <= 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ReorderDialog.9"));
            return;
        }
        ticketViewerTableModel.removeAll();
        this.c.repaint();
    }
}

