/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class KDSOrderTypeBaseColorSettings
extends JPanel {
    private JButton a = new JButton(POSConstants.BACKGROUND);
    private JButton b = new JButton(POSConstants.TEXT_COLOR);
    private POSComboBox c;
    private Terminal d;
    private List<String> e = new ArrayList<String>();

    public KDSOrderTypeBaseColorSettings() {
        this.d = Application.getInstance().refreshAndGetTerminal();
        this.a();
        this.c();
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fillx", "", ""));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap 2,ins 10 5 5 5", "[][grow]", ""));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(this.b(POSConstants.ORDER_TYPE));
        this.c = new POSComboBox();
        jPanel.add((Component)this.c, "growx,wrap");
        this.a(jPanel, Messages.getString("KitchenDisplayConfigDialog.19"), true);
        this.a(jPanel, POSConstants.TEXT_COLOR, false);
        PosButton posButton = new PosButton(Messages.getString("OrderFilterPanel.5"));
        posButton.addActionListener(actionEvent -> this.b());
        this.add((Component)jPanel, "growx,spanx,top,wrap,split 2");
        this.add((Component)posButton, "skip 1,right");
        this.d();
        this.a(null, false);
    }

    private void b() {
        if (this.c.getSelectedItem() instanceof OrderType) {
            OrderType orderType = (OrderType)this.c.getSelectedItem();
            String string = orderType.getId();
            this.d.removeProperty(String.format("kds.{%s}.background", string));
            this.d.removeProperty(String.format("kds.{%s}.foreground", string));
            this.e.add(string);
        }
        this.a(null, true);
    }

    private void c() {
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement("");
        if (list != null && !list.isEmpty()) {
            for (OrderType orderType : list) {
                comboBoxModel.addElement(orderType);
            }
        }
        this.c.setModel(comboBoxModel);
    }

    private void d() {
        this.c.addItemListener(itemEvent -> {
            if (this.c.getSelectedItem() instanceof OrderType) {
                OrderType orderType = (OrderType)this.c.getSelectedItem();
                this.a(orderType, true);
            } else {
                this.a(null, false);
            }
        });
    }

    private OrderType e() {
        if (this.c.getSelectedItem() instanceof OrderType) {
            return (OrderType)this.c.getSelectedItem();
        }
        return null;
    }

    private void a(OrderType orderType, boolean bl) {
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        if (orderType != null) {
            Color color = TerminalProperties.getColor(this.d, String.format("kds.{%s}.background", orderType.getId()));
            if (color != null) {
                this.a.setBackground(color);
                this.b.setBackground(color);
            } else {
                this.a.setBackground(Color.white);
                this.b.setBackground(Color.white);
            }
            Color color2 = TerminalProperties.getColor(this.d, String.format("kds.{%s}.foreground", orderType.getId()));
            if (color2 != null) {
                this.a.setForeground(color2);
                this.b.setForeground(color2);
            } else {
                this.a.setForeground(Color.black);
                this.b.setForeground(Color.black);
            }
        } else {
            this.a.setBackground(Color.white);
            this.a.setForeground(Color.black);
            this.b.setBackground(Color.white);
            this.b.setForeground(Color.black);
        }
    }

    public void doSave() {
        try {
            OrderType orderType = this.e();
            if (orderType == null) {
                return;
            }
            String string = orderType.getId();
            if (this.e.isEmpty() || !this.e.isEmpty() && !this.e.contains(string)) {
                this.a(string);
            }
            TerminalDAO.getInstance().saveOrUpdate(this.d);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    private void a(String string) {
        TerminalProperties.setKDSOrderTypeBg(this.d, string, this.a.getBackground().getRGB());
        TerminalProperties.setKDSOrderTypeFg(this.d, string, this.b.getForeground().getRGB());
    }

    private void a(JPanel jPanel, String string, final boolean bl) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                Color color = JColorChooser.showDialog(POSUtil.getFocusedWindow(), "", jButton.getBackground());
                if (color == null) {
                    return;
                }
                OrderType orderType = KDSOrderTypeBaseColorSettings.this.e();
                if (orderType == null) {
                    return;
                }
                if (!KDSOrderTypeBaseColorSettings.this.e.isEmpty() && KDSOrderTypeBaseColorSettings.this.e.contains(orderType.getId())) {
                    KDSOrderTypeBaseColorSettings.this.e.remove(orderType.getId());
                }
                if (bl) {
                    KDSOrderTypeBaseColorSettings.this.a.setBackground(color);
                    KDSOrderTypeBaseColorSettings.this.b.setBackground(color);
                } else {
                    KDSOrderTypeBaseColorSettings.this.a.setForeground(color);
                    KDSOrderTypeBaseColorSettings.this.b.setForeground(color);
                }
            }
        };
        jPanel.add(this.b(string));
        if (bl) {
            jPanel.add((Component)this.a, "growx,h " + PosUIManager.getSize(30) + "!");
            this.a.addActionListener(actionListener);
        } else {
            jPanel.add((Component)this.b, "growx,h " + PosUIManager.getSize(30) + "!");
            this.b.addActionListener(actionListener);
        }
    }

    private Component b(String string) {
        return new JLabel(string);
    }
}

