/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class OrderStatusDisplayConfigDialog
extends OkCancelOptionDialog {
    private IntegerTextField a = new IntegerTextField(8);
    private IntegerTextField b = new IntegerTextField(8);

    public OrderStatusDisplayConfigDialog() {
        String string = Messages.getString("OrderStatusDisplayConfigDialog.0");
        this.setTitle(string);
        this.setCaption(string);
        this.a();
        this.b();
    }

    private void a() {
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("wrap 2,ins 0 10 0 10", "[][grow]", ""));
        jPanel.add(this.a(Messages.getString("KitchenDisplayConfigDialog.5")));
        jPanel.add((Component)this.a, "growx,split 3,wrap");
        jPanel.add(this.a(Messages.getString("OrderStatusDisplayConfigDialog.1")));
        jPanel.add((Component)this.b, "growx,wrap");
        NumericKeypad numericKeypad = new NumericKeypad();
        jPanel.add((Component)numericKeypad, "span 2,gaptop 10,grow");
    }

    private Component a(String string) {
        return new JLabel(string);
    }

    private void b() {
        Terminal terminal = Application.getInstance().getTerminal();
        this.a.setText(String.valueOf(terminal.getTicketsPerPage()));
        this.b.setText(String.valueOf(terminal.getTextFontSize()));
    }

    @Override
    public void doOk() {
        int n = this.a.getInteger();
        if (n < 2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderStatusDisplayConfigDialog.2"));
            return;
        }
        if (n > 24) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderStatusDisplayConfigDialog.3"));
            return;
        }
        int n2 = this.b.getInteger();
        if (n2 < 8) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderStatusDisplayConfigDialog.4"));
            return;
        }
        if (n2 > 128) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderStatusDisplayConfigDialog.5"));
            return;
        }
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        terminal.setTicketsPerPage(n);
        terminal.setTextFontSize(n2);
        TerminalDAO.getInstance().saveOrUpdate(terminal);
        this.setCanceled(false);
        this.dispose();
    }
}

