/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.config.TerminalProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;

public class TimerWatch
extends JPanel
implements ActionListener {
    private Timer c = new Timer(1000, this);
    private JLabel d = new JLabel("");
    private final Date e;
    private final Color f;
    private final Color g;
    private final Color h;
    private final Color i;
    private final Color j;
    private final Color k;
    public Color backColor;
    public Color textColor;
    public Integer applicableColorComponentIndex;
    private ChangeListener l;
    int a = 300;
    int b = 600;
    private final int m;
    private final int n;
    private final int o;

    public TimerWatch(Date date) {
        this(date, null);
    }

    public TimerWatch(Date date, ChangeListener changeListener) {
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        this.e = date;
        this.l = changeListener;
        this.setOpaque(false);
        this.setLayout((LayoutManager)new MigLayout("right,ins 0"));
        this.f = TerminalProperties.getKDSInitialBgColor(terminal);
        this.g = TerminalProperties.getKDSInitialFgColor(terminal);
        this.h = TerminalProperties.getKDSWarninBgColor(terminal);
        this.i = TerminalProperties.getKDSWarninFgColor(terminal);
        this.j = TerminalProperties.getKDSOverBgColor(terminal);
        this.k = TerminalProperties.getKDSOverFgColor(terminal);
        this.m = TerminalProperties.getKDSInitialComponentIndex(terminal);
        this.n = TerminalProperties.getKDSwarningComponentIndex(terminal);
        this.o = TerminalProperties.getKDSOverComponentIndex(terminal);
        this.backColor = this.f;
        this.textColor = this.g;
        this.applicableColorComponentIndex = this.m;
        int n = TerminalProperties.getKDSTicketTokenSize(terminal);
        if (n == 0) {
            n = PosUIManager.getDefaultFontSize();
        }
        this.d.setFont(this.d.getFont().deriveFont(1, n));
        this.d.setHorizontalAlignment(4);
        this.d.setOpaque(false);
        this.d.setForeground(Color.black);
        this.d.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        if (StringUtils.isNotBlank((String)TerminalProperties.getKDSYellowTimeOut(terminal))) {
            try {
                this.a = Integer.parseInt(TerminalProperties.getKDSYellowTimeOut(terminal));
            }
            catch (Exception exception) {
                this.a = 120;
            }
        }
        if (StringUtils.isNotBlank((String)TerminalProperties.getKDSRedTimeOut(terminal))) {
            try {
                this.b = Integer.parseInt(TerminalProperties.getKDSRedTimeOut(terminal));
            }
            catch (Exception exception) {
                this.b = 240;
            }
        }
        this.actionPerformed(null);
        this.add(this.d);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        int n;
        long l = new Instant().getMillis();
        long l2 = this.e.getTime();
        long l3 = l2 - l;
        Interval interval = null;
        interval = l3 > 0L ? new Interval(l, this.e.getTime()) : new Interval(this.e.getTime(), l);
        Duration duration = interval.toDuration();
        int n2 = n = this.backColor != null ? this.backColor.getRGB() : -1;
        if ((long)this.a < duration.getStandardSeconds() && (long)this.b > duration.getStandardSeconds()) {
            this.backColor = this.h;
            this.textColor = this.i;
            this.applicableColorComponentIndex = this.n;
        } else if ((long)this.b < duration.getStandardSeconds()) {
            this.backColor = this.j;
            this.textColor = this.k;
            this.applicableColorComponentIndex = this.o;
        } else {
            this.backColor = this.f;
            this.textColor = this.g;
            this.applicableColorComponentIndex = this.m;
        }
        this.d.setForeground(this.textColor);
        this.d.setText(this.a(duration.getStandardHours()) + ":" + this.a(duration.getStandardMinutes() % 60L) + ":" + this.a(duration.getStandardSeconds() % 60L));
        boolean bl2 = bl = this.backColor != null && this.backColor.getRGB() != n;
        if (this.l != null && bl) {
            this.l.stateChanged(null);
        }
    }

    public void setBackgroundColor(Color color) {
        this.d.setOpaque(true);
        this.d.setBackground(color);
    }

    public void setForegroundColor(Color color) {
        this.d.setForeground(color);
    }

    public Color getBackgroundColor() {
        return this.applicableColorComponentIndex == 0 ? KitchenDisplayView.getInstance().getBackground() : this.backColor;
    }

    private String a(long l) {
        String string = String.valueOf(l);
        return string.length() == 2 ? string : "0" + l;
    }

    public void start() {
        this.c.start();
    }

    public void stop() {
        this.c.stop();
    }
}

