/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.swing.ListModel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;

public class DatabaseServerListDialog
extends OkCancelOptionDialog {
    private JList<DatabaseServer> a;
    private ListModel<DatabaseServer> b;
    private SwingWorker<Void, Void> c;
    private JButton d;
    private JProgressBar e;
    private int f;
    private String g;
    private String h;
    private int i;

    public DatabaseServerListDialog(Database database) {
        super((Frame)Application.getPosWindow(), true);
        this.setCaption(String.format(Messages.getString("PostgresQLServerListDialog.0"), database.getProviderName()));
        this.a();
        this.f = Integer.parseInt(database.getDefaultPort());
    }

    private void a() {
        JPanel jPanel = this.getContentPanel();
        jPanel.setBorder(null);
        jPanel.setLayout((LayoutManager)new MigLayout("fill", "[]", ""));
        JLabel jLabel = new JLabel(Messages.getString("PostgresQLServerListDialog.1"));
        jPanel.add((Component)jLabel, "wrap");
        this.e = new JProgressBar();
        jPanel.add((Component)this.e, "height 20!,growx,spanx,split 3");
        this.d = new JButton(Messages.getString("PostgresQLServerListDialog.2"));
        this.d.addActionListener(actionEvent -> {
            if (this.c.isCancelled() || this.c.isDone()) {
                this.c();
            } else {
                this.d();
            }
        });
        jPanel.add((Component)this.d, "right, wrap");
        this.a = new JList();
        this.b = new ListModel();
        this.a.setModel(this.b);
        jPanel.add((Component)new JScrollPane(this.a), "grow,push,span");
        this.b();
    }

    private void b() {
        this.i = 0;
        this.c = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                DatabaseServerListDialog.this.update();
                return null;
            }

            @Override
            protected void done() {
                DatabaseServerListDialog.this.e.setIndeterminate(false);
                DatabaseServerListDialog.this.d.setText(Messages.getString("PostgresQLServerListDialog.3"));
            }
        };
        this.c.execute();
    }

    private void c() {
        this.c.cancel(true);
        this.b.getDataList().clear();
        this.a.repaint();
        this.b();
        this.d.setText(Messages.getString("PostgresQLServerListDialog.2"));
    }

    private void d() {
        this.c.cancel(true);
        this.e.setIndeterminate(false);
        this.d.setText(Messages.getString("PostgresQLServerListDialog.3"));
    }

    public static boolean isDbServerAvailable(String string, int n) {
        boolean bl = false;
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(string, n), 100);
            bl = true;
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void update() throws Exception {
        AtomicReference atomicReference = new AtomicReference();
        ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
        arrayList.forEach(networkInterface -> {
            try {
                if (networkInterface.isUp() && !networkInterface.isLoopback()) {
                    networkInterface.getInterfaceAddresses().forEach(interfaceAddress -> {
                        InetAddress inetAddress = interfaceAddress.getAddress();
                        if (inetAddress instanceof Inet4Address) {
                            atomicReference.set(inetAddress);
                        }
                    });
                }
            }
            catch (SocketException socketException) {
                PosLog.error(this.getClass(), socketException);
            }
        });
        InetAddress inetAddress = atomicReference.get() == null ? InetAddress.getLocalHost() : (InetAddress)atomicReference.get();
        this.g = inetAddress.getHostAddress();
        String string = "localhost";
        if (this.g.equals("127.0.0.1") || this.g.equals("127.0.1.1")) {
            DatabaseServer databaseServer = new DatabaseServer();
            databaseServer.setServerName(string);
            databaseServer.setServerIp(this.g);
            this.b.addElement(databaseServer);
        } else {
            int n;
            int n2;
            if (DatabaseServerListDialog.isDbServerAvailable(this.g, this.f)) {
                DatabaseServer databaseServer = new DatabaseServer();
                databaseServer.setServerName(string);
                databaseServer.setServerIp(this.g);
                this.b.addElement(databaseServer);
            }
            this.e.setMaximum(254);
            this.h = new String();
            for (int i = this.g.length() - 1; i >= 0; --i) {
                if (this.g.charAt(i) != '.') continue;
                this.h = this.g.substring(0, i + 1);
                break;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n3 = 1;
            int n4 = 254;
            for (n = n2 = 254; n <= n4; n += n2) {
                Thread thread = new Thread(new IpFindingRunnable(n3, n));
                thread.start();
                arrayList2.add(thread);
                if (n == n4) break;
                n3 = n + 1;
                if (n + n2 <= n4 || n % n2 != 0) continue;
                n += n4 - n - n2;
            }
            n = 0;
            do {
                n = 0;
                for (Thread thread : arrayList2) {
                    if (thread.isAlive()) {
                        ++n;
                    }
                    this.e.setStringPainted(true);
                    this.e.setValue(this.i);
                }
            } while (n > 0);
        }
    }

    public DatabaseServer getSelectedServer() {
        return this.a.getSelectedValue();
    }

    @Override
    public void doOk() {
        if (this.getSelectedServer() == null) {
            POSMessageDialog.showError(Messages.getString("PostgresQLServerListDialog.4"));
            return;
        }
        this.c.cancel(true);
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void dispose() {
        this.c.cancel(true);
        super.dispose();
    }

    @Override
    public void doCancel() {
        this.c.cancel(true);
        super.doCancel();
    }

    private class IpFindingRunnable
    implements Runnable {
        private final int b;
        private final int c;

        public IpFindingRunnable(int n, int n2) {
            this.b = n;
            this.c = n2;
        }

        @Override
        public void run() {
            for (int i = this.b; i <= this.c; ++i) {
                if (DatabaseServerListDialog.this.c.isCancelled()) {
                    return;
                }
                String string = DatabaseServerListDialog.this.h + new Integer(i).toString();
                DatabaseServerListDialog.this.i++;
                if (DatabaseServerListDialog.this.g.equals(string)) continue;
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    String string2 = inetAddress.getHostAddress();
                    if (!DatabaseServerListDialog.isDbServerAvailable(string2, DatabaseServerListDialog.this.f)) continue;
                    String string3 = inetAddress.getHostName();
                    DatabaseServer databaseServer = new DatabaseServer();
                    databaseServer.setServerName(string3);
                    databaseServer.setServerIp(string2);
                    DatabaseServerListDialog.this.b.addElement(databaseServer);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public class DatabaseServer {
        private String b;
        private String c;

        public String getServerName() {
            return this.b;
        }

        public void setServerName(String string) {
            this.b = string;
        }

        public String getServerIp() {
            return this.c;
        }

        public void setServerIp(String string) {
            this.c = string;
        }

        public String toString() {
            return this.b + " - " + this.c;
        }
    }
}

