/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalSimpleScrollPane;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CategoryView
extends SelectionView
implements ActionListener {
    private Vector<CategorySelectionListener> a = new Vector();
    private ButtonGroup b;
    public static final String VIEW_NAME = "CATEGORY_VIEW";

    public CategoryView() {
        super(POSConstants.CATEGORIES, new GridLayout(0, 1, 5, 5), 100, 100);
        this.dataModel = new PaginatedListModel(5);
        this.b = new ButtonGroup();
        this.setPreferredSize(new Dimension(PosUIManager.getSize(120, 100)));
    }

    public void initialize() {
        Ticket ticket;
        if (this.isInitialized()) {
            // empty if block
        }
        if ((ticket = OrderView.getInstance().getCurrentTicket()) == null) {
            return;
        }
        OrderType orderType = ticket.getOrderType();
        MenuCategoryDAO menuCategoryDAO = MenuCategoryDAO.getInstance();
        this.dataModel.setCurrentRowIndex(0);
        menuCategoryDAO.findCategoriesForCategoryView(this.dataModel, orderType);
        this.setDataModel(this.dataModel);
        if (this.dataModel.getSize() == 0) {
            this.a(null);
            return;
        }
        this.setInitialized(true);
        CategoryButton categoryButton = (CategoryButton)this.getFirstItemButton();
        if (categoryButton != null) {
            categoryButton.setSelected(true);
            this.a(categoryButton.a);
        }
        if (this.dataModel.getSize() <= 1) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuCategory menuCategory = (MenuCategory)object;
        CategoryButton categoryButton = new CategoryButton(this, menuCategory);
        this.b.add(categoryButton);
        return categoryButton;
    }

    public void addCategorySelectionListener(CategorySelectionListener categorySelectionListener) {
        this.a.add(categorySelectionListener);
    }

    public void removeCategorySelectionListener(CategorySelectionListener categorySelectionListener) {
        this.a.remove(categorySelectionListener);
    }

    private void a(MenuCategory menuCategory) {
        for (CategorySelectionListener categorySelectionListener : this.a) {
            categorySelectionListener.categorySelected(menuCategory);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CategoryButton categoryButton = (CategoryButton)actionEvent.getSource();
        if (categoryButton.isSelected()) {
            this.a(categoryButton.a);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuCategoryDAO.getInstance().findCategoriesForCategoryView(this.dataModel, OrderView.getInstance().getCurrentTicket().getOrderType());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuCategoryDAO.getInstance().findCategoriesForCategoryView(this.dataModel, OrderView.getInstance().getCurrentTicket().getOrderType());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected JPanel createButtonPanel() {
        return new VerticalTouchScrollPanel();
    }

    @Override
    protected JScrollPane createScrollContainer() {
        return new VerticalSimpleScrollPane();
    }

    private static class CategoryButton
    extends POSToggleButton {
        MenuCategory a;

        CategoryButton(CategoryView categoryView, MenuCategory menuCategory) {
            this.a = menuCategory;
            this.setText("<html><body><center>" + menuCategory.getDisplayName() + "</center></body></html>");
            if (menuCategory.getButtonColor() != null) {
                this.setBackground(menuCategory.getButtonColor());
            }
            if (menuCategory.getTextColor() != null) {
                this.setForeground(menuCategory.getTextColor());
            }
            this.addActionListener(categoryView);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(PosUIManager.getSize(100), dimension.height);
        }
    }
}

