/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class DefaultOrderServiceExtension
extends OrderServiceExtension {
    @Override
    public boolean requireLicense() {
        return false;
    }

    @Override
    public String getProductName() {
        return Messages.getString("DefaultOrderServiceExtension.0");
    }

    @Override
    public String getDescription() {
        return Messages.getString("DefaultOrderServiceExtension.1");
    }

    @Override
    public void createNewTicket(OrderType orderType, List<ShopTable> list, Customer customer) throws TicketAlreadyExistsException {
        this.createNewTicket(orderType, list, customer, 0);
    }

    @Override
    public void setCustomerToTicket(String string) {
    }

    @Override
    public void setDeliveryDate(String string) {
    }

    @Override
    public void assignDriver(String string) {
    }

    @Override
    public boolean finishOrder(String string) {
        Ticket ticket = TicketDAO.getInstance().get(string);
        int n = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (n != 0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("DefaultOrderServiceExtension.2"));
            return false;
        }
        int n2 = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("DefaultOrderServiceExtension.3") + ticket.getId() + Messages.getString("DefaultOrderServiceExtension.4"), Messages.getString("CONFIRM"), 2, 1, null, null, null);
        if (n2 != 0) {
            return false;
        }
        OrderController.closeOrder(ticket);
        return true;
    }

    @Override
    public void createCustomerMenu(JMenu jMenu) {
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    @Override
    public void initConfigurationView(JDialog jDialog) {
    }

    @Override
    public String getId() {
        return "default-floorplan";
    }

    @Override
    public IView getDeliveryDispatchView(OrderType orderType) {
        return null;
    }

    @Override
    public CustomerSelector createNewCustomerSelector() {
        return null;
    }

    @Override
    public CustomerSelector createCustomerSelectorView() {
        return null;
    }

    @Override
    public void openDeliveryDispatchDialog(OrderType orderType) {
    }

    @Override
    public IView getDriverView() {
        return null;
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public boolean hasValidLicense() {
        return true;
    }

    @Override
    public void initUI(PosWindow posWindow) {
    }

    @Override
    public String getProductVersion() {
        return null;
    }

    @Override
    public Component getParent() {
        return null;
    }

    @Override
    public void createNewTicket(OrderType orderType, List<ShopTable> list, Customer customer, int n) throws TicketAlreadyExistsException {
        try {
            if (!PosAction.checkPermission(Application.getCurrentUser(), UserPermission.CREATE_TICKET)) {
                POSMessageDialog.showError(Messages.getString("DefaultOrderServiceExtension.5"));
                return;
            }
            Ticket ticket = new Ticket(true);
            ticket.setOrderType(orderType);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), Messages.getString("DefaultOrderServiceExtension.14"));
            }
            if (orderType.isRequiredCustomerData().booleanValue() && customer == null && (customer = PosGuiUtil.captureCustomer(orderType)) == null) {
                return;
            }
            ticket.setNumberOfGuests(n);
            ticket.setCustomer(customer);
            ticket.setShouldIncludeInSales(true);
            if (list != null) {
                for (ShopTable shopTable : list) {
                    shopTable.setTableStatus(TableStatus.Serving);
                    SalesArea salesArea = shopTable.getSalesArea();
                    if (salesArea != null) {
                        ticket.setSalesArea(salesArea);
                        ticket.setSalesAreaId(salesArea.getId());
                    }
                    ticket.addTable(shopTable.getTableNumber());
                }
            }
            OrderView.getInstance().setCurrentTicket(ticket);
            RootView.getInstance().showView("ORDER_VIEW");
            if (orderType.isTokenInputEnable()) {
                ticket.setTokenNo(PosGuiUtil.captureTokenNumber());
            }
            if (orderType.isShowGuestSelection().booleanValue() && n == 0) {
                ticket.setNumberOfGuests(PosGuiUtil.captureGuestNumber());
            }
            OrderView.getInstance().updateView();
        }
        catch (DatabaseConnectionException databaseConnectionException) {
            POSMessageDialog.showError(Messages.getString("DefaultOrderServiceExtension.15"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    @Override
    public boolean showDeliveryInfo(Ticket ticket, OrderType orderType, Customer customer) {
        return true;
    }

    @Override
    public String getUpdateServerURL() {
        return null;
    }

    @Override
    public Integer getProductNumericVersion() {
        return null;
    }
}

