/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupView
extends SelectionView {
    private Vector<GroupSelectionListener> a = new Vector();
    private MenuCategory b;
    public static final String VIEW_NAME = "GROUP_VIEW";
    private NoneSelectedButtonGroup c;

    public GroupView() {
        super(POSConstants.GROUPS, new GridLayout(1, 0, 5, 5), PosUIManager.getSize(100), PosUIManager.getSize(50));
        this.dataModel = new PaginatedListModel(4);
        this.remove(this.actionButtonPanel);
        this.btnPrev.setText("<<");
        this.btnNext.setText(">>");
        this.add((Component)this.btnPrev, "West");
        this.add((Component)this.btnNext, "East");
    }

    public MenuCategory getMenuCategory() {
        return this.b;
    }

    public void setMenuCategory(MenuCategory menuCategory) {
        this.b = menuCategory;
        this.reset();
        if (menuCategory == null) {
            this.a(null);
            return;
        }
        try {
            this.dataModel.setCurrentRowIndex(0);
            MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), menuCategory, this.dataModel);
            this.setDataModel(this.dataModel);
            if (this.dataModel.getSize() > 0) {
                MenuGroup menuGroup = (MenuGroup)this.dataModel.getElementAt(0);
                GroupButton groupButton = (GroupButton)this.getFirstItemButton();
                if (groupButton != null) {
                    groupButton.setSelected(true);
                    this.a(menuGroup);
                }
            } else {
                this.a(null);
            }
        }
        catch (Exception exception) {
            MessageDialog.showError(exception);
        }
    }

    @Override
    protected void renderItems() {
        this.c = new NoneSelectedButtonGroup();
        super.renderItems();
    }

    @Override
    protected int getFitableButtonCount() {
        Dimension dimension = this.selectionButtonsPanel.getSize();
        Dimension dimension2 = this.getButtonSize();
        int n = this.getButtonCount(dimension.width, dimension2.width);
        return n;
    }

    public void addGroupSelectionListener(GroupSelectionListener groupSelectionListener) {
        this.a.add(groupSelectionListener);
    }

    public void removeGroupSelectionListener(GroupSelectionListener groupSelectionListener) {
        this.a.remove(groupSelectionListener);
    }

    private void a(MenuGroup menuGroup) {
        for (GroupSelectionListener groupSelectionListener : this.a) {
            groupSelectionListener.groupSelected(menuGroup);
        }
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuGroup menuGroup = (MenuGroup)object;
        GroupButton groupButton = new GroupButton(menuGroup);
        this.c.add(groupButton);
        return groupButton;
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), this.b, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), this.b, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected JPanel createButtonPanel() {
        return new HorizontalTouchScrollPanel();
    }

    @Override
    protected JScrollPane createScrollContainer() {
        return new HorizontalSimpleScrollPane();
    }

    private class NoneSelectedButtonGroup
    extends ButtonGroup {
        private NoneSelectedButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel buttonModel, boolean bl) {
            if (bl) {
                super.setSelected(buttonModel, bl);
            } else {
                this.clearSelection();
            }
        }
    }

    private class GroupButton
    extends POSToggleButton
    implements ActionListener {
        MenuGroup a;

        GroupButton(MenuGroup menuGroup) {
            this.a = menuGroup;
            this.setText("<html><body><center>" + menuGroup.getDisplayName() + "</center></body></html>");
            if (this.a.getButtonColorCode() != null) {
                this.setBackground(this.a.getButtonColor());
            }
            if (this.a.getTextColorCode() != null) {
                this.setForeground(this.a.getTextColor());
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isSelected()) {
                GroupView.this.a(null);
                return;
            }
            GroupView.this.a(this.a);
        }
    }
}

