/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.TicketDeletedException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import org.apache.commons.lang.StringUtils;

public class TicketCloseAction
extends PosAction {
    private Object a;

    public TicketCloseAction() {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
        this.setMandatoryPermission(true);
    }

    public TicketCloseAction(DataChangeListener dataChangeListener) {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
        this.setMandatoryPermission(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.a = this.getSelectedObject();
            if (this.a instanceof Ticket) {
                Ticket ticket = (Ticket)this.a;
                if (ticket.getDueAmount() != 0.0) {
                    super.actionPerformed(actionEvent);
                } else {
                    this.execute();
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
    }

    @Override
    public void execute() {
        this.a();
    }

    private void a() {
        try {
            if (this.a != null) {
                this.a(this.a);
            }
        }
        catch (TicketDeletedException ticketDeletedException) {
            POSMessageDialog.showError(Application.getPosWindow(), ticketDeletedException.getMessage());
            this.b();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(Object object) {
        Ticket ticket = null;
        ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
        if (ticket == null) {
            return;
        }
        if (ticket.isDeleted().booleanValue()) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TICKET_IS_DELETED"));
            this.b();
            return;
        }
        if (ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int n = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (!NumberUtil.isZero(n)) {
            POSMessageDialog.showError(Messages.getString("TicketCloseAction.3"));
            return;
        }
        String string = Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7");
        int n2 = POSMessageDialog.showYesNoQuestionDialog(string, POSConstants.CONFIRM);
        if (n2 != 0) {
            return;
        }
        String string2 = StringUtils.isBlank((String)ticket.getOwnerNameFromProperty()) ? " " : "Server: " + ticket.getOwnerNameFromProperty();
        string2 = string2 + (ticket.getTotalAmount() == null ? " " : ", Total amount: " + ticket.getTotalAmount());
        ticket.addEvent("Close ticket", string2);
        OrderController.closeOrder(ticket);
        if (this.listener != null) {
            this.listener.dataChanged(ticket);
        }
    }

    private void b() {
        if (this.listener != null) {
            this.listener.dataSetUpdated();
        }
    }
}

