/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.bo.actions.DataImportDialog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.base.BaseInventoryUnitGroup;
import com.floreantpos.model.base.BaseMenuCategory;
import com.floreantpos.model.base.BaseMenuGroup;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.base.BaseModifierGroup;
import com.floreantpos.model.base.BasePrinterGroup;
import com.floreantpos.model.base.BaseReportGroup;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.base.BaseTaxGroup;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.base.BaseUserType;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.Elements;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;

public class DataImportAction
extends AbstractAction {
    public DataImportAction() {
        super(Messages.getString("DataImportAction.0"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = DataExportAction.getFileChooser();
        int n = jFileChooser.showOpenDialog(POSUtil.getBackOfficeWindow());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            DataImportDialog dataImportDialog = new DataImportDialog(file);
            dataImportDialog.setSize(PosUIManager.getSize(800, 550));
            dataImportDialog.open();
            if (dataImportDialog.isCanceled()) {
                return;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    public static Elements importMenuItemsFromFile(File file) throws Exception {
        if (file == null) {
            new FileNotFoundException(Messages.getString("DataImportAction.2"));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        return DataImportAction.loadMenuItems(fileInputStream);
    }

    public static boolean saveImportedMenuItems(Elements elements, ProgressObserver progressObserver) throws Exception {
        try {
            DataImportAction.importMenuItems(elements, progressObserver);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        DataImportAction.generateAutoMenuPages();
        return true;
    }

    public static Elements loadMenuItems(InputStream inputStream) throws Exception {
        try {
            Elements elements;
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Elements.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Elements elements2 = elements = (Elements)unmarshaller.unmarshal(inputStream);
            return elements2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static void importMenuItems(Elements elements, ProgressObserver progressObserver) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        List<Comparable> list;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TaxGroup taxGroup = DataImportAction.a();
        List<TaxGroup> list2 = elements.getTaxGroups();
        if (list2 != null) {
            list = list2.iterator();
            while (list.hasNext()) {
                object13 = (TaxGroup)list.next();
                object12 = TaxGroupDAO.getInstance().get(((BaseTaxGroup)object13).getId());
                object11 = new ArrayList();
                if (((BaseTaxGroup)object13).getTaxes() != null) {
                    object10 = ((BaseTaxGroup)object13).getTaxes().iterator();
                    while (object10.hasNext()) {
                        object9 = (Tax)object10.next();
                        object8 = (Tax)hashMap.get(((Tax)object9).getUniqueId());
                        object11.add(object8);
                    }
                }
                ((BaseTaxGroup)object13).setTaxes((List<Tax>)object11);
                if (object12 == null) {
                    TaxGroupDAO.getInstance().save((TaxGroup)object13);
                } else {
                    ((BaseTaxGroup)object13).setId(((BaseTaxGroup)object12).getId());
                    ((BaseTaxGroup)object13).setVersion(((BaseTaxGroup)object12).getVersion());
                    PropertyUtils.copyProperties((Object)object12, (Object)object13);
                    TaxGroupDAO.getInstance().update((TaxGroup)object12);
                    object13 = object12;
                }
                hashMap.put(((TaxGroup)object13).getUniqueId(), object13);
                progressObserver.progress(Messages.getString("DataImportAction.3") + ((TaxGroup)object13).toString());
            }
        } else {
            list = elements.getTaxes();
            if (list != null) {
                object13 = list.iterator();
                while (object13.hasNext()) {
                    object12 = (Tax)object13.next();
                    object11 = TaxDAO.getInstance().get(((BaseTax)object12).getId());
                    if (object11 == null) {
                        TaxDAO.getInstance().save((Tax)object12);
                        taxGroup.addTotaxes((Tax)object11);
                        TaxGroupDAO.getInstance().update(taxGroup);
                    } else {
                        ((BaseTax)object12).setId(((BaseTax)object11).getId());
                        ((BaseTax)object12).setVersion(((BaseTax)object11).getVersion());
                        PropertyUtils.copyProperties((Object)object11, (Object)object12);
                        TaxDAO.getInstance().update((Tax)object11);
                        taxGroup.addTotaxes((Tax)object11);
                        TaxGroupDAO.getInstance().update(taxGroup);
                        object12 = object11;
                    }
                    progressObserver.progress(Messages.getString("DataImportAction.4") + ((Tax)object12).toString());
                    hashMap.put(((Tax)object12).getUniqueId(), object12);
                }
            }
        }
        if ((list = elements.getUnitGroups()) != null) {
            object13 = list.iterator();
            while (object13.hasNext()) {
                object12 = (InventoryUnitGroup)object13.next();
                object11 = InventoryUnitGroupDAO.getInstance().findByName(((BaseInventoryUnitGroup)object12).getName());
                ((BaseInventoryUnitGroup)object12).setUnits(null);
                if (object11 == null) {
                    InventoryUnitGroupDAO.getInstance().save((InventoryUnitGroup)object12);
                } else {
                    ((BaseInventoryUnitGroup)object12).setId(((BaseInventoryUnitGroup)object11).getId());
                    ((BaseInventoryUnitGroup)object12).setVersion(((BaseInventoryUnitGroup)object11).getVersion());
                    PropertyUtils.copyProperties((Object)object11, (Object)object12);
                    InventoryUnitGroupDAO.getInstance().update((InventoryUnitGroup)object11);
                    object12 = object11;
                }
                if (object11 == null) {
                    hashMap.put(((BaseInventoryUnitGroup)object12).getId(), object12);
                } else {
                    hashMap.put(((BaseInventoryUnitGroup)object11).getId(), object12);
                }
                progressObserver.progress(Messages.getString("DataImportAction.5") + ((InventoryUnitGroup)object12).toString());
            }
        }
        if ((object13 = elements.getUnits()) != null) {
            object12 = object13.iterator();
            while (object12.hasNext()) {
                object11 = (InventoryUnit)object12.next();
                object10 = InventoryUnitDAO.getInstance().get(((BaseInventoryUnit)object11).getId());
                object9 = ((BaseInventoryUnit)object11).getUnitGroupId();
                object8 = (InventoryUnitGroup)hashMap.get(object9);
                if (object8 != null) {
                    ((BaseInventoryUnit)object11).setUnitGroupId(((BaseInventoryUnitGroup)object8).getId());
                } else {
                    ((BaseInventoryUnit)object11).setUnitGroupId(null);
                }
                if (object10 == null) {
                    InventoryUnitDAO.getInstance().save((InventoryUnit)object11);
                } else {
                    ((BaseInventoryUnit)object11).setId(((BaseInventoryUnit)object10).getId());
                    ((BaseInventoryUnit)object11).setVersion(((BaseInventoryUnit)object10).getVersion());
                    PropertyUtils.copyProperties((Object)object10, (Object)object11);
                    InventoryUnitDAO.getInstance().update((InventoryUnit)object10);
                    object11 = object10;
                }
                hashMap.put(((InventoryUnit)object11).getUniqueId(), object11);
                progressObserver.progress(Messages.getString("DataImportAction.6") + ((InventoryUnit)object11).toString());
            }
        }
        if ((object12 = elements.getMenuCategories()) != null) {
            object11 = object12.iterator();
            while (object11.hasNext()) {
                object10 = (MenuCategory)object11.next();
                object9 = MenuCategoryDAO.getInstance().get(((BaseMenuCategory)object10).getId());
                if (object9 == null) {
                    MenuCategoryDAO.getInstance().save((MenuCategory)object10);
                } else {
                    ((BaseMenuCategory)object10).setId(((BaseMenuCategory)object9).getId());
                    ((BaseMenuCategory)object10).setVersion(((BaseMenuCategory)object9).getVersion());
                    PropertyUtils.copyProperties((Object)object9, (Object)object10);
                    MenuCategoryDAO.getInstance().update((MenuCategory)object10);
                    object10 = object9;
                }
                hashMap.put(((MenuCategory)object10).getUniqueId(), object10);
                progressObserver.progress(Messages.getString("DataImportAction.7") + ((MenuCategory)object10).toString());
            }
        }
        if ((object11 = elements.getMenuGroups()) != null) {
            object10 = object11.iterator();
            while (object10.hasNext()) {
                object9 = (MenuGroup)object10.next();
                object8 = MenuGroupDAO.getInstance().get(((BaseMenuGroup)object9).getId());
                if (object8 == null) {
                    MenuGroupDAO.getInstance().save((MenuGroup)object9);
                } else {
                    ((BaseMenuGroup)object9).setId(((BaseMenuGroup)object8).getId());
                    ((BaseMenuGroup)object9).setVersion(((BaseMenuGroup)object8).getVersion());
                    object7 = ((BaseMenuGroup)object9).getTextColorCode();
                    PropertyUtils.copyProperties((Object)object8, (Object)object9);
                    ((BaseMenuGroup)object8).setTextColorCode((Integer)object7);
                    MenuGroupDAO.getInstance().update((MenuGroup)object8);
                    object9 = object8;
                }
                hashMap.put(((MenuGroup)object9).getUniqueId(), object9);
                progressObserver.progress(Messages.getString("DataImportAction.8") + ((MenuGroup)object9).toString());
            }
        }
        if ((object10 = elements.getMenuModifiers()) != null) {
            object9 = object10.iterator();
            while (object9.hasNext()) {
                object8 = (MenuModifier)object9.next();
                object7 = MenuModifierDAO.getInstance().get(((BaseMenuModifier)object8).getId());
                object6 = ((MenuModifier)object8).getTaxGroup();
                if (object6 != null) {
                    object6 = (TaxGroup)hashMap.get(((TaxGroup)object6).getUniqueId());
                    ((MenuModifier)object8).setTaxGroup((TaxGroup)object6);
                }
                ((MenuModifier)object8).setTaxGroup(null);
                if (object7 == null) {
                    MenuModifierDAO.getInstance().save((MenuModifier)object8);
                } else {
                    ((BaseMenuModifier)object8).setId(((BaseMenuModifier)object7).getId());
                    ((BaseMenuModifier)object8).setVersion(((BaseMenuModifier)object7).getVersion());
                    PropertyUtils.copyProperties((Object)object7, (Object)object8);
                    MenuModifierDAO.getInstance().update((MenuModifier)object7);
                    object8 = object7;
                }
                hashMap.put(((MenuModifier)object8).getUniqueId(), object8);
                progressObserver.progress(Messages.getString("DataImportAction.9") + ((MenuModifier)object8).toString());
            }
        }
        if ((object9 = elements.getModifierGroups()) != null) {
            object8 = object9.iterator();
            while (object8.hasNext()) {
                object7 = (ModifierGroup)object8.next();
                object6 = ModifierGroupDAO.getInstance().get(((BaseModifierGroup)object7).getId());
                object5 = new ArrayList();
                if (((BaseModifierGroup)object7).getModifiers() != null) {
                    object4 = ((BaseModifierGroup)object7).getModifiers().iterator();
                    while (object4.hasNext()) {
                        object3 = object4.next();
                        object2 = (MenuModifier)hashMap.get(((MenuModifier)object3).getUniqueId());
                        object5.add(object2);
                    }
                }
                ((BaseModifierGroup)object7).setModifiers((List<MenuModifier>)object5);
                if (object6 == null) {
                    ModifierGroupDAO.getInstance().save((ModifierGroup)object7);
                } else {
                    ((BaseModifierGroup)object7).setId(((BaseModifierGroup)object6).getId());
                    ((BaseModifierGroup)object7).setVersion(((BaseModifierGroup)object6).getVersion());
                    PropertyUtils.copyProperties((Object)object6, (Object)object7);
                    ModifierGroupDAO.getInstance().update((ModifierGroup)object6);
                    object7 = object6;
                }
                hashMap.put(((ModifierGroup)object7).getUniqueId(), object7);
                progressObserver.progress(Messages.getString("DataImportAction.10") + ((ModifierGroup)object7).toString());
            }
        }
        if ((object8 = elements.getMenuItems()) != null) {
            object7 = object8.iterator();
            while (object7.hasNext()) {
                object6 = (MenuItem)object7.next();
                object5 = null;
                if (((BaseMenuItem)object6).getId() != null) {
                    object5 = MenuItemDAO.getInstance().get(((BaseMenuItem)object6).getId());
                }
                if ((object4 = ((MenuItem)object6).getPrinterGroup()) != null) {
                    object3 = PrinterGroupDAO.getInstance().findByName(((BasePrinterGroup)object4).getName());
                    if (object3 == null) {
                        object3 = new PrinterGroup();
                        PropertyUtils.copyProperties((Object)object3, object4);
                        PrinterGroupDAO.getInstance().save((PrinterGroup)object3);
                    }
                    ((BasePrinterGroup)object4).setId(((BasePrinterGroup)object3).getId());
                }
                if ((object3 = ((MenuItem)object6).getTaxGroup()) != null) {
                    object3 = (TaxGroup)hashMap.get(((TaxGroup)object3).getUniqueId());
                    ((MenuItem)object6).setTaxGroup((TaxGroup)object3);
                }
                if ((object2 = ((MenuItem)object6).getUnit()) != null) {
                    object2 = (InventoryUnit)hashMap.get(((InventoryUnit)object2).getUniqueId());
                    ((MenuItem)object6).setUnit((InventoryUnit)object2);
                }
                if ((object = ((BaseMenuItem)object6).getMenuItemModiferSpecs()) != null) {
                    MenuItem.copyModifierSpecsToMenuItem((MenuItem)object6, (List<MenuItemModifierSpec>)object);
                    for (MenuItemModifierSpec menuItemModifierSpec : ((BaseMenuItem)object6).getMenuItemModiferSpecs()) {
                        Set<MenuItemModifierPage> set;
                        ModifierGroup modifierGroup = menuItemModifierSpec.getModifierGroup();
                        if (modifierGroup != null) {
                            menuItemModifierSpec.setModifierGroup((ModifierGroup)hashMap.get(modifierGroup.getUniqueId()));
                        }
                        if ((set = menuItemModifierSpec.getModifierPages()) != null) {
                            for (MenuItemModifierPage menuItemModifierPage : set) {
                                List<MenuItemModifierPageItem> list3 = menuItemModifierPage.getPageItems();
                                if (list3 == null) continue;
                                for (MenuItemModifierPageItem menuItemModifierPageItem : list3) {
                                    MenuModifier menuModifier = menuItemModifierPageItem.getMenuModifier();
                                    if (menuModifier == null) continue;
                                    menuItemModifierPageItem.setMenuModifier((MenuModifier)hashMap.get(menuModifier.getUniqueId()));
                                }
                            }
                        }
                        MenuItemModifierSpecDAO.getInstance().save(menuItemModifierSpec);
                    }
                }
                ((BaseMenuItem)object6).setAttributes(null);
                ((BaseMenuItem)object6).setComboItems(null);
                ((BaseMenuItem)object6).setComboGroups(null);
                ((MenuItem)object6).setParentMenuItem(null);
                ((BaseMenuItem)object6).setVariants(null);
                ((BaseMenuItem)object6).setStockUnits(null);
                try {
                    Object object14;
                    if (object5 == null) {
                        MenuItemModifierSpec menuItemModifierSpec;
                        ((BaseMenuItem)object6).setVersion(0L);
                        object14 = MenuItemDAO.getInstance().createNewSession();
                        menuItemModifierSpec = object14.beginTransaction();
                        MenuItemDAO.getInstance().save((MenuItem)object6, (Session)object14);
                        menuItemModifierSpec.commit();
                        object14.close();
                    } else {
                        ((BaseMenuItem)object6).setId(((BaseMenuItem)object5).getId());
                        ((BaseMenuItem)object6).setVersion(((BaseMenuItem)object5).getVersion());
                        object14 = ((BaseMenuItem)object6).getTextColorCode();
                        PropertyUtils.copyProperties((Object)object5, (Object)object6);
                        ((BaseMenuItem)object5).setTextColorCode((Integer)object14);
                        MenuItemDAO.getInstance().update((MenuItem)object5);
                        object6 = object5;
                    }
                    hashMap.put(((MenuItem)object6).getUniqueId(), object6);
                    progressObserver.progress(Messages.getString("DataImportAction.11") + ((MenuItem)object6).toString());
                }
                catch (Exception exception) {}
            }
        }
        if ((object7 = elements.getUsers()) != null) {
            object6 = object7.iterator();
            while (object6.hasNext()) {
                object5 = (User)object6.next();
                object4 = UserDAO.getInstance().get(((BaseUser)object5).getId());
                if (object4 == null) {
                    UserDAO.getInstance().save((User)object5);
                } else {
                    ((BaseUser)object5).setId(((BaseUser)object4).getId());
                    ((BaseUser)object5).setVersion(((BaseUser)object4).getVersion());
                    PropertyUtils.copyProperties(object4, (Object)object5);
                    UserDAO.getInstance().update((User)object5);
                    object5 = object4;
                }
                progressObserver.progress(Messages.getString("USER") + " " + ((User)object5).toString());
            }
        }
        if ((object6 = elements.getUserTypes()) != null) {
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (UserType)object5.next();
                object3 = UserTypeDAO.getInstance().get(((BaseUserType)object4).getId());
                if (object3 == null) {
                    UserTypeDAO.getInstance().save((UserType)object4);
                } else {
                    ((BaseUserType)object4).setId(((BaseUserType)object3).getId());
                    ((BaseUserType)object4).setVersion(((BaseUserType)object3).getVersion());
                    PropertyUtils.copyProperties((Object)object3, object4);
                    UserTypeDAO.getInstance().update((UserType)object4);
                    object4 = object3;
                }
                progressObserver.progress(Messages.getString("DataImportAction.13") + ((UserType)object4).toString());
            }
        }
        if ((object5 = elements.getCustomers()) != null) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (Customer)((Object)object4.next());
                object2 = CustomerDAO.getInstance().get(((BaseCustomer)object3).getId());
                if (object2 == null) {
                    CustomerDAO.getInstance().save((Customer)object3);
                } else {
                    ((BaseCustomer)object3).setId(((BaseCustomer)object2).getId());
                    ((BaseCustomer)object3).setVersion(((BaseCustomer)object2).getVersion());
                    PropertyUtils.copyProperties((Object)object2, (Object)object3);
                    CustomerDAO.getInstance().update((Customer)object3);
                    object3 = object2;
                }
                progressObserver.progress(POSConstants.CUSTOMER + " " + ((Customer)object3).toString());
            }
        }
        if ((object4 = elements.getReportGroups()) != null) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (ReportGroup)object3.next();
                object = ReportGroupDAO.getInstance().get(((BaseReportGroup)object2).getId());
                if (object == null) {
                    ReportGroupDAO.getInstance().save((ReportGroup)object2);
                } else {
                    ((BaseReportGroup)object2).setId(((BaseReportGroup)object).getId());
                    ((BaseReportGroup)object2).setVersion(((BaseReportGroup)object).getVersion());
                    PropertyUtils.copyProperties((Object)object, (Object)object2);
                    ReportGroupDAO.getInstance().update((ReportGroup)object2);
                    object2 = object;
                }
                progressObserver.progress(Messages.getString("MenuItemForm.45") + " " + ((ReportGroup)object2).toString());
            }
        }
    }

    private static TaxGroup a() {
        TaxGroup taxGroup;
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        if (list.size() > 0) {
            taxGroup = list.get(0);
        } else {
            taxGroup = new TaxGroup();
            taxGroup.setName("default");
            TaxGroupDAO.getInstance().save(taxGroup);
        }
        return taxGroup;
    }

    public static void generateAutoMenuPages() {
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        if (list == null) {
            return;
        }
        for (MenuGroup menuGroup : list) {
            List<MenuItem> list2;
            List<MenuPage> list3 = MenuPageDAO.getInstance().findByGroup(menuGroup);
            if (list3 != null && list3.size() > 0 || (list2 = MenuItemDAO.getInstance().findByParent(null, menuGroup, true)) == null || list2.isEmpty()) continue;
            int n = 0;
            DataImportAction.a(menuGroup, list2, n, 1);
        }
    }

    private static void a(MenuGroup menuGroup, List<MenuItem> list, int n, int n2) {
        try {
            MenuPage menuPage = new MenuPage();
            menuPage.setId(GlobalIdGenerator.generateGlobalId());
            menuPage.setMenuGroupId(menuGroup.getId());
            menuPage.setName("Page " + n2);
            menuPage.setRows(4);
            menuPage.setCols(4);
            menuPage.setSortOrder(n2);
            for (int i = 0; i < 4 && n < list.size(); ++i) {
                for (int j = 0; j < 4 && n < list.size(); ++n, ++j) {
                    MenuPageItem menuPageItem = new MenuPageItem(j, i);
                    menuPageItem.setMenuPage(menuPage);
                    menuPageItem.setMenuItem(list.get(n));
                    menuPage.addTopageItems(menuPageItem);
                }
            }
            MenuPageDAO.getInstance().save(menuPage);
            if (n < list.size()) {
                DataImportAction.a(menuGroup, list, n, ++n2);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(exception.getMessage(), exception);
        }
    }
}

