/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer.attribute;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.attribute.QuickAttributeLayout;
import com.floreantpos.bo.ui.explorer.attribute.QuickGroupLayout;
import com.floreantpos.bo.ui.explorer.attribute.VariantComboCheckUtil;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.AttributeGroupsSelectionListener;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class AttributesGroupSelectionDialog
extends OkCancelOptionDialog
implements FocusListener {
    private List<Attribute> a;
    private MenuItem b;
    private boolean c;
    private JPanel d;
    private JButton e;
    private boolean f = true;
    private AttributeGroupsSelectionListener g;

    public AttributesGroupSelectionDialog(List<Attribute> list, MenuItem menuItem) {
        this(list, menuItem, (boolean)Boolean.FALSE);
    }

    public AttributesGroupSelectionDialog(List<Attribute> list, MenuItem menuItem, boolean bl) {
        this.a = list;
        this.b = menuItem;
        this.c = bl;
        this.setCaption(Messages.getString("AttributesGroupSelectionDialog.0"));
        this.a();
    }

    private void a() {
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fillx,inset 0,hidemode 3", "[][grow]", ""));
        this.d = new TransparentPanel();
        this.d.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,wrap 4,ins 5 0", "[][]"));
        this.e = new JButton(Messages.getString("AttributesGroupSelectionDialog.1"));
        this.e.setVisible(!this.c);
        jPanel.add(this.d);
        jPanel.add((Component)this.e, "newline,gapleft 10!");
        this.e.addActionListener(actionEvent -> this.c());
        this.updatePanel();
    }

    protected void updatePanel() {
        boolean bl;
        if (this.a == null || this.a.isEmpty()) {
            this.a(this.b(), null, false, this.b);
            return;
        }
        HashMap<AttributeGroup, Object> hashMap = new HashMap<AttributeGroup, Object>();
        for (Attribute attribute : this.a) {
            AttributeGroup attributeGroup = attribute.getGroup();
            ArrayList<Attribute> arrayList = (ArrayList<Attribute>)hashMap.get(attributeGroup);
            if (arrayList == null) {
                arrayList = new ArrayList<Attribute>();
            }
            arrayList.add(attribute);
            hashMap.put(attributeGroup, arrayList);
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        if (arrayList != null) {
            Collections.sort(arrayList, new Comparator<AttributeGroup>(){

                @Override
                public int compare(AttributeGroup attributeGroup, AttributeGroup attributeGroup2) {
                    return attributeGroup.getSortOrder().compareTo(attributeGroup2.getSortOrder());
                }
            });
        }
        boolean bl2 = bl = arrayList == null || arrayList.isEmpty();
        if (bl) {
            this.a(this.b());
            return;
        }
        boolean bl3 = true;
        for (AttributeGroup attributeGroup : arrayList) {
            if (bl3) {
                this.a(attributeGroup, (List)hashMap.get(attributeGroup), false, this.b);
                bl3 = false;
                bl = StringUtils.isBlank((CharSequence)attributeGroup.getId());
                continue;
            }
            this.a(attributeGroup, (List)hashMap.get(attributeGroup), true, this.b);
        }
    }

    private AttributeGroup b() {
        AttributeGroupDAO attributeGroupDAO;
        AttributeGroup attributeGroup = new AttributeGroup();
        if (this.c && (attributeGroup = (attributeGroupDAO = AttributeGroupDAO.getInstance()).get("membership_type")) == null) {
            attributeGroup = new AttributeGroup("membership_type");
            attributeGroup.setName(Messages.getString("CustomerForm.37"));
            attributeGroupDAO.save(attributeGroup);
        }
        return attributeGroup;
    }

    @Override
    public void doOk() {
        if (this.doCheckValidation(true)) {
            return;
        }
        this.saveAttributeGroup();
        this.setCanceled(false);
        this.dispose();
    }

    protected void saveAttributeGroup() {
        ArrayList<AttributeGroup> arrayList = new ArrayList<AttributeGroup>();
        for (int i = 0; i < this.d.getComponentCount(); ++i) {
            Component component = this.d.getComponent(i);
            if (!(component instanceof QuickGroupLayout)) continue;
            QuickGroupLayout quickGroupLayout = (QuickGroupLayout)component;
            AttributeGroup attributeGroup = quickGroupLayout.getAttributeGroup();
            attributeGroup.setSortOrder(i + 1);
            int n = 1;
            List<Attribute> list = attributeGroup.getAttributes();
            if (list != null) {
                for (Attribute attribute : list) {
                    attribute.setSortOrder(n++);
                }
            }
            ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(list);
            List<Attribute> object2 = quickGroupLayout.b;
            for (Attribute attribute : object2) {
                attribute.setDeleted(true);
            }
            if (quickGroupLayout.b != null && !quickGroupLayout.b.isEmpty()) {
                arrayList2.addAll(quickGroupLayout.b);
            }
            attributeGroup.setAttributes((List<Attribute>)arrayList2);
            arrayList.add(attributeGroup);
        }
        if (this.g != null) {
            this.g.itemSelected(arrayList);
        }
    }

    private void c() {
        try {
            VariantComboCheckUtil.checkVariantIsUsedByCombo(this.b, this.a, true);
            AttributeGroup attributeGroup = this.b();
            QuickGroupLayout quickGroupLayout = new QuickGroupLayout(attributeGroup, new ArrayList<Attribute>(), true, this.b, this);
            this.d.add((Component)quickGroupLayout, "wrap");
            quickGroupLayout.getTfAttributeGroupName().requestFocus();
            this.d();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void d() {
        this.revalidate();
        this.repaint();
    }

    private void a(AttributeGroup attributeGroup) {
        this.a(attributeGroup, null);
    }

    private void a(AttributeGroup attributeGroup, List<Attribute> list) {
        this.a(attributeGroup, list, true);
    }

    private void a(AttributeGroup attributeGroup, List<Attribute> list, boolean bl) {
        this.a(attributeGroup, list, bl, null);
    }

    private void a(AttributeGroup attributeGroup, List<Attribute> list, boolean bl, MenuItem menuItem) {
        QuickGroupLayout quickGroupLayout = new QuickGroupLayout(attributeGroup, list, bl, menuItem, this);
        this.d.add((Component)quickGroupLayout, "wrap");
    }

    public boolean isSaveImmediately() {
        return this.f;
    }

    public void setSaveImmediately(boolean bl) {
        this.f = bl;
    }

    protected boolean doCheckValidation() {
        return this.doCheckValidation(false);
    }

    protected boolean doCheckValidation(boolean bl) {
        for (int i = 0; i < this.d.getComponentCount(); ++i) {
            Component component = this.d.getComponent(i);
            if (!(component instanceof QuickGroupLayout)) continue;
            QuickGroupLayout quickGroupLayout = (QuickGroupLayout)component;
            String string = quickGroupLayout.getTfAttributeGroupName().getText();
            if (StringUtils.isBlank((CharSequence)string)) {
                quickGroupLayout.updateValidation(Messages.getString("AttributesGroupSelectionDialog.2"));
                if (bl) {
                    quickGroupLayout.getTfAttributeGroupName().requestFocus();
                }
                throw new PosException(Messages.getString("AttributesGroupSelectionDialog.2"));
            }
            quickGroupLayout.updateValidation("");
            List<QuickAttributeLayout> list = quickGroupLayout.getQuickAttributeLayoutList();
            if (list.size() == 1) {
                QuickAttributeLayout quickAttributeLayout = list.get(0);
                if (quickAttributeLayout == null || StringUtils.isBlank((CharSequence)quickAttributeLayout.getTfAttributeName().getText())) {
                    if (bl) {
                        quickAttributeLayout.updateValidation(Messages.getString("AttributesGroupSelectionDialog.3"));
                        quickAttributeLayout.getTfAttributeName().requestFocus();
                    }
                    throw new PosException(Messages.getString("AttributesGroupSelectionDialog.3"));
                }
                quickAttributeLayout.updateValidation("");
                continue;
            }
            boolean bl2 = false;
            for (QuickAttributeLayout quickAttributeLayout : list) {
                if (quickAttributeLayout == null || !StringUtils.isNotBlank((CharSequence)quickAttributeLayout.getTfAttributeName().getText())) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            QuickAttributeLayout quickAttributeLayout = list.get(0);
            quickAttributeLayout.getTfAttributeName().requestFocus();
            quickAttributeLayout.updateValidation(Messages.getString("AttributesGroupSelectionDialog.3"));
            throw new PosException(Messages.getString("AttributesGroupSelectionDialog.3"));
        }
        this.validateAttributeGroupName(bl);
        AttributesGroupSelectionDialog.validateAllAttributes(this.getAllAttributesLayout(), bl);
        return false;
    }

    protected List<QuickAttributeLayout> getAllAttributesLayout() {
        ArrayList<QuickAttributeLayout> arrayList = new ArrayList<QuickAttributeLayout>();
        for (int i = 0; i < this.d.getComponentCount(); ++i) {
            QuickGroupLayout quickGroupLayout = (QuickGroupLayout)this.d.getComponent(i);
            arrayList.addAll(quickGroupLayout.getAttributesLayout());
        }
        return arrayList;
    }

    public static void validateAllAttributes(List<QuickAttributeLayout> list, boolean bl) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (int i = 0; i < list.size(); ++i) {
            QuickAttributeLayout quickAttributeLayout = list.get(i);
            String string = quickAttributeLayout.getTfAttributeName().getText().trim();
            if (quickAttributeLayout == null || StringUtils.isBlank((CharSequence)string)) {
                Container container = quickAttributeLayout.getParent();
                if (container.getComponentCount() > 2 && bl) {
                    quickAttributeLayout.updateValidation(Messages.getString("please_enter_variant_value"));
                }
                if (bl) {
                    quickAttributeLayout.getTfAttributeName().requestFocus();
                }
            } else {
                quickAttributeLayout.updateValidation("");
            }
            if (hashMap.get(string) != null && ((Boolean)hashMap.get(string)).booleanValue()) {
                quickAttributeLayout.updateValidation(string + Messages.getString("AttributesGroupSelectionDialog.5"));
                if (bl) {
                    quickAttributeLayout.getTfAttributeName().requestFocus();
                }
                throw new PosException(string + Messages.getString("AttributesGroupSelectionDialog.5"));
            }
            if (StringUtils.isNotBlank((CharSequence)string)) {
                hashMap.put(string, true);
            }
            quickAttributeLayout.updateValidation("");
            quickAttributeLayout.revalidate();
            quickAttributeLayout.repaint();
        }
    }

    protected void validateAttributeGroupName(boolean bl) {
        int n = this.d.getComponentCount();
        if (n == 1) {
            return;
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (int i = 0; i < n; ++i) {
            QuickGroupLayout quickGroupLayout = (QuickGroupLayout)this.d.getComponent(i);
            String string = quickGroupLayout.getTfAttributeGroupName().getText().trim();
            if (StringUtils.isBlank((CharSequence)string)) {
                quickGroupLayout.updateValidation(Messages.getString("AttributesGroupSelectionDialog.2"));
                if (bl) {
                    quickGroupLayout.getTfAttributeGroupName().requestFocus();
                }
                throw new PosException(Messages.getString("AttributesGroupSelectionDialog.2"));
            }
            quickGroupLayout.updateValidation("");
            if (hashMap.get(string) != null && ((Boolean)hashMap.get(string)).booleanValue()) {
                quickGroupLayout.updateValidation(string + Messages.getString("AttributesGroupSelectionDialog.6"));
                quickGroupLayout.revalidateUi();
                if (bl) {
                    quickGroupLayout.getTfAttributeGroupName().requestFocus();
                }
                throw new PosException(string + Messages.getString("AttributesGroupSelectionDialog.6"));
            }
            hashMap.put(string, true);
            quickGroupLayout.updateValidation("");
            quickGroupLayout.revalidateUi();
        }
    }

    public void addItemSelectionListener(AttributeGroupsSelectionListener attributeGroupsSelectionListener) {
        this.g = attributeGroupsSelectionListener;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        try {
            this.doCheckValidation(false);
        }
        catch (PosException posException) {
            // empty catch block
        }
    }
}

