/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer.attribute;

import com.floreantpos.PosLog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.MenuItem;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortUtil {
    public static void sortVariants(List<MenuItem> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        try {
            if (list.get(0).getVariantSortOrder() == null) {
                return;
            }
            for (MenuItem menuItem : list) {
                if (menuItem.getAttributes() == null) continue;
                Collections.sort(menuItem.getAttributes(), new Comparator<Attribute>(){

                    @Override
                    public int compare(Attribute attribute, Attribute attribute2) {
                        return attribute.getGroup().getSortOrder().compareTo(attribute2.getGroup().getSortOrder());
                    }
                });
            }
            Collections.sort(list, new Comparator<MenuItem>(){

                @Override
                public int compare(MenuItem menuItem, MenuItem menuItem2) {
                    Integer n;
                    Integer n2 = menuItem.getVariantSortOrder();
                    if (n2 == null) {
                        n2 = 0;
                    }
                    if ((n = menuItem2.getVariantSortOrder()) == null) {
                        n = 0;
                    }
                    return n2.compareTo(n);
                }
            });
        }
        catch (Exception exception) {
            PosLog.error(SortUtil.class, exception);
        }
    }
}

