/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config;

import com.floreantpos.Database;
import com.floreantpos.PosLog;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AESencrp;
import java.io.File;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class AppConfig {
    public static final String DATABASE_URL = "database_url";
    public static final String DATABASE_PORT = "database_port";
    public static final String DATABASE_NAME = "database_name";
    public static final String DATABASE_USER = "database_user";
    public static final String DATABASE_PASSWORD = "database_pass";
    public static final String CONNECTION_STRING = "connection_string";
    public static final String DATABASE_PROVIDER_NAME = "database_provider_name";
    private static final String a = "kitchen_print_on_order_settle";
    private static final String b = "kitchen_print_on_order_finish";
    private static final String c = "print_receipt_on_order_settle";
    private static final String d = "print_receipt_on_order_finish";
    private static PropertiesConfiguration e;

    private static void a() {
        try {
            boolean bl;
            File file = new File(DataProvider.get().getAppConfigFileLocation(), "app.config");
            PosLog.info(AppConfig.class, "creating config file in " + file.getAbsolutePath());
            if (!file.exists() && !(bl = file.createNewFile())) {
                PosLog.error(AppConfig.class, "Cannot create config file, default to fallback 1.");
                e = new PropertiesConfiguration();
                return;
            }
            if (file.canWrite()) {
                e = new PropertiesConfiguration(file);
                e.setAutoSave(true);
            } else {
                PosLog.error(AppConfig.class, "Cannot create config file, default to fallback 2.");
                e = new PropertiesConfiguration();
            }
        }
        catch (Exception exception) {
            PosLog.error(AppConfig.class, "Cannot create config file, default to fallback 3.");
            e = new PropertiesConfiguration();
        }
    }

    public static PropertiesConfiguration getConfig() {
        return e;
    }

    public static void removeProperty(String string) {
        e.clearProperty(string);
    }

    public static boolean getBoolean(String string, boolean bl) {
        return e.getBoolean(string, bl);
    }

    public static int getInt(String string, int n) {
        return e.getInt(string, n);
    }

    public static void putInt(String string, int n) {
        e.setProperty(string, (Object)n);
    }

    public static String getString(String string) {
        return e.getString(string);
    }

    public static String getString(String string, String string2) {
        return e.getString(string, string2);
    }

    public static void put(String string, boolean bl) {
        e.setProperty(string, (Object)bl);
    }

    public static void put(String string, String string2) {
        e.setProperty(string, (Object)string2);
    }

    public static String getDatabaseHost() {
        return e.getString(DATABASE_URL, "localhost");
    }

    public static void setDatabaseHost(String string) {
        e.setProperty(DATABASE_URL, (Object)string);
    }

    public static String getConnectString() {
        return e.getString(CONNECTION_STRING);
    }

    public static void setConnectString(String string) {
        e.setProperty(CONNECTION_STRING, (Object)string);
    }

    public static String getDatabasePort() {
        return e.getString(DATABASE_PORT, null);
    }

    public static void setDatabasePort(String string) {
        e.setProperty(DATABASE_PORT, (Object)string);
    }

    public static String getDatabaseName() {
        return e.getString(DATABASE_NAME, "posdb");
    }

    public static void setDatabaseName(String string) {
        e.setProperty(DATABASE_NAME, (Object)string);
    }

    public static String getDatabaseUser() {
        return e.getString(DATABASE_USER, "app");
    }

    public static void setDatabaseUser(String string) {
        e.setProperty(DATABASE_USER, (Object)string);
    }

    public static String getDatabasePassword() {
        String string = e.getString(DATABASE_PASSWORD, "sa");
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                return AESencrp.decrypt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static void setDatabasePassword(String string) {
        try {
            e.setProperty(DATABASE_PASSWORD, (Object)AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            PosLog.error(AppConfig.class, exception);
        }
    }

    public static void setDatabaseProviderName(String string) {
        e.setProperty(DATABASE_PROVIDER_NAME, (Object)string);
    }

    public static String getDatabaseProviderName() {
        return e.getString(DATABASE_PROVIDER_NAME);
    }

    public static Database getDefaultDatabase() {
        return Database.getByProviderName(AppConfig.getDatabaseProviderName());
    }

    public static boolean isPrintReceiptOnOrderFinish() {
        return AppConfig.getBoolean(d, false);
    }

    public static void setPrintReceiptOnOrderFinish(boolean bl) {
        e.setProperty(d, (Object)bl);
    }

    public static boolean isPrintReceiptOnOrderSettle() {
        return AppConfig.getBoolean(c, false);
    }

    public static void setPrintReceiptOnOrderSettle(boolean bl) {
        e.setProperty(c, (Object)bl);
    }

    public static boolean isPrintToKitchenOnOrderFinish() {
        return AppConfig.getBoolean(b, false);
    }

    public static void setPrintToKitchenOnOrderFinish(boolean bl) {
        e.setProperty(b, (Object)bl);
    }

    public static boolean isPrintToKitchenOnOrderSettle() {
        return AppConfig.getBoolean(a, false);
    }

    public static void setPrintToKitchenOnOrderSettle(boolean bl) {
        e.setProperty(a, (Object)bl);
    }

    static {
        AppConfig.a();
    }
}

