/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.extension.CloudSyncPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.sun.jersey.api.client.ClientHandlerException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CloudAutoSyncJob
extends CronJob {
    public static final String CLOUD_AUTO_SYNC_ID = "cloud_auto_sync";
    public static final String CLOUD_AUTO_SYNC_NAME = "Cloud auto sync";
    private static boolean b = false;

    public CloudAutoSyncJob() {
        this.setId(CLOUD_AUTO_SYNC_ID);
        this.setJobId(CLOUD_AUTO_SYNC_ID);
        this.setJobName(CLOUD_AUTO_SYNC_NAME);
        this.setFrequency("EVERY");
    }

    @Override
    public synchronized void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        PosWindow posWindow = Application.getPosWindow();
        try {
            CloudSyncPlugin cloudSyncPlugin = (CloudSyncPlugin)ExtensionManager.getPlugin(CloudSyncPlugin.class);
            if (cloudSyncPlugin == null || !cloudSyncPlugin.hasValidLicense()) {
                return;
            }
            Boolean bl = DataProvider.get().getCurrentTerminal().isMasterTerminal();
            if (!bl.booleanValue()) {
                return;
            }
            if (!PosWebService.get().checkIsConnectedToHost()) {
                return;
            }
            if (b) {
                return;
            }
            b = true;
            posWindow.updateVissabityOfProgressObserver(true);
            PosLog.debug(this.getClass(), "Starting cloud sync.....");
            SyncService.sync(posWindow);
            PosLog.debug(this.getClass(), "Finished cloud sync.....");
            b = false;
        }
        catch (ClientHandlerException clientHandlerException) {
            b = false;
            PosLog.debug(this.getClass(), "Cloud sync connection failed.");
            posWindow.progressComplete(false);
        }
        catch (Exception exception) {
            b = false;
            PosLog.debug(this.getClass(), "Connection lost");
            posWindow.progressComplete(false);
        }
    }
}

