/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.base.BaseTicketItemDiscount;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.pricecalc.DiscountCalcFactory;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlTransient;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"subTotalAmountWithoutModifiersDisplay"})
public class TicketItemDiscount
extends BaseTicketItemDiscount
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    private int originalType;
    private double originalValue;
    private double amountWithoutModifiers;
    private double discountPercentage;
    private int tableRowNum;
    private String ticketItemId;
    private Integer dataVersion;

    public TicketItemDiscount() {
    }

    public TicketItemDiscount(String string) {
        super(string);
    }

    public TicketItemDiscount(String string, String string2, double d, double d2, int n) {
        this.setId(string);
        this.setDiscountId(string);
        this.setName(string2);
        this.setCouponQuantity(d);
        this.setValue(d2);
        this.setType(n);
    }

    public TicketItemDiscount(TicketItemDiscount ticketItemDiscount) {
        this.setDiscountId(ticketItemDiscount.getDiscountId());
        this.setName(ticketItemDiscount.getName());
        this.setType(ticketItemDiscount.getType());
        this.setAutoApply(ticketItemDiscount.isAutoApply());
        this.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
        this.setMinimumAmount(ticketItemDiscount.getMinimumAmount());
        this.setValue(ticketItemDiscount.getValue());
        this.setAmount(ticketItemDiscount.getAmount());
    }

    public double calculateDiscount(double d) {
        return DiscountCalcFactory.getCalc().calculateDiscount(this, d);
    }

    public BigDecimal calculateDiscount(BigDecimal bigDecimal) {
        double d = DiscountCalcFactory.getCalc().calculateDiscount(this, bigDecimal.doubleValue());
        return NumberUtil.convertToBigDecimal(d);
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    @Override
    public String getItemCode() {
        return "";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getNameDisplay() {
        double d = this.getCouponQuantity();
        String string = d > 1.0 ? NumberUtil.trimDecilamIfNotNeeded(d) + "x " + this.getName() : this.getName().trim();
        return "  *" + string;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public Boolean isPrintedToKitchen() {
        return false;
    }

    @Override
    public String getUnitPriceDisplay() {
        return null;
    }

    @Override
    public String getItemQuantityDisplay() {
        return null;
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public void setDiscountAmount(Double d) {
    }

    @Override
    public Double getDiscountAmount() {
        return null;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return null;
    }

    @Override
    public Double getSubtotalAmount() {
        TicketItem ticketItem = this.getTicketItem();
        if (ticketItem != null && ticketItem.getDiscounts() != null && ticketItem.getDiscounts().size() == 1) {
            return -ticketItem.getDiscountAmount().doubleValue();
        }
        double d = this.getAmount();
        if (d <= 0.0) {
            return 0.0;
        }
        if (ticketItem.isReturned()) {
            return d;
        }
        return -d;
    }

    @Override
    public String getSubTotalAmountDisplay() {
        return NumberUtil.format(this.getSubtotalAmount());
    }

    public double getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(double d) {
        this.discountPercentage = d;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(PROP_DISCOUNT_ID, (Object)this.getDiscountId());
        jSONObject.put(PROP_NAME, (Object)this.getName());
        jSONObject.put(PROP_TYPE, (Object)this.getType());
        jSONObject.put("originalType", this.getOriginalType());
        jSONObject.put("originalValue", this.getOriginalValue());
        jSONObject.put(PROP_AUTO_APPLY, (Object)this.isAutoApply());
        jSONObject.put(PROP_COUPON_QUANTITY, (Object)this.getCouponQuantity());
        jSONObject.put(PROP_MINIMUM_AMOUNT, (Object)this.getMinimumAmount());
        jSONObject.put(PROP_VALUE, (Object)this.getValue());
        jSONObject.put(PROP_AMOUNT, NumberUtil.round(this.getAmount()));
        jSONObject.put(PROP_APPLY_IF_DIVISIBLE, (Object)this.isApplyIfDivisible());
        jSONObject.put("discountPercentage", this.discountPercentage);
        if (NumberUtil.round(this.getAmountWithoutModifiers()) == 0.0) {
            jSONObject.put("amountWithoutModifier", NumberUtil.round(this.getAmount()));
        } else {
            jSONObject.put("amountWithoutModifier", NumberUtil.round(this.getAmountWithoutModifiers()));
        }
        jSONObject.put("dataVersion", (Object)this.getDataVersion());
        return jSONObject;
    }

    public String getTicketItemId() {
        return this.ticketItemId;
    }

    public void setTicketItemId(String string) {
        this.ticketItemId = string;
    }

    @Override
    public boolean isSaved() {
        return this.getTicketItem() == null ? false : this.getTicketItem().isSaved();
    }

    public int getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(int n) {
        this.originalType = n;
    }

    public double getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(double d) {
        this.originalValue = d;
    }

    public double getAmountWithoutModifiers() {
        return this.amountWithoutModifiers;
    }

    public void setAmountWithoutModifiers(double d) {
        this.amountWithoutModifiers = d;
    }

    @XmlTransient
    @JsonIgnore
    public Integer getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(Integer n) {
        this.dataVersion = n;
    }
}

