/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Store;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.pricecalc.TicketItemModifierCalcFactory;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"itemQuantityDisplay"})
public class TicketItemModifier
extends BaseTicketItemModifier
implements ITicketItem,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_MODIFIER = 1;
    public static final int EXTRA_MODIFIER = 3;
    public static final int CRUST = 5;
    public static final int SEPERATOR = 6;
    public static final String TRANSIENT_PROP_TICKET_ITEM_QUANTITY = "ticketItemQuantity";
    public MenuModifier menuModifier;
    private boolean selected;
    private int tableRowNum;
    private double ticketItemQuantity;
    private List<TicketItemTax> taxes;
    private transient com.google.gson.JsonObject propertiesContainer;

    public TicketItemModifier() {
    }

    public TicketItemModifier(String string) {
        super(string);
    }

    public TicketItemModifier(TicketItem ticketItem, String string, double d, double d2) {
        this.setTicketItem(ticketItem);
        this.setName(string);
        this.setUnitPrice(d);
        this.setItemQuantity(d2);
    }

    public TicketItemModifier(String string, TicketItem ticketItem, String string2, double d, double d2, TicketItemTax ticketItemTax) {
        this.setId(string);
        this.setTicketItem(ticketItem);
        this.setName(string2);
        this.setUnitPrice(d);
        this.setItemQuantity(d2);
        this.addTotaxes(ticketItemTax);
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    public void calculatePrice() {
        TicketItemModifierCalcFactory.geCalc(this.getTicketItem()).calculatePrice(this);
    }

    public List<TicketItemDiscount> getDiscounts() {
        ArrayList<TicketItemDiscount> arrayList = new ArrayList<TicketItemDiscount>();
        String string = this.getProperty("discountDetail");
        if (StringUtils.isNotEmpty((String)string)) {
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
                ticketItemDiscount.setTicketItem(this.getTicketItem());
                ticketItemDiscount.setDiscountId(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_DISCOUNT_ID));
                ticketItemDiscount.setName(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_NAME));
                ticketItemDiscount.setType(OrgJsonUtil.getInt(jSONObject, TicketItemDiscount.PROP_TYPE));
                ticketItemDiscount.setAutoApply(OrgJsonUtil.getBoolean(jSONObject, TicketItemDiscount.PROP_AUTO_APPLY));
                ticketItemDiscount.setCouponQuantity(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_COUPON_QUANTITY));
                ticketItemDiscount.setMinimumAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_MINIMUM_AMOUNT));
                ticketItemDiscount.setValue(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_VALUE));
                ticketItemDiscount.setAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_AMOUNT));
                arrayList.add(ticketItemDiscount);
            }
        }
        return arrayList;
    }

    public void merge(TicketItemModifier ticketItemModifier) {
        this.setItemQuantity(this.getItemQuantity() + ticketItemModifier.getItemQuantity());
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> list = this.getTaxes();
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemTax ticketItemTax : list) {
            d += ticketItemTax.getRate().doubleValue();
        }
        return d;
    }

    @Override
    public String getNameDisplay() {
        return this.getItemQuantityDisplay() + " " + this.getNameDisplay(false);
    }

    public String getNameDisplay(boolean bl) {
        Store store;
        boolean bl2;
        if (this.isInfoOnly().booleanValue()) {
            return this.getName().trim();
        }
        double d = Math.abs(this.getItemQuantity());
        String string = "";
        if (d > 1.0) {
            string = NumberUtil.trimDecilamIfNotNeeded(d) + "x ";
        }
        String string2 = d > 1.0 ? string + this.getName() : this.getName().trim();
        if (this.getModifierType() == 1 && !bl) {
            string2 = string2 + "*";
        }
        boolean bl3 = bl2 = (store = DataProvider.get().getStore()).getProperty("showModifierPrice") == null ? false : Boolean.valueOf(store.getProperty("showModifierPrice"));
        if (bl2 && this.getUnitPrice() > 0.0 && !bl) {
            string2 = string + this.getName() + " @" + NumberUtil.formatNumber(this.getUnitPrice());
        }
        if (bl) {
            return "-- " + string2;
        }
        return " -- " + string2;
    }

    @Override
    public String getUnitPriceDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getUnitPrice());
    }

    @Override
    public String getItemQuantityDisplay() {
        return "";
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getTaxAmount());
    }

    @Override
    public String getTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getTotalAmount());
    }

    @Override
    public String getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getSubTotalAmount());
    }

    @Override
    public String getItemCode() {
        return "";
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public Double getItemQuantity() {
        Double d = super.getItemQuantity();
        if (d == 0.0) {
            d = (double)super.getItemCount();
        }
        return d;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    @Override
    public Double getSubtotalAmount() {
        return super.getSubTotalAmount();
    }

    @Override
    public String getSubTotalAmountDisplay() {
        return null;
    }

    @XmlTransient
    public MenuModifier getMenuModifier() {
        return this.menuModifier;
    }

    public void setMenuModifier(MenuModifier menuModifier) {
        this.menuModifier = menuModifier;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public void setTaxes(List<TicketItemTax> list) {
        this.taxes = list;
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String string = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax ticketItemTax = new TicketItemTax();
                    ticketItemTax.setId(JsonUtil.getString(jsonObject, TicketItemTax.PROP_ID));
                    ticketItemTax.setName(jsonObject.getString(TicketItemTax.PROP_NAME));
                    ticketItemTax.setRate(POSUtil.parseDouble("" + jsonObject.get((Object)TicketItemTax.PROP_RATE)));
                    ticketItemTax.setTaxAmount(POSUtil.parseDouble("" + jsonObject.get((Object)TicketItemTax.PROP_TAX_AMOUNT)));
                    this.taxes.add(ticketItemTax);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax ticketItemTax) {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes = this.getTaxes();
        this.taxes.add(ticketItemTax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jSONArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jSONArray.toString());
    }

    public void setTicketItemQuantity(double d) {
        this.ticketItemQuantity = d;
    }

    public double getTicketItemQuantity() {
        if (this.getTicketItem() != null) {
            return this.getTicketItem().getQuantity();
        }
        return this.ticketItemQuantity;
    }

    @Override
    public String getProperty(String string) {
        String string2;
        if (this.propertiesContainer == null) {
            string2 = super.getProperties();
            if (StringUtils.isEmpty((String)string2)) {
                return null;
            }
            this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string2, com.google.gson.JsonObject.class);
        }
        if (this.propertiesContainer.has(string) && !(string2 = this.propertiesContainer.get(string)).isJsonNull()) {
            return string2.getAsString();
        }
        return null;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        try {
            this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new com.google.gson.JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public com.google.gson.JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new com.google.gson.JsonObject();
        }
        return this.propertiesContainer;
    }

    public Double getMultiplierPrice(Double d) {
        if (StringUtils.isEmpty((String)super.getMultiplierName())) {
            return d;
        }
        Multiplier multiplier = DataProvider.get().getMultiplierById(super.getMultiplierName());
        if (multiplier == null || multiplier.isMain().booleanValue()) {
            return d;
        }
        return d * multiplier.getRate() / 100.0;
    }

    public void setSizeAndCrust(PizzaPrice pizzaPrice) {
        this.setModifierType(5);
        this.setInfoOnly(true);
        this.setPizzaCrustId(pizzaPrice.getCrust().getId());
        this.setMenuSizeId(pizzaPrice.getSize().getId());
        this.setName(pizzaPrice.getSize().getName() + " " + pizzaPrice.getCrust());
    }

    /*
     * WARNING - void declaration
     */
    public MenuItemSize getMenuSize(MenuItem menuItem) {
        MenuItemSize menuItemSize;
        List<PizzaPrice> list = menuItem.getPizzaPriceList();
        if (list == null) {
            return null;
        }
        String string = this.getMenuSizeId();
        if (StringUtils.isNotBlank((String)string)) {
            for (PizzaPrice object2 : list) {
                menuItemSize = object2.getSize();
                if (!string.equals(menuItemSize.getId())) continue;
                return menuItemSize;
            }
        }
        String string2 = this.getName();
        String string3 = "";
        menuItemSize = null;
        for (PizzaPrice pizzaPrice : list) {
            void var5_7;
            MenuItemSize menuItemSize2 = pizzaPrice.getSize();
            if (!string2.contains(menuItemSize2.getName()) || menuItemSize2.getName().length() <= var5_7.length()) continue;
            String string4 = menuItemSize2.getName();
            menuItemSize = menuItemSize2;
        }
        return menuItemSize;
    }

    /*
     * WARNING - void declaration
     */
    public PizzaCrust getPizzaCrust(MenuItem menuItem) {
        PizzaCrust pizzaCrust;
        List<PizzaPrice> list = menuItem.getPizzaPriceList();
        if (list == null) {
            return null;
        }
        String string = this.getPizzaCrustId();
        if (StringUtils.isNotBlank((String)string)) {
            for (PizzaPrice object2 : list) {
                pizzaCrust = object2.getCrust();
                if (!string.equals(pizzaCrust.getId())) continue;
                return pizzaCrust;
            }
        }
        String string2 = this.getName();
        String string3 = "";
        pizzaCrust = null;
        for (PizzaPrice pizzaPrice : list) {
            void var5_7;
            PizzaCrust pizzaCrust2 = pizzaPrice.getCrust();
            if (!string2.contains(pizzaCrust2.getName()) || pizzaCrust2.getName().length() <= var5_7.length()) continue;
            String string4 = pizzaCrust2.getName();
            pizzaCrust = pizzaCrust2;
        }
        return pizzaCrust;
    }

    public String getMenuSizeId() {
        return this.getProperty("menu_size_id");
    }

    public void setMenuSizeId(String string) {
        this.addProperty("menu_size_id", string);
    }

    public String getPizzaCrustId() {
        return this.getProperty("pizza_crust_id");
    }

    public void setPizzaCrustId(String string) {
        this.addProperty("pizza_crust_id", string);
    }
}

