/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseCashDrawerDAO;
import com.floreantpos.model.dao.CashBreakdownDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class CashDrawerDAO
extends BaseCashDrawerDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void loadCashDrawerReport(PaginationSupport paginationSupport, Date date, Date date2) {
        this.loadCashDrawerReport(paginationSupport, date, date2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCashDrawerReport(PaginationSupport paginationSupport, Date date, Date date2, User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.between((String)CashDrawer.PROP_START_TIME, (Object)date, (Object)date2));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_ASSIGNED_USER_ID, (Object)user.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            for (CashDrawer cashDrawer : list) {
                CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
                cashDrawerReportService.populateReport();
            }
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findReports(Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)date2));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CashDrawer> findByStoreOperationData(StoreSession storeSession, Boolean bl, Session session) {
        if (storeSession == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
        if (bl != null) {
            criteria.add(bl != false ? Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME) : Restrictions.isNotNull((String)CashDrawer.PROP_REPORT_TIME));
        }
        criteria.addOrder(Order.desc((String)CashDrawer.PROP_START_TIME));
        return criteria.list();
    }

    public List<CashDrawer> findByStoreOperationData(StoreSession storeSession, Boolean bl) {
        try (Session session = this.createNewSession();){
            List<CashDrawer> list = this.findByStoreOperationData(storeSession, bl, session);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCashDrawerIds(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)CashDrawer.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSumOfOpeningBalance(StoreSession storeSession) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
            Double d = (Double)criteria.uniqueResult();
            if (d == null) {
                double d2 = 0.0;
                return d2;
            }
            double d3 = d;
            return d3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByUnSyncStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Criterion criterion = Restrictions.isNull((String)CashDrawer.PROP_LAST_UPDATE_TIME);
            Criterion criterion2 = Restrictions.isNull((String)CashDrawer.PROP_LAST_SYNC_TIME);
            PropertyExpression propertyExpression = Restrictions.gtProperty((String)CashDrawer.PROP_LAST_UPDATE_TIME, (String)CashDrawer.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{criterion, criterion2, propertyExpression}));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCashDrawer(List<CashDrawer> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CashDrawer cashDrawer : list) {
                List<CashBreakdown> list2 = cashDrawer.getCashBreakdownList();
                cashDrawer.setCashBreakdownList(null);
                cashDrawer.setUpdateLastUpdateTime(bl);
                cashDrawer.setUpdateSyncTime(bl2);
                CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
                CashDrawer cashDrawer2 = cashDrawerDAO.get(cashDrawer.getId());
                if (cashDrawer2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(cashDrawer.getLastUpdateTime(), cashDrawer2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), cashDrawer.getId() + " already updated");
                        continue;
                    }
                    long l = cashDrawer2.getVersion();
                    cashDrawer.setVersion(l);
                } else {
                    this.save(cashDrawer, session);
                }
                if (list2 != null && list2.size() > 0) {
                    for (CashBreakdown cashBreakdown : list2) {
                        CashBreakdownDAO cashBreakdownDAO = CashBreakdownDAO.getInstance();
                        CashBreakdown cashBreakdown2 = cashBreakdownDAO.get(cashBreakdown.getId());
                        if (cashBreakdown2 == null) {
                            cashDrawerDAO.save(cashBreakdown, session);
                            continue;
                        }
                        cashBreakdown.setVersion(cashBreakdown2.getVersion());
                    }
                }
                cashDrawer.setCashBreakdownList(list2);
                this.saveOrUpdate(cashDrawer, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findStaffBank(Date date, Date date2, User user) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_TYPE, (Object)DrawerType.STAFF_BANK.getTypeNumber()));
            criteria.add(Restrictions.between((String)CashDrawer.PROP_START_TIME, (Object)date, (Object)date2));
            CashDrawerDAO.addUserWithAllRoleCriteria(criteria, user, CashDrawer.PROP_ASSIGNED_USER_ID);
            List list = criteria.list();
            if (!list.isEmpty()) {
                for (CashDrawer cashDrawer : list) {
                    CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
                    cashDrawerReportService.populateReport();
                }
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveDrawerAssignment(CashDrawer cashDrawer, Terminal terminal) {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (cashDrawer != null) {
                this.saveOrUpdate(cashDrawer, session);
            }
            if (terminal != null) {
                TerminalDAO.getInstance().saveOrUpdate(terminal, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_ID, (Object)string));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void transferUser(CashDrawer cashDrawer, User user) {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            cashDrawer.setAssignedUser(user);
            this.update(cashDrawer, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

