/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.dao.BaseDeliveryChargeDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class DeliveryChargeDAO
extends BaseDeliveryChargeDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<DeliveryCharge> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        DeliveryCharge deliveryCharge = (DeliveryCharge)object;
        deliveryCharge.setDeleted(Boolean.TRUE);
        this.update(deliveryCharge, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeliveryCharge> findByDistance(double d) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)DeliveryCharge.PROP_START_RANGE, (Object)d), (Criterion)Restrictions.ge((String)DeliveryCharge.PROP_END_RANGE, (Object)d)));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeliveryCharge> findByZipCode(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)DeliveryCharge.PROP_ZIP_CODE, (Object)string));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findMinRange() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.min((String)DeliveryCharge.PROP_START_RANGE));
            this.addDeletedFilter(criteria);
            double d = (Double)criteria.uniqueResult();
            return d;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double findMaxRange() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)DeliveryCharge.PROP_END_RANGE));
            this.addDeletedFilter(criteria);
            Double d = (Double)criteria.uniqueResult();
            return d;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateDeliveryChargeList(List<DeliveryCharge> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (DeliveryCharge deliveryCharge : list) {
                DeliveryCharge deliveryCharge2 = this.get(deliveryCharge.getId());
                if (deliveryCharge2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(deliveryCharge.getLastUpdateTime(), deliveryCharge2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), deliveryCharge.getName() + " already updated");
                        continue;
                    }
                    long l = deliveryCharge2.getVersion();
                    PropertyUtils.copyProperties((Object)deliveryCharge2, (Object)deliveryCharge);
                    deliveryCharge2.setVersion(l);
                    deliveryCharge2.setUpdateLastUpdateTime(bl);
                    deliveryCharge2.setUpdateSyncTime(bl2);
                    this.update(deliveryCharge2, session);
                    continue;
                }
                deliveryCharge.setUpdateLastUpdateTime(bl);
                deliveryCharge.setUpdateSyncTime(bl2);
                this.save(deliveryCharge, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

