/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.dao.BaseMenuModifierDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MenuModifierDAO
extends BaseMenuModifierDAO {
    private static final String EMPTY_NEWLINE_STRING = "\n";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    private String constructExceptionDetailsByModifierGroup(MenuModifier menuModifier, List<ModifierGroup> list) {
        if (list != null && !list.isEmpty()) {
            String string = Messages.getString("MenuModifierDAO.1");
            if (menuModifier.isPizzaModifier().booleanValue()) {
                string = Messages.getString("MenuModifierDAO.5");
            }
            StringBuilder stringBuilder = new StringBuilder(menuModifier.getName() + " " + string);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = i + 1 + ". " + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string2);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByModifier(MenuModifier menuModifier, List<String> list) {
        if (list != null && !list.isEmpty()) {
            String string = Messages.getString("MenuModifierDAO.2");
            if (menuModifier.isPizzaModifier().booleanValue()) {
                string = Messages.getString("MenuModifierDAO.7");
            }
            StringBuilder stringBuilder = new StringBuilder(menuModifier.getName() + " " + string);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = i + 1 + ". " + list.get(i);
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string2);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByDefaultMenuModifier(MenuModifier menuModifier, List<String> list) {
        if (list != null && !list.isEmpty()) {
            String string = Messages.getString("MenuModifierDAO.3");
            if (menuModifier.isPizzaModifier().booleanValue()) {
                string = Messages.getString("MenuModifierDAO.9");
            }
            StringBuilder stringBuilder = new StringBuilder(menuModifier.getName() + " " + string);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = i + 1 + ". " + list.get(i);
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string2);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    protected void delete(Object object, Session session) {
        String string;
        List<String> list;
        List<String> list2;
        MenuModifier menuModifier = (MenuModifier)object;
        if (menuModifier == null) {
            throw new PosException(Messages.getString("MenuModifierDAO.0"));
        }
        session.refresh(object);
        StringBuilder stringBuilder = new StringBuilder();
        List<ModifierGroup> list3 = this.getModifierGroupByModifier(menuModifier, session);
        if (list3 != null && !list3.isEmpty()) {
            stringBuilder.append(this.constructExceptionDetailsByModifierGroup(menuModifier, list3));
            stringBuilder.append(EMPTY_NEWLINE_STRING);
            stringBuilder.append(EMPTY_NEWLINE_STRING);
        }
        if ((list2 = this.getMenuItemNamesByModifier(menuModifier, session)) != null && !list2.isEmpty()) {
            stringBuilder.append(this.constructExceptionDetailsByModifier(menuModifier, list2));
            stringBuilder.append(EMPTY_NEWLINE_STRING);
            stringBuilder.append(EMPTY_NEWLINE_STRING);
        }
        if ((list = this.getMenuItemNamesByDefaultModifier(menuModifier, session)) != null && !list.isEmpty()) {
            stringBuilder.append(this.constructExceptionDetailsByDefaultMenuModifier(menuModifier, list));
            stringBuilder.append(EMPTY_NEWLINE_STRING);
        }
        String string2 = Messages.getString("MenuModifierDAO.10");
        if (menuModifier.isPizzaModifier().booleanValue()) {
            string2 = Messages.getString("MenuModifierDAO.11");
        }
        if (StringUtils.isNotBlank((String)(string = stringBuilder.toString()))) {
            throw new PosException(string2, string);
        }
        menuModifier.setDeleted(true);
        this.update(menuModifier, session);
    }

    private List<ModifierGroup> getModifierGroupByModifier(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(ModifierGroup.class);
        this.addDeletedFilter(criteria);
        criteria.createAlias("modifiers", "modifier");
        criteria.add(Restrictions.in((String)("modifier." + MenuModifier.PROP_ID), (Object[])new Object[]{menuModifier.getId()}));
        return criteria.list();
    }

    private List<String> getMenuItemNamesByModifier(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        this.addDeletedFilter(criteria, MenuItem.class);
        criteria.createAlias("menuItemModiferSpecs", "ms");
        criteria.createAlias("ms.modifierPages", "mp");
        criteria.createAlias("mp.pageItems", "i");
        criteria.add((Criterion)Restrictions.eq((String)("i." + MenuItemModifierPageItem.PROP_MENU_MODIFIER_ID), (Object)menuModifier.getId()));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)));
        return criteria.list();
    }

    private List<String> getMenuItemNamesByDefaultModifier(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        this.addDeletedFilter(criteria, MenuItem.class);
        Criteria criteria2 = criteria.createCriteria("menuItemModiferSpecs");
        criteria2.createAlias("defaultModifierList", "dml");
        criteria2.add(Restrictions.in((String)("dml." + DefaultMenuModifier.PROP_MODIFIER), (Object[])new Object[]{menuModifier}));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)));
        return criteria.list();
    }

    private void deleteModifierFromModifierPageItem(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierPageItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierPageItem.PROP_MENU_MODIFIER_ID, (Object)menuModifier.getId()));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MenuItemModifierPageItem menuItemModifierPageItem : list) {
            this.deletePageItemFromPage(menuItemModifierPageItem, session);
        }
    }

    private void deletePageItemFromPage(MenuItemModifierPageItem menuItemModifierPageItem, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierPage.class);
        criteria.createAlias("pageItems", "pageItem");
        criteria.add((Criterion)Restrictions.eq((String)("pageItem." + MenuItemModifierPage.PROP_ID), (Object)menuItemModifierPageItem.getId()));
        List list = criteria.list();
        for (MenuItemModifierPage menuItemModifierPage : list) {
            menuItemModifierPage.getPageItems().remove(menuItemModifierPageItem);
            MenuItemModifierPageDAO.getInstance().update(menuItemModifierPage, session);
        }
    }

    private void deleteModifierFromDefaultModifierList(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierSpec.class);
        criteria.createAlias("defaultModifierList", "m");
        criteria.add((Criterion)Restrictions.eq((String)"m.modifier", (Object)menuModifier));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            List<DefaultMenuModifier> list2 = menuItemModifierSpec.getDefaultModifierList();
            if (list2 != null && list2.size() > 0) {
                Iterator<DefaultMenuModifier> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    DefaultMenuModifier defaultMenuModifier = iterator.next();
                    if (!defaultMenuModifier.getModifier().getId().equals(menuModifier.getId())) continue;
                    iterator.remove();
                }
            }
            MenuItemModifierSpecDAO.getInstance().update(menuItemModifierSpec, session);
        }
    }

    private void deleteModifierFromModifierGroup(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(ModifierGroup.class);
        criteria.createAlias("modifiers", "modifier");
        criteria.add(Restrictions.in((String)("modifier." + MenuModifier.PROP_ID), Arrays.asList(menuModifier.getId())));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ModifierGroup modifierGroup : list) {
            modifierGroup.getModifiers().remove(menuModifier);
            ModifierGroupDAO.getInstance().update(modifierGroup, session);
        }
    }

    public MenuModifier loadFullModifier(String string) {
        try (Session session = this.createNewSession();){
            MenuModifier menuModifier = this.get(string, session);
            if (menuModifier != null) {
                this.initialize(menuModifier, session);
            }
            MenuModifier menuModifier2 = menuModifier;
            return menuModifier2;
        }
    }

    public void initialize(MenuModifier menuModifier) {
        if (menuModifier == null || menuModifier.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(menuModifier.getPizzaModifierPriceList()) && Hibernate.isInitialized(menuModifier.getMultiplierPriceList()) && Hibernate.isInitialized(menuModifier.getModifierGroups())) {
            return;
        }
        try (Session session = this.createNewSession();){
            session.refresh((Object)menuModifier);
            this.initialize(menuModifier, session);
        }
    }

    private void initialize(MenuModifier menuModifier, Session session) {
        Hibernate.initialize(menuModifier.getPizzaModifierPriceList());
        Hibernate.initialize(menuModifier.getMultiplierPriceList());
        Hibernate.initialize(menuModifier.getModifierGroups());
    }

    public List<MenuModifier> getModifierList(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_TAG, (Object)string));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuModifier> getMenuModifiers(String string) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(MenuModifier.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_NAME).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }

    @Deprecated
    public int getRowCount(String string, boolean bl) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
        }
        return 0;
    }

    public void loadItems(String string, boolean bl, PaginatedListModel paginatedListModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            paginatedListModel.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            paginatedListModel.setData(criteria.list());
        }
    }

    public void loadItems(String string, boolean bl, boolean bl2, BeanTableModel<MenuModifier> beanTableModel) {
        this.loadItems(null, string, bl, bl2, beanTableModel);
    }

    public void loadItems(ModifierGroup modifierGroup, String string, boolean bl, boolean bl2, BeanTableModel<MenuModifier> beanTableModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            if (modifierGroup != null) {
                criteria.createAlias("modifierGroups", "groups");
                criteria.add((Criterion)Restrictions.eq((String)("groups." + ModifierGroup.PROP_ID), (Object)modifierGroup.getId()));
            }
            beanTableModel.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_NAME).ignoreCase());
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            beanTableModel.setRows(criteria.list());
        }
    }

    @Deprecated
    public List<MenuModifier> getComboModifiers() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(MenuModifier.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_COMBO_MODIFIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }

    public MenuModifier findName(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuModifier menuModifier = (MenuModifier)list.get(0);
                return menuModifier;
            }
            MenuModifier menuModifier = null;
            return menuModifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void loadMenuModifier(PaginationSupport paginationSupport, String string, ModifierGroup modifierGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.addDeletedFilter(criteria);
            this.updateCriteria(string, modifierGroup, criteria);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteria(string, modifierGroup, criteria);
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(String string, ModifierGroup modifierGroup, Criteria criteria) {
        this.addDeletedFilter(criteria);
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (modifierGroup != null) {
            criteria.createAlias("modifierGroups", "groups");
            criteria.add((Criterion)Restrictions.eq((String)("groups." + ModifierGroup.PROP_ID), (Object)modifierGroup.getId()));
        }
    }

    public void removePizzaModifierPrices(List<String> list, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("pizzaModifierPriceList", "modifierPrice");
        criteria.add(Restrictions.in((String)"modifierPrice.id", list));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List list2 = criteria.list();
        if (list2 != null && !list2.isEmpty()) {
            for (MenuModifier menuModifier : list2) {
                List<PizzaModifierPrice> list3 = menuModifier.getPizzaModifierPriceList();
                Iterator<PizzaModifierPrice> iterator = list3.iterator();
                while (iterator.hasNext()) {
                    PizzaModifierPrice pizzaModifierPrice = iterator.next();
                    if (!list.contains(pizzaModifierPrice.getId())) continue;
                    iterator.remove();
                }
                session.update((Object)menuModifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMenuModifierFormData(MenuModifier menuModifier) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(menuModifier, session);
            MenuItemModifierPageItemDAO menuItemModifierPageItemDAO = MenuItemModifierPageItemDAO.getInstance();
            List<MenuItemModifierPageItem> list = menuItemModifierPageItemDAO.getPageItemFor(menuModifier, session);
            if (list != null) {
                for (MenuItemModifierPageItem menuItemModifierPageItem : list) {
                    menuItemModifierPageItem.setMenuModifier(menuModifier);
                    menuItemModifierPageItemDAO.saveOrUpdate(menuItemModifierPageItem, session);
                }
            }
            transaction.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> getPizzaModifiers(String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuModifier.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)true));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_NAME).ignoreCase());
            List list = criteria.list();
            for (MenuModifier menuModifier : list) {
                Hibernate.initialize(menuModifier.getModifierGroups());
            }
            List list2 = list;
            return list2;
        }
    }

    public boolean hasMenuModifierByName(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuModifier.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                boolean bl = list.size() > 0;
                return bl;
            }
        }
        return false;
    }

    public List<String> getNonExistingModifierIds(Set<MenuModifier> set) {
        MenuModifier menuModifier2;
        if (set == null || set.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MenuModifier menuModifier2 : set) {
            arrayList.add(menuModifier2.getId());
        }
        ArrayList arrayList2 = new ArrayList();
        menuModifier2 = this.createNewSession();
        Throwable throwable = null;
        try {
            Criteria criteria = menuModifier2.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)MenuModifier.PROP_ID));
            criteria.add(Restrictions.in((String)MenuModifier.PROP_ID, arrayList));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                ArrayList<String> arrayList3 = arrayList;
                return arrayList3;
            }
            for (String string : arrayList) {
                if (list.contains(string)) continue;
                arrayList2.add(string);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (menuModifier2 != null) {
                if (throwable != null) {
                    try {
                        menuModifier2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    menuModifier2.close();
                }
            }
        }
        return arrayList2;
    }
}

