/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseComboGroup;
import com.floreantpos.model.base.BaseComboItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TicketItemUtil {
    public static void validateTicketItem(TicketItem ticketItem, Ticket ticket) {
        TicketItemUtil.validateTicketItem(ticketItem, ticket, Messages.getString("IS_NOT_AVAILABLE_FOR_REORDER"));
    }

    public static void validateTicketItem(TicketItem ticketItem, Ticket ticket, String string) {
        String string2 = ticketItem.getMenuItemId();
        if (StringUtils.isBlank((String)string2) || string2.equals("0")) {
            return;
        }
        MenuItem menuItem = MenuItemDAO.getInstance().get(string2);
        if (menuItem.isHasVariant().booleanValue()) {
            throw new PosException(ticketItem.getName() + string);
        }
        if (!ticketItem.isComboItem().equals(menuItem.isComboItem())) {
            throw new PosException(ticketItem.getName() + string);
        }
        TicketItemUtil.verifyModifiers(ticketItem, string);
        TicketItemUtil.verifyComboItem(ticketItem, string);
    }

    private static void verifyModifiers(TicketItem ticketItem, String string) {
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null && list.size() > 0) {
            for (TicketItemModifier ticketItemModifier : list) {
                String string2 = ticketItemModifier.getItemId();
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                MenuModifier menuModifier = MenuModifierDAO.getInstance().get(string2);
                String string3 = ticketItemModifier.getGroupId();
                MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(string3);
                if (menuItemModifierSpec != null) {
                    Serializable serializable;
                    if (menuItemModifierSpec.isUseModifierGroupSettings()) {
                        serializable = menuItemModifierSpec.getModifierGroup();
                        List<MenuModifier> list2 = serializable.getModifiers();
                        TicketItemUtil.checkModifiers(menuModifier, list2, ticketItemModifier.getName(), string);
                    } else {
                        MenuItemModifierSpecDAO.getInstance().initialize(menuItemModifierSpec);
                        serializable = new ArrayList<MenuModifier>(menuItemModifierSpec.getModifiers());
                        TicketItemUtil.checkModifiers(menuModifier, (List<MenuModifier>)((Object)serializable), ticketItemModifier.getName(), string);
                    }
                } else {
                    throw new PosException(ticketItemModifier.getName() + string);
                }
                if (menuModifier == null || !menuModifier.isDeleted().booleanValue()) continue;
                throw new PosException(menuModifier.getName() + string);
            }
        }
    }

    private static void checkModifiers(MenuModifier menuModifier, List<MenuModifier> list, String string, String string2) {
        List<String> list2;
        if (!(list == null || (list2 = POSUtil.getStringIds(list, MenuModifier.class)).contains(menuModifier.getId()) && menuModifier.isEnable().booleanValue())) {
            throw new PosException(string + string2);
        }
    }

    private static void verifyComboItem(TicketItem ticketItem, String string) {
        List<MenuItem> list;
        Object object;
        Object object2;
        Object object3;
        if (!ticketItem.isComboItem().booleanValue()) {
            return;
        }
        MenuItem menuItem = MenuItemDAO.getInstance().loadInitialized(ticketItem.getMenuItemId());
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ComboItem> list2 = menuItem.getComboItems();
        if (list2 != null) {
            object3 = list2.iterator();
            while (object3.hasNext()) {
                object2 = (ComboItem)object3.next();
                arrayList.add(((BaseComboItem)object2).getItemId());
            }
        }
        if ((object3 = menuItem.getComboGroups()) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (ComboGroup)object2.next();
                list = ((BaseComboGroup)object).getItems();
                if (list == null) continue;
                for (MenuItem menuItem2 : list) {
                    arrayList.add(menuItem2.getId() + "_" + ((BaseComboGroup)object).getId());
                }
            }
        }
        if ((object2 = ticketItem.getComboItems()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                list = (TicketItem)object.next();
                Object object4 = ((BaseTicketItem)((Object)list)).getMenuItemId();
                if (StringUtils.isNotBlank((String)((BaseTicketItem)((Object)list)).getGroupId())) {
                    object4 = (String)object4 + "_" + ((BaseTicketItem)((Object)list)).getGroupId();
                }
                if (!arrayList.contains(object4)) {
                    throw new PosException(((BaseTicketItem)((Object)list)).getName() + string);
                }
                TicketItemUtil.verifyModifiers((TicketItem)((Object)list), string);
            }
        }
    }
}

