/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Discount;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SalesExceptionReport {
    private Date a;
    private Date b;
    private Date c;
    private List<VoidData> d = new ArrayList<VoidData>();
    private Map<String, DiscountData> e = new HashMap<String, DiscountData>();
    private List<RefundData> f = new ArrayList<RefundData>();

    public void addVoidToVoidData(Ticket ticket) {
        double d = ticket.getSubtotalAmount();
        String string = ticket.getVoidReason();
        VoidData voidData = new VoidData();
        voidData.a = ticket.getId();
        voidData.setReasonCode(string);
        voidData.setCount(1);
        voidData.setAmount(d);
        voidData.b = ticket.isWasted();
        this.d.add(voidData);
    }

    public void addRefundToRefundData(RefundTransaction refundTransaction) {
        double d = refundTransaction.getAmount();
        RefundData refundData = new RefundData();
        refundData.b = refundTransaction.getTicketId();
        refundData.setTime(refundTransaction.getTransactionTime());
        refundData.setTransactionId(refundTransaction.getId());
        PaymentType paymentType = refundTransaction.getPaymentType();
        if (paymentType == PaymentType.CUSTOM_PAYMENT) {
            refundData.setPaymentType(refundTransaction.getCustomPaymentName());
        } else {
            refundData.setPaymentType(paymentType.getDisplayString());
        }
        refundData.setAmount(d);
        this.f.add(refundData);
    }

    public void addDiscountOnTicketItem(TicketItem ticketItem) {
        List<TicketItemDiscount> list = ticketItem.getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                String string = ticketItemDiscount.getName();
                DiscountData discountData = this.e.get(ticketItemDiscount.getDiscountId());
                if (discountData == null) {
                    discountData = new DiscountData();
                    discountData.a = ticketItemDiscount.getDiscountId();
                    discountData.b = string;
                    this.e.put(ticketItemDiscount.getDiscountId(), discountData);
                }
                if (ticketItem.isItemReturned().booleanValue() || ticketItem.isVoided().booleanValue()) {
                    discountData.d = discountData.d - Math.abs(ticketItemDiscount.getAmountWithoutModifiers());
                } else {
                    discountData.c = ++discountData.c;
                    discountData.d = discountData.d + Math.abs(ticketItemDiscount.getAmountWithoutModifiers());
                }
                discountData.e = discountData.e + ticketItem.getSubtotalAmount();
                discountData.f = discountData.f + (double)ticketItem.getTicket().getNumberOfGuests().intValue();
                discountData.g = discountData.e / (double)discountData.c;
            }
        }
    }

    public void addDiscountOnTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemDiscount> list = ticketItemModifier.getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                String string = ticketItemDiscount.getName();
                DiscountData discountData = this.e.get(ticketItemDiscount.getDiscountId());
                if (discountData == null) {
                    discountData = new DiscountData();
                    discountData.a = ticketItemDiscount.getDiscountId();
                    discountData.b = string;
                    this.e.put(ticketItemDiscount.getDiscountId(), discountData);
                }
                discountData.d = discountData.d + ticketItemDiscount.getAmount();
            }
        }
    }

    public void addDiscountOnTicket(Ticket ticket) {
        List<TicketDiscount> list = ticket.getDiscounts();
        if (list != null) {
            for (TicketDiscount ticketDiscount : list) {
                String string = ticketDiscount.getName();
                if (NumberUtil.isZero(ticketDiscount.getTotalDiscountAmount())) {
                    return;
                }
                DiscountData discountData = this.e.get(ticketDiscount.getDiscountId());
                if (discountData == null) {
                    discountData = new DiscountData();
                    discountData.a = ticketDiscount.getDiscountId();
                    discountData.b = string;
                    this.e.put(ticketDiscount.getDiscountId(), discountData);
                }
                discountData.c = ++discountData.c;
                discountData.d = discountData.d + ticketDiscount.getTotalDiscountAmount();
                discountData.e = discountData.e + ticket.getSubtotalAmount();
                discountData.f = discountData.f + (double)ticket.getNumberOfGuests().intValue();
                discountData.g = discountData.e / (double)discountData.c;
            }
        }
    }

    public void addEmptyDiscounts(List<Discount> list) {
        if (list != null) {
            for (Discount discount : list) {
                String string = discount.getName();
                DiscountData discountData = this.e.get(discount.getId());
                if (discountData != null) continue;
                discountData = new DiscountData();
                discountData.a = discount.getId();
                discountData.b = string;
                this.e.put(discount.getId(), discountData);
            }
        }
    }

    public static void main(String[] stringArray) {
    }

    public Date getFromDate() {
        return this.a;
    }

    public void setFromDate(Date date) {
        this.a = date;
    }

    public Date getReportTime() {
        return this.c;
    }

    public void setReportTime(Date date) {
        this.c = date;
    }

    public Date getToDate() {
        return this.b;
    }

    public void setToDate(Date date) {
        this.b = date;
    }

    public VoidTableModel getVoidTableModel() {
        VoidTableModel voidTableModel = new VoidTableModel();
        voidTableModel.setRows(this.d);
        return voidTableModel;
    }

    public RefundTableModel getRefundTableModel() {
        RefundTableModel refundTableModel = new RefundTableModel();
        refundTableModel.setRows(this.f);
        return refundTableModel;
    }

    public DiscountTableModel getDiscountTableModel() {
        DiscountTableModel discountTableModel = new DiscountTableModel();
        ArrayList<DiscountData> arrayList = new ArrayList<DiscountData>(this.e.values());
        discountTableModel.setRows(arrayList);
        return discountTableModel;
    }

    public class RefundTableModel
    extends ListTableModel {
        public RefundTableModel() {
            this.setColumnNames(new String[]{"time", "ticketId", "transactionId", "paymentType", "amount"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            RefundData refundData = (RefundData)this.rows.get(n);
            if (refundData == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return refundData.getTime();
                }
                case 1: {
                    return refundData.getTicketId();
                }
                case 2: {
                    return refundData.getTransactionId();
                }
                case 3: {
                    return refundData.getPaymentType();
                }
                case 4: {
                    return refundData.getAmount();
                }
            }
            return null;
        }
    }

    public static class RefundData {
        private Date a;
        private String b;
        private String c;
        private String d;
        private double e;

        public Date getTime() {
            return this.a;
        }

        public void setTime(Date date) {
            this.a = date;
        }

        public String getTicketId() {
            return this.b;
        }

        public void setTicketId(String string) {
            this.b = string;
        }

        public double getAmount() {
            return this.e;
        }

        public void setAmount(double d) {
            this.e = d;
        }

        public String getTransactionId() {
            return this.c;
        }

        public void setTransactionId(String string) {
            this.c = string;
        }

        public String getPaymentType() {
            return this.d;
        }

        public void setPaymentType(String string) {
            this.d = string;
        }
    }

    public class DiscountTableModel
    extends ListTableModel {
        public DiscountTableModel() {
            this.setColumnNames(new String[]{"no", "name", "code", "totalCount", "totalDiscount", "totalNetSales", "totalGuests", "partySize", "checkSize", "countPercent", "ratioDnet"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DiscountData discountData = (DiscountData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return discountData.a;
                }
                case 1: {
                    return discountData.b;
                }
                case 2: {
                    return discountData.a;
                }
                case 3: {
                    return discountData.c;
                }
                case 4: {
                    return discountData.d;
                }
                case 5: {
                    return discountData.e;
                }
                case 7: {
                    return discountData.f;
                }
                case 8: {
                    return discountData.g;
                }
            }
            return null;
        }
    }

    public class VoidTableModel
    extends ListTableModel {
        public VoidTableModel() {
            this.setColumnNames(new String[]{"code", "reason", "wast", "qty", "amount"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            VoidData voidData = (VoidData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return String.valueOf(voidData.a);
                }
                case 1: {
                    return voidData.getReasonCode();
                }
                case 2: {
                    return voidData.b ? "Y" : "N";
                }
                case 3: {
                    return String.valueOf(voidData.getCount());
                }
                case 4: {
                    return voidData.getAmount();
                }
            }
            return null;
        }
    }

    public static class DiscountData {
        private String a;
        private String b;
        private int c;
        private double d;
        private double e;
        private double f;
        private double g;

        public double getCheckSize() {
            return this.g;
        }

        public void setCheckSize(double d) {
            this.g = d;
        }

        public String getCode() {
            return this.a;
        }

        public void setCode(String string) {
            this.a = string;
        }

        public String getName() {
            return this.b;
        }

        public void setName(String string) {
            this.b = string;
        }

        public double getPartySize() {
            return this.f;
        }

        public void setPartySize(double d) {
            this.f = d;
        }

        public int getTotalCount() {
            return this.c;
        }

        public void setTotalCount(int n) {
            this.c = n;
        }

        public double getTotalDiscount() {
            return this.d;
        }

        public void setTotalDiscount(double d) {
            this.d = d;
        }

        public double getTotalNetSales() {
            return this.e;
        }

        public void setTotalNetSales(double d) {
            this.e = d;
        }
    }

    public static class VoidData {
        String a;
        private String c;
        private int d;
        private double e;
        boolean b;

        public double getAmount() {
            return this.e;
        }

        public void setAmount(double d) {
            this.e = d;
        }

        public int getCount() {
            return this.d;
        }

        public void setCount(int n) {
            this.d = n;
        }

        public String getReasonCode() {
            return this.c;
        }

        public void setReasonCode(String string) {
            this.c = string;
        }
    }
}

