/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.NumberUtil;
import java.util.Date;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

public class SalesBalanceReportService {
    public static JasperPrint createSalesBalanceReport(Date date, Date date2, User user) throws JRException {
        ReportService reportService = new ReportService();
        SalesBalanceReport salesBalanceReport = reportService.getSalesBalanceReport(date, date2, user);
        String string = user == null ? POSConstants.ALL : user.getFullName();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, null, date, date2, null);
        ReportUtil.populateReportFooter(hashMap);
        SalesBalanceReportService.a(hashMap);
        hashMap.put("userName", ReportUtil.reportLabelWithBoldTag(POSConstants.USER_WITH_CLONE) + " " + string);
        hashMap.put("days", ReportUtil.reportLabelWithBoldTag(POSConstants.DAYS) + " " + String.valueOf((int)((double)(date2.getTime() - date.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1));
        hashMap.put("grossTaxableSales", NumberUtil.formatNumber(salesBalanceReport.getNetTaxableSalesAmount()));
        hashMap.put("grossNonTaxableSales", NumberUtil.formatNumber(salesBalanceReport.getNetNonTaxableSalesAmount()));
        hashMap.put("discounts", NumberUtil.formatNumber(salesBalanceReport.getDiscountAmount()));
        hashMap.put("returnAmount", NumberUtil.formatNumber(salesBalanceReport.getReturnAmount()));
        hashMap.put("netSales", NumberUtil.formatNumber(salesBalanceReport.getGrossSalesAmount()));
        hashMap.put("salesTaxes", NumberUtil.formatNumber(salesBalanceReport.getSalesTaxAmount()));
        hashMap.put("totalRevenues", NumberUtil.formatNumber(salesBalanceReport.getTotalRevenueAmount()));
        hashMap.put("payIns", NumberUtil.formatNumber(salesBalanceReport.getPayInsAmount()));
        hashMap.put("gratuity", NumberUtil.formatNumber(salesBalanceReport.getGratuity()));
        hashMap.put("cashTips", NumberUtil.formatNumber(salesBalanceReport.getCashTipsAmount()));
        hashMap.put("chargedTips", NumberUtil.formatNumber(salesBalanceReport.getChargedTipsAmount()));
        hashMap.put("deliveryCharge", NumberUtil.formatNumber(salesBalanceReport.getDeliveryChargeAmnt()));
        hashMap.put("fee", NumberUtil.formatNumber(salesBalanceReport.getFeeAmnt()));
        hashMap.put("grossReceipts", NumberUtil.formatNumber(salesBalanceReport.getGrossReceiptsAmount()));
        hashMap.put("cashReceipts", NumberUtil.formatNumber(salesBalanceReport.getCashReceiptsAmount()));
        hashMap.put("creditCardReceipts", NumberUtil.formatNumber(salesBalanceReport.getCreditCardReceiptsAmount()));
        hashMap.put("debitCardReceipts", NumberUtil.formatNumber(salesBalanceReport.getDebitCardReceiptsAmount()));
        hashMap.put("memberPaymentReceipts", NumberUtil.formatNumber(salesBalanceReport.getMemberPaymentAmount()));
        hashMap.put("customPayment", NumberUtil.formatNumber(salesBalanceReport.getCustomPaymentAmount()));
        hashMap.put("grossTipsPaid", NumberUtil.formatNumber(salesBalanceReport.getGrossTipsPaidAmount()));
        hashMap.put("giftCertReceipts", NumberUtil.formatNumber(salesBalanceReport.getGiftCertReceipts()));
        hashMap.put("cashBack", NumberUtil.formatNumber(salesBalanceReport.getRefundAmount()));
        hashMap.put("cashRefund", NumberUtil.formatNumber(salesBalanceReport.getCashRefundAmount()));
        hashMap.put("receiptDiff", NumberUtil.formatNumber(salesBalanceReport.getReceiptDiffAmount()));
        hashMap.put("cashPayout", NumberUtil.formatNumber(salesBalanceReport.getCashPayoutAmount()));
        hashMap.put("cashAccountable", NumberUtil.formatNumber(salesBalanceReport.getCashAccountableAmount()));
        hashMap.put("drawerPulls", NumberUtil.formatNumber(salesBalanceReport.getDrawerPullsAmount()));
        hashMap.put("coCurrent", NumberUtil.formatNumber(salesBalanceReport.getCoCurrentAmount()));
        hashMap.put("coPrevious", NumberUtil.formatNumber(salesBalanceReport.getCoPreviousAmount()));
        hashMap.put("coOverShort", NumberUtil.formatNumber(salesBalanceReport.getOverShortAmount()));
        hashMap.put("serviceCharge", NumberUtil.formatNumber(salesBalanceReport.getServiceChargeAmnt()));
        hashMap.put("toleranceAmount", NumberUtil.formatNumber(salesBalanceReport.getToleranceAmount(), true));
        hashMap.put("visaCreditCardSum", NumberUtil.formatNumber(salesBalanceReport.getVisaCreditCardAmount()));
        hashMap.put("mastercardSum", NumberUtil.formatNumber(salesBalanceReport.getMasterCardAmount()));
        hashMap.put("amexSum", NumberUtil.formatNumber(salesBalanceReport.getAmexAmount()));
        hashMap.put("discoverySum", NumberUtil.formatNumber(salesBalanceReport.getDiscoveryAmount()));
        hashMap.put("visaDebitCardSum", NumberUtil.formatNumber(salesBalanceReport.getVisaDebitCardAmount()));
        hashMap.put("masterDebitCardSum", NumberUtil.formatNumber(salesBalanceReport.getMasterDebitCardAmount()));
        hashMap.put("cashInAmount", NumberUtil.formatNumber(salesBalanceReport.getCashInAmount()));
        hashMap.put("roundingAmount", NumberUtil.formatNumber(salesBalanceReport.getRoundedAmount(), true));
        hashMap.put("showCashSummary", true);
        hashMap.put("othersCardAmountSum", NumberUtil.formatNumber(salesBalanceReport.getOthersCardAmount()));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_balance_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    private static void a(HashMap<String, Object> hashMap) {
        hashMap.put("lblRHeader", POSConstants.SALES_BALANCE_REPORT);
        hashMap.put("lblReciptS", Messages.getString("RECEIPTS_SUMMARY"));
        hashMap.put("lblReturn", "-" + Messages.getString("Return"));
        hashMap.put("lblNetSales", Messages.getString("Gross_Sales"));
        hashMap.put("lblServiceC", "+" + POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL);
        hashMap.put("lblDiscount", "-" + POSConstants.DISCOUNT);
        hashMap.put("lblRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("lblTotalRev", "=" + POSConstants.NET_SALES);
        hashMap.put("lblSalesT", "+" + Messages.getString("SALES_TAXES"));
        hashMap.put("lblDeliveryCharge", "+" + POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL);
        hashMap.put("lblCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        hashMap.put("lblGratuity", "+" + POSConstants.TIPS);
        hashMap.put("lblChargedTips", "+" + Messages.getString("chargedTips"));
        hashMap.put("lblFee", "+" + POSConstants.FEE_AMOUNT);
        hashMap.put("lblGrossReceipts", "=" + Messages.getString("netReceivable"));
        hashMap.put("lblCReceipts", "-" + Messages.getString("cashReceipts"));
        hashMap.put("lblCCReceipts", "-" + Messages.getString("CreditCardReceipts"));
        hashMap.put("lblDCReceipts", "-" + Messages.getString("DebitCartReceipts"));
        hashMap.put("lblMPReceipts", "-" + Messages.getString("MemberPaymentReceipts"));
        hashMap.put("lblCPReceipts", "-" + Messages.getString("CustomPaymentReceipts"));
        hashMap.put("lblGCertReceipts", "-" + Messages.getString("GiftCertReceipts"));
        hashMap.put("lblRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("lblTolerance", "+" + Messages.getString("CurrencyExplorer.8"));
        hashMap.put("lblReceiptDiff", "=" + Messages.getString("ReceiptDiff"));
        hashMap.put("lblCCS", Messages.getString("CreditCardSummary"));
        hashMap.put("lblTR", Messages.getString("TotalReceipts"));
        hashMap.put("lblVCS", Messages.getString("VisaCardSummary"));
        hashMap.put("lblTT", Messages.getString("TotalTips"));
        hashMap.put("lblMCS", Messages.getString("MasterCardSummary"));
        hashMap.put("lblAmexS", Messages.getString("AmexSummary"));
        hashMap.put("lblDiscoveryS", Messages.getString("DiscoverSummary"));
        hashMap.put("lblCashS", Messages.getString("CashSummary"));
        hashMap.put("lblCashRecipts", Messages.getString("cashReceipts"));
        hashMap.put("lblGTP", "-" + Messages.getString("GrossTipsPaid"));
        hashMap.put("lblCPO", "-" + Messages.getString("CashPayOut"));
        hashMap.put("lblGCChange", "-" + Messages.getString("giftCertChange"));
        hashMap.put("lblCashAcc", "=" + Messages.getString("CashAccountable"));
        hashMap.put("lblDrawerPulls", "-" + Messages.getString("DRAWER_BLEED"));
        hashMap.put("lblCOC", "-" + Messages.getString("COCurrent"));
        hashMap.put("lblCOP", "+" + Messages.getString("COPrevious"));
        hashMap.put("lblOS", "=" + Messages.getString("OverShort"));
        hashMap.put("lblDCS", Messages.getString("SalesBalanceReportService.0"));
        hashMap.put("lblDEBITVCS", Messages.getString("VisaCardSummary"));
        hashMap.put("lblDEBITMCS", Messages.getString("MasterCardSummary"));
        hashMap.put("lblCashIn", "+" + Messages.getString("cashIn"));
        hashMap.put("lblRounding", POSConstants.LABEL_ROUNDING);
        hashMap.put("lblOther", Messages.getString("SalesBalanceReportService.3"));
    }
}

