/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashInTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePayoutReason;
import com.floreantpos.model.base.BasePayoutRecepient;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PayoutReasonDAO;
import com.floreantpos.model.dao.PayoutRecepientDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DiscountData;
import com.floreantpos.report.DiscountReportDataModel;
import com.floreantpos.report.JournalReportModel;
import com.floreantpos.report.MenuUsageReport;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.report.ServerProductivityReport;
import com.floreantpos.report.TaxExemptReport;
import com.floreantpos.report.payout.PayoutReportData;
import com.floreantpos.report.payout.PayoutReportDataModel;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class ReportService {
    private static SimpleDateFormat a = new SimpleDateFormat("MMM dd yyyy, hh:mm a");
    private static SimpleDateFormat b = new SimpleDateFormat("MMM dd yyyy ");

    public static String formatFullDate(Date date) {
        return a.format(date);
    }

    public static String formatShortDate(Date date) {
        return b.format(date);
    }

    public static String storeFarmatDate(Date date) {
        return DateUtil.getSimpleDateFormat().format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public MenuUsageReport getMenuUsageReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        MenuUsageReport menuUsageReport = new MenuUsageReport();
        try (Session session = null;){
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(MenuCategory.class);
            List list = criteria.list();
            MenuCategory menuCategory = new MenuCategory();
            menuCategory.setName(POSConstants.MISC_BUTTON_TEXT);
            list.add(menuCategory);
            MenuCategory menuCategory2 = new MenuCategory();
            menuCategory2.setName(POSConstants.NONE);
            list.add(menuCategory2);
            for (MenuCategory menuCategory3 : list) {
                if (POSUtil.isBlankOrNull(menuCategory3.getName())) continue;
                SalesReportUtil salesReportUtil = new SalesReportUtil(date, date2);
                salesReportUtil.setCategoryName(menuCategory3.getName());
                MenuUsageReport.MenuUsageReportData menuUsageReportData = new MenuUsageReport.MenuUsageReportData();
                double d = salesReportUtil.calculateItemCount(session);
                double d2 = salesReportUtil.calculateGrossSalesWithOutIncludedTax(session);
                double d3 = salesReportUtil.calculateDiscountAmount(session);
                double d4 = salesReportUtil.calculateReturnAmountWithOutIncludedTax(session);
                double d5 = salesReportUtil.calculateTotalServiceChargeAmount(session);
                double d6 = salesReportUtil.calculateTotalCost(session);
                d3 = NumberUtil.isZero(d3) ? 0.0 : -1.0 * d3;
                d4 = NumberUtil.isZero(d4) ? 0.0 : -1.0 * d4;
                menuUsageReportData.setCategoryName(menuCategory3.getName());
                menuUsageReportData.setCount((int)d);
                menuUsageReportData.setGrossSales(d2);
                menuUsageReportData.setDiscount(d3);
                menuUsageReportData.setReturnAmount(d4);
                menuUsageReportData.setServiceCharge(d5);
                menuUsageReportData.setTotalCost(d6);
                menuUsageReportData.calculate();
                menuUsageReport.addReportData(menuUsageReportData);
            }
            MenuUsageReport menuUsageReport2 = menuUsageReport;
            return menuUsageReport2;
        }
    }

    public ServerProductivityReport getServerProductivityReport(Date date, Date date2, List<User> list) {
        ServerProductivityReport serverProductivityReport = new ServerProductivityReport();
        for (User user : list) {
            ServerProductivityReport.ServerProductivityReportData serverProductivityReportData;
            ServerProductivityReport.ServerProductivityReportData serverProductivityReportData2 = new ServerProductivityReport.ServerProductivityReportData();
            serverProductivityReportData2.setServerName(user.toString());
            HashSet<Ticket> hashSet = new HashSet<Ticket>();
            List<TicketItem> list2 = TicketItemDAO.getInstance().findTicketItems(date, date2, false, null, null, user);
            for (TicketItem ticketItem : list2) {
                hashSet.add(ticketItem.getTicket());
                if (ticketItem.isTaxIncluded().booleanValue()) {
                    serverProductivityReportData2.setTotalSales(serverProductivityReportData2.getTotalSales() + ticketItem.getSubtotalAmount() - ticketItem.getAdjustedTax());
                    continue;
                }
                serverProductivityReportData2.setTotalSales(serverProductivityReportData2.getTotalSales() + ticketItem.getSubtotalAmount());
            }
            for (Ticket ticket : hashSet) {
                serverProductivityReportData2.setTotalGuestCount(serverProductivityReportData2.getTotalGuestCount() + ticket.getNumberOfGuests());
            }
            serverProductivityReportData2.setTotalCheckCount(hashSet.size());
            serverProductivityReportData2.calculate();
            serverProductivityReport.addReportData(serverProductivityReportData2);
            HashMap hashMap = new HashMap();
            for (TicketItem ticketItem : list2) {
                String string = ticketItem.getCategoryName();
                if (StringUtils.isBlank((String)string)) {
                    string = POSConstants.OTHERS;
                }
                if ((serverProductivityReportData = (ServerProductivityReport.ServerProductivityReportData)hashMap.get(string)) == null) {
                    serverProductivityReportData = new ServerProductivityReport.ServerProductivityReportData();
                    serverProductivityReportData.setCategoryName(string);
                    serverProductivityReportData.setServerName(user.toString());
                    serverProductivityReportData.setTotalCheckCount(hashSet.size());
                    hashMap.put(string, serverProductivityReportData);
                }
                if (ticketItem.isReturned()) {
                    if (ticketItem.isTaxIncluded().booleanValue()) {
                        serverProductivityReportData.setReturnAmount(serverProductivityReportData.getReturnAmount() + Math.abs(ticketItem.getSubtotalAmount()) - Math.abs(ticketItem.getAdjustedTax()));
                    } else {
                        serverProductivityReportData.setReturnAmount(serverProductivityReportData.getReturnAmount() + Math.abs(ticketItem.getSubtotalAmount()));
                    }
                } else if (ticketItem.isTaxIncluded().booleanValue()) {
                    serverProductivityReportData.setGrossSales(serverProductivityReportData.getGrossSales() + ticketItem.getSubtotalAmount() - ticketItem.getAdjustedTax());
                } else {
                    serverProductivityReportData.setGrossSales(serverProductivityReportData.getGrossSales() + ticketItem.getSubtotalAmount());
                }
                serverProductivityReportData.setItemCount(serverProductivityReportData.getItemCount() + ticketItem.getQuantity());
                serverProductivityReportData.setSalesDiscount(serverProductivityReportData.getSalesDiscount() + ticketItem.getAdjustedDiscount());
            }
            ArrayList arrayList2 = new ArrayList(hashMap.keySet());
            Collections.sort(arrayList2);
            for (String string : arrayList2) {
                serverProductivityReportData = (ServerProductivityReport.ServerProductivityReportData)hashMap.get(string);
                serverProductivityReportData.calculate();
                serverProductivityReport.addReportData(serverProductivityReportData);
            }
        }
        serverProductivityReport.calculate();
        return serverProductivityReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalReportModel getJournalReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        JournalReportModel journalReportModel = new JournalReportModel();
        Session session = null;
        journalReportModel.setFromDate(date);
        journalReportModel.setToDate(date2);
        journalReportModel.setReportTime(new Date());
        try {
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(ActionHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)ActionHistory.PROP_ACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)ActionHistory.PROP_ACTION_TIME, (Object)date2));
            criteria.addOrder(Order.desc((String)ActionHistory.PROP_ACTION_TIME));
            List list = criteria.list();
            for (ActionHistory actionHistory : list) {
                User user = actionHistory.getPerformer();
                String string = "";
                if (user != null) {
                    string = user.getId() + "/" + user.getFullName();
                }
                JournalReportModel.JournalReportData journalReportData = new JournalReportModel.JournalReportData();
                journalReportData.setAction(actionHistory.getActionName());
                journalReportData.setUserInfo(string);
                journalReportData.setTerminalId(actionHistory.getTerminalId());
                journalReportData.setTime(actionHistory.getActionTime());
                journalReportData.setComments(actionHistory.getDescription());
                journalReportModel.addReportData(journalReportData);
            }
            JournalReportModel journalReportModel2 = journalReportModel;
            return journalReportModel2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesBalanceReport getSalesBalanceReport(Date date, Date date2, User user) {
        GenericDAO genericDAO = new GenericDAO();
        SalesBalanceReport salesBalanceReport = new SalesBalanceReport();
        Session session = null;
        salesBalanceReport.setFromDate(date);
        salesBalanceReport.setToDate(date2);
        salesBalanceReport.setReportTime(new Date());
        try {
            session = genericDAO.createNewSession();
            session.setDefaultReadOnly(true);
            SalesReportUtil salesReportUtil = new SalesReportUtil(date, date2, user);
            salesBalanceReport.setGrossSalesAmount(salesReportUtil.calculateGrossSalesWithOutIncludedTax(session));
            salesBalanceReport.setDiscountAmount(salesReportUtil.calculateDiscountAmount(session));
            salesBalanceReport.setSalesTaxAmount(salesReportUtil.calculateSalesTaxAmount(session));
            salesBalanceReport.setReturnAmount(salesReportUtil.calculateReturnAmountWithOutIncludedTax(session));
            salesBalanceReport.setGratuity(salesReportUtil.calculateGratuity(session));
            salesBalanceReport.setCashReceiptsAmount(salesReportUtil.calculateCashReceipt(session));
            salesBalanceReport.setCreditCardReceiptsAmount(salesReportUtil.calculateCreditReceipt(session));
            salesBalanceReport.setDebitCardReceiptsAmount(salesReportUtil.calculateDebitReceipt(session));
            salesBalanceReport.setMemberPaymentAmount(salesReportUtil.calculateMemberPayment(session));
            this.b(session, salesBalanceReport, CustomPaymentTransaction.class, date, date2, user);
            salesBalanceReport.setGiftCertReceipts(salesReportUtil.calculateGiftCertReceipts(session));
            salesBalanceReport.setRefundAmount(salesReportUtil.calculateRefundAmount(session));
            this.a(session, salesBalanceReport, RefundTransaction.class, date, date2, user);
            salesBalanceReport.setToleranceAmount(salesReportUtil.calculateToleranceAmount(session));
            salesBalanceReport.setServiceChargeAmnt(salesReportUtil.calculateTotalServiceChargeAmount(session));
            salesBalanceReport.setDeliveryChargeAmnt(salesReportUtil.calculateDeliveryCharge(session));
            salesBalanceReport.setFeeAmnt(salesReportUtil.calculateFeeAmount(session));
            salesBalanceReport.setRoundAmount(salesReportUtil.calculateRoundingAmount(session));
            if (user == null) {
                salesBalanceReport.setGrossTipsPaidAmount(this.b(session, date, date2, user));
                salesBalanceReport.setCashPayoutAmount(this.a(session, date, date2, user));
                this.a(session, salesBalanceReport, date, date2, user);
                this.b(session, salesBalanceReport, date, date2, user);
            }
            salesBalanceReport.setVisaCreditCardAmount(salesReportUtil.calculateVisaCreditCardSummery(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setMasterCardAmount(salesReportUtil.calculateMasterCardSummery(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setAmexAmount(salesReportUtil.calculateAmexSummery(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setDiscoveryAmount(salesReportUtil.calculateDiscoverySummery(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setOthersCardAmount(salesReportUtil.calculateOthersCardSummery(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setVisaDebitCardAmount(salesReportUtil.calculateVisaDebitCardSummery(session, DebitCardTransaction.class, date, date2, user));
            salesBalanceReport.setMasterDebitCardAmount(salesReportUtil.calculateMasterDebitCardSummery(session, DebitCardTransaction.class, date, date2, user));
            salesBalanceReport.calculate();
            SalesBalanceReport salesBalanceReport2 = salesBalanceReport;
            return salesBalanceReport2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void a(Session session, SalesBalanceReport salesBalanceReport, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(CashDropTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)CashDropTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)CashDropTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, CashDrawer.PROP_ASSIGNED_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashDropTransaction.PROP_AMOUNT));
        salesBalanceReport.setDrawerPullsAmount(this.a(criteria.uniqueResult()));
    }

    private void b(Session session, SalesBalanceReport salesBalanceReport, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(CashInTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)CashInTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)CashInTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, CashDrawer.PROP_ASSIGNED_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashInTransaction.PROP_AMOUNT));
        salesBalanceReport.setCashInAmount(this.a(criteria.uniqueResult()));
    }

    public static double calculateGrossSales(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.createAlias(TicketItem.PROP_TICKET, "t");
        criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ITEM_RETURNED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, "t." + Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    private double a(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PayOutTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double b(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(GratuityPaymentHistory.class);
        criteria.add((Criterion)Restrictions.ge((String)GratuityPaymentHistory.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)GratuityPaymentHistory.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private void a(Session session, SalesBalanceReport salesBalanceReport, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        salesBalanceReport.setCashRefundAmount(this.a(criteria.uniqueResult()));
    }

    private void b(Session session, SalesBalanceReport salesBalanceReport, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        salesBalanceReport.setCustomPaymentAmount(this.a(criteria.uniqueResult()));
    }

    public void calculateGiftCertReceipts(Session session, SalesBalanceReport salesBalanceReport, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(GiftCertificateTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, GiftCertificateTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)GiftCertificateTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        salesBalanceReport.setGiftCertReceipts(this.a(criteria.uniqueResult()));
    }

    private double a(Object object) {
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesExceptionReport getSalesExceptionReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesExceptionReport salesExceptionReport = new SalesExceptionReport();
        Session session = null;
        salesExceptionReport.setFromDate(date);
        salesExceptionReport.setToDate(date2);
        salesExceptionReport.setReportTime(new Date());
        try {
            Object object;
            Object object2;
            Object object32;
            Object object42;
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(RefundTransaction.class);
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            List list = criteria.list();
            for (Object object42 : list) {
                salesExceptionReport.addRefundToRefundData((RefundTransaction)object42);
            }
            Criteria criteria2 = session.createCriteria(Ticket.class);
            criteria2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria2.add((Criterion)Restrictions.lt((String)Ticket.PROP_CLOSING_DATE, (Object)date2));
            criteria2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            list = criteria2.list();
            for (Object object32 : list) {
                salesExceptionReport.addVoidToVoidData((Ticket)object32);
            }
            criteria2 = session.createCriteria(Ticket.class);
            criteria2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria2.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            list = criteria2.list();
            for (Object object32 : list) {
                salesExceptionReport.addDiscountOnTicket((Ticket)object32);
            }
            object42 = new SalesReportUtil(date, date2);
            criteria2 = ((SalesReportUtil)object42).buildCriteriaForTicketItem(session);
            object32 = criteria2.list();
            Object object5 = object32.iterator();
            while (object5.hasNext()) {
                object2 = (TicketItem)object5.next();
                salesExceptionReport.addDiscountOnTicketItem((TicketItem)object2);
                if (!((TicketItem)object2).isHasModifiers().booleanValue()) continue;
                object = ((TicketItem)object2).getTicketItemModifiers();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    TicketItemModifier ticketItemModifier = (TicketItemModifier)iterator.next();
                    salesExceptionReport.addDiscountOnTicketItemModifier(ticketItemModifier);
                }
            }
            object5 = new DiscountDAO();
            object2 = ((DiscountDAO)object5).getValidCoupons();
            salesExceptionReport.addEmptyDiscounts((List<Discount>)object2);
            object = salesExceptionReport;
            return object;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public SalesDetailedReport getSalesDetailedReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesDetailedReport salesDetailedReport = new SalesDetailedReport();
        salesDetailedReport.setFromDate(date);
        salesDetailedReport.setToDate(date2);
        salesDetailedReport.setReportTime(new Date());
        try (Session session = genericDAO.createNewSession();){
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CustomPaymentTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)CustomPaymentTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            List list = criteria.list();
            for (PosTransaction posTransaction : list) {
                salesDetailedReport.addPaymentData(posTransaction);
            }
            SalesDetailedReport salesDetailedReport2 = salesDetailedReport;
            return salesDetailedReport2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesDetailedReport getCloudSalesDetailedReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesDetailedReport salesDetailedReport = new SalesDetailedReport();
        Session session = null;
        salesDetailedReport.setFromDate(date);
        salesDetailedReport.setToDate(date2);
        salesDetailedReport.setReportTime(new Date());
        try {
            Object[] objectArray2;
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            List list = criteria.list();
            for (Object[] objectArray2 : list) {
                salesDetailedReport.addCreditCardData((CreditCardTransaction)objectArray2);
            }
            criteria = session.createCriteria(DebitCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Object[] objectArray2 : list) {
                salesDetailedReport.addCreditCardData((DebitCardTransaction)objectArray2);
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            objectArray2 = (Object[])criteria.uniqueResult();
            if (objectArray2 != null && objectArray2.length > 0 && objectArray2[0] instanceof Number) {
                salesDetailedReport.setGiftCertReturnCount(((Number)objectArray2[0]).intValue());
            }
            if (objectArray2 != null && objectArray2.length > 1 && objectArray2[1] instanceof Number) {
                salesDetailedReport.setGiftCertReturnAmount(((Number)objectArray2[1]).doubleValue());
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            criteria.add((Criterion)Restrictions.gt((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT, (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            objectArray2 = (Object[])criteria.uniqueResult();
            if (objectArray2 != null && objectArray2.length > 0 && objectArray2[0] instanceof Number) {
                salesDetailedReport.setGiftCertChangeCount(((Number)objectArray2[0]).intValue());
            }
            if (objectArray2 != null && objectArray2.length > 1 && objectArray2[1] instanceof Number) {
                salesDetailedReport.setGiftCertChangeAmount(((Number)objectArray2[1]).doubleValue());
            }
            SalesDetailedReport salesDetailedReport2 = salesDetailedReport;
            return salesDetailedReport2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void addMultiUserFilter(User user, Criteria criteria, String string) {
        if (user != null) {
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)string, (Object)user.getId()));
            List<User> list = user.getLinkedUser();
            if (list != null) {
                for (User user2 : list) {
                    if (user2.getId().equals(user.getId())) continue;
                    disjunction.add((Criterion)Restrictions.eq((String)string, (Object)user2.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    public static SalesReportModel prepareItemSalesReportModel(List<TicketItem> list) {
        SalesReportModel salesReportModel = new SalesReportModel();
        if (list != null && list.size() > 0) {
            LinkedHashMap<String, ReportItem> linkedHashMap = new LinkedHashMap<String, ReportItem>();
            String string = null;
            for (TicketItem ticketItem : list) {
                String string2 = ticketItem.getMenuItemId();
                string = (string2 == null ? ticketItem.getName() : string2) + "-" + ticketItem.getUnitPrice() + "-" + ticketItem.getUnitName();
                ReportItem reportItem = (ReportItem)((HashMap)linkedHashMap).get(string);
                if (reportItem == null) {
                    reportItem = new ReportItem();
                    reportItem.setId(string);
                    reportItem.setPrice(ticketItem.getUnitPrice());
                    reportItem.setUnit(ticketItem.getUnitName());
                    reportItem.setCost(ticketItem.getUnitCost());
                    reportItem.setName(ticketItem.getName());
                    reportItem.setTaxRate(ticketItem.getTotalTaxRate());
                    reportItem.setGroupName(ticketItem.getGroupName());
                    reportItem.setBarcode(string2);
                    reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
                    reportItem.calculate();
                    linkedHashMap.put(string, reportItem);
                }
                reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
                reportItem.setTotal(reportItem.getTotal() + ticketItem.getAdjustedTotalWithoutModifiers());
                reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscountWithoutModifiers());
                reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTaxWithoutModifiers());
                reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
                double d = ticketItem.isTaxIncluded() != false ? ticketItem.getAdjustedTotalWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers() : ticketItem.getAdjustedSubtotalWithoutModifiers();
                reportItem.setNetTotal(reportItem.getNetTotal() + d);
                reportItem.calculate();
            }
            salesReportModel.setItems(new ArrayList<ReportItem>(((HashMap)linkedHashMap).values()));
        }
        return salesReportModel;
    }

    public static Map<String, Integer> prepareTicketForDashBoard(List<Date> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (list != null && list.size() > 0) {
            int n = 0;
            for (Date date : list) {
                String string = DateUtil.formatAsDefaultMonthDate(date);
                if (hashMap.get(string) == null) {
                    n = 1;
                }
                if (hashMap.containsKey(string)) {
                    ++n;
                }
                hashMap.put(string, n);
            }
        }
        return hashMap;
    }

    public TaxExemptReport getTaxExemptReport(Date date, Date date2) throws Exception {
        TaxExemptReport taxExemptReport = new TaxExemptReport();
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CLOSING_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TAX_EXEMPT, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_ID), Ticket.PROP_ID);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE), Ticket.PROP_CREATE_DATE);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_TOTAL_AMOUNT), Ticket.PROP_TOTAL_AMOUNT);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_EXTRA_PROPERTIES), Ticket.PROP_EXTRA_PROPERTIES);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List list = criteria.list();
            for (Ticket ticket : list) {
                taxExemptReport.addTaxExemptTicket(ticket);
            }
            TaxExemptReport taxExemptReport2 = taxExemptReport;
            return taxExemptReport2;
        }
    }

    public DiscountReportDataModel createTicketDiscountDataList(Date date, Date date2) {
        DiscountReportDataModel discountReportDataModel = new DiscountReportDataModel();
        try (Session session = TicketItemDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.gt((String)Ticket.PROP_DISCOUNT_AMOUNT, (Object)0.0));
            criteria.addOrder(Order.asc((String)Ticket.PROP_CREATE_DATE));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_ID), "ticketId");
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE), "date");
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_TOTAL_AMOUNT), "totalWithDiscount");
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_DISCOUNTS_PROPERTY), "properties");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(DiscountData.class));
            List list = criteria.list();
            Object object = list.iterator();
            while (object.hasNext()) {
                DiscountData discountData = (DiscountData)object.next();
                String string = discountData.getProperties();
                if (string.equals("[]")) {
                    object.remove();
                }
                discountData.setTicketDiscount(Boolean.TRUE);
            }
            discountReportDataModel.addDiscountDataList(list);
            object = discountReportDataModel;
            return object;
        }
    }

    public DiscountReportDataModel createItemDiscountDataList(Date date, Date date2) {
        DiscountReportDataModel discountReportDataModel = new DiscountReportDataModel();
        try (Session session = TicketItemDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.createAlias("ticket", "t");
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ne((String)TicketItem.PROP_DISCOUNT_AMOUNT, (Object)0.0));
            criteria.addOrder(Order.asc((String)TicketItem.PROP_CREATE_DATE));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_NAME), "itemName");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_ID)), "ticketId");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_CREATE_DATE), "date");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_DISCOUNT_AMOUNT), "totalItemDiscount");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_TOTAL_AMOUNT), "totalWithDiscount");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_DISCOUNTS_PROPERTY), "properties");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(DiscountData.class));
            List list = criteria.list();
            discountReportDataModel.addDiscountDataList(list);
            DiscountReportDataModel discountReportDataModel2 = discountReportDataModel;
            return discountReportDataModel2;
        }
    }

    public PayoutReportDataModel findPayoutTransactions(String string, Date date, Date date2) {
        PayoutReportDataModel payoutReportDataModel = new PayoutReportDataModel();
        try (Session session = PosTransactionDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(PayOutTransaction.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            }
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), "date");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_RECEPIENT_ID), "recipientId");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_REASON_ID), PosTransaction.PROP_REASON_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_NOTE), PosTransaction.PROP_NOTE);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_CASH_DRAWER_ID), PosTransaction.PROP_CASH_DRAWER_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(PayoutReportData.class));
            List list = criteria.list();
            HashMap<String, Comparable> hashMap = new HashMap<String, Comparable>();
            HashMap<String, Comparable> hashMap2 = new HashMap<String, Comparable>();
            HashMap<String, Comparable> hashMap3 = new HashMap<String, Comparable>();
            HashMap<Integer, Comparable> hashMap4 = new HashMap<Integer, Comparable>();
            if (list.size() > 0) {
                for (PayoutReportData payoutReportData : list) {
                    Comparable comparable;
                    if (payoutReportData.getReasonId() != null) {
                        comparable = (PayoutReason)hashMap.get(payoutReportData.getReasonId());
                        if (comparable == null) {
                            comparable = PayoutReasonDAO.getInstance().get(payoutReportData.getReasonId());
                            hashMap.put(((BasePayoutReason)comparable).getId(), comparable);
                        }
                        payoutReportData.setReason(((BasePayoutReason)comparable).getReason());
                    }
                    if (payoutReportData.getUserId() != null) {
                        comparable = (User)hashMap2.get(payoutReportData.getUserId());
                        if (comparable == null) {
                            comparable = UserDAO.getInstance().get(payoutReportData.getUserId());
                            hashMap2.put(((BaseUser)comparable).getId(), comparable);
                        }
                        payoutReportData.setUserName(((User)comparable).getFullName());
                    }
                    if (payoutReportData.getRecipientId() != null) {
                        comparable = (PayoutRecepient)hashMap3.get(payoutReportData.getRecipientId());
                        if (comparable == null) {
                            comparable = PayoutRecepientDAO.getInstance().get(payoutReportData.getRecipientId());
                            hashMap3.put(((BasePayoutRecepient)comparable).getId(), comparable);
                        }
                        payoutReportData.setRecipientName(((BasePayoutRecepient)comparable).getName());
                    }
                    if (payoutReportData.getTerminalId() == null) continue;
                    comparable = (Terminal)hashMap4.get(payoutReportData.getTerminalId());
                    if (comparable == null) {
                        comparable = TerminalDAO.getInstance().get(payoutReportData.getTerminalId());
                        hashMap4.put(((BaseTerminal)comparable).getId(), comparable);
                    }
                    payoutReportData.setTerminalName(((BaseTerminal)comparable).getName());
                }
            }
            payoutReportDataModel.addPayoutDataList(list);
            PayoutReportDataModel payoutReportDataModel2 = payoutReportDataModel;
            return payoutReportDataModel2;
        }
    }
}

