/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class ListTableModel<E>
extends AbstractTableModel {
    protected String[] columnNames;
    protected List<E> rows;

    public ListTableModel() {
    }

    public ListTableModel(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public ListTableModel(String[] stringArray, List<E> list) {
        this.columnNames = stringArray;
        this.rows = list;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public List<E> getRows() {
        return this.rows;
    }

    public void setRows(List<E> list) {
        this.rows = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public E getRowData(int n) {
        return this.rows.get(n);
    }

    public void setRowData(int n, E e) {
        if (this.rows != null) {
            this.rows.set(n, e);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void addItem(E e) {
        if (this.rows == null) {
            this.rows = new ArrayList();
        }
        int n = this.rows.size();
        this.rows.add(e);
        this.fireTableRowsInserted(n, n);
    }

    public void deleteItem(int n) {
        this.rows.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public boolean deleteItem(Object object) {
        return this.rows.remove(object);
    }

    public void updateItem(int n) {
        this.fireTableRowsUpdated(n, n);
    }
}

