/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.User;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.licensemanager.OroLicense;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;

public class FooterPanel
extends JPanel {
    private static final SimpleDateFormat a = new SimpleDateFormat("hh:mm:ss aaa");
    private JPanel b;
    private JPanel c;
    private JPanel d = new JPanel(new FlowLayout(3));
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JPanel i;
    private PosBlinkButton j;
    private JLabel k;
    private Timer l;
    private JLabel m;

    public FooterPanel() {
        super(new BorderLayout());
        this.d.setOpaque(true);
        this.e = new JLabel();
        this.g = new JLabel(this.getPoweredbyText() + Messages.getString("PosWindow.3") + TerminalConfig.getTerminalId());
        this.f = new JLabel();
        this.h = new JLabel();
        Font font = this.e.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.e.setFont(font);
        this.f.setFont(font);
        this.g.setFont(font);
        this.h.setFont(font);
        this.d.add(this.e);
        this.d.add(this.g);
        this.d.add(this.f);
        this.d.add((Component)this.h, "");
        this.b = new JPanel();
        this.c = new JPanel((LayoutManager)new MigLayout("right, filly,hidemode 3, ins 0 0 0 0"));
        this.k = new JLabel("");
        this.k.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.k.setFont(font);
        this.m = new JLabel();
        this.b.add(this.c);
        this.b.add(this.k);
        this.b.add(this.m);
        this.add((Component)new JSeparator(0), "North");
        this.add(this.d);
        this.add((Component)this.b, "East");
    }

    private void a() {
        this.j.setBlinking(false);
        this.j.setVisible(false);
        Main.restart();
    }

    public void setVisibleRestartButton(boolean bl) {
        if (this.j == null) {
            this.j = new PosBlinkButton();
            this.j.setText("Restart required. Click to restart");
            this.j.addActionListener(actionEvent -> this.a());
            this.c.add((Component)this.j, "h 18!");
        }
        this.j.setVisible(bl);
        this.j.setBlinking(true);
        this.revalidate();
        this.repaint();
    }

    public JPanel getMessagePanel() {
        return this.c;
    }

    public JPanel getRightPanel() {
        return this.b;
    }

    public void updateUserInfo() {
        User user = Application.getCurrentUser();
        this.updateUserInfo(user);
    }

    public void updateUserInfo(User user) {
        if (user != null) {
            this.f.setText(Messages.getString("PosWindow.6") + user.getFullName() + " (" + user.getType().getName() + ")");
        } else {
            this.f.setText("");
        }
    }

    public void updateStoreName(String string) {
        this.e.setText(string);
    }

    public void updateTerminalId() {
        this.g.setText(this.getPoweredbyText() + Messages.getString("PosWindow.10") + TerminalConfig.getTerminalId());
    }

    public String getPoweredbyText() {
        if (VersionInfo.isBranded()) {
            return "Powered by OROPOS | ";
        }
        if (TerminalConfig.isKioskMode()) {
            return "OROPOS v" + VersionInfo.getVersion() + " | ";
        }
        return "";
    }

    public void updateLicenseStatus() {
        OroLicense oroLicense = Application.getInstance().getLicense();
        if (oroLicense != null && oroLicense.isDemoLicense() && this.i == null) {
            this.i = POSUtil.doCreateDemoMessagePanel("Using demo license. Please visit ");
            this.d.add((Component)this.i, "grow");
        }
    }

    private void b() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(a.format(Calendar.getInstance().getTime()));
        this.k.setText(stringBuilder.toString());
    }

    public void updateView(User user) {
        this.updateTerminalId();
        this.updateLicenseStatus();
        this.updateUserInfo(user);
    }

    public void initTimers() {
        this.l = new Timer(1000, new ClockTimerHandler());
        this.l.start();
    }

    private void c() {
        if (this.l != null) {
            this.l.start();
        }
    }

    private void d() {
        if (this.l != null) {
            this.l.stop();
        }
    }

    public void startOrStopTimer(boolean bl) {
        if (bl) {
            this.c();
        } else {
            this.d();
        }
    }

    public void mqttConnectionLost() {
        this.m.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NOTIFICATIONS_OFF, (float)PosUIManager.getSize(16), (Color)Color.black));
        this.m.setToolTipText("Notification service off.");
    }

    public void mqttConnected() {
        this.m.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NOTIFICATIONS_ACTIVE, (float)PosUIManager.getSize(16), (Color)Color.black));
        this.m.setToolTipText("Notification service on.");
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!FooterPanel.this.isShowing()) {
                FooterPanel.this.l.stop();
                return;
            }
            FooterPanel.this.b();
        }
    }
}

