/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ItemDetailDialog
extends OkCancelOptionDialog {
    private Ticket b;
    private MenuItem c;
    private List<IUnit> d;
    private JLabel e;
    private JLabel f = new JLabel();
    private JLabel g = new JLabel();
    private JLabel h;
    private POSToggleButton i;
    private POSToggleButton j;
    private IUnit k;
    private IUnit l;
    InputPanel a;
    private Double m;
    private double n;
    private JTabbedPane o = new JTabbedPane();
    private boolean p;

    public ItemDetailDialog() {
        super(POSUtil.getFocusedWindow());
        this.a();
    }

    public ItemDetailDialog(Ticket ticket, MenuItem menuItem, IUnit iUnit) {
        super(POSUtil.getFocusedWindow());
        this.b = ticket;
        this.c = menuItem;
        this.d = this.c.getUnits();
        this.k = iUnit;
        if (iUnit != null && iUnit.hideFromSalesScreen()) {
            for (IUnit iUnit2 : this.d) {
                if (iUnit2.hideFromSalesScreen()) continue;
                this.k = iUnit2;
                break;
            }
        }
        this.a();
    }

    private void a() {
        this.setResizable(false);
        this.setTitle(Messages.getString("ItemDetailDialog.2"));
        this.setCaption(this.c.getDisplayName());
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
        Dimension dimension = PosUIManager.getSize(300, 200);
        this.e = new JLabel("");
        this.e.setVerticalAlignment(0);
        this.e.setHorizontalAlignment(0);
        this.e.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.e.setPreferredSize(dimension);
        jPanel2.add((Component)this.e, "North");
        this.g.setVerticalAlignment(1);
        this.g.setPreferredSize(PosUIManager.getSize(342, 200));
        String string = this.c.getDescription();
        if (StringUtils.isNotBlank((String)string)) {
            string = string.replaceAll("\n", "<br/>");
            this.g.setText("<html><p style='text-align: justify;'>" + string + "</p></html>");
        } else {
            this.g.setText(Messages.getString("ItemDetailDialog.4"));
        }
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("hidemode 3,inset 0"));
        jPanel3.add(this.g);
        this.h = new JLabel();
        this.h.setVerticalAlignment(1);
        this.h.setPreferredSize(PosUIManager.getSize(300, 200));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("hidemode 3,inset 0"));
        jPanel4.add(this.h);
        this.o.addTab(POSConstants.DESCRIPTION, jPanel3);
        this.o.addTab(Messages.getString("ItemDetailDialog.3"), jPanel4);
        this.o.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n == 1) {
                    ItemDetailDialog.this.c();
                }
            }
        });
        jPanel2.add((Component)this.o, "Center");
        this.f.setVerticalAlignment(1);
        this.f.setHorizontalAlignment(0);
        jPanel2.add((Component)this.f, "South");
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout("hidemode 3,inset 0"));
        jPanel.add((Component)jPanel2, "West");
        this.a = new InputPanel(Messages.getString("ItemDetailDialog.1"), this.c.isFractionalUnit());
        this.a.setQty(1.0);
        jPanel5.add((Component)this.a, "gapleft 30, span 2");
        this.a.a(this.c.isEditablePrice());
        jPanel.add((Component)jPanel5, "East");
        this.a(this.k);
        if (this.c.isEditablePrice().booleanValue()) {
            this.f.setVisible(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageResource imageResource = DataProvider.get().getImageResource(ItemDetailDialog.this.c.getImageId());
                if (imageResource != null) {
                    ItemDetailDialog.this.e.setIcon(imageResource.getImageOfHeight(PosUIManager.getSize(200)));
                } else {
                    ImageIcon imageIcon = IconFactory.getIcon("image-placeholder.jpg");
                    ItemDetailDialog.this.e.setIcon(imageIcon);
                }
                ItemDetailDialog.this.a.h.requestFocus();
            }
        });
    }

    private void a(JPanel jPanel) {
        if (this.d == null) {
            return;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (IUnit iUnit : this.d) {
            if (iUnit.hideFromSalesScreen()) {
                if (!this.k.equals(iUnit)) continue;
                this.k = null;
                continue;
            }
            UnitButton unitButton = new UnitButton(iUnit);
            buttonGroup.add(unitButton);
            jPanel.add(unitButton);
        }
    }

    public IUnit getSelectedUnit() {
        return this.l;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    public void setDialogTitle(String string) {
        super.setTitle(string);
    }

    public double getWeightOrQuantity() {
        String string = this.a.h.getText();
        if (StringUtils.isEmpty((String)string) || !NumberUtil.isValidDouble(string)) {
            return 0.0;
        }
        return NumberUtil.parseDouble(string);
    }

    public double getPrice() {
        String string = this.a.d.getText();
        if (StringUtils.isEmpty((String)string) || !NumberUtil.isValidDouble(string)) {
            return 0.0;
        }
        double d = NumberUtil.parseDouble(string);
        if (this.i.isSelected()) {
            return d * this.getWeightOrQuantity();
        }
        return d;
    }

    private Boolean b() {
        if (this.c == null) {
            return Boolean.FALSE;
        }
        Double d = this.c.getUnitQuantity(this.l == null ? this.k : this.l, this.c.getUnit());
        d = Double.parseDouble(this.a.h.getText()) * d;
        double d2 = d;
        int n = (int)d2;
        d = new Double(n);
        return d2 > d;
    }

    @Override
    public void doOk() {
        if (!NumberUtil.isValidDouble(this.a.h.getText()) || this.getWeightOrQuantity() <= 0.0) {
            POSMessageDialog.showError(this, Messages.getString("PosMessage.312"));
            return;
        }
        if (this.c.isEditablePrice().booleanValue()) {
            if (!NumberUtil.isValidDouble(this.a.d.getText())) {
                POSMessageDialog.showError(this, Messages.getString("PosMessage.280"));
                return;
            }
            if (this.getPrice() < 0.0) {
                POSMessageDialog.showError(this, POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void c() {
        Recepie recepie;
        if (this.p) {
            return;
        }
        this.h.setText(Messages.getString("ItemDetailDialog.5"));
        String string = this.c.getDefaultRecipeId();
        if (StringUtils.isNotEmpty((String)string) && (recepie = RecepieDAO.getInstance().get(string)) != null) {
            this.h.setText("<html><p style='text-align: justify;'>" + recepie.getDescription() + "</p></html>");
        }
        this.p = true;
    }

    private StringBuilder d() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><p style='font-size: 26pt;'><b>");
        stringBuilder.append(POSConstants.PRICE);
        stringBuilder.append(": ");
        stringBuilder.append(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(this.n));
        stringBuilder.append("</b></p></html>");
        return stringBuilder;
    }

    private void a(IUnit iUnit) {
        this.l = iUnit;
        double d = this.c.getUnitQuantity(this.c.getUnit(), this.l);
        this.m = this.l != null ? Double.valueOf(this.c.getDestinationUnitPrice(this.b, this.c, this.l, d)) : Double.valueOf(this.c.getPriceFromPriceRule(this.b));
        this.n = this.m;
        StringBuilder stringBuilder = this.d();
        this.f.setText(stringBuilder.toString());
        if (this.c.isEditablePrice().booleanValue()) {
            this.a.setPrice(this.n * this.getWeightOrQuantity());
        }
    }

    class UnitButton
    extends POSToggleButton
    implements ActionListener {
        private IUnit b;

        public UnitButton(IUnit iUnit) {
            this.b = iUnit;
            this.setText(iUnit.getName());
            this.addActionListener(this);
            if (iUnit.equals(ItemDetailDialog.this.k)) {
                this.setSelected(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (jToggleButton.isSelected()) {
                ItemDetailDialog.this.a(this.b);
            }
        }
    }

    class InputPanel
    extends JPanel {
        JLabel a = new JLabel();
        PosButton b = new PosButton("-");
        PosButton c = new PosButton("+");
        JTextField d;
        JLabel e = new JLabel();
        PosButton f = new PosButton("-");
        PosButton g = new PosButton("+");
        JTextField h;
        boolean i;

        public InputPanel(String string, boolean bl) {
            Serializable serializable;
            JComponent jComponent;
            this.i = bl;
            this.setLayout((LayoutManager)new MigLayout("fill, ins 0, hidemode 3"));
            ItemDetailDialog.this.i = new POSToggleButton(Messages.getString("POSConstants.17"));
            ItemDetailDialog.this.j = new POSToggleButton(Messages.getString("ItemDetailDialog.8"));
            ItemDetailDialog.this.i.addActionListener(actionEvent -> this.a());
            ItemDetailDialog.this.j.addActionListener(actionEvent -> this.a());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(ItemDetailDialog.this.i);
            buttonGroup.add(ItemDetailDialog.this.j);
            ItemDetailDialog.this.i.setSelected(true);
            this.a.setHorizontalAlignment(4);
            this.b = new PosButton("-");
            this.b.setFont(new Font("Arial", 0, 30));
            this.b.setFocusable(false);
            this.b.setPreferredSize(PosUIManager.getSize(60, 60));
            this.c = new PosButton("+");
            this.c.setPreferredSize(PosUIManager.getSize(60, 60));
            this.c.setFont(new Font("Arial", 1, 30));
            this.c.setFocusable(false);
            this.d = new DoubleTextField(10, 16, 6);
            this.d.setHorizontalAlignment(11);
            this.d.setFont(this.d.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
            this.d.setFocusable(true);
            this.d.requestFocus();
            this.d.setBackground(Color.WHITE);
            if (ItemDetailDialog.this.c.isEditablePrice().booleanValue()) {
                jComponent = new JPanel(new GridLayout(1, 2, 5, 5));
                serializable = BorderFactory.createTitledBorder(Messages.getString("ItemDetailDialog.9"));
                ((TitledBorder)serializable).setTitleJustification(2);
                ((TitledBorder)serializable).setBorder(new EmptyBorder(0, 0, 0, 0));
                jComponent.setBorder((Border)((Object)serializable));
                jComponent.add(ItemDetailDialog.this.i);
                jComponent.add(ItemDetailDialog.this.j);
                this.add((Component)jComponent, "skip 2, grow, wrap");
            }
            this.add((Component)this.a, "grow");
            this.add((Component)this.b, "grow");
            this.add((Component)this.d, "grow");
            this.add((Component)this.c, "wrap");
            this.e.setText("<html><p style='font-size: 20pt; font-weight: bold; text-align: right;'>" + Messages.getString("ItemDetailDialog.1") + "</p></html>");
            this.e.setHorizontalAlignment(4);
            this.f = new PosButton("-");
            this.f.setFont(new Font("Arial", 0, 30));
            this.f.setFocusable(false);
            this.f.setPreferredSize(PosUIManager.getSize(60, 60));
            this.g = new PosButton("+");
            this.g.setPreferredSize(PosUIManager.getSize(60, 60));
            this.g.setFont(new Font("Arial", 1, 30));
            this.g.setFocusable(false);
            this.h = bl ? new DoubleTextField(10, 16, 6) : new IntegerTextField(10);
            this.h.setHorizontalAlignment(11);
            this.h.setFont(this.d.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
            this.h.setFocusable(true);
            this.h.requestFocus();
            this.h.setBackground(Color.WHITE);
            this.add((Component)this.e, "grow");
            this.add((Component)this.f, "grow");
            this.add((Component)this.h, "grow");
            this.add((Component)this.g, "");
            jComponent = new NumericKeypad();
            jComponent.setPreferredSize(PosUIManager.getSize(200, 300));
            this.add((Component)jComponent, "newline, skip 1, span 2, grow");
            if (ItemDetailDialog.this.c.isAllowUnitSelection()) {
                serializable = new JPanel(new WrapLayout(3));
                ((JComponent)serializable).setPreferredSize(PosUIManager.getSize(200, 100));
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, Messages.getString("SelectUnit"), 2, 0), new EmptyBorder(0, 0, 0, 0));
                ((JComponent)serializable).setBorder(compoundBorder);
                ItemDetailDialog.this.a((JPanel)serializable);
                this.add((Component)serializable, "grow, span 2");
            }
            this.addButtonListeners();
            this.a();
        }

        private void a() {
            if (ItemDetailDialog.this.j.isSelected()) {
                this.a.setText("<html><p style='font-size: 20pt; font-weight: bold; text-align: right;'>" + Messages.getString("ItemDetailDialog.8") + "</p></html>");
            } else {
                this.a.setText("<html><p style='font-size: 20pt; font-weight: bold; text-align: right;'>" + Messages.getString("POSConstants.17") + "</p></html>");
            }
        }

        public void addButtonListeners() {
            this.c.addActionListener(actionEvent -> this.b());
            this.b.addActionListener(actionEvent -> this.c());
            this.g.addActionListener(actionEvent -> this.d());
            this.f.addActionListener(actionEvent -> this.e());
        }

        public void setPrice(double d) {
            if (d == 0.0) {
                this.d.setText("0");
                this.d.selectAll();
            } else {
                this.d.setText(NumberUtil.formatNumber(d));
            }
            this.d.selectAll();
        }

        public void setQty(double d) {
            if (d == 0.0) {
                if (this.i) {
                    this.h.setText("0");
                    this.h.selectAll();
                } else {
                    this.h.setText("");
                }
            } else if (this.i) {
                this.h.setText(NumberUtil.formatNumber(d));
            } else {
                this.h.setText(String.valueOf((int)d));
            }
            this.h.selectAll();
        }

        void a(boolean bl) {
            this.a.setVisible(bl);
            this.d.setVisible(bl);
            this.b.setVisible(bl);
            this.c.setVisible(bl);
        }

        private void b() {
            this.d.requestFocus();
            String string = this.d.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtil.isValidDouble(string)) {
                double d = NumberUtil.parseDouble(string);
                if (d == Math.floor(d) || !Double.isInfinite(d)) {
                    this.d.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void c() {
            this.d.requestFocus();
            String string = this.d.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtil.isValidDouble(string)) {
                double d = NumberUtil.parseDouble(string);
                if ((d == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) >= 0.0) {
                    this.d.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void d() {
            this.h.requestFocus();
            String string = this.h.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtil.isValidDouble(string)) {
                double d = NumberUtil.parseDouble(string);
                if (d == Math.floor(d) || !Double.isInfinite(d)) {
                    this.h.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void e() {
            this.h.requestFocus();
            String string = this.h.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtil.isValidDouble(string)) {
                double d = NumberUtil.parseDouble(string);
                if ((d == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) >= 0.0) {
                    this.h.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void f() {
            if (ItemDetailDialog.this.c.isEditablePrice().booleanValue() && this.d.isVisible()) {
                double d = ItemDetailDialog.this.getWeightOrQuantity();
                this.setPrice(ItemDetailDialog.this.n * d);
            }
        }
    }
}

