/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosComboRenderer;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class MiscTicketItemDialog
extends OkCancelOptionDialog {
    private TicketItem a;
    private JComboBox b;
    private FixedLengthTextField c;
    private DoubleTextField d;
    private JComboBox e;
    private JLabel f;
    private OrderType g;

    public MiscTicketItemDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(Messages.getString("MiscTicketItemDialog.0"));
        this.a();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 0, fillx", "", ""));
        this.setTitle(Messages.getString("MiscTicketItemDialog.4"));
        this.setCaption(Messages.getString("MiscTicketItemDialog.4"));
        JLabel jLabel = new JLabel(Messages.getString("MiscTicketItemDialog.6"));
        jPanel.add((Component)jLabel, "newline,alignx trailing");
        this.c = new FixedLengthTextField();
        this.c.setLength(120);
        jPanel.add((Component)this.c, "grow, span, h 40");
        JLabel jLabel2 = new JLabel(Messages.getString("MiscTicketItemDialog.9"));
        jPanel.add((Component)jLabel2, "newline,alignx trailing");
        this.d = new DoubleTextField();
        jPanel.add((Component)this.d, "grow, w 120, h 40");
        this.f = new JLabel(Messages.getString("MiscTicketItemDialog.2"));
        jPanel.add((Component)this.f, "alignx trailing");
        PosComboRenderer posComboRenderer = new PosComboRenderer();
        posComboRenderer.setEnableDefaultValueShowing(false);
        this.b = new JComboBox();
        this.b.setRenderer(posComboRenderer);
        jPanel.add((Component)this.b, "w 200!, h 40");
        jPanel.add((Component)new JLabel(Messages.getString("MiscTicketItemDialog.15")), "alignx trailing");
        this.e = new JComboBox();
        this.e.setRenderer(posComboRenderer);
        jPanel.add((Component)this.e, "w 200!, h 40");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        jPanel.add((Component)((Object)qwertyKeyPad), "newline, grow, span, gaptop 10");
        this.getContentPanel().add(jPanel);
        this.b();
    }

    private void b() {
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        this.b.addItem(null);
        for (TaxGroup taxGroup : list) {
            this.b.addItem(taxGroup);
        }
        String string = TerminalConfig.getMiscItemDefaultTaxId();
        if (!string.equals("-1")) {
            for (int i = 0; i < list.size(); ++i) {
                TaxGroup taxGroup = list.get(i);
                if (!taxGroup.getId().equals(string)) continue;
                this.b.setSelectedIndex(i);
                break;
            }
        }
        List<PrinterGroup> list2 = PrinterGroupDAO.getInstance().findAll();
        this.e.addItem(null);
        for (PrinterGroup printerGroup : list2) {
            this.e.addItem(printerGroup);
            if (!printerGroup.isIsDefault()) continue;
            this.e.setSelectedItem(printerGroup);
        }
    }

    @Override
    public void doCancel() {
        this.setCanceled(true);
        this.a = null;
        this.dispose();
    }

    @Override
    public void doOk() {
        Comparable comparable;
        String string = this.c.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MiscTicketItemDialog.1"));
            return;
        }
        if (StringUtils.isEmpty((String)this.d.getText())) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MiscTicketItemDialog.3"));
            return;
        }
        double d = this.d.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("NegativePriceNotAllowed"));
            return;
        }
        this.setCanceled(false);
        this.a = new TicketItem();
        this.a.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        this.a.setQuantity(1.0);
        this.a.setUnitPrice(d);
        this.a.setName(string.trim());
        this.a.setMenuItemId("0");
        this.a.setCategoryName(POSConstants.MISC_BUTTON_TEXT);
        this.a.setGroupName(POSConstants.MISC_BUTTON_TEXT);
        this.a.setShouldPrintToKitchen(false);
        OrderView orderView = OrderView.getInstance();
        Object object = orderView.getSelectedSeatNumber();
        if (object instanceof Integer) {
            this.a.setSeatNumber((Integer)object);
        } else if (object instanceof TicketItemSeat) {
            comparable = (TicketItemSeat)orderView.getSelectedSeatNumber();
            this.a.setSeat((TicketItemSeat)comparable);
            this.a.setSeatNumber(((BaseTicketItemSeat)comparable).getSeatNumber());
        }
        comparable = (TaxGroup)this.b.getSelectedItem();
        MenuItem.setItemTaxes(this.a, (TaxGroup)comparable, this.getOrderType());
        PrinterGroup printerGroup = (PrinterGroup)this.e.getSelectedItem();
        if (printerGroup != null) {
            this.a.setPrinterGroup(printerGroup);
            this.a.setShouldPrintToKitchen(true);
        }
        this.dispose();
    }

    public TicketItem getTicketItem() {
        return this.a;
    }

    public OrderType getOrderType() {
        return this.g;
    }

    public void setOrderType(OrderType orderType) {
        this.g = orderType;
    }
}

