/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ShopSeatForm
extends BeanEditor<ShopSeat> {
    private IntegerTextField a;
    private JPanel b;
    private JLabel c;
    private ShopSeat d;
    private ShopTable e;

    public ShopSeatForm(ShopTable shopTable) {
        this.e = shopTable;
        this.b = new JPanel();
        this.b.setLayout((LayoutManager)new MigLayout("fill"));
        this.a = new IntegerTextField(0, 3);
        this.c = new JLabel("Seat Number");
        this.b.add((Component)this.c, "grow");
        this.b.add((Component)this.a, "grow,w 200!");
        this.add(this.b);
    }

    public void setFieldsEditable(boolean bl) {
        this.a.setEditable(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new ShopSeat());
    }

    @Override
    public boolean delete() {
        try {
            ShopSeat shopSeat = (ShopSeat)this.getBean();
            if (shopSeat == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTabeTypeForm.2"), POSConstants.CONFIRM);
            if (n != 0) {
                return false;
            }
            this.e.getSeats().remove(shopSeat);
            this.a.setText("");
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.a.setEnabled(bl);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            this.d = (ShopSeat)this.getBean();
            this.e.addToseats(this.d);
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
            return false;
        }
    }

    @Override
    protected void updateView() {
        ShopSeat shopSeat = (ShopSeat)this.getBean();
        if (shopSeat == null) {
            return;
        }
        this.a.setText(String.valueOf(shopSeat.getSeatNumber()));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Integer n;
        ShopSeat shopSeat = (ShopSeat)this.getBean();
        if (shopSeat == null) {
            shopSeat = new ShopSeat();
            this.setBean(shopSeat, false);
        }
        if ((n = Integer.valueOf(this.a.getInteger())) == 0) {
            POSMessageDialog.showError(Messages.getString("ShopSeatForm.1"));
            return false;
        }
        if (!this.a(n)) {
            POSMessageDialog.showError(Messages.getString("ShopSeatForm.3"));
            return false;
        }
        shopSeat.setSeatNumber(n);
        return true;
    }

    private boolean a(Integer n) {
        Set<ShopSeat> set = null;
        if (this.e != null) {
            set = this.e.getSeats();
        }
        if (set == null || set.isEmpty()) {
            return true;
        }
        for (ShopSeat shopSeat : set) {
            if (shopSeat.equals(this.getBean()) || !shopSeat.getSeatNumber().equals(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("ShopSeatForm.0");
    }

    public ShopSeat getSeat() {
        return this.d;
    }
}

