/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class MenuCategoryForm
extends BeanEditor
implements RefreshableView {
    private JCheckBox a;
    private CheckBoxList b;
    private CheckBoxList c;
    private CheckBoxList d;
    private JScrollPane e;
    private JCheckBox f;
    private JCheckBox g;
    private JLabel h;
    private FixedLengthTextField i;
    private IntegerTextField j;
    private JButton k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private FixedLengthTextField o;
    private JLabel p;
    private JButton q;

    public MenuCategoryForm() throws Exception {
        this(new MenuCategory());
    }

    public MenuCategoryForm(MenuCategory menuCategory) throws Exception {
        this.a();
        this.setBean(menuCategory);
    }

    @Override
    public String getDisplayText() {
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        if (menuCategory.getId() == null) {
            return POSConstants.NEW_MENU_CATEGORY;
        }
        return POSConstants.EDIT_MENU_CATEGORY;
    }

    private void a() {
        this.h = new JLabel();
        this.g = new JCheckBox();
        this.i = new FixedLengthTextField();
        this.i.setLength(120);
        this.f = new JCheckBox();
        this.a = new JCheckBox("Ticket discount applicable");
        this.h.setText(POSConstants.NAME + ":");
        this.g.setText(POSConstants.VISIBLE);
        this.g.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.g.setMargin(new Insets(0, 0, 0, 0));
        this.f.setText(POSConstants.BEVERAGE);
        this.f.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.f.setMargin(new Insets(0, 0, 0, 0));
        this.l = new JLabel(Messages.getString("MenuCategoryForm.1"));
        this.j = new IntegerTextField();
        this.j.setColumns(10);
        this.m = new JLabel(Messages.getString("MenuCategoryForm.2"));
        this.k = new JButton();
        this.k.setPreferredSize(new Dimension(140, 40));
        TitledBorder titledBorder = new TitledBorder(Messages.getString("PosMessage.58"));
        this.e = new JScrollPane();
        this.e.setBorder(titledBorder);
        this.e.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.b = new CheckBoxList();
        List<Department> list = DepartmentDAO.getInstance().findAll();
        this.b.setModel(list);
        TitledBorder titledBorder2 = new TitledBorder(Messages.getString("MenuCategoryForm.0"));
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setBorder(titledBorder2);
        jScrollPane.setPreferredSize(new Dimension(228, 100));
        this.c = new CheckBoxList();
        this.c.setModel(OrderTypeDAO.getInstance().findAll());
        JScrollPane jScrollPane2 = new JScrollPane(this.c);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(Messages.getString("MenuCategoryForm.3")));
        jScrollPane2.setPreferredSize(new Dimension(228, 120));
        this.d = new CheckBoxList();
        List<MenuShift> list2 = MenuShiftDAO.getInstance().findAll();
        this.d.setModel(list2);
        TitledBorder titledBorder3 = new TitledBorder(Messages.getString("MenuCategoryForm.4"));
        JScrollPane jScrollPane3 = new JScrollPane(this.d);
        jScrollPane3.setBorder(titledBorder3);
        jScrollPane3.setPreferredSize(new Dimension(228, 100));
        this.n = new JLabel(Messages.getString("MenuCategoryForm.7"));
        this.o = new FixedLengthTextField();
        this.o.setLength(120);
        this.p = new JLabel(Messages.getString("MenuCategoryForm.5"));
        this.q = new JButton();
        this.q.setText(Messages.getString("MenuCategoryForm.16"));
        this.q.setPreferredSize(new Dimension(140, 40));
        this.setLayout(new GridLayout(1, 2));
        this.setPreferredSize(new Dimension(850, 450));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", ""));
        jPanel.add((Component)this.h, "alignx left");
        jPanel.add((Component)this.i, "growx,aligny top");
        jPanel.add((Component)this.n, "newline");
        jPanel.add((Component)this.o, "growx");
        jPanel.add((Component)this.l, "newline,alignx left");
        jPanel.add((Component)this.j, "alignx left,aligny top");
        jPanel.add((Component)this.m, "newline,h 25!,alignx left,growy");
        jPanel.add((Component)this.k, "h 25!,alignx left,growy");
        jPanel.add((Component)this.p, "newline,h 25!");
        jPanel.add((Component)this.q, "h 25!,growy");
        jPanel.add((Component)this.a, "newline, skip 1");
        jPanel.add((Component)this.f, "newline,alignx left,growy, skip 1");
        jPanel.add((Component)this.g, "newline,alignx left,gapbottom 5, skip 1");
        jPanel.add((Component)this.e, "newline, span");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel2.add((Component)jScrollPane2, "grow");
        jPanel2.add((Component)jScrollPane3, "newline, grow");
        jPanel2.add((Component)jScrollPane, "newline, grow");
        this.add(jPanel2);
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryForm.21"), MenuCategoryForm.this.k.getBackground());
                if (color != null) {
                    MenuCategoryForm.this.k.setBackground(color);
                    MenuCategoryForm.this.q.setBackground(color);
                }
            }
        });
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryForm.22"), MenuCategoryForm.this.q.getForeground());
                if (color != null) {
                    MenuCategoryForm.this.q.setForeground(color);
                }
            }
        });
    }

    @Override
    protected void updateView() {
        Serializable serializable;
        Color color;
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        MenuCategoryDAO.getInstance().initialize(menuCategory);
        if (menuCategory == null) {
            this.i.setText("");
            this.o.setText("");
            this.j.setText("0");
            this.g.setSelected(false);
            return;
        }
        this.i.setText(menuCategory.getName());
        this.o.setText(menuCategory.getTranslatedName());
        if (menuCategory.getSortOrder() != null) {
            this.j.setText(menuCategory.getSortOrder().toString());
        }
        if ((color = menuCategory.getButtonColor()) != null) {
            this.k.setBackground(color);
            this.q.setBackground(color);
        }
        if (menuCategory.getTextColor() != null) {
            this.q.setForeground(menuCategory.getTextColor());
        }
        this.a.setSelected(menuCategory.isTicketDiscountApplicable());
        this.f.setSelected(menuCategory.isBeverage());
        if (menuCategory.getId() == null) {
            this.g.setSelected(true);
        } else {
            this.g.setSelected(menuCategory.isVisible());
        }
        if (menuCategory.getDepartments() != null) {
            serializable = new ArrayList<Department>(menuCategory.getDepartments());
            this.b.selectItems((List)((Object)serializable));
        }
        this.c.selectItems(menuCategory.getOrderTypes());
        this.d.selectItems(menuCategory.getMenuShifts());
        serializable = new DefaultListModel();
        List<MenuGroup> list = menuCategory.getMenuGroups();
        if (list != null) {
            for (MenuGroup menuGroup : list) {
                ((DefaultListModel)serializable).addElement((MenuGroup)menuGroup);
            }
        }
        JList<Department> jList = new JList<Department>((ListModel<Department>)((Object)serializable));
        this.e.setViewportView(jList);
    }

    @Override
    protected boolean updateModel() {
        String string;
        MenuCategory menuCategory;
        block4: {
            menuCategory = (MenuCategory)this.getBean();
            if (menuCategory == null) {
                return false;
            }
            string = this.i.getText();
            if (POSUtil.isBlankOrNull(string)) {
                MessageDialog.showError(Messages.getString("MenuCategoryForm.26"));
                return false;
            }
            try {
                GenericDAO.getInstance().checkIdOrNameExists(menuCategory.getId(), string, MenuCategory.class);
            }
            catch (DuplicateDataException duplicateDataException) {
                String string2 = String.format(Messages.getString("SAME_NAME_WARRING"), Messages.getString("DataImportAction.7"));
                String string3 = Messages.getString("WARNING");
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string2, string3, Messages.getString("YES"), Messages.getString("NO"));
                if (n == 0) break block4;
                return false;
            }
        }
        menuCategory.setName(string);
        menuCategory.setTranslatedName(this.o.getText());
        menuCategory.setSortOrder(this.j.getInteger());
        menuCategory.setButtonColor(this.k.getBackground());
        menuCategory.setTextColor(this.q.getForeground());
        menuCategory.setButtonColorCode(this.k.getBackground().getRGB());
        menuCategory.setTextColorCode(this.q.getForeground().getRGB());
        menuCategory.setTicketDiscountApplicable(this.a.isSelected());
        menuCategory.setBeverage(this.f.isSelected());
        menuCategory.setVisible(this.g.isSelected());
        menuCategory.setOrderTypes(POSUtil.copySelectedValues(menuCategory.getOrderTypes(), this.c.getCheckedValuesAsSet()));
        menuCategory.setDepartments(POSUtil.copySelectedValues(menuCategory.getDepartments(), this.b.getCheckedValuesAsSet()));
        menuCategory.setMenuShifts(POSUtil.copySelectedValues(menuCategory.getMenuShifts(), this.d.getCheckedValuesAsSet()));
        return true;
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuCategory menuCategory = (MenuCategory)this.getBean();
            MenuCategoryDAO.getInstance().saveOrUpdate(menuCategory);
            return true;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public void refresh() {
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        MenuCategory menuCategory2 = MenuCategoryDAO.getInstance().get(menuCategory.getId());
        this.setBean(menuCategory2);
    }
}

