/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PriceTableForm;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PriceTableItemSelectionView
extends JPanel {
    private PriceTable a;
    protected JButton btnAddItem = new JButton(Messages.getString("PriceTableItemSelectionView.0"));
    protected JButton btnSave = new JButton(Messages.getString("ModelBrowser.2"));
    protected JButton btnDeleteItem = new JButton(POSConstants.DELETE);
    private JComboBox b;
    private PosTable c;
    private PriceTableItemTableModel d;
    private POSTextField e;
    private JButton f;
    private JButton g;
    private MenuGroup h;
    private JLabel i = new JLabel();
    private JLabel j;
    private JButton k;
    private JPanel l;
    private JCheckBox m;
    private boolean n = false;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    private boolean o = true;
    private boolean p = true;
    private JPanel q;
    private PriceTableForm r;

    public PriceTableItemSelectionView(PriceTableForm priceTableForm) {
        this.r = priceTableForm;
        this.a();
        this.d.setCurrentRowIndex(0);
        this.b.addItemListener(itemEvent -> {
            this.d.setCurrentRowIndex(0);
            this.setSelectedMenuGroup(this.b.getSelectedItem());
        });
    }

    public void initData() {
        this.d.setCurrentRowIndex(0);
        if (this.a == null) {
            this.d.setRows(new ArrayList());
        } else {
            PriceTableItemDAO.getInstance().getItemsByPriceTable(this.a, this.d);
        }
        this.e();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.d = new PriceTableItemTableModel();
        this.d.setCurrentRowIndex(0);
        String[] stringArray = new String[]{Messages.getString("PriceTableForm.23"), Messages.getString("PriceTableForm.24"), Messages.getString("MenuItemForm.2"), Messages.getString("PriceTableForm.25"), Messages.getString("PriceTableForm.26")};
        this.d.setColumnNames(stringArray);
        this.d.setPageSize(10);
        this.c = new PosTable();
        this.c.setModel(this.d);
        this.c.setSelectionMode(2);
        this.c.setRowHeight(PosUIManager.getSize(40));
        this.c.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setAllowNegativeValue(false);
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.c.setDefaultEditor(this.c.getColumnClass(3), defaultCellEditor);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.c));
        jScrollPane.setPreferredSize(PosUIManager.getSize(500, 250));
        jPanel.add(jScrollPane);
        jPanel.add((Component)this.c(), "North");
        this.add(jPanel);
        this.resizeColumnWidth((JTable)((Object)this.c));
        this.btnAddItem.addActionListener(actionEvent -> this.i());
        this.btnSave.addActionListener(actionEvent -> this.r.save());
        this.btnDeleteItem.addActionListener(actionEvent -> this.j());
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0 0 0 0,fillx", "", ""));
        jPanel2.add(this.btnAddItem);
        jPanel2.add(this.btnDeleteItem);
        jPanel2.add(this.btnSave);
        this.q = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        this.q.add((Component)jPanel2, "center");
        this.m = new JCheckBox(Messages.getString("MenuItemSelectionView.7"));
        this.q.add((Component)this.i, "split 3,right");
        this.g = new JButton(Messages.getString("MenuItemSelectionView.8"));
        this.q.add((Component)this.g, "center");
        this.f = new JButton(Messages.getString("MenuItemSelectionView.11"));
        this.q.add(this.f);
        jPanel.add((Component)this.q, "South");
        ActionListener actionListener = actionEvent -> this.a(actionEvent);
        this.g.addActionListener(actionListener);
        this.f.addActionListener(actionListener);
        this.f.setEnabled(false);
        this.g.setEnabled(false);
        this.e();
        this.b();
    }

    private void a(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object == this.g) {
                this.h();
            } else if (object == this.f) {
                this.g();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    private void b() {
        this.btnAddItem.setEnabled(this.a != null);
        this.btnDeleteItem.setEnabled(this.a != null);
        this.btnSave.setEnabled(this.a != null);
        this.i.setText("");
        this.g.setEnabled(false);
        this.f.setEnabled(false);
        this.b.setEnabled(false);
    }

    private JPanel c() {
        this.l = new JPanel();
        this.l.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[]10[]"));
        this.j = new JLabel(POSConstants.NAME + "/" + Messages.getString("MenuItemSelectionView.16"));
        this.e = new POSTextField(25);
        this.k = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.l.add((Component)this.j, "align label,split 5");
        this.l.add(this.e);
        this.b = new OverflowCombobox();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Messages.getString("MenuItemSelectionView.19"));
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        arrayList.addAll(list);
        ComboBoxModel comboBoxModel = new ComboBoxModel(arrayList);
        this.b.setModel(comboBoxModel);
        this.b.setSelectedItem(Messages.getString("MenuItemSelectionView.19"));
        this.b.addItemListener(itemEvent -> this.d());
        this.l.add(this.k);
        this.k.addActionListener(actionEvent -> this.d());
        this.e.addActionListener(actionEvent -> this.d());
        return this.l;
    }

    private void d() {
        try {
            String string;
            if (this.a == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PriceTableItemSelectionView.3"));
                return;
            }
            this.d.setCurrentRowIndex(0);
            String string2 = string = StringUtils.isBlank((String)this.e.getText()) ? "" : this.e.getText();
            if (StringUtils.isNotBlank((String)this.e.getText())) {
                PriceTableItemDAO.getInstance().getItemsByPriceTable(this.a, this.d, string);
                this.d.setNumRows(1);
            } else {
                PriceTableItemDAO.getInstance().getItemsByPriceTable(this.a, this.d);
            }
            this.e();
            this.d.fireTableDataChanged();
            this.c.repaint();
            this.m.setSelected(false);
            this.b.setEnabled(true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void e() {
        this.q.setEnabled(true);
        int n = this.d.getCurrentRowIndex() + 1;
        int n2 = this.d.getNextRowIndex();
        int n3 = this.d.getNumRows();
        if (n2 > n3) {
            n2 = n3;
        }
        this.i.setText(String.format(Messages.getString("MenuItemSelectionView.27"), n, n2, n3));
        this.g.setEnabled(this.d.hasPrevious());
        this.f.setEnabled(this.d.hasNext());
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.f().get(i));
        }
    }

    private List f() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(PosUIManager.getSize(100));
        arrayList.add(PosUIManager.getSize(130));
        arrayList.add(PosUIManager.getSize(130));
        arrayList.add(PosUIManager.getSize(180));
        arrayList.add(PosUIManager.getSize(100));
        return arrayList;
    }

    public List<PriceTableItem> getSelectedMenuItemList() {
        return new ArrayList<PriceTableItem>();
    }

    private void g() {
        this.d.setCurrentRowIndex(this.d.getNextRowIndex());
        PriceTableItemDAO.getInstance().getItemsByPriceTable(this.a, this.d);
        this.e();
        this.c.repaint();
        this.m.setSelected(false);
    }

    private void h() {
        this.d.setCurrentRowIndex(this.d.getPreviousRowIndex());
        PriceTableItemDAO.getInstance().getItemsByPriceTable(this.a, this.d);
        this.e();
        this.c.repaint();
        this.m.setSelected(false);
    }

    public void setSelectedMenuGroup(Object object) {
        this.h = object instanceof MenuGroup ? (MenuGroup)object : null;
        this.d();
    }

    public int getSelectedRow() {
        int n = this.c.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        return this.c.convertRowIndexToModel(n);
    }

    public PriceTableItemTableModel getModel() {
        return this.d;
    }

    public void setShowVariantParent(boolean bl) {
        this.n = bl;
    }

    public void setShowVariant(boolean bl) {
        this.o = bl;
    }

    public void setShowComboItem(boolean bl) {
        this.p = bl;
    }

    public void setEnableTable(boolean bl) {
        this.c.setEnabled(bl);
    }

    public boolean delete() {
        try {
            int n = this.c.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PriceTableItemSelectionView.4"));
                return false;
            }
            int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("PriceTableItemSelectionView.2"), POSConstants.CONFIRM);
            if (n2 != 0) {
                return false;
            }
            if (n != -1) {
                n = this.c.convertRowIndexToModel(n);
                PriceTableItem priceTableItem = (PriceTableItem)this.d.getRowData(n);
                PriceTableItemDAO.getInstance().delete(priceTableItem);
                this.d.deleteItem(n);
                this.d.fireTableDataChanged();
                return true;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
        return false;
    }

    public void setPriceTable(PriceTable priceTable) {
        this.a = priceTable;
        this.b();
        this.initData();
    }

    public PriceTableItemTableModel getTableModel() {
        return this.d;
    }

    private void i() {
        this.r.createNew();
    }

    private void j() {
        this.r.delete();
    }

    public class PriceTableItemTableModel
    extends PaginatedTableModel<PriceTableItem> {
        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PriceTableItem priceTableItem = (PriceTableItem)this.getRowData(n);
            switch (n2) {
                case 0: {
                    return priceTableItem.getItemBarcode();
                }
                case 1: {
                    String string = priceTableItem.getItemName();
                    if (StringUtils.isBlank((String)string)) {
                        string = priceTableItem.getMenuItem().getDisplayName();
                    }
                    return string;
                }
                case 2: {
                    return priceTableItem.getUnit();
                }
                case 3: {
                    return priceTableItem.getRegularPrice();
                }
                case 4: {
                    MenuItem menuItem;
                    Double d = priceTableItem.getPrice();
                    if (priceTableItem.getMenuItem().isVariant().booleanValue() && (menuItem = priceTableItem.getMenuItem().getParentMenuItem()) != null) {
                        return menuItem.getPrice() + d;
                    }
                    return d;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PriceTableItem priceTableItem = this.getPriceTableItem(n);
            if (priceTableItem == null) {
                return;
            }
            if (n2 == 4) {
                String string = (String)object;
                if (StringUtils.isBlank((String)string)) {
                    return;
                }
                double d = Double.parseDouble(string);
                MenuItem menuItem = priceTableItem.getMenuItem();
                if (menuItem.isVariant().booleanValue()) {
                    MenuItem menuItem2 = menuItem.getParentMenuItem();
                    if (d < menuItem2.getPrice()) {
                        POSMessageDialog.showError(Messages.getString("PriceTableItemSelectionView.1") + NumberUtil.round(menuItem2.getPrice()));
                        return;
                    }
                    double d2 = d - menuItem2.getPrice();
                    priceTableItem.setPrice(d2);
                } else {
                    priceTableItem.setPrice(d);
                }
                PriceTableItemDAO.getInstance().update(priceTableItem);
            } else {
                super.setValueAt(object, n, n2);
            }
        }

        public PriceTableItem getPriceTableItem(int n) {
            return (PriceTableItem)this.getRowData(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 4;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Double.class;
                }
                case 4: {
                    return Double.class;
                }
            }
            throw new InternalError();
        }
    }
}

