/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.MenuItemVariantExplorer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ServicePaymentType;
import com.floreantpos.model.ServiceType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.ButtonStylePanel;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class ServiceForm
extends BeanEditor<MenuItem>
implements RefreshableView,
ActionListener,
ChangeListener {
    private MenuItem a;
    private JComboBox b = new JComboBox();
    private JComboBox c = new JComboBox();
    private JComboBox d = new JComboBox();
    private JCheckBox e = new JCheckBox();
    private JCheckBox f = new JCheckBox();
    private JLabel g = new JLabel();
    private JLabel h = new JLabel();
    private JLabel i = new JLabel();
    private JLabel j = new JLabel();
    private JPanel k = new JPanel();
    private JTabbedPane l = new JTabbedPane();
    private FixedLengthTextField m = new FixedLengthTextField(20, 255);
    private FixedLengthTextField n = new FixedLengthTextField(20, 255);
    private DoubleTextField o = new DoubleTextField(10);
    private JTextArea p = new JTextArea(new FixedLengthDocument(512));
    private JLabel q = new JLabel(Messages.getString("MenuItemForm.lblBarcode.text"));
    private FixedLengthTextField r = new FixedLengthTextField(21, 128);
    private JButton s = new JButton("+");
    private MenuItemVariantExplorer t;
    private JComboBox<MenuGroup> u = new JComboBox();
    private ButtonStylePanel v;
    private Double w;
    private JLabel x;
    private ImageResource y;

    public ServiceForm(MenuItem menuItem) throws Exception {
        this.a = menuItem;
        this.a();
        this.initData();
        this.setBean(menuItem);
    }

    public void initData() {
        MenuGroupDAO menuGroupDAO = new MenuGroupDAO();
        ArrayList<MenuGroup> arrayList = new ArrayList<MenuGroup>();
        arrayList.add(null);
        List<MenuGroup> list = menuGroupDAO.findAll();
        if (list != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        this.u.setModel(new ComboBoxModel(arrayList));
        this.b.setModel(new ComboBoxModel(Arrays.asList(ServiceType.values())));
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        List<ServicePaymentType> list2 = Arrays.asList(ServicePaymentType.values());
        for (ServicePaymentType object2 : list2) {
            comboBoxModel.addElement(object2);
        }
        this.c.setModel(comboBoxModel);
        ComboBoxModel comboBoxModel2 = new ComboBoxModel();
        comboBoxModel2.addElement((Object)null);
        List<TaxGroup> list3 = TaxGroupDAO.getInstance().findAll();
        for (TaxGroup taxGroup : list3) {
            comboBoxModel2.addElement(taxGroup);
        }
        this.d.setModel(comboBoxModel2);
        this.t.setParentMenuItem(this.a);
    }

    protected void doShowPriceAndVariantTab(boolean bl) {
        if (bl) {
            this.i.setVisible(false);
            this.c.setVisible(false);
            this.h.setVisible(false);
            this.o.setVisible(false);
            this.l.remove(this.t);
        } else {
            this.i.setVisible(true);
            this.c.setVisible(true);
            this.h.setVisible(true);
            this.o.setVisible(true);
            this.l.remove(this.t);
            this.b();
            this.l.remove(this.v);
            this.initBtnstyleTab();
        }
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.initGeneralTab();
        this.b();
        this.initBtnstyleTab();
        this.l.addChangeListener(this);
    }

    private void b() {
        this.t = new MenuItemVariantExplorer(true);
        this.t.setVisibleResetCostButton(false);
        this.l.addTab(Messages.getString("ServiceVariants"), this.t);
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.c().get(i));
        }
    }

    private List c() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(200);
        arrayList.add(50);
        arrayList.add(50);
        return arrayList;
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
            boolean bl = menuItemDAO.isNameExist(menuItem.getId(), menuItem.getName());
            if (bl) {
                String string = Messages.getString("MenuItemForm.0");
                String string2 = Messages.getString("MenuItemForm.1");
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string, string2, Messages.getString("MenuItemForm.3"), Messages.getString("MenuItemForm.5"));
                if (n != 0) {
                    return false;
                }
            }
            menuItemDAO.saveOrUpdate(menuItem, this.t.getAttributeGroups());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        String string;
        MenuItem menuItem = (MenuItem)this.getBean();
        this.m.setText(menuItem.getName());
        this.p.setText(menuItem.getDescription());
        this.n.setText(menuItem.getTranslatedName());
        this.r.setText(menuItem.getBarcode());
        this.w = menuItem.getPrice();
        this.o.setText(NumberUtil.formatAmount(this.w));
        this.f.setSelected(menuItem.isVisible());
        this.v.setShowTextWithImage(menuItem.isShowImageOnly());
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (imageResource != null) {
            this.setImageResource(imageResource);
        }
        this.d.setSelectedItem(menuItem.getTaxGroup());
        if (menuItem.getMenuGroupId() != null) {
            PosGuiUtil.selectComboItemById(this.u, menuItem.getMenuGroupId());
        }
        if (StringUtils.isNotBlank((String)(string = ((MenuItem)this.getBean()).getServiceType()))) {
            this.b.setSelectedItem((Object)ServiceType.valueOf(string));
        } else {
            this.b.setSelectedIndex(0);
        }
        ServicePaymentType servicePaymentType = ((MenuItem)this.getBean()).getPaymentType();
        this.c.setSelectedItem(servicePaymentType);
        Color color = menuItem.getButtonColor();
        if (color != null) {
            this.v.setButtonColor(color);
            this.v.setTextColor(color);
        }
        if (menuItem.getTextColor() != null) {
            this.v.setTextForegroundColor(menuItem.getTextColor());
        }
        this.e.setSelected(true);
        this.e.setEnabled(false);
        this.t.setParentMenuItem(menuItem);
    }

    @Override
    public boolean updateModel() {
        Iterator iterator;
        Object object;
        Serializable serializable;
        String string = this.m.getText();
        if (POSUtil.isBlankOrNull(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        ServicePaymentType servicePaymentType = (ServicePaymentType)this.c.getSelectedItem();
        ServiceType serviceType = (ServiceType)((Object)this.b.getSelectedItem());
        if (servicePaymentType == null && serviceType != ServiceType.ADD_CUSTOMER_BALANCE) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PaymentTypeIsRequired"));
            return false;
        }
        double d = this.o.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.12"));
            return false;
        }
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setName(string);
        if (StringUtils.isNotBlank((String)this.p.getText())) {
            menuItem.setDescription(this.p.getText().trim());
        }
        menuItem.setService(true);
        menuItem.setBarcode(this.r.getText());
        menuItem.setPrice(d);
        menuItem.setTaxGroup((TaxGroup)this.d.getSelectedItem());
        menuItem.setVisible(this.f.isSelected());
        menuItem.setShowImageOnly(this.v.isShowTextWithImage());
        menuItem.setTranslatedName(this.n.getText());
        menuItem.setButtonColorCode(this.v.getButtonColorCode());
        menuItem.setTextColorCode(this.v.getTextColorCode());
        menuItem.setHasMandatoryModifiers(false);
        menuItem.setServiceChargeApplicable(false);
        menuItem.setServiceChargeRefundable(false);
        menuItem.setTaxOnServiceCharge(false);
        int n = this.l.getTabCount();
        for (int i = 0; i < n; ++i) {
            serializable = this.l.getComponent(i);
            if (!(serializable instanceof IUpdatebleView) || (object = (IUpdatebleView)((Object)serializable)).updateModel(menuItem)) continue;
            return false;
        }
        MenuGroup menuGroup = (MenuGroup)this.u.getSelectedItem();
        menuItem.setMenuGroup(menuGroup);
        menuItem.setComboItem(false);
        menuItem.setServiceType(((ServiceType)((Object)this.b.getSelectedItem())).name());
        menuItem.setPaymentType(servicePaymentType);
        menuItem.setCustomerRequired(this.e.isSelected());
        serializable = menuItem.getVariants();
        if (serializable == null) {
            serializable = new ArrayList<MenuItem>();
        }
        if ((object = this.t.getVariants()) != null && object.size() > 0) {
            MenuItem menuItem2;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                menuItem2 = (MenuItem)iterator.next();
                menuItem2.setName(menuItem2.createVariantName(string));
                menuItem2.setLastUpdateTime(StoreDAO.getServerTimestamp());
                menuItem2.setInventoryItem(false);
                menuItem2.setParentMenuItem(menuItem);
                menuItem2.setMenuGroup(menuGroup);
                menuItem2.setService(true);
                menuItem2.setPaymentType(menuItem.getPaymentType());
                menuItem2.setServiceType(menuItem.getServiceType());
                menuItem2.setCustomerRequired(menuItem.isCustomerRequired());
                menuItem2.setShouldPrintToKitchen(false);
                menuItem2.setVisible(this.f.isSelected());
                if (serializable.contains(menuItem2)) continue;
                serializable.add(menuItem2);
            }
            iterator = serializable.iterator();
            while (iterator.hasNext()) {
                menuItem2 = (MenuItem)iterator.next();
                if (object.contains(menuItem2)) continue;
                menuItem2.setDeleted(true);
            }
            menuItem.setVariants((List<MenuItem>)((Object)serializable));
        }
        if (StringUtils.isNotBlank((String)((Object)(iterator = this.getImageResourceId())))) {
            menuItem.setImageId((String)((Object)iterator));
        } else {
            menuItem.setImageId(null);
        }
        menuItem.setHasVariant(menuItem.getActiveVariants() != null && menuItem.getActiveVariants().size() > 0);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItem menuItem = (MenuItem)this.getBean();
        if (menuItem.getId() == null) {
            return Messages.getString("NewService");
        }
        return Messages.getString("EditService") + " " + menuItem.getName();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.l.getSelectedComponent();
        if (!(component instanceof IUpdatebleView)) {
            return;
        }
        IUpdatebleView iUpdatebleView = (IUpdatebleView)((Object)component);
        MenuItem menuItem = (MenuItem)this.getBean();
        iUpdatebleView.initView(menuItem);
    }

    private void d() {
        MenuGroupForm menuGroupForm = new MenuGroupForm();
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)menuGroupForm);
        beanEditorDialog.open();
        if (!beanEditorDialog.isCanceled()) {
            MenuGroup menuGroup = (MenuGroup)menuGroupForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.u.getModel();
            comboBoxModel.addElement(menuGroup);
            comboBoxModel.setSelectedItem(menuGroup);
        }
    }

    public void initGeneralTab() {
        int n = PosUIManager.getSize(200);
        JLabel jLabel = new JLabel(Messages.getString("MenuItemForm.28"));
        this.x = new JLabel("");
        this.x.setHorizontalAlignment(0);
        this.x.setBorder(new EtchedBorder(1, null, null));
        this.x.setPreferredSize(PosUIManager.getSize(100, 100));
        JButton jButton = new JButton(Messages.getString("MenuItemForm.34"));
        JButton jButton2 = new JButton("...");
        this.g.setText(Messages.getString("Service.Name"));
        this.g.setHorizontalAlignment(11);
        this.h.setHorizontalAlignment(11);
        this.h.setText(Messages.getString("Service.Price") + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        this.j.setHorizontalAlignment(11);
        this.j.setText(Messages.getString("MenuItemForm.81"));
        this.o.setHorizontalAlignment(4);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow]", ""));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("hidemode 3, fillx", "[][grow]", ""));
        this.b.addItemListener(itemEvent -> {
            ServiceType serviceType = (ServiceType)((Object)((Object)this.b.getSelectedItem()));
            if (serviceType == ServiceType.ADD_CUSTOMER_BALANCE) {
                this.doShowPriceAndVariantTab(true);
            } else {
                this.doShowPriceAndVariantTab(false);
            }
        });
        this.i.setText(Messages.getString("Service.PaymentType"));
        Dimension dimension = PosUIManager.getSize(280, 450);
        jPanel.setPreferredSize(dimension);
        jPanel2.setPreferredSize(dimension);
        this.k.setLayout(new GridLayout(1, 2, 40, 5));
        jPanel.add((Component)jLabel, "right");
        int n2 = PosUIManager.getSize(100);
        jPanel.add((Component)this.x, "split 3,h " + n2 + "!,w " + n2 + "!");
        jPanel.add((Component)jButton, "");
        jPanel.add((Component)jButton2, "wrap");
        jPanel.add((Component)this.g, "right");
        jPanel.add((Component)this.m, "grow, wrap");
        jPanel.add((Component)new JLabel(Messages.getString("Service.Group")), "right");
        jPanel.add(this.u, "split 2, w " + n);
        jPanel.add((Component)this.s, "wrap");
        jPanel.add((Component)new JLabel(Messages.getString("Service.Type")), "right");
        jPanel.add((Component)this.b, "wrap,w " + n);
        jPanel.add((Component)this.i, "right");
        jPanel.add((Component)this.c, "wrap,w " + n);
        jPanel.add((Component)this.q, "right");
        jPanel.add((Component)this.r, "wrap, w " + n);
        jPanel.add((Component)this.h, "right");
        jPanel.add((Component)this.o, "wrap");
        jPanel.add((Component)this.e, "skip 1,wrap");
        jPanel.add((Component)this.f, "skip 1,wrap");
        this.f.setText(POSConstants.ACTIVE);
        this.f.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.f.setMargin(new Insets(0, 0, 0, 0));
        this.e.setText(Messages.getString("CustomerRequired"));
        this.e.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.e.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add((Component)this.j, "right");
        jPanel2.add((Component)this.d, "wrap, w " + n + "!");
        JLabel jLabel2 = new JLabel(Messages.getString("MenuItemForm.104"));
        jLabel2.setVerticalAlignment(1);
        jLabel2.setHorizontalAlignment(11);
        this.p.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.p, 20, 30);
        jPanel2.add((Component)jLabel2, "align right, grow");
        jPanel2.add((Component)jScrollPane, "h 25%,grow,wrap");
        this.k.add((Component)jPanel, "grow,wrap");
        this.k.add((Component)jPanel2, "grow,wrap");
        JScrollPane jScrollPane2 = new JScrollPane(this.k, 20, 30);
        jScrollPane2.setBorder(null);
        this.l.addTab(POSConstants.GENERAL, jScrollPane2);
        Dimension dimension2 = PosUIManager.getSize(700, 470);
        this.l.setPreferredSize(dimension2);
        this.add(this.l);
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceForm.this.d();
            }
        });
        this.m.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ServiceForm.this.a.setName(ServiceForm.this.m.getText());
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        jButton2.addActionListener(actionEvent -> this.doSelectImageFile());
        jButton.addActionListener(actionEvent -> this.doClearImage());
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setTitle(Messages.getString("ButtonStylePanel.8"));
        imageGalleryDialog.setResizable(true);
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.openFullScreen();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.y = imageGalleryDialog.getImageResource();
        if (this.y != null) {
            this.setImageResource(this.y);
        }
    }

    protected void doClearImage() {
        this.x.setIcon(null);
        this.y = null;
    }

    public String getImageResourceId() {
        if (this.y != null) {
            return this.y.getId();
        }
        return "";
    }

    public void setImageResource(ImageResource imageResource) {
        this.y = imageResource;
        if (imageResource != null) {
            this.x.setIcon(imageResource.getButtonImage(100, 100));
        }
    }

    public void initBtnstyleTab() {
        this.v = new ButtonStylePanel();
        this.l.addTab("Style", this.v);
    }

    @Override
    public void refresh() {
        MenuItem menuItem = MenuItemDAO.getInstance().getInitialized(this.a.getId());
        this.setBean(menuItem, false);
    }
}

