/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.NumberBound;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import validation.ValidationCombobox;

public class TaxGroupAndTaxForm
extends BeanEditor<TaxGroup> {
    private ValidationCombobox a;
    private FixedLengthTextField b = new FixedLengthTextField();
    private DoubleTextField c;
    private TaxGroup d;

    public TaxGroupAndTaxForm() {
        this(new TaxGroup());
    }

    public TaxGroupAndTaxForm(TaxGroup taxGroup) {
        this.a(taxGroup);
        this.b();
        this.a();
        this.setBean(taxGroup);
        this.a.setSelectedItem(taxGroup);
        this.b.requestFocus();
    }

    private void a() {
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        for (TaxGroup taxGroup : list) {
            comboBoxModel.addElement(taxGroup);
        }
        this.a.setModel(comboBoxModel);
    }

    private void b() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(Messages.getString("TaxGroupAndTaxForm.0") + ":"));
        this.a = new ValidationCombobox();
        this.a.setTextFieldLength(20);
        this.add((Component)this.a, "grow, wrap");
        this.add(new JLabel(POSConstants.NAME + ":"));
        this.add((Component)this.b, "grow, wrap");
        this.c = new DoubleTextField(10, 6, DataProvider.get().getStore().getDecimalPlace());
        this.add(new JLabel(POSConstants.RATE + ":"));
        this.c.setHorizontalAlignment(4);
        this.add((Component)this.c, "split 2,grow");
        this.add((Component)new JLabel("%"), "wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            this.c();
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            return false;
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
            return false;
        }
    }

    private void c() {
        String string = this.b.getText();
        Double d = this.c.getDoubleOrZero();
        Transaction transaction = null;
        Session session = null;
        GenericDAO genericDAO = GenericDAO.getInstance();
        try {
            session = genericDAO.createNewSession();
            transaction = session.beginTransaction();
            Tax tax = new Tax();
            GenericDAO.getInstance().checkIdOrNameExists(tax.getId(), string, Tax.class);
            tax.setName(string);
            tax.setRate(d);
            genericDAO.saveOrUpdate(tax, session);
            TaxGroup taxGroup = null;
            Object object = this.a.getSelectedItem();
            if (object instanceof TaxGroup) {
                taxGroup = (TaxGroup)object;
            } else {
                taxGroup = new TaxGroup();
                taxGroup.setName((String)object);
            }
            taxGroup.addTotaxes(tax);
            genericDAO.saveOrUpdate(taxGroup, session);
            this.a(taxGroup);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    @Override
    public void clearFields() {
        this.b.setText("");
        this.c.setText("");
    }

    @Override
    protected void updateView() {
        this.clearFields();
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Object object = this.a.getSelectedItem();
        if (object == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxGroupAndTaxForm.1"));
            return false;
        }
        String string = this.b.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxGroupAndTaxForm.2"));
            return false;
        }
        Double d = this.c.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxForm.0"));
            return false;
        }
        Pattern pattern = NumberUtil.getPattern(new NumberBound(6, 4));
        Matcher matcher = pattern.matcher(this.c.getText());
        if (!matcher.matches()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxRateIsTooBig"));
            return false;
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return POSConstants.NEW_TAX_RATE;
    }

    private void a(TaxGroup taxGroup) {
        this.d = taxGroup;
    }

    public TaxGroup getTaxGroup() {
        return this.d;
    }
}

