/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class UserRoleForm
extends BeanEditor {
    private JComboBox a;
    private DoubleTextField b;
    private DoubleTextField c;
    private IntegerTextField d;
    private JCheckBox e;
    private JCheckBox f;
    private JCheckBox g;
    private JCheckBox h;
    private JCheckBox i;
    private JCheckBox j;
    private boolean k = false;

    public UserRoleForm(User user) {
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        this.a.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.setBean(user);
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.b = new DoubleTextField(10);
        this.c = new DoubleTextField(10);
        this.d = new IntegerTextField(10, 2);
        this.a = new JComboBox();
        jPanel.add(new JLabel(Messages.getString("UserRoleForm.0")));
        jPanel.add((Component)this.a, "wrap,grow");
        this.a.setSelectedItem(null);
        jPanel.add(new JLabel(Messages.getString("UserRoleForm.5")));
        jPanel.add((Component)this.d, "wrap");
        jPanel.add(new JLabel(Messages.getString("UserRoleForm.2")));
        jPanel.add((Component)this.b, "wrap");
        jPanel.add(new JLabel(Messages.getString("UserForm.3")));
        jPanel.add((Component)this.c, "wrap");
        this.e = new JCheckBox(Messages.getString("UserRoleForm.4"));
        jPanel.add((Component)this.e, "skip 1,newline,grow");
        this.f = new JCheckBox(Messages.getString("UserRoleForm.6"));
        jPanel.add((Component)this.f, "skip 1,newline,grow");
        this.g = new JCheckBox("Staff Bank");
        jPanel.add((Component)this.g, "skip 1,newline,grow");
        this.h = new JCheckBox("Auto start staff bank");
        jPanel.add((Component)this.h, "skip 1,newline,grow");
        this.i = new JCheckBox("Blind Accountable Amount");
        jPanel.add((Component)this.i, "skip 1,newline,grow");
        this.j = new JCheckBox(Messages.getString("ACTIVE"));
        jPanel.add((Component)this.j, "skip 1,newline,grow");
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserRoleForm.this.h.setEnabled(UserRoleForm.this.g.isSelected());
                UserRoleForm.this.i.setEnabled(UserRoleForm.this.g.isSelected());
            }
        });
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            User user = (User)this.getBean();
            UserDAO userDAO = new UserDAO();
            userDAO.saveOrUpdate(user);
            this.a(user);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
    }

    private void a(User user) {
        if (this.k) {
            String string = String.format("User %s created.", user.getId());
            ActionHistoryDAO.saveHistory("user created", string);
        } else {
            String string = String.format("User %s updated.", user.getId());
            ActionHistoryDAO.saveHistory("user modified", string);
        }
    }

    @Override
    protected void updateView() {
        User user = (User)this.getBean();
        this.b.setText(NumberUtil.formatAmount(user.getCostPerHourRate()));
        this.c.setText(NumberUtil.formatAmount(user.getOvertimePerHourRate()));
        this.d.setText(String.valueOf(user.getRegularWorkHour()));
        this.e.setSelected(user.isAllowReceiveTips());
        this.a.setSelectedItem(user.getType());
        this.g.setSelected(user.isStaffBank());
        this.h.setSelected(user.isAutoStartStaffBank());
        this.i.setSelected(user.isBlindAccountableAmount());
        this.f.setSelected(user.isDriver());
        this.h.setEnabled(this.g.isSelected());
        this.i.setEnabled(this.g.isSelected());
        this.j.setSelected(user.isActive());
    }

    @Override
    protected boolean updateModel() {
        double d;
        User user = (User)this.getBean();
        UserType userType = (UserType)this.a.getSelectedItem();
        if (userType == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("UserRoleForm.1"));
            return false;
        }
        if (user.isClockedIn().booleanValue()) {
            if (ConfirmDeleteDialog.showMessage(POSUtil.getFocusedWindow(), user.getFullName() + Messages.getString("UserExplorer.5"), POSConstants.DEACTIVE) == 0) {
                user.setClockedIn(false);
                user.setLastClockOutTime(new Date());
            } else {
                return false;
            }
        }
        User user2 = user.isRoot() != false ? user : user.getParentUser();
        List<User> list = user2.getLinkedUser();
        list.add(user2);
        if (list != null) {
            for (User user3 : list) {
                if (user3.isDeleted().booleanValue()) continue;
                if (user.getType() != null && user.getType().getId().equals(userType.getId())) break;
                if (user3.getType() == null || !user3.getType().getName().equals(userType.getName())) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("UserRoleForm.13"));
                return false;
            }
        }
        if ((d = this.b.getDoubleOrZero()) < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserRoleForm.3"));
            return false;
        }
        double d2 = this.c.getDoubleOrZero();
        if (d2 < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserRoleForm.7"));
            return false;
        }
        double d3 = this.d.getInteger();
        if (d3 < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserRoleForm.8"));
            return false;
        }
        if (d3 > 24.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserRoleForm.9"));
            return false;
        }
        if (user.getId() == null) {
            this.k = true;
            user.setId(GlobalIdGenerator.generateGlobalId().toString());
        }
        user.setCostPerHour(d);
        user.setOvertimeRatePerHour(d2);
        user.setRegularWorkHour(d3);
        user.setAllowReceiveTips(this.e.isSelected());
        user.setType(userType);
        user.setStaffBank(this.g.isSelected());
        user.setActive(this.j.isSelected());
        if (this.g.isSelected()) {
            user.setAutoStartStaffBank(this.h.isSelected());
            user.setBlindAccountableAmount(this.i.isSelected());
        } else {
            user.setAutoStartStaffBank(false);
            user.setBlindAccountableAmount(false);
        }
        user.setDriver(this.f.isSelected());
        user.setFirstName(user2.getFirstName());
        user.setLastName(user2.getLastName());
        user.setPhoneNo(user2.getPhoneNo());
        user.setAvailableForDelivery(user2.isAvailableForDelivery());
        user.setImageId(user2.getImageId());
        user.setSsn(user2.getSsn());
        user.setPassword(null);
        user.setLinkedUser(null);
        user.setRoot(false);
        user2.addTolinkedUser(user);
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("UserRoleForm.14");
    }
}

