/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.github.cjwizard.WizardSettings;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

public class ConfigureDatabasePage1
extends PosWizardPage
implements ActionListener {
    private JRadioButton a;
    private JRadioButton b;
    private JRadioButton c;
    private JRadioButton d;
    private JRadioButton e;
    private JRadioButton f;
    private boolean g;

    public ConfigureDatabasePage1() {
        super(Messages.getString("ConfigureDatabasePage1.4"), "Please select a database");
    }

    @Override
    public void initialize() throws Exception {
        if (this.g) {
            return;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.a = new JRadioButton(Messages.getString("ConfigureDatabasePage1.1"));
        this.a.setSelected(true);
        this.b = new JRadioButton(DatabaseSetupOption.POSTGRESQL.b);
        this.c = new JRadioButton(DatabaseSetupOption.MYSQL.b);
        this.d = new JRadioButton(DatabaseSetupOption.MS_SQL_SERVER.b);
        this.e = new JRadioButton(DatabaseSetupOption.DERBY_SERVER.b);
        this.f = new JRadioButton(DatabaseSetupOption.DERBY_SINGLE.b);
        this.a.addActionListener(this);
        this.b.addActionListener(this);
        this.c.addActionListener(this);
        this.d.addActionListener(this);
        this.e.addActionListener(this);
        this.f.addActionListener(this);
        buttonGroup.add(this.a);
        buttonGroup.add(this.b);
        buttonGroup.add(this.c);
        buttonGroup.add(this.d);
        buttonGroup.add(this.e);
        buttonGroup.add(this.f);
        this.removeAll();
        this.setLayout((LayoutManager)new MigLayout("", "[][grow]", ""));
        this.add(this.a);
        this.add(this.b, "newline");
        this.add(this.c, "newline");
        this.add(this.d, "newline");
        this.add(this.e, "newline");
        this.add(this.f, "newline");
        this.g = true;
    }

    public void useDemoDatabase() {
        DatabaseConfigurationDialog.DbInfo dbInfo = this.a();
        int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationView.0"));
        if (n != 0) {
            return;
        }
        DatabaseConfigurationDialog.saveConfig(dbInfo);
        ProcessUtil.restart();
    }

    private DatabaseConfigurationDialog.DbInfo a() {
        Database database = Database.DERBY_SINGLE;
        DatabaseConfigurationDialog.DbInfo dbInfo = new DatabaseConfigurationDialog.DbInfo();
        dbInfo.providerName = database.getProviderName();
        dbInfo.databaseURL = AppConfig.getDatabaseHost();
        dbInfo.databasePort = database.getDefaultPort();
        dbInfo.databaseName = "";
        dbInfo.user = "app";
        dbInfo.pass = new String("sa");
        dbInfo.connectionString = database.getConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.createDbConnectionString = database.getCreateDbConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.hibernateDialect = database.getHibernateDialect();
        dbInfo.driverClass = database.getHibernateConnectionDriverClass();
        return dbInfo;
    }

    public boolean onNext(WizardSettings wizardSettings) {
        return true;
    }

    @Override
    public void finish() throws Exception {
    }

    public Database getSelectedOption() {
        if (this.b.isSelected()) {
            return Database.POSTGRES;
        }
        if (this.c.isSelected()) {
            return Database.MYSQL;
        }
        if (this.d.isSelected()) {
            return Database.MS_SQL;
        }
        if (this.e.isSelected()) {
            return Database.DERBY_SERVER;
        }
        if (this.f.isSelected()) {
            return Database.DERBY_SINGLE;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = actionEvent.getSource().equals(this.a);
        this.getController().setNextEnabled(!bl);
        this.getController().setFinishEnabled(bl);
    }

    public static enum DatabaseSetupOption {
        POSTGRESQL(1, Messages.getString("ConfigureDatabasePage1.6")),
        MYSQL(2, Database.MYSQL.getProviderName()),
        MS_SQL_SERVER(3, Database.MS_SQL.getProviderName()),
        DERBY_SERVER(4, Database.DERBY_SERVER.getProviderName()),
        DERBY_SINGLE(5, Database.DERBY_SINGLE.getProviderName());

        private final int a;
        private final String b;

        private DatabaseSetupOption(int n2, String string2) {
            this.a = n2;
            this.b = string2;
        }

        public int getKey() {
            return this.a;
        }

        public String getDisplayString() {
            return this.b;
        }

        public String toString() {
            return this.b;
        }

        public static DatabaseSetupOption fromKey(int n) {
            for (DatabaseSetupOption databaseSetupOption : DatabaseSetupOption.values()) {
                if (databaseSetupOption.getKey() != n) continue;
                return databaseSetupOption;
            }
            return null;
        }
    }
}

