/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.swing.DoubleDocument;
import com.floreantpos.swing.IntegerDocument;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.StringUtils;

public class NumberSelectionView
extends TransparentPanel {
    private TitledBorder a;
    private boolean b;
    private JTextField c;
    private PosButton d;
    private PosButton e;

    public NumberSelectionView() {
        this.a();
    }

    private void a() {
        Font font = UIManager.getFont("Button.font").deriveFont((float)PosUIManager.getFontSize(32));
        this.setLayout(new BorderLayout(5, 5));
        this.c = new JTextField();
        this.c.setText("0");
        this.c.setFont(this.c.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.c.setEditable(true);
        this.c.setBackground(Color.WHITE);
        this.c.setHorizontalAlignment(4);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.c, "Center");
        this.d = new PosButton("+");
        this.d.setFont(font);
        this.d.setFocusable(false);
        jPanel.add((Component)this.d, "East");
        this.d.setPreferredSize(PosUIManager.getSize(60, 45));
        this.e = new PosButton("-");
        this.e.setPreferredSize(PosUIManager.getSize(60, 45));
        this.e.setFont(font);
        this.e.setFocusable(false);
        jPanel.add((Component)this.e, "West");
        this.add((Component)jPanel, "North");
        this.add((Component)new NumericKeypad(), "Center");
        this.a = new TitledBorder("");
        this.a.setTitleJustification(2);
        this.setBorder(this.a);
        this.buttonAction();
        this.setVisibleControlsButton(false);
    }

    public void setVisibleControlsButton(boolean bl) {
        this.d.setVisible(bl);
        this.e.setVisible(bl);
    }

    public void buttonAction() {
        try {
            this.d.addActionListener(actionEvent -> this.b());
            this.e.addActionListener(actionEvent -> this.c());
        }
        catch (NumberFormatException numberFormatException) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, numberFormatException);
        }
    }

    public void setTitle(String string) {
        this.a.setTitle(string);
    }

    public double getValue() {
        String string = this.c.getText();
        if (StringUtils.isBlank((String)string)) {
            throw new PosException(POSConstants.ENTER_AMOUNT);
        }
        return POSUtil.parseDouble(string);
    }

    public String getText() {
        return this.c.getText();
    }

    public void setValue(double d) {
        if (this.isDecimalAllowed()) {
            this.c.setText(String.valueOf(d));
        } else {
            this.c.setText(String.valueOf((int)d));
        }
    }

    public boolean isDecimalAllowed() {
        return this.b;
    }

    public void setDecimalAllowed(boolean bl) {
        this.setDecimalAllowed(bl, 16);
    }

    public void setDecimalAllowed(boolean bl, int n) {
        this.b = bl;
        if (bl) {
            this.c.setDocument(new DoubleDocument(n));
        } else {
            this.c.setDocument(new IntegerDocument(n));
        }
    }

    private void b() {
        double d;
        String string = this.c.getText();
        if (StringUtils.isNotBlank((String)string) && ((d = POSUtil.parseDouble(string)) == Math.floor(d) || !Double.isInfinite(d))) {
            this.c.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
        }
    }

    private void c() {
        double d;
        String string = this.c.getText();
        if (StringUtils.isNotBlank((String)string) && ((d = POSUtil.parseDouble(string)) == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) > 0.0) {
            this.c.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
        }
    }
}

