/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.SeatSelectionAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.TableSelectionAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.UpdatableView;
import com.floreantpos.ui.dialog.MiscTicketItemDialog;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.dialog.SalesAreaSelectionDialog;
import com.floreantpos.ui.order.CourseOrganizeDialog;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.CategoryView;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.MenuItemView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.TicketSummaryView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ProfileUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class OrderView
extends ViewPanel
implements RefreshableView,
UpdatableView,
DataChangeListener,
OrderListener,
TicketEditListener,
PaymentListener {
    private HashMap<String, JComponent> a = new HashMap();
    public static final String VIEW_NAME = "ORDER_VIEW";
    private static OrderView b;
    private Ticket c;
    private CategoryView d = new CategoryView();
    private GroupView e = new GroupView();
    private MenuItemView f = new MenuItemView();
    private TicketView g = new TicketView();
    private TransparentPanel h = new TransparentPanel(new BorderLayout(5, 5));
    private JPanel i = new JPanel(new BorderLayout());
    private TicketSummaryView j;
    private OrderController k = new OrderController(this);
    private JPanel l = new JPanel((LayoutManager)new MigLayout("fill, ins 2, hidemode 3", "fill", "fill"));
    private PosButton m = new PosButton(POSConstants.HOLD_BUTTON_TEXT);
    private PosButton n = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton o = new PosButton(POSConstants.SEND_TO_KITCHEN);
    private PosButton p = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
    private PosButton q = new PosButton(POSConstants.GUEST_NO_BUTTON_TEXT);
    private PosButton r = new PosButton(Messages.getString("OrderView.7"));
    private PosButton s = new PosButton(POSConstants.MISC_BUTTON_TEXT);
    private PosButton t = new PosButton(POSConstants.TABLE_NO_BUTTON_TEXT);
    private PosButton u = new PosButton(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
    private PosButton v = new PosButton(Messages.getString("OrderView.1"));
    private PosButton w = new PosButton("<html><center>" + POSConstants.ORGANIZE_COURSE + "</center></html>");
    private PosButton x = new PosButton(Messages.getString("OrderView.25"));
    private PosButton y = new PosButton(Messages.getString("OrderView.11"));
    private PosButton z = new PosButton(Messages.getString("OrderView.2"));
    private PosButton A = new PosButton(Messages.getString("OrderView.5"));
    private SeatSelectionAction B = new SeatSelectionAction();
    private PosButton C = new PosButton();
    private boolean D;
    private PaymentView E;

    private OrderView() {
        this.a();
        this.g.addOrderListener(this);
        this.k.addTicketUpdateListener(this);
    }

    public void addView(String string, JComponent jComponent) {
        JComponent jComponent2 = this.a.get(string);
        if (jComponent2 != null) {
            return;
        }
        this.h.add((Component)jComponent, string);
    }

    private void a() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(2, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.g);
        this.i.add(jPanel);
        this.h.setOpaque(false);
        this.h.setBorder(null);
        this.h.add((Component)this.e, "North");
        this.h.add(this.f);
        this.b();
        this.showView("VIEW_EMPTY");
    }

    private void b() {
        this.A.addActionListener(actionEvent -> this.doAddSalesArea());
        this.n.addActionListener(actionEvent -> this.m());
        this.p.addActionListener(actionEvent -> this.o());
        this.o.addActionListener(actionEvent -> this.l());
        this.v.addActionListener(actionEvent -> this.k());
        this.w.addActionListener(actionEvent -> this.e());
        this.u.addActionListener(actionEvent -> this.doAddEditCustomer());
        this.C.addActionListener(actionEvent -> this.c());
        this.x.addActionListener(actionEvent -> this.d());
        this.s.addActionListener(actionEvent -> this.doInsertMisc(actionEvent));
        this.q.addActionListener(actionEvent -> this.btnCustomerNumberActionPerformed());
        this.y.addActionListener(actionEvent -> this.doTokenNumberInputActionPerformed());
        this.B.setSource(this.r);
        this.r.setAction(this.B);
        this.t.addActionListener(new TableSelectionAction(this));
        this.m.addActionListener(actionEvent -> this.doHoldOrder());
        this.z.addActionListener(actionEvent -> this.doShowDeliveryDialog());
        this.l.add(this.C);
        this.l.add(this.u);
        this.l.add(this.x);
        this.l.add(this.z);
        this.l.add(this.t);
        this.l.add(this.y);
        this.l.add(this.q);
        this.l.add(this.r);
        this.l.add(this.A);
        this.l.add(this.w);
        this.l.add(this.s);
        this.l.add(this.m);
        this.l.add(this.o);
        this.l.add(this.v);
        this.l.add(this.p);
        this.l.add(this.n);
        this.z.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void c() {
        Serializable serializable;
        Serializable serializable2;
        if (this.c.getPaidAmount() > 0.0) {
            POSMessageDialog.showError(Messages.getString("OrderView.24"));
            return;
        }
        OrderTypeSelectionDialog orderTypeSelectionDialog = new OrderTypeSelectionDialog();
        orderTypeSelectionDialog.setSelectedOrderType(this.c.getOrderType());
        orderTypeSelectionDialog.open();
        if (orderTypeSelectionDialog.isCanceled()) {
            return;
        }
        OrderType orderType = orderTypeSelectionDialog.getSelectedOrderType();
        if (orderType.isShowTableSelection().booleanValue()) {
            serializable2 = TableSelectorFactory.createTableSelectorDialog(orderType);
            TableSelectionView tableSelectionView = ((TableSelectorDialog)serializable2).getTableSelector();
            tableSelectionView.setHomeViewMode(Boolean.FALSE);
            ((TableSelectorDialog)serializable2).setCreateNewTicket(false);
            System.setProperty("SplitedTicketSelectionDialog.createNewTicket", "false");
            ((TableSelectorDialog)serializable2).updateView(true);
            tableSelectionView.setShouldReorder(Boolean.FALSE);
            try {
                ((POSDialog)serializable2).openUndecoratedFullScreen();
                if (((POSDialog)serializable2).isCanceled()) {
                    return;
                }
            }
            finally {
                System.setProperty("SplitedTicketSelectionDialog.createNewTicket", "true");
            }
            List<ShopTable> list = ((TableSelectorDialog)serializable2).getSelectedTables();
            serializable = new ArrayList();
            for (Comparable comparable : list) {
                SalesArea salesArea = ((ShopTable)comparable).getSalesArea();
                if (salesArea != null) {
                    this.c.setSalesArea(salesArea);
                    this.c.setSalesAreaId(salesArea.getId());
                }
                serializable.add(((BaseShopTable)comparable).getId());
            }
            this.c.setTableNumbers((List<Integer>)((Object)serializable));
            this.c.setShouldUpdateTableStatus(true);
        }
        if (orderType.isRequiredCustomerData().booleanValue() && !orderType.isDelivery().booleanValue()) {
            if (this.c.getCustomer() == null) {
                serializable2 = this.a(orderType);
                if (serializable2 == null) return;
                this.c.setCustomer((Customer)serializable2);
            }
        } else if (orderType.isDelivery().booleanValue()) {
            boolean bl;
            if (this.c.getCustomer() == null) {
                serializable2 = this.a(orderType);
                if (serializable2 == null) return;
                this.c.setCustomer((Customer)serializable2);
            }
            if (!(bl = OrderServiceFactory.getOrderService().showDeliveryInfo(this.c, this.c.getOrderType(), this.c.getCustomer()))) {
                return;
            }
        }
        if (!orderType.isDelivery().booleanValue()) {
            this.c.setDeliveryCharge(0.0);
        }
        this.c.setOrderType(orderType);
        List<TicketItem> list = this.c.getTicketItems();
        for (TicketItem ticketItem : list) {
            Comparable comparable;
            serializable = orderType.isServiceChargeApplicable();
            if (((Boolean)serializable).booleanValue()) {
                ticketItem.setServiceChargeApplicable((Boolean)serializable);
                ticketItem.setServiceChargeRate(this.c.getOutletServiceChargeRate());
            } else {
                ticketItem.setServiceCharge(0.0);
                ticketItem.setServiceChargeRate(0.0);
            }
            List<TicketItemTax> list2 = ticketItem.getTaxes();
            comparable = ticketItem.getMenuItem();
            MenuItem.setItemTaxes(ticketItem, comparable == null ? null : ((MenuItem)comparable).getTaxGroup(), orderType);
        }
        OrderView.getInstance().setCurrentTicket(this.c);
        RootView.getInstance().showView(VIEW_NAME);
    }

    private Customer a(OrderType orderType) {
        CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(orderType);
        customerSelectorDialog.setCreateNewTicket(false);
        customerSelectorDialog.updateView(true);
        customerSelectorDialog.openUndecoratedFullScreen();
        if (customerSelectorDialog.isCanceled()) {
            POSMessageDialog.showError(Messages.getString("OrderView.28"));
            return null;
        }
        return customerSelectorDialog.getSelectedCustomer();
    }

    private void d() {
        String string = this.c.getNote();
        NotesDialog notesDialog = new NotesDialog();
        notesDialog.setTitle(VersionInfo.getAppName());
        notesDialog.setCaption(Messages.getString("OrderView.104"));
        notesDialog.setNote(string);
        notesDialog.setSize(PosUIManager.getSize(900, 500));
        notesDialog.open();
        if (notesDialog.isCanceled()) {
            return;
        }
        string = notesDialog.getNote();
        if (notesDialog.getNote() != null) {
            this.c.setNote(string);
        }
        this.c.addEvent("Note added", "Note: " + string);
    }

    private void e() {
        try {
            if (DataProvider.get().getCourses().isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.15"));
                return;
            }
            if (this.c.getId() != null) {
                OrderController.saveOrder(this.c);
            }
            CourseOrganizeDialog courseOrganizeDialog = new CourseOrganizeDialog(this.c);
            courseOrganizeDialog.openFullScreen();
            if (courseOrganizeDialog.isCanceled()) {
                this.refresh();
                return;
            }
            OrderView.getInstance().setCurrentTicket(courseOrganizeDialog.getTicket());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doShowDeliveryDialog() {
        try {
            Customer customer = CustomerDAO.getInstance().findById(this.c.getCustomerId());
            boolean bl = OrderServiceFactory.getOrderService().showDeliveryInfo(this.c, this.c.getOrderType(), customer);
            if (!bl) {
                return;
            }
            this.f();
            if (this.g != null) {
                this.g.updateView();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doAddSalesArea() {
        try {
            SalesAreaSelectionDialog salesAreaSelectionDialog = new SalesAreaSelectionDialog();
            salesAreaSelectionDialog.open();
            if (salesAreaSelectionDialog.isCanceled()) {
                return;
            }
            SalesArea salesArea = salesAreaSelectionDialog.getSelectedSalesArea();
            this.setFocusable(true);
            SalesArea salesArea2 = this.c.getSalesArea();
            this.c.setSalesArea(salesArea);
            this.c.setSalesAreaId(salesArea.getId());
            this.c.updateTicketItemsPrice();
            this.A.setText("<html><center>" + POSConstants.SALES_AREA + "<br/>" + salesArea.getName() + "</center></html>");
            this.g.updateView();
            this.a(salesArea, salesArea2);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(SalesArea salesArea, SalesArea salesArea2) {
        String string = "Sales area change";
        String string2 = "";
        if (salesArea2 == null) {
            string = "Sales area added";
            string2 = String.format("Sales id : %s, Sales area name: %s", salesArea.getId(), salesArea.getName());
        } else {
            string2 = String.format("Sales id : %s, Updated sales area name : %s", salesArea.getId(), salesArea.getName());
        }
        this.c.addEvent(string, string2);
    }

    protected void btnCustomerNumberActionPerformed() {
        try {
            Ticket ticket = this.c;
            int n = ticket.getNumberOfGuests();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(5);
            numberSelectionDialog2.setCaption(POSConstants.NUMBER_OF_GUESTS);
            numberSelectionDialog2.setValue(n);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            n = (int)numberSelectionDialog2.getValue();
            if (n == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.GUEST_NUMBER_CANNOT_BE_0);
                return;
            }
            ticket.setNumberOfGuests(n);
            this.updateView();
            ticket.addEvent("Guest number updated", " Guest number updated to " + n);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doTokenNumberInputActionPerformed() {
        try {
            Ticket ticket = this.c;
            int n = ticket.getTokenNo();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(5);
            numberSelectionDialog2.setCaption(Messages.getString("EnterTokenNo"));
            numberSelectionDialog2.setControlButtonsVisible(false);
            numberSelectionDialog2.setValue(n);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            n = (int)numberSelectionDialog2.getValue();
            ticket.setTokenNo(n);
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doInsertMisc(ActionEvent actionEvent) {
        try {
            MiscTicketItemDialog miscTicketItemDialog = new MiscTicketItemDialog();
            OrderType orderType = this.c.getOrderType();
            miscTicketItemDialog.setOrderType(orderType);
            miscTicketItemDialog.pack();
            miscTicketItemDialog.open();
            if (!miscTicketItemDialog.isCanceled()) {
                TicketItem ticketItem = miscTicketItemDialog.getTicketItem();
                Boolean bl = orderType.isServiceChargeApplicable();
                if (bl.booleanValue()) {
                    ticketItem.setServiceChargeApplicable(bl);
                    ticketItem.setServiceChargeRate(this.c.getOutletServiceChargeRate());
                } else {
                    ticketItem.setServiceChargeRate(0.0);
                }
                ticketItem.setTicket(this.c);
                ticketItem.calculatePrice();
                this.g.addTicketItem(ticketItem);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddEditCustomer() {
        try {
            Serializable serializable;
            if (StringUtils.isNotBlank((String)this.c.getCustomerId()) && (serializable = this.c.getItemWithRequiredCustomer()) != null) {
                throw new PosException(Messages.getString("OrderView.30") + " " + ((BaseTicketItem)serializable).getName() + " " + Messages.getString("OrderView.31"));
            }
            DataProvider.get().setTicketToBeCreated(this.getCurrentTicket());
            serializable = CustomerSelectorFactory.createCustomerSelectorDialog(this.c.getOrderType(), Boolean.FALSE);
            ((CustomerSelectorDialog)serializable).setCreateNewTicket(false);
            ((CustomerSelectorDialog)serializable).updateView(true);
            if (this.c.getPaidAmount() > 0.0 && StringUtils.isNotEmpty((String)this.c.getCustomerName())) {
                throw new PosException(Messages.getString("OrderView.22"));
            }
            ((CustomerSelectorDialog)serializable).setTicket(this.c);
            ((POSDialog)serializable).openUndecoratedFullScreen();
            if (!((POSDialog)serializable).isCanceled()) {
                Customer customer = ((CustomerSelectorDialog)serializable).getSelectedCustomer();
                CustomerDAO.getInstance().refresh(customer);
                this.c.setCustomer(customer, true);
                if (customer != null) {
                    String string = this.a(this.c.getCustomer());
                    String string2 = "<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + string + "</center></html>";
                    this.u.setText(string2);
                }
                this.g.updateView();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            DataProvider.get().setTicketToBeCreated(null);
        }
    }

    private String a(Customer customer) {
        String string = "";
        if (customer != null) {
            OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderServiceExtension != null && ProfileUtil.shouldDisplayClubposSfControls()) {
                return orderServiceExtension.getCustomerName(customer);
            }
            string = customer.getName();
            if (StringUtils.isEmpty((String)string)) {
                string = "";
            }
        } else {
            string = this.c.getCustomerNameByProperty();
        }
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        return string;
    }

    protected void addDiscount() {
        try {
            ITicketItem iTicketItem = this.g.getTicketViewerTable().getSelected();
            if (!(iTicketItem instanceof TicketItem)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.20"));
                return;
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void updateView() {
        Terminal terminal = Application.getInstance().getTerminal();
        this.s.setVisible(!DataProvider.get().getStore().getBooleanProperty("hide_misc_button.in_order", false));
        if (this.c != null) {
            Object object;
            Object object2;
            OrderType orderType = this.c.getOrderType();
            this.b(orderType);
            this.n.setVisible(orderType.isPrepaid() == false);
            this.o.setVisible(orderType.isPrepaid() == false && orderType.isShouldPrintToKitchen() != false);
            if (!orderType.isAllowSeatBasedOrder().booleanValue() || !orderType.isShowTableSelection().booleanValue()) {
                this.r.setVisible(false);
            } else {
                this.r.setVisible(true);
                object2 = null;
                object = this.B.getLastSeat(this.c);
                if (object instanceof Integer) {
                    object2 = (Integer)object;
                    this.r.putClientProperty("SEAT_NO", object2);
                } else if (object instanceof TicketItemSeat) {
                    TicketItemSeat ticketItemSeat = (TicketItemSeat)this.B.getLastSeat(this.c);
                    this.r.putClientProperty("SEAT_NO", ticketItemSeat);
                }
            }
            if (!orderType.isShowGuestSelection().booleanValue()) {
                this.q.setVisible(false);
            } else {
                this.q.setVisible(true);
                this.q.setText(Messages.getString("OrderView.27") + ": " + String.valueOf(this.c.getNumberOfGuests()));
            }
            if (!orderType.isShowTableSelection().booleanValue()) {
                this.t.setVisible(false);
            } else {
                this.t.setVisible(true);
                this.t.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.c.getTableNameOrNumberDisplay() + "</center><html/>");
            }
            if (orderType.isEnableReorder().booleanValue()) {
                this.v.setVisible(true);
            } else {
                this.v.setVisible(false);
            }
            this.w.setVisible(orderType.isEnableCourse());
            object2 = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (object2 != null && orderType.isDelivery().booleanValue() && orderType.isRequiredCustomerData().booleanValue()) {
                this.z.setVisible(true);
            }
            if (orderType.isRetailOrder().booleanValue()) {
                this.g();
                this.d(orderType);
            }
            if (this.c.getSalesArea() != null) {
                object = this.c.getSalesArea().getName();
                this.A.setText("<html><center>" + Messages.getString("OrderView.38") + "<br>" + (String)object + "</center><html/>");
            } else if (this.c.getId() != null) {
                this.A.setText(Messages.getString("OrderView.41"));
            } else {
                object = terminal.getSalesArea();
                if (object != null) {
                    this.A.setText("<html><center>" + Messages.getString("OrderView.42") + "<br>" + ((BaseSalesArea)object).getName() + "</center><html/>");
                } else {
                    this.A.setText(Messages.getString("OrderView.41"));
                }
                if (terminal.isFixedSalesArea().booleanValue()) {
                    this.A.setEnabled(false);
                } else {
                    this.A.setEnabled(true);
                }
            }
            this.f();
            this.C.setText(this.c.getOrderType().getName());
        }
    }

    private void f() {
        String string = this.a(this.c.getCustomer());
        String string2 = "<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + string + "</center></html>";
        this.u.setText(string2);
    }

    private void b(OrderType orderType) {
        boolean bl = POSUtil.getBoolean(orderType.getProperty("TokenManualInput"));
        this.y.setVisible(bl);
        if (bl) {
            this.y.setText("Token: " + String.valueOf(this.c.getTokenNo()));
        }
        this.y.setEnabled(this.c.getId() == null);
    }

    public void showView(String string) {
    }

    public CategoryView getCategoryView() {
        return this.d;
    }

    public void setCategoryView(CategoryView categoryView) {
        this.d = categoryView;
    }

    public GroupView getGroupView() {
        return this.e;
    }

    public void setGroupView(GroupView groupView) {
        this.e = groupView;
    }

    public MenuItemView getItemView() {
        return this.f;
    }

    public void setItemView(MenuItemView menuItemView) {
        this.f = menuItemView;
    }

    public TicketView getTicketView() {
        return this.g;
    }

    public void setTicketView(TicketView ticketView) {
        this.g = ticketView;
    }

    public OrderController getOrderController() {
        return this.k;
    }

    public Ticket getCurrentTicket() {
        return this.c;
    }

    private void c(OrderType orderType) {
        if (orderType.isRetailOrder().booleanValue()) {
            this.d(orderType);
        } else {
            this.i();
        }
        this.revalidate();
        this.repaint();
    }

    private void g() {
        this.n.setVisible(false);
        this.p.setVisible(false);
        this.z.setVisible(false);
        this.q.setVisible(false);
        this.v.setVisible(false);
        this.A.setVisible(false);
        this.r.setVisible(false);
        this.t.setVisible(false);
        this.o.setVisible(false);
        this.m.setVisible(false);
        this.C.setVisible(false);
    }

    private void h() {
        this.n.setVisible(true);
        this.p.setVisible(true);
        this.q.setVisible(true);
        this.m.setVisible(true);
        this.s.setVisible(true);
        this.A.setVisible(true);
        this.r.setVisible(true);
        this.o.setVisible(true);
        this.t.setVisible(true);
        this.C.setVisible(true);
    }

    private void d(OrderType orderType) {
        this.removeAll();
        if (this.j == null) {
            this.j = new TicketSummaryView(this);
            this.g.getParent().add((Component)this.j, "South");
        }
        if (this.E == null) {
            SettleTicketProcessor settleTicketProcessor = new SettleTicketProcessor(Application.getCurrentUser(), this);
            settleTicketProcessor.addPaymentListener(this);
            this.E = new PaymentView(settleTicketProcessor, this);
        } else {
            this.E.getTicketProcessor().setCurrentUser(Application.getCurrentUser());
        }
        this.g.showSettleButton(false);
        this.j.setVisible(true);
        this.j.setTicket(this.g.getTicket());
        this.j.setPaymentView(this.E);
        this.i.add((Component)this.l, "South");
        this.add((Component)this.i, "Center");
        this.add((Component)this.E, "East");
        if (orderType.isQuickMenuEnable()) {
            this.f.setPreferredSize(PosUIManager.getSize(190, 100));
            this.add((Component)this.f, "West");
            SwingUtilities.invokeLater(() -> this.f.setQuickMenus(MenuItemDAO.getInstance().getMenuItemByIDs(orderType.getQuickMenuIds())));
        }
    }

    private void i() {
        this.removeAll();
        this.h();
        if (this.j != null) {
            this.j.setVisible(false);
        }
        this.g.showSettleButton(true);
        boolean bl = DataProvider.get().getStore().getBooleanProperty("order_view.ticket_on_right", false);
        if (!bl) {
            this.add((Component)this.d, "East");
            this.add((Component)this.i, "West");
        } else {
            this.add((Component)this.d, "West");
            this.add((Component)this.i, "East");
        }
        this.h.add(this.f);
        this.add((Component)this.h, "Center");
        this.add((Component)this.l, "South");
    }

    public void setCurrentTicket(Ticket ticket) {
        if (this.c != null && this.c != ticket) {
            this.k.fireTicketEditingFinish(this.c);
        }
        if (this.c != null && ticket != null) {
            OrderType orderType = this.c.getOrderType();
            OrderType orderType2 = ticket.getOrderType();
            if (orderType2 == null) {
                throw new PosException(Messages.getString("OrderView.55"));
            }
            if (orderType != null && !orderType.equals(orderType2)) {
                this.c = ticket;
                this.c(orderType2);
            }
        } else if (this.c == null && ticket != null) {
            OrderType orderType = ticket.getOrderType();
            if (orderType == null) {
                throw new PosException(Messages.getString("OrderView.55"));
            }
            this.c(orderType);
        }
        this.c = ticket;
        this.g.setTicket(ticket);
        if (this.j != null) {
            this.j.setTicket(this.c);
        }
        if (this.E != null) {
            this.E.setTicket(ticket);
        }
        this.updateView();
        this.k.fireTicketEditingStart(ticket);
    }

    public static synchronized OrderView getInstance() {
        if (b == null) {
            b = new OrderView();
        }
        return b;
    }

    public void resetView() {
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.j();
            this.g.setVisible(true);
        } else {
            this.g.setVisible(false);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), Messages.getString("OrderView.48"));
            }
        }
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    private void j() {
        Ticket ticket = this.getTicketView().getTicket();
        if (ticket != null && ticket.getOrderType() != null && ticket.getOrderType().isRetailOrder().booleanValue()) {
            if (this.E != null) {
                this.E.getTicketProcessor().setCurrentUser(Application.getCurrentUser());
            }
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderView.this.d.initialize();
                }
                catch (Throwable throwable) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
    }

    public void doHoldOrder() {
        try {
            this.doHoldOrder(true);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doHoldOrder(boolean bl) {
        this.c.validateTicketBeforeSave();
        this.g.doHoldOrder(bl);
        this.g.setAllowToLogOut(true);
        this.k.fireTicketEditingFinish(this.c);
    }

    private void k() {
        try {
            Ticket ticket = this.g.getTicket();
            Ticket ticket2 = Ticket.clone(ticket);
            List<TicketItem> list = ticket2.getTicketItems();
            if (list == null || list.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            if (ticket2.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            ReorderDialog reorderDialog = new ReorderDialog(ticket2);
            reorderDialog.setTitle(Messages.getString("OrderView.51"));
            reorderDialog.setDefaultCloseOperation(2);
            reorderDialog.setResizable(false);
            reorderDialog.openFullScreen();
            if (!reorderDialog.isCanceled()) {
                List<TicketItem> list2 = reorderDialog.getTicketItems();
                if (list2 == null || list2.isEmpty()) {
                    return;
                }
                for (TicketItem ticketItem : list2) {
                    this.g.addTicketItem(ticketItem);
                    this.a(ticketItem);
                }
                OrderController.saveOrder(this.g.getTicket());
                this.g.sendTicketToKitchen();
                this.g.getTicketViewerTable().repaint();
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(TicketItem ticketItem) {
        String string = StringUtils.isBlank((String)this.c.getId()) ? " " : "Ticket id :" + this.c.getId();
        string = string + (StringUtils.isBlank((String)ticketItem.getId()) ? " " : "Reorder item id :" + ticketItem.getId());
        String string2 = ticketItem.getNameDisplay();
        string = string + (StringUtils.isBlank((String)string2) ? " " : "Reorder item name :" + string2.replaceAll("\n --", ", "));
        this.c.addRandomEvent("Item reordered", string);
        if (ticketItem.isHasModifiers().booleanValue()) {
            List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
            for (TicketItemModifier ticketItemModifier : list) {
                String string3 = ticketItemModifier.getNameDisplay();
                String string4 = "Reorder modifier name: " + string3.replaceAll("--", "").trim();
                string4 = string4 + (StringUtils.isBlank((String)ticketItemModifier.getId()) ? " " : " ,Reorder modifier id: " + ticketItemModifier.getId());
                this.c.addRandomEvent("Modifier item reordered", string4);
            }
        }
    }

    private void l() {
        try {
            Ticket ticket = this.getCurrentTicket();
            boolean bl = ticket.isKitchenPrintable();
            if (!bl) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.333"));
                return;
            }
            ticket.validateTicketBeforeSave();
            OrderController.saveOrder(ticket);
            new SendToKitchenAction(this).actionPerformed(null);
            this.g.updateTicketTitle();
            this.g.getTicketViewerTable().updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket ticket = this.getCurrentTicket();
        if (ticket.getOrderType() != null && ticket.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            return this.B.getSelectedSeatNumber();
        }
        return null;
    }

    public boolean updateSeat(TicketItem ticketItem) {
        return this.B.updateSeatNumber(ticketItem);
    }

    public boolean is_86Mode() {
        return this.D;
    }

    public void set_86Mode(boolean bl) {
        this.D = bl;
    }

    @Override
    public void paymentDone() {
        try {
            if (this.c.isVoided().booleanValue()) {
                this.g.doVoidOrder();
            } else {
                this.g.doFinishOrder();
            }
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void paymentCanceled() {
        if (this.c == null) {
            return;
        }
        this.c.getTicketItems().clear();
        this.g.doCancelOrder();
        this.updateView();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
        if (this.getCurrentTicket().getOrderType().isRetailOrder().booleanValue()) {
            this.j.updateView();
            this.E.updateView();
        }
    }

    @Override
    public void discountUpdated() {
        this.g.setTicket(this.c);
        this.j.updateView();
        this.E.updateView();
        this.g.getTicketViewerTable().fireTicketEdited(this.c);
    }

    @Override
    public void gratuityUpdated() {
        this.g.setTicket(this.c);
        this.j.updateView();
        this.E.updateView();
        this.g.getTicketViewerTable().fireTicketEdited(this.c);
    }

    public PaymentView getPaymentView() {
        return this.E;
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem iTicketItem) {
        if (ticket.getOrderType().isRetailOrder().booleanValue()) {
            ticket.calculatePrice();
            this.j.updateView();
            this.E.updateView();
        }
    }

    @Override
    public void itemRemoved(ITicketItem iTicketItem) {
        if (this.c.getOrderType().isRetailOrder().booleanValue()) {
            this.g.updateView();
            this.j.updateView();
            this.E.updateView();
        }
    }

    @Override
    public void refresh() {
        if (this.c != null && this.c.getId() != null) {
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.c.getId());
            if (ticket != null && ticket.getVersion() != this.c.getVersion()) {
                this.setCurrentTicket(ticket);
            }
        } else {
            this.setCurrentTicket(this.c);
        }
    }

    @Override
    public void dataAdded(Object object) {
    }

    @Override
    public void dataChanged(Object object) {
    }

    @Override
    public void dataRemoved(Object object) {
    }

    @Override
    public Object getSelectedData() {
        return this.getCurrentTicket();
    }

    @Override
    public void dataSetUpdated() {
    }

    @Override
    public void dataChangeCanceled(Object object) {
    }

    private void m() {
        try {
            this.c.validateTicketBeforeSave();
            this.c.setShouldUpdateStock(true);
            this.c.closeIfApplicable();
            String string = StringUtils.isBlank((String)this.c.getId()) ? " " : "Ticket id :" + this.c.getId();
            this.c.addEvent("Done order", string);
            this.g.doFinishOrder();
            this.k.fireTicketEditingFinish(this.c);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            this.c.setShouldUpdateStock(false);
        }
    }

    @Override
    public void payOrderSelected(Ticket ticket) {
        this.n();
    }

    private void n() {
        try {
            this.c.validateTicketBeforeSave();
            SettleTicketAction settleTicketAction = new SettleTicketAction(this.c);
            boolean bl = settleTicketAction.hasPermission(Application.getCurrentUser(), UserPermission.SETTLE_TICKET);
            if (!bl) {
                return;
            }
            if (settleTicketAction.performSettle()) {
                RootView.getInstance().showDefaultView();
            } else {
                this.setCurrentTicket(this.c);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void o() {
        if (this.g.isCancelable()) {
            this.g.doCancelOrder();
            this.k.fireTicketEditingFinish(this.c);
            return;
        }
        POSMessageDialog.showError(Messages.getString("OrderView.4"));
    }
}

