/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.TaxExemptAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.UpdatableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTableChangeListener;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class TicketSummaryView
extends JPanel
implements RefreshableView,
TicketViewerTableChangeListener {
    private Ticket a;
    private JTextField b;
    private JTextField c;
    private JLabel d;
    private JTextField e;
    private JTextField f;
    private JTextField g;
    private JButton h;
    private JLabel i;
    private JTextField j;
    private JTextField k;
    private JLabel l;
    private JTextField m = new JTextField();
    private JTextField n = new JTextField();
    private PaymentView o;
    private JPanel p;
    private JTable q;
    private TicketDiscountTableModel r;
    private JPanel s;
    private JTable t;
    private TransactionDataTableModel u;
    private UpdatableView v;

    public TicketSummaryView(UpdatableView updatableView) {
        this.v = updatableView;
        this.a();
        this.c();
        this.d();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.b(), "East");
        this.createTicketDiscountPanel();
        this.createTransactionListPanel();
    }

    private JPanel b() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.b = new JTextField(10);
        this.b.setHorizontalAlignment(11);
        this.b.setEditable(false);
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.c = new JTextField(10);
        this.c.setHorizontalAlignment(11);
        this.c.setEditable(false);
        this.d = new JLabel();
        this.d.setHorizontalAlignment(4);
        this.d.setText(Messages.getString("SettleTicketDialog.2") + " " + CurrencyUtil.getCurrencySymbol());
        this.e = new JTextField(10);
        this.e.setEditable(false);
        this.e.setHorizontalAlignment(11);
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("Delivery Charge: " + CurrencyUtil.getCurrencySymbol());
        this.f = new JTextField(10);
        this.f.setHorizontalAlignment(11);
        this.f.setEditable(false);
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.g = new JTextField(10);
        this.g.setEditable(false);
        this.g.setHorizontalAlignment(11);
        this.h = new JButton();
        this.h.setVisible(false);
        this.h.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
        this.h.addActionListener(actionEvent -> this.f());
        this.i = new JLabel();
        this.i.setHorizontalAlignment(4);
        this.i.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.j = new JTextField(10);
        this.j.setEditable(false);
        this.j.setHorizontalAlignment(11);
        JLabel jLabel5 = new JLabel();
        jLabel5.setFont(jLabel5.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.k = new JTextField(10);
        this.k.setFont(this.k.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.k.setHorizontalAlignment(11);
        this.k.setEditable(false);
        this.n.setHorizontalAlignment(11);
        this.n.setEditable(false);
        this.m.setEditable(false);
        this.m.setHorizontalAlignment(11);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx,hidemode 3,ins 2 10 3 2,alignx trailing", "[grow]2[]", ""));
        transparentPanel.add((Component)jLabel, "growx,aligny center");
        transparentPanel.add((Component)this.b, "growx,aligny center");
        transparentPanel.add((Component)jLabel2, "newline,growx,aligny center");
        transparentPanel.add((Component)this.c, "growx,aligny center");
        transparentPanel.add((Component)this.d, "newline,growx,aligny center");
        transparentPanel.add((Component)this.e, "growx,aligny center");
        transparentPanel.add((Component)jLabel4, "newline,growx,aligny center");
        transparentPanel.add((Component)this.h, "growx,aligny center,split 2");
        transparentPanel.add((Component)this.g, "growx,aligny center");
        transparentPanel.add((Component)this.i, "newline,growx,aligny center");
        transparentPanel.add((Component)this.j, "growx,aligny center");
        transparentPanel.add((Component)jLabel5, "newline,growx,aligny center");
        transparentPanel.add((Component)this.k, "growx,aligny center");
        transparentPanel.add((Component)new JLabel(Messages.getString("SettleTicketDialog.36") + CurrencyUtil.getCurrencySymbol(), 11), "newline,growx,aligny center");
        transparentPanel.add((Component)this.n, "growx,aligny center");
        this.l = new JLabel(Messages.getString("SettleTicketDialog.37") + CurrencyUtil.getCurrencySymbol(), 11);
        transparentPanel.add((Component)this.l, "newline,growx,aligny center");
        transparentPanel.add((Component)this.m, "growx,aligny center");
        return transparentPanel;
    }

    public void createTicketDiscountPanel() {
        this.p = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 2 0 0 0"));
        this.q = new JTable();
        this.q.setGridColor(Color.LIGHT_GRAY);
        this.q.setCellSelectionEnabled(false);
        this.q.setColumnSelectionAllowed(false);
        this.q.setRowSelectionAllowed(false);
        this.q.setAutoscrolls(true);
        this.q.setRowHeight(PosUIManager.getSize(40));
        this.q.setShowGrid(true);
        this.q.setFocusable(false);
        this.q.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.q.getTableHeader().setVisible(false);
        this.q.setAutoResizeMode(4);
        this.r = new TicketDiscountTableModel();
        this.q.setModel(this.r);
        this.q.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                this.setHorizontalAlignment(4);
                if (bl) {
                    return component;
                }
                component.setBackground(jTable.getBackground());
                return component;
            }

            @Override
            protected void setValue(Object object) {
                if (object == null) {
                    this.setText("");
                    return;
                }
                String string = object.toString();
                if (object instanceof Double || object instanceof Float) {
                    string = NumberUtil.formatNumberAcceptNegative(((Number)object).doubleValue());
                }
                this.setText(string);
            }
        });
        this.a(1, PosUIManager.getSize(50), this.q);
        this.a(2, PosUIManager.getSize(175), this.q);
        this.q.removeColumn(this.q.getColumnModel().getColumn(1));
        JScrollPane jScrollPane = new JScrollPane(this.q);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        this.p.add((Component)jScrollPane, "newline,grow,span");
        jScrollPane.setPreferredSize(PosUIManager.getSize(0, 70));
        this.p.setBorder(BorderFactory.createTitledBorder(new EmptyBorder(0, 0, 0, 0), Messages.getString("SettleTicketDialog.30")));
        this.add((Component)this.p, "North");
    }

    private void c() {
        List<TicketDiscount> list = null;
        if (this.a != null) {
            list = this.a.getDiscounts();
        }
        this.r.setRows(list);
        this.p.setVisible(list != null && list.size() > 0);
        this.revalidate();
        this.repaint();
    }

    private void a(int n, int n2, JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    public void createTransactionListPanel() {
        this.s = new JPanel(new BorderLayout());
        this.t = new JTable();
        this.t.setGridColor(Color.LIGHT_GRAY);
        this.t.setCellSelectionEnabled(false);
        this.t.setColumnSelectionAllowed(false);
        this.t.setRowSelectionAllowed(false);
        this.t.setAutoscrolls(true);
        this.t.setRowHeight(PosUIManager.getSize(40));
        this.t.setShowVerticalLines(false);
        this.t.setIntercellSpacing(new Dimension(0, 2));
        this.t.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.t.setFocusable(false);
        this.t.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.t.getTableHeader().setVisible(false);
        this.t.setAutoResizeMode(4);
        this.u = new TransactionDataTableModel();
        this.t.setModel(this.u);
        this.a(1, PosUIManager.getSize(50), this.t);
        this.e();
        PosScrollPane posScrollPane = new PosScrollPane(this.t);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("SettleTicketDialog.24")), BorderFactory.createEmptyBorder(0, 5, 0, 5));
        posScrollPane.setBorder(compoundBorder);
        posScrollPane.setPreferredSize(PosUIManager.getSize(0, 130));
        this.s.add(posScrollPane);
        this.s.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 150));
        this.add(this.s);
    }

    private void d() {
        Set<PosTransaction> set = null;
        if (this.a != null) {
            set = this.a.getTransactions();
        }
        if (set == null || set.size() == 0) {
            this.s.setVisible(false);
            return;
        }
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        for (PosTransaction posTransaction : set) {
            if (posTransaction.isVoided().booleanValue() || posTransaction instanceof RefundTransaction) continue;
            arrayList.add(posTransaction);
        }
        Collections.sort(arrayList, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                return posTransaction.getTransactionTime().compareTo(posTransaction2.getTransactionTime());
            }
        });
        this.u.setRows(arrayList);
        this.s.setVisible(arrayList.size() > 0);
        this.revalidate();
        this.repaint();
    }

    private void e() {
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                PosTransaction posTransaction = (PosTransaction)TicketSummaryView.this.u.getRowData(this.a);
                if (posTransaction == null) {
                    return;
                }
                TicketSummaryView.this.a(posTransaction);
            }
        };
        posAction.setRequiredPermission(UserPermission.VOID_PAYMENTS);
        ButtonColumn buttonColumn = new ButtonColumn(this.t, posAction, 1){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                posButton.setText("X");
                posButton.setHorizontalAlignment(0);
                jTable.setRowHeight(n, jTable.getRowHeight(0));
                return posButton;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.t.getBackground());
        PosButton posButton = new PosButton();
        buttonColumn.setUnselectedBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
        buttonColumn.setFocusBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
    }

    private void f() {
        try {
            if (this.a.getPaidAmount() > 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CANNOT_CHENGED_TAX_EXAMPT"));
                return;
            }
            Boolean bl = this.a.isTaxExempt();
            String string = bl != false ? Messages.getString("SettleTicketDialog.19") : Messages.getString("SettleTicketDialog.4");
            int n = POSMessageDialog.showYesNoQuestionDialog(null, string, POSConstants.CONFIRM);
            if (n != 0) {
                return;
            }
            new TaxExemptAction(this.a, this.v, this.o).actionPerformed(null);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void a(final PosTransaction posTransaction) {
        if (this.a.isRefunded().booleanValue()) {
            POSMessageDialog.showError(this, Messages.getString("SettleTicketDialog.25"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.26"), POSConstants.CONFIRM) != 0) {
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketDialog.18"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                String string = POSConstants.CHECK + "#:" + TicketSummaryView.this.a.getId() + "," + Messages.getString("voided_payment") + posTransaction.getId() + "," + Messages.getString("voided_amount") + posTransaction.getAmount() + "," + Messages.getString("transaction_type") + posTransaction.buildPaymentTypeDisplayName();
                TicketSummaryView.this.a.addEvent("Void payment", string);
                TicketDAO.getInstance().reversePayment(TicketSummaryView.this.a, posTransaction);
                return null;
            }

            @Override
            protected void done() {
                try {
                    busyDialog.dispose();
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.27"));
                    TicketSummaryView.this.ticketDataChanged();
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        TicketSummaryView.this.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    public void updateView() {
        if (this.a == null) {
            this.b.setText("");
            this.c.setText("");
            this.e.setText("");
            this.f.setText("");
            this.g.setText("");
            this.k.setText("");
            this.j.setText("");
            this.m.setText("");
            this.n.setText("");
            return;
        }
        this.b.setText(NumberUtil.formatNumber(this.a.getSubtotalAmount()));
        this.c.setText(NumberUtil.formatNumber(this.a.getDiscountAmount()));
        Double d = this.a.getServiceCharge();
        this.e.setText(NumberUtil.formatNumber(d));
        this.f.setText(NumberUtil.formatNumber(this.a.getDeliveryCharge()));
        Store store = DataProvider.get().getStore();
        if (POSUtil.getBoolean(store.getProperty("show_tax_exempt_button.in_settlement_screen"))) {
            this.h.setVisible(Boolean.TRUE);
            if (this.a.isTaxExempt().booleanValue()) {
                this.h.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.UNDO, (float)15.0f));
            } else {
                this.h.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
            }
        } else {
            this.h.setVisible(Boolean.FALSE);
        }
        if (Application.getInstance().isPriceIncludesTax()) {
            this.g.setText(Messages.getString("TicketView.35"));
        } else {
            this.g.setText(NumberUtil.formatNumber(this.a.getTaxAmount()));
        }
        Double d2 = 0.0;
        if (this.a.getGratuity() != null) {
            d2 = this.a.getGratuity().getAmount();
            this.j.setText(NumberUtil.formatNumber(d2));
        } else {
            this.j.setText("0.00");
        }
        this.k.setText(NumberUtil.formatNumber(this.a.getTotalAmountWithTips()));
        this.n.setText(NumberUtil.formatNumber(this.a.getPaidAmount()));
        Double d3 = this.a.getRefundAmount();
        this.m.setText(NumberUtil.formatNumber(d3));
        this.d.setVisible(d > 0.0);
        this.e.setVisible(d > 0.0);
        this.i.setVisible(d2 > 0.0);
        this.j.setVisible(d2 > 0.0);
        this.l.setVisible(d3 > 0.0);
        this.m.setVisible(d3 > 0.0);
        this.c();
        this.d();
    }

    @Override
    public void refresh() {
        Ticket ticket;
        this.a = ticket = TicketDAO.getInstance().loadFullTicket(this.a.getId());
        this.ticketDataChanged();
    }

    @Override
    public void ticketDataChanged() {
        this.a.calculatePrice();
        this.updateView();
        this.o.updateView();
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
        this.updateView();
    }

    public void setPaymentView(PaymentView paymentView) {
        this.o = paymentView;
    }

    private class TransactionDataTableModel
    extends ListTableModel<PosTransaction> {
        public TransactionDataTableModel() {
            super(new String[]{"Payment", "Void"});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
            switch (n2) {
                case 0: {
                    Object object;
                    String string = " ";
                    if (posTransaction instanceof CustomPaymentTransaction) {
                        object = (CustomPaymentTransaction)posTransaction;
                        string = string + object.getCustomPaymentName();
                    } else {
                        string = string + (Object)((Object)posTransaction.getPaymentType());
                        object = posTransaction.getPaymentType();
                        if ((object == PaymentType.CREDIT_CARD || object == PaymentType.DEBIT_CARD) && StringUtils.isNotBlank((String)posTransaction.getCardNumber())) {
                            string = string + " [" + posTransaction.getCardNumber().replace("X", "") + "]";
                        }
                    }
                    object = posTransaction.getAmount();
                    if (posTransaction instanceof RefundTransaction) {
                        object = (Double)object * -1.0;
                    }
                    string = string + "   " + NumberUtil.getCurrencyFormat(object);
                    return string;
                }
                case 1: {
                    return "X";
                }
            }
            return null;
        }
    }

    public class TicketDiscountTableModel
    extends ListTableModel<TicketDiscount> {
        public TicketDiscountTableModel() {
            super(new String[]{"name", "qty", "subtotal"});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketDiscount ticketDiscount = (TicketDiscount)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return ticketDiscount.getNameDisplay();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return -ticketDiscount.getTotalDiscountAmount().doubleValue();
                }
            }
            return null;
        }
    }
}

