/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import org.apache.commons.lang.StringUtils;

public enum CashRoundingRule {
    _NOROUNDING("No Rounding", ""),
    _05Interval("Rounding with 0.05 interval", "Exp: 1.02 will be rounded to 1.00, 1.06 will be rounded to 1.05"),
    _10Interval("Rounding with 0.10 interval", "Exp: 1.02 will be rounded to 1.0, 1.06 will be rounded to 1.1"),
    _25Interval("Rounding with 0.25 interval", "Exp: 1.02 will be rounded to 1.00, 1.26 will be rounded to 1.25"),
    _50Interval("Rounding with 0.50 interval", "Exp: 1.02 will be rounded to 1.00, 1.26 will be rounded to 1.5"),
    _1Interval("Rounding with  1.0 interval", "Exp: 1.02 will be rounded to 1.0, 1.5 will be rounded to 2.0");

    private String a;
    private String b;

    private CashRoundingRule(String string2, String string3) {
        this.a = string2;
        this.b = string3;
    }

    public String getDisplayString() {
        return this.a;
    }

    public String getExampleString() {
        return this.b;
    }

    public static CashRoundingRule fromDisplayString(String string) {
        CashRoundingRule[] cashRoundingRuleArray;
        for (CashRoundingRule cashRoundingRule : cashRoundingRuleArray = CashRoundingRule.values()) {
            if (!cashRoundingRule.getDisplayString().equals(string)) continue;
            return cashRoundingRule;
        }
        return _NOROUNDING;
    }

    public static double round(CashRoundingRule cashRoundingRule, double d) {
        switch (cashRoundingRule) {
            case _10Interval: {
                return CashRoundingRule.tenCentRound(d);
            }
            case _05Interval: {
                return CashRoundingRule.fiveCentRound(d);
            }
            case _25Interval: {
                return CashRoundingRule.twentyFiveCentRound(d);
            }
            case _50Interval: {
                return CashRoundingRule.fiftyCentRound(d);
            }
            case _1Interval: {
                return CashRoundingRule.fullRound(d);
            }
        }
        return d;
    }

    public static double fiveCentRound(double d) {
        return (double)Math.round(d * 100.0 / 5.0) * 5.0 / 100.0;
    }

    public static double tenCentRound(double d) {
        return (double)Math.round(d * 10.0) / 10.0;
    }

    public static double twentyFiveCentRound(double d) {
        return (double)Math.round(d * 4.0) / 4.0;
    }

    public static double fiftyCentRound(double d) {
        return (double)Math.round(d * 2.0) / 2.0;
    }

    public static double fullRound(double d) {
        return Math.round(d);
    }

    public String toString() {
        if (StringUtils.isBlank((String)this.b)) {
            return this.a;
        }
        return this.a + " (" + this.b + ")";
    }
}

