/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import validation.ValidationCombobox;

public class MenuItemUtil {
    public static void populateGroup(ValidationCombobox validationCombobox, ValidationCombobox validationCombobox2) {
        ArrayList<MenuGroup> arrayList = new ArrayList<MenuGroup>();
        arrayList.add(null);
        Object object = validationCombobox.getSelectedItem();
        if (object instanceof MenuCategory) {
            MenuCategory menuCategory = (MenuCategory)object;
            List<MenuGroup> list = MenuGroupDAO.getInstance().findByCategoryId(menuCategory.getId());
            if (list != null && list.size() > 0) {
                arrayList.addAll(list);
            }
        }
        validationCombobox2.setDataModel(arrayList);
    }

    public static void doAddNewCategory(ValidationCombobox validationCombobox) {
        try {
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuCategory menuCategory = (MenuCategory)menuCategoryForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)validationCombobox.getModel();
            comboBoxModel.addElement(menuCategory);
            comboBoxModel.setSelectedItem(menuCategory);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public static void doCreateNewGroup(ValidationCombobox validationCombobox, ValidationCombobox validationCombobox2) {
        Object object = validationCombobox.getSelectedItem();
        if (object != null) {
            MenuGroupForm menuGroupForm = new MenuGroupForm(new MenuGroup(), object);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)menuGroupForm);
            beanEditorDialog.open();
            if (!beanEditorDialog.isCanceled()) {
                MenuGroup menuGroup = (MenuGroup)menuGroupForm.getBean();
                ComboBoxModel comboBoxModel = (ComboBoxModel)validationCombobox2.getModel();
                comboBoxModel.addElement(menuGroup);
                comboBoxModel.setSelectedItem(menuGroup);
            }
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.54"));
            return;
        }
    }
}

