/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util.datamigrate;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.datamigrate.DatabaseConfigurationView;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MigrateDatabaseConfigurationDialog
extends POSDialog
implements DatabaseConfigurationView.DerbySingleListener {
    private DatabaseConfigurationView e;
    private DatabaseConfigurationView f;
    private TitlePanel g;
    private PosButton h;
    private PosButton i;
    private PosButton j;
    private PosButton k;
    private JCheckBox l;
    DbConnectionInfo a;
    DbConnectionInfo b;
    Connection c;
    Connection d;

    public MigrateDatabaseConfigurationDialog() throws HeadlessException {
        super((Frame)BackOfficeWindow.getInstance(), true);
        this.b();
    }

    @Override
    protected void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.g = new TitlePanel();
        this.getContentPane().add((Component)this.g, "North");
        JPanel jPanel = new JPanel();
        this.j = new PosButton(Messages.getString("TestConnection"));
        jPanel.add(this.j);
        JPanel jPanel2 = new JPanel();
        this.l = new JCheckBox(Messages.getString("MigrateDatabaseConfigurationDialog.1"));
        this.a();
        jPanel2.add(this.l);
        JPanel jPanel3 = new JPanel();
        this.k = new PosButton(Messages.getString("TestConnection"));
        jPanel3.add(this.k);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 1));
        this.e = new DatabaseConfigurationView(this);
        this.e.setBorder(BorderFactory.createTitledBorder(Messages.getString("MigrateDatabaseConfigurationDialog.3")));
        this.e.add((Component)jPanel, "South");
        this.f = new DatabaseConfigurationView();
        this.f.setBorder(BorderFactory.createTitledBorder(Messages.getString("MigrateDatabaseConfigurationDialog.4")));
        this.f.add(jPanel2);
        this.f.add((Component)jPanel3, "South");
        jPanel4.add(this.e);
        jPanel4.add(this.f);
        this.getContentPane().add(jPanel4);
        this.h = new PosButton(Messages.getString("CONFIRM"));
        this.i = new PosButton(Messages.getString("Cancel"));
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(this.h);
        jPanel5.add(this.i);
        this.add((Component)jPanel5, "South");
    }

    private void a() {
        this.l.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    MigrateDatabaseConfigurationDialog.this.f.setFieldValueFromCurrentDB();
                    MigrateDatabaseConfigurationDialog.this.f.setEditableMode(false);
                } else {
                    MigrateDatabaseConfigurationDialog.this.f.setEditableMode(true);
                }
            }
        });
    }

    private void b() {
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrateDatabaseConfigurationDialog.this.f();
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrateDatabaseConfigurationDialog.this.e();
            }
        });
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrateDatabaseConfigurationDialog.this.d();
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrateDatabaseConfigurationDialog.this.c();
            }
        });
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(Messages.getString("MigrateDatabaseConfigurationDialog.5"));
        this.g.setTitle(string);
    }

    public void setSuperTitle(String string) {
        super.setTitle(string);
    }

    public DbConnectionInfo getSourceConnectionInfo() {
        return this.a;
    }

    public void setSourceConnectionInfo(DbConnectionInfo dbConnectionInfo) {
        this.a = dbConnectionInfo;
    }

    public DbConnectionInfo getDestinationConnectionInfo() {
        return this.b;
    }

    public void setDestinationConnectionInfo(DbConnectionInfo dbConnectionInfo) {
        this.b = dbConnectionInfo;
    }

    public JCheckBox getCheckDestinationDB() {
        return this.l;
    }

    public void setCheckDestinationDB(JCheckBox jCheckBox) {
        this.l = jCheckBox;
    }

    public void updateFieldsValue() {
        try {
            this.a = new DbConnectionInfo();
            this.a.setSelectedDatabase(this.e.getSelectedDatabase());
            if (this.e.getSelectedDatabase().equals((Object)Database.DERBY_SINGLE)) {
                this.a.setConnectionString(this.e.getDerbySingleConnectionUrl());
                this.a.setDriverClass(this.e.getDriverClass());
                this.a.setUserName("app");
                this.a.setPassword("sa");
            } else {
                this.a.setConnectionString(this.e.getConnectionString());
                this.a.setDriverClass(this.e.getDriverClass());
                this.a.setUserName(this.e.getUserName());
                this.a.setPassword(this.e.getPassword());
            }
            this.b = new DbConnectionInfo();
            this.b.setSelectedDatabase(this.f.getSelectedDatabase());
            this.b.setConnectionString(this.f.getConnectionString());
            this.b.setDriverClass(this.f.getDriverClass());
            this.b.setUserName(this.f.getUserName());
            this.b.setPassword(this.f.getPassword());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void c() {
        try {
            this.updateFieldsValue();
            if (this.f.checkDestField()) {
                this.c = this.b.openConnection();
                if (this.c != null) {
                    POSMessageDialog.showMessage(Messages.getString("MigrateDatabaseConfigurationDialog.4") + " " + Messages.getString("DatabaseConfigurationDialog.31").toLowerCase());
                    return;
                }
                POSMessageDialog.showMessage(Messages.getString("MigrateDatabaseConfigurationDialog.4") + " " + Messages.getString("DatabaseConfigurationDialog.32").toLowerCase());
                return;
            }
            POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.43"));
            return;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void d() {
        Database database = this.e.getSelectedDatabase();
        if (database.equals((Object)Database.DERBY_SINGLE)) {
            try {
                if (!this.e.checkSourceField()) {
                    POSMessageDialog.showMessage(Messages.getString("MigrateDatabaseConfigurationDialog.0"));
                    return;
                }
                String string = this.e.getDerbySingleConnectionUrl();
                DatabaseUtil.checkConnection(string, database.getHibernateDialect(), database.getHibernateConnectionDriverClass(), "app", "sa");
            }
            catch (DatabaseConnectionException databaseConnectionException) {
                POSMessageDialog.showError(this, Messages.getString("MigrateDatabaseConfigurationDialog.3") + " " + Messages.getString("DatabaseConfigurationDialog.32").toLowerCase());
                return;
            }
            POSMessageDialog.showMessage(Messages.getString("MigrateDatabaseConfigurationDialog.3") + " " + Messages.getString("DatabaseConfigurationDialog.31").toLowerCase());
            return;
        }
        try {
            this.updateFieldsValue();
            if (this.e.checkSourceField()) {
                this.d = this.a.openConnection();
                if (this.d != null) {
                    POSMessageDialog.showMessage(Messages.getString("MigrateDatabaseConfigurationDialog.3") + " " + Messages.getString("DatabaseConfigurationDialog.31").toLowerCase());
                    return;
                }
                POSMessageDialog.showMessage(Messages.getString("MigrateDatabaseConfigurationDialog.3") + " " + Messages.getString("DatabaseConfigurationDialog.32").toLowerCase());
                return;
            }
            POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.42"));
            return;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void e() {
        try {
            this.updateFieldsValue();
            this.setCanceled(true);
            this.dispose();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void f() {
        try {
            this.updateFieldsValue();
            if (!this.e.checkSourceField() && !this.f.checkDestField()) {
                POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.39"));
                return;
            }
            if (!this.f.checkDestField()) {
                POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.43"));
                return;
            }
            if (!this.e.checkSourceField()) {
                POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.42"));
                return;
            }
            try {
                if (this.a.openConnection() != null) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Messages.getString("DatabaseConfigurationDialog.42") + "\n" + exception.getMessage());
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            try {
                if (this.b.openConnection() != null) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Messages.getString("DatabaseConfigurationDialog.43") + "\n" + exception.getMessage());
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.setCanceled(false);
            this.dispose();
            return;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void updateUI() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.j);
        this.e.add((Component)jPanel, "South");
    }
}

